var totalScore = 0;
function getParameters() {
  var urlParams = new URLSearchParams(window.location.search);
  var endpoint = urlParams.get('endpoint') + "/";
  var auth = urlParams.get('auth');

  var actorObject = JSON.parse(urlParams.get('actor')); // this needs to be JSON decoded
  var actor = actorObject ? actorObject.id : null;
  var activity_id = urlParams.get('activityId'); // for example, http://adlnet.gov/expapi/activities/question/{question-id}

  document.querySelector("#cookieId").innerText = "Cookie: " + auth;
  document.querySelector("#questionId").innerText = "QuestionId: " + activity_id;
  document.querySelector("#userId").innerText = "UserId: " + actor ;

  var conf = {
    "endpoint" : endpoint,
    "auth": `Basic ${auth}`
    ,"withCredentials": true
  };

  ADL.XAPIWrapper.changeConfig(conf);

  return {
    actor,
    activity_id
  }
}

function sendState(answer){
  if (totalScore === 'randomText'){
    totalScore = 0;
  }
  if(answer === 'randomText'){
    totalScore = 'randomText';
  } else {
    totalScore = totalScore + answer;
  }

  try {
    var parameters = getParameters();
    var stateval = {
      score: totalScore
    };
    ADL.XAPIWrapper.sendState("http://adlnet.gov/expapi/activities/question/" + parameters.activity_id,
        {"mbox":"mailto:tom@example.com"},
        parameters.actor, null, stateval);
    document.querySelector("#result").innerText = "Score Submitted: " + totalScore;
  } catch (err) {
    console.error("An error has occurred!", err);
    document.querySelector("#result").innerText = "Error has occurred: " + err;
  }



}

getParameters();
