var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./MassAndSpring/masses-spring-projectile-screenshot-small.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/MassAndSpring.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./MassAndSpring/PacoEsquembre2011.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/ScienceSamuraiDarrenTanSquareSmall.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/WC_logo.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["./MassAndSpring/MassAndSpringComplete.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUAAAAC0CAYAAADl5PURAAAKsWlDQ1BJQ0MgUHJvZmlsZQAASA2tlmdYE1kXx+/MpBdaQpUSeu/SpddQpIMgKiEJhBZjSBARG7K4AiuKiAhYQBZFFFyVImtBRLGi2LBvkEVFXRcLNlTeCbzE/fDut3ee59755X//c+bck7nPcwCgNLIEgixYAYBsvkgYFejDWJCQyMA/AiSABwqADhxZ7ByBd0REKPjX68MdAEkXb1pKY/2r7X8vKHK4OWwAoAh0OYWTw85G+Rg6ytgCoQgAxAvVDZaLBFLmoEwXogminCfltBkuk3LKDO+Z9sRE+aIeNA6BwmIJ0wAg96A6I5edhsYhS1C24XPS+QBQ0J0DDzaPhcamSHOwyM5eKuUClE1S/hEn7R/MYqXIYrJYaTKe2Qv6JPpiv/QcQRZrxfSP/+eUnSVG6zV9aaMzJSczOgS909Ga5bFZ/tGzzOMypf/ZtC4Q+UTNcrqIGTPLPHFQ7CyLM2O9ZzlzaYjMz0+ZHz6rs3N80drPxMznxcTPMofr5z/LwqVRMn9ObrRMz+f5zp/1ZLCCpbWezo0lROm/zM0KlL1XIIqQ5cnPmi/bS6owQObh5vzYr4gXEzQbRySMkXlS0wOYszpPGCTTBVnT3/R0DkJxlKwOXH6srIYclp+stiAU2AEbEAMsgS1gAH/gC8JF3DyRNHnfpYIVwvQ0nojhjZ4ArgWDyWdbWTDsbGztgfQ8ST0AvLs7fU4gFcIPLS8HAPfDAMCff2jxnQAcQr9fddsfmlELAMpUADoRtliYOxMPI71h0ZMqj1ZSHWgDfWCCZmcHHIEb8EIzDAbhaL4JYDFgAx7IBkKwHBSAdaAYlILNYBuoAbvBXrAfHAJHQCc4Ac6A8+AyuA5ugwdAAkbBSzAOPoBJCILwEBWiQeqQDmQImUN2kDPkAflDoVAUlAAlQ2kQHxJDBdB6qBSqgGqgeqgZ+g06Dp2BLkKD0D1oGBqD3kJfYASmwHRYCzaCrWFn2BsOgWPgRXAavAzOh4vgTXA13AAfhDvgM/Bl+DYsgV/CEwhAyIgKootYIs6ILxKOJCKpiBBZjZQgVUgD0op0I/3ITUSCvEI+Y3AYGoaBscS4YYIwsRg2ZhlmNaYMU4PZj+nA9GFuYoYx45jvWCpWE2uOdcUysQuwadjl2GJsFbYJ2449h72NHcV+wOFwKjhjnBMuCJeAy8CtxJXhduLacD24QdwIbgKPx6vjzfHu+HA8Cy/CF+N34A/iT+Nv4Efxnwhkgg7BjhBASCTwCYWEKsIBwinCDcIzwiRRgWhIdCWGEznEFcRyYiOxm3iNOEqcJCmSjEnupBhSBmkdqZrUSjpHekh6RyaT9cgu5EhyOnktuZp8mHyBPEz+TFGimFF8KUkUMWUTZR+lh3KP8o5KpRpRvaiJVBF1E7WZepb6mPpJjiZnJceU48itkauV65C7IfdanihvKO8tv1g+X75K/qj8NflXCkQFIwVfBZbCaoVaheMKQwoTijRFW8VwxWzFMsUDihcVnyvhlYyU/JU4SkVKe5XOKo3QEJo+zZfGpq2nNdLO0UbpOLoxnUnPoJfSD9EH6OPKSspzleOU85RrlU8qS1QQFSMVpkqWSrnKEZU7Kl9UtVS9VbmqG1VbVW+oflSbo+alxlUrUWtTu632RZ2h7q+eqb5FvVP9kQZGw0wjUmO5xi6Ncxqv5tDnuM1hzymZc2TOfU1Y00wzSnOl5l7NK5oTWtpagVoCrR1aZ7Veaatoe2lnaFdqn9Ie06HpeOik61TqnNZ5wVBmeDOyGNWMPsa4rqZukK5Yt153QHdSz1gvVq9Qr03vkT5J31k/Vb9Sv1d/3EDHIMygwKDF4L4h0dDZkGe43bDf8KORsVG80QajTqPnxmrGTON84xbjhyZUE0+TZSYNJrdMcabOppmmO02vm8FmDmY8s1qza+awuaN5uvlO80ELrIWLBd+iwWLIkmLpbZlr2WI5bKViFWpVaNVp9drawDrReot1v/V3GwebLJtGmwe2SrbBtoW23bZv7czs2Ha1drfsqfYB9mvsu+zfzDWfy527a+5dB5pDmMMGh16Hb45OjkLHVscxJwOnZKc6pyFnunOEc5nzBResi4/LGpcTLp9dHV1Frkdc/3azdMt0O+D2fJ7xPO68xnkj7nruLPd6d4kHwyPZY4+HxFPXk+XZ4PnES9+L49Xk9czb1DvD+6D3ax8bH6FPu89HX1ffVb49fohfoF+J34C/kn+sf43/4wC9gLSAloDxQIfAlYE9QdigkKAtQUNMLSab2cwcD3YKXhXcF0IJiQ6pCXkSahYqDO0Og8OCw7aGPZxvOJ8/vzMchDPDt4Y/ijCOWBbxeyQuMiKyNvJplG1UQVR/NC16SfSB6A8xPjHlMQ9iTWLFsb1x8nFJcc1xH+P94iviJQusF6xacDlBIyE9oSsRnxiX2JQ4sdB/4baFo0kOScVJdxYZL8pbdHGxxuKsxSeXyC9hLTmajE2OTz6Q/JUVzmpgTaQwU+pSxtm+7O3slxwvTiVnjOvOreA+S3VPrUh9nuaetjVtjOfJq+K9SvdNr0l/kxGUsTvjY2Z45r7Mqaz4rLZsQnZy9nG+Ej+T37dUe2ne0kGBuaBYIFnmumzbsnFhiLApB8pZlNMloqONyxWxifgn8XCuR25t7qflccuP5inm8fOurDBbsXHFs/yA/F9XYlayV/YW6BasKxhe5b2qfjW0OmV17xr9NUVrRtcGrt2/jrQuc93VQpvCisL36+PXdxdpFa0tGvkp8KeWYrliYfHQBrcNu3/G/Jz+88BG+407Nn4v4ZRcKrUprSr9WsYuu/SL7S/Vv0xtSt00UO5YvmszbjN/850tnlv2VyhW5FeMbA3b2lHJqCypfL9tybaLVXOrdm8nbRdvl1SHVnftMNixecfXGl7N7Vqf2rY6zbqNdR93cnbe2OW1q3W31u7S3V/2pO+5Wx9Y39Fg1FC1F7c3d+/TxrjG/l+df21u0mgqbfq2j79Psj9qf1+zU3PzAc0D5S1wi7hl7GDSweuH/A51tVq21reptJUeBofFh1/8lvzbnSMhR3qPOh9tPWZ4rK6d1l7SAXWs6Bjv5HVKuhK6Bo8HH+/tdutu/93q930ndE/UnlQ+WX6KdKro1NTp/NMTPYKeV2fSzoz0Lul9cHbB2Vt9kX0D50LOXTgfcP5sv3f/6QvuF05cdL14/JLzpc7Ljpc7rjhcab/qcLV9wHGg45rTta7rLte7B+cNnrrheePMTb+b528xb12+Pf/24J3YO3eHkoYkdzl3n9/Luvfmfu79yQdrH2IfljxSeFT1WPNxwx+mf7RJHCUnh/2GrzyJfvJghD3y8s+cP7+OFj2lPq16pvOs+bnd8xNjAWPXXyx8MfpS8HLyVfFfin/VvTZ5fexvr7+vjC8YH30jfDP1tuyd+rt97+e+752ImHj8IfvD5MeST+qf9n92/tz/Jf7Ls8nlX/Ffq7+Zfuv+HvL94VT21JSAJWRN9wIIOsOpqQC83QcANQEA2nUASHIz/e60AwLg/R+z9G880xNPuxwBaOwBINYLACY6alHRGB20tQBEoL9jvAAcelU20BXplZNqbzcNEBntYbBVU1Pv4gHAmwLwbWhqarJzaupbE9qX3weg58NMny11axxFPdLcoP4s1fHp5/8x/Qd4Kfp6lRgTYAAAAAlwSFlzAAALEwAACxMBAJqcGAAAAZ1pVFh0WE1MOmNvbS5hZG9iZS54bXAAAAAAADx4OnhtcG1ldGEgeG1sbnM6eD0iYWRvYmU6bnM6bWV0YS8iIHg6eG1wdGs9IlhNUCBDb3JlIDUuNC4wIj4KICAgPHJkZjpSREYgeG1sbnM6cmRmPSJodHRwOi8vd3d3LnczLm9yZy8xOTk5LzAyLzIyLXJkZi1zeW50YXgtbnMjIj4KICAgICAgPHJkZjpEZXNjcmlwdGlvbiByZGY6YWJvdXQ9IiIKICAgICAgICAgICAgeG1sbnM6ZXhpZj0iaHR0cDovL25zLmFkb2JlLmNvbS9leGlmLzEuMC8iPgogICAgICAgICA8ZXhpZjpQaXhlbFhEaW1lbnNpb24+MzIwPC9leGlmOlBpeGVsWERpbWVuc2lvbj4KICAgICAgICAgPGV4aWY6UGl4ZWxZRGltZW5zaW9uPjE4MDwvZXhpZjpQaXhlbFlEaW1lbnNpb24+CiAgICAgIDwvcmRmOkRlc2NyaXB0aW9uPgogICA8L3JkZjpSREY+CjwveDp4bXBtZXRhPgoJZY8TAAAfXklEQVR4Ae2dCXxU1dnGnySTyb6QBAhBVtkFBeH3gYAIBQVFwQ2rVqsoqFRQrCAgooJFoMG6VqW41qVV0WordYN+oKwKko+lBFGRLUBYQvYJySTfee9w4yTMJHNnJpMb73P4DXc95z3nf+597nuWexN2z/3TquY+lAkGEiABErAagXCrFZjlJQESIAGdAAVQJ8ElCZCA5QhQAC1X5SwwCZCAToACqJPgkgRIwHIEKICWq3IWmARIQCdAAdRJcEkCJGA5AhRAy1U5C0wCJKAToADqJLgkARKwHAEKoOWqnAUmARLQCVAAdRJckgAJWI4ABdByVc4CkwAJ6AQogDoJLkmABCxHgAJouSpngUmABHQCFECdBJckQAKWI0ABtFyVs8AkQAI6AQqgToJLEiAByxGgAFquyllgEiABnQAFUCfBJQmQgOUIUAAtV+UsMAmQgE6AAqiT4JIESMByBCiAlqtyFpgESEAnQAHUSXBJAiRgOQIUQMtVOQtMAiSgE6AA6iS4JAESsBwBCqDlqpwFJgES0AlQAHUSXJIACViOAAXQclXOApMACegEKIA6CS5JgAQsR4ACaLkqZ4FJgAR0AhRAnQSXJEACliNAAbRclbPAJEACOgEKoE6CSxIgAcsRoABarspZYBIgAZ1A2JChQ6t6n9tP3/ZrGR4ejqlTZyEpKdmv+IxEAiRAAo1BwHb3pEkB2123bj3y809SAAMmyQRIgARCSYBN4FDSpi0SIAFTEaAAmqo6mBkSIIFQEqAAhpI2bZEACZiKAAXQVNXBzJAACYSSAAUwlLRpiwRIwFQEKICmqg5mhgRIIJQEKIChpE1bJEACpiJAATRVdTAzJEACoSRAAQwlbdoiARIwFQEKoKmqg5khARIIJQEKYChp0xYJkICpCFAATVUdzAwJkEAoCVAAQ0mbtkiABExFgAJoqupgZkiABEJJgAIYStq0RQIkYCoCFEBTVQczQwIkEEoCFMBQ0qYtEiABUxGgAJqqOpgZEiCBUBKgAIaSNm2RAAmYigAF0FTVwcyQAAmEkgAFMJS0aYsESMBUBCiApqoOZoYESCCUBCiAoaRNWyRAAqYiQAE0VXUwMyRAAqEkQAEMJW3aIgESMBUBCqCpqoOZIQESCCUBCmAoadMWCZCAqQhQAE1VHcwMCZBAKAlQAENJm7ZIgARMRYACaKrqYGZIgARCSYACGEratEUCJGAqAhRAU1UHM0MCJBBKAhTAUNKmLRIgAVMRsJkqN8wMCZBAgxLYuXM7tn+ZhdyfDqPkWBFQAlQlAKmt09C8Yzr6DRuAjIyzGjQPZkqcAmim2mBeSKABCGxatwErXl6OyB8i0GV/JwyLG4B0WzriI+KrrR3beAyHyw9j9aMf48cOe5HQMwlXTr0ebdu2rz7nl7hCAfwl1irLRAKKwLasLLz78Ov4VfZF+EPiI7CFqds9xTOaNFsa5NczpieQBxStKsIrn7yGnIFHcNuCu9GiRbrniE18LwWwiVcgs08CtQlUVFRg8Z1z0fWrs/FkYiZsScZvc/EO74mfjJNbTuL5kS8i9vpk3Drjrtqmmvw2B0GafBWyACTwM4Hc3MN4cOQUTN50J8Yn3ery+n4+bHgtOSIZD9pmou9rPbHw9jkQcf0lBQrgL6k2WRZLE9i9MxvPXbEIf8rLxFn24A5kXBg/GHdtuh1zr5yO4mI1ePILCRTAX0hFshjWJpCffxJv3L4Ef3Jm1hjcCCaV9vb2mH1gBhbeMieYyTZqWhTARsVP4yQQOAFpli68aQ4edzwWcJO3vtykR6bjjuzb8ecZi+s7tUkcpwA2iWpiJknAO4EljzyF+/fe22CeX23LvdRIcdtl6Vi7YlXtQ01u2/jwkEmLuHt3Nt599y0td3FxcZg4cTLi4n6e5xTsbH/wwd+xc+cOrVO4X7/+GD36ymCbqE5P+lyefXYxnE6nZm/8+DsbdH7Wpk0bsHz5R7DZbEhJSdVYynpDhaVLn0Nu7hGtb2nMmGswYMDghjKl7BzG0qV/1tIXz2ny5PuRmprWYPYaOmFp+jqXO9ApqlNDm6qR/s0pN2HKovswaMTQGvub2kbEuHHjHg000/v3H0CfPgOQlJQcaFJ+xRfxk4v6kUcWYOjQEZo4LFo0F+eccy4SEhL9SrOuSHLDSroismJv//6f8MYbL2vrdcXz55iI34MP3od7730Al146BhdcMBivvvoiCgsL0KlTF3+SrDPOhg1r8MUXn2DOnPkYMuRXmjjMmzcLAwcOQXR0dJ1x/Tk4f/4cTfBuvPFWDB8+Cl9/vQ4rVnyK/v0H+pNcnXFE/MTe7NmPabb69OmHZ57J1K7bVq0y6oxr1oPPTF2I3+fcg+jw4NdNfWWOORaNTUmb0PW8HvWdatrjTb4JnJNzQBO/xx9/UvNYhLS8yvPYY5lYvHh+0Ift3333TW1S6Nix11ZXqty4o0ePVfl4rnpfsFbmzJmu3bD6RNSoqGhMm/YQtmzZhH37fgqWGS0deU1q5crPNHt6wh07dsK8eZmQB0qwwwsvPKWEaGQNj+/qq6+H2Fy+/MOgmisrc2DhwrmQ60RvGcgDWx6a7733FsSTampBHo7R62yQqSqNEYbFD8XWtzY3humg2WzyAvjii09rF3HtJpoIxdSpM5QI/iFosERsRXTcxU9PvF+/AdqqCFOwwl//+hJuvvl2j7PwRQSfempRUAX+1VeXYMaMR87IvgjFuHG/CarAi9cudeapuSvdCdu2ZQVV4EVs5XrQxc+9kOIRimfYEEGul4aaO/fZso8xpvLyhsi2z2l2/KEd5L5oqqFJC+Bnn32MQYMu8nhRS4XIe4zyk5spGEHEdtKkqV6TkiaxeBPBCNJck5800zwFEY9Jk+7VmsOejhvdJ2J7ww23VHvRteNLPsTjkDwFI0iXxfjx3t8sEIF/6SVXX12g9kRs5YHo7b1WEUXpe/zoo2WBmtLia6OyCx/VRHXNmlXKg56Ft99+LShpuyfy3Sc70Dumt/uukK9fEXs5Pn/z45DbDZbBJiuA0qRZu3Y1Ro6s+wl43XU34W9/ez1gXitXflqn2OoGrr7612ow5k190+/lCy/ULbaScOfO3dTT92DAzTdp/u3fv9er2OqFEIGXfAUaRAzqEltJXwS+b9/+EAEJNIhnK3mvKwwePBSbN28M2FsT8ZM+22uuuV7rSpC+TelCkGb93LmzAk7fvQxVPzb+Wxky4frIuoPu2WpS601WAMVjufXWO+uFLTeS9DOJgAUSpG+sPrGV9KUpLKPDItD+BvFYO3fu6tWzdU9XvMBA+x6leSijofUF8ZQkX4F41MJl9+5d9Yqt5EW6Gv7974/qy1adx1etWqHVv1wH9QW5nmSAKZAgLCdOvFt7OLmnI0192S/iGAwvWh5aLYtauptotHVbYUSj2Q7UcJMUQLmJxPORp6ovQQYpRMD8DdIhf9llY32OLv12ItD+BmlGi+fqS5DBEbm5/b2pJJ6M7vo6gi/5CqSZr/dr+lI2OUc8aply5G/4/PPl2oivL/HlepLpOP4OiEhfmFyb4pl7CjI4J4Muzz33BGSqUSBB6q3VqfRAkgha3LDioCUV8oTqfyz6mCWpUCOjknLTyc2rL300o532l788p/qP6vf+3NMUARMhMzpfT5o00tSW0UNfg9xIb7xxULsZpO/JSBDvqlu3c7z2xXlKS/rSxAuUfjOj4ZVXXqyzX7N2eiK2/fsPgkyX8TSAUft8922jDy6JKx71P//5vuqju9YQE4lr9MElccRLEy9w6tSZsmkoSB+xp0Ek90TEi5YmsXQDSLkuumi41j/pfo4v67t2/Rd9I80x/cRWYtOa9r542b6ULZTnNJoHKE9Z6d95//2/4+GHp6tm43afyi1PPqezwmuHtrdEpI9HhMxokP486a8yGkSg/fECpb9S+o2MBPHe5Pfjj98biaadL5OAffX+9MTlISI3r9EgYivesdEgI9BG+1X1B5fUu5EgD2WHw2HYC9QfXJ5GmT3Zlzp++OEFPnVzeIovk+Jt6p8Zgq3Kpt2TZsiL0TwEjaA8qb2NstWXKblYxYORKST13fzSCT9t2uz6kvR4XG4kaU7JXDNfguQrO3tHvXnylJawOH78mHYj+Sow8kCQUW1/wm9/O0Gb5yZNLF+DTN6eOfMRX0+vcZ7kU/Lrq8DIA09+vnZbuBvr1au31uyW+vDVy/D3wSV2b7vtLsNeoDy4xLMzEqQsRr1oPX15cB3IzNY3G3XpiHH45cU2aqZPG280D9C98HIhyPQS6SOR+VhyoXsK0uzq1es8v5+aMpUjK2uz1/Rr25SbSETT36DfSL7Glw5/o010PW3XNI92aoDBt5tCvMWMjNZ+X7hGvUBpVgoPf4N44b5OJdEfXCKc/gR90rmv/ar6g8tXcfYnT7XjSB4P2Q7X3t0o21VxjWI2KEZNIYB6SeS1MrnQZaSsdke0NJFFIHz13vQ0ay99HemTOW8yWunvTSR29RvJl4miMqfxkktG186uoe2bb56gPJclPsUR70+8xkCCzJ3zZYBChERESefhj83u3XtqU3VqXxee0gr0wSVpuvpVfZuHGMiDy1P+fdknHuCRuCO+nNrg51QkOhvcRkMZMJUASiGliSTNOJlO8NRTCyHTGKR5/MEH7xhuYniC5utInz6dwVMaRvaJZ6u/fO8tnoit9E/KAyCQIB6I3jStKx2ZEiQfcDA6QFM7TWn+ikctgxt1BRn1rGsCeV1x3Y/pAxTu+2qvS7eDDMYF8uCSNKXbQjzk+jxq8UplpLoxwqm2nltKoczLsYpjSD4vNZQmg2rLdAIopZOO5JkzH9X63mSUWJpb8rpSsMJdd92LJ56Y7zU56dCWJ6w0yQMNIjK9e/etcx6iiK3kKRhBWIlHIqLqKYhYrV690u+mdu00J0y4W/tSTe39+raIrYwa+zo4oMfztBQPUtKpax7i008vwpQp0zxFN7xPPGp5eHnrkhGx3bPnB22k2nDiQYjQcURXfF/2fRBS8j+JfxV8jItvrftlBP9Tb/iYphRAvdhywUsncTCESE9TliJuMi3G0yitCIfMc5OLP1hBJvRu2LDW4zuT0q8p5QtmGe+/f7bXjxc8+eTCoImt8JHBHvGqpQlfO0jTV+Zf+tuvWTs92ZY3OqT57qkpLM3xYImt2BKPWiaIe3qfXERR+qvl/eLGCpf8+nJ8UPFhY5nX7O5st8uvga1GzbSbcVMLoFs+g74qwirekHsfloiffEFG5nIFu0NbRq4lbfepKiJ+332X7dcoc11AROClf26heh/VvXkqXQryilYwxVbyIf2y4pVJd4UeRPzEezIyKq3HrW8prQF5rcx9kELm/Mn0lWCKreRDBF6a09INo3uCspSpW/IWTjA82/rK6+241HNun+NwVNbdBeEtfqD7s0qz0GFs10CTadT4Ye+8805VoDlYt269GuG71+9pMIHaDyS+3LTytkBiYpKWjDSfGuqilhtHmruHDh3U7Inn5OsbH/6UUfrCZHKuXp7rrvuN17cU/Em/dhwRIWley0dUpeti8uRpQX+Q6DblYSWidOLEca0vU/o0fXlVUY9vdCmDcOJ5SpeGPBylPzKQQR2j9r2dL3X86ahleCAuOM1+b3Y87b8n9j48vFL92U3Fo6kGywtgU6045psEdAJ/mvIH/O6rCZC/1xGq8EnBp8ib68Bl118ZKpMNYseyTeAGoclESaARCNy5cCrmpaiP/1ZVhMT6gVMHsHrw2iYvfgKLAhiSS4ZGSKDhCEgXx+Q3Z2B2ZcN81NU950XOIjyevgjTlvj3BpF7WmZYpwCaoRaYBxIIkIAMbF389FjMLlNvUjWQJ3jSeVL1Nc7C1DdmN+l+P3fUFEB3GlwngSZMoN+FA3DlO7/BPZH3QTy1YIZsRzbmtJmL2Z8uMMXgT7DKRgEMFkmmQwImINC5ezfM+PQxTG81C18U/jwtyd+siTe5NP8lvD10GR55P7N6RoG/6ZktHgXQbDXC/JBAgATkNb4Fy5/FiccduCf+PmwpyfIrxX/kf4j7Mqaj5/sD8PtnH/rFNHvdYTTdCTzupeA6CZDAGQRGXn05ho8ZhX+9sQxv/+sdNNubhCElgzEgbgBsYWfe+tJs/qp4Df632WqEn23DsAkj8dgw3z8EfEYGmsCOMyk0gUwziyRAAr4RkEnKV42/XvvJW0Grlq/AvNUL4SyogPYp+xKgKkGlFQ/EpsWj36UD8OAQ378p6VsuzHsWBdC8dcOckUBQCchbLOIVyo/BRYB9gLwSSIAELEuAAmjZqmfBSYAEKIC8BkiABCxLgAJo2apnwUmABCiAvAZIgAQsS4ACaNmqZ8FJgAQogLwGSIAELEuAAmjZqmfBSYAEKIC8BkiABCxLgAJo2apnwUmABCiAvAZIgAQsS4ACaNmqZ8FJgAQogLwGSIAELEuAAmjZqmfBSYAEKIC8BkiABCxLgAJo2apnwUmABCiAvAZIgAQsS4ACaNmqZ8FJgAQogLwGSIAELEuAAmjZqmfBSYAEKIC8BkiABCxLgAJo2apnwUmABCiAvAZIgAQsS4ACaNmqZ8FJgAQogLwGSIAELEuAAmjZqmfBSYAEKIC8BkiABCxLgAJo2apnwUmABCiAvAZIgAQsS4ACaNmqZ8FJgAQogLwGSIAELEuAAmjZqmfBSYAEKIC8BkiABCxLwLZk6VJ063JOQAAcDgfi4uIDSoORSYAESCDUBGw9z+uNuQ9lhtou7ZEACZBAoxOwNXoOmAESIAHLEggLAwpLjmP73k346r9f4OvsNdh3bDdOFhciISoaHdJ74LyO52NIr1Ho03EgEmPTUFUVPFwUwOCxZEokQAI+EhDh2/7Terz6xTPYcPBLtGqdgVYZ6eh1SXcMSuyP6JhoOEodKCgoQG7ufjy7/jEcWpaDvi0uwOQxs9G5dR8fLdV9GgWwbj48SgIkEGQC+SW5WLxsJtYfWY1u3bth7JAxCIsIQ1R4NGJt8YiPTEJ0ZAwckaVIiClAs9RktO3aBlXOKuz9bh8mvX0t+ja7AI/e/DxiohIDyh0FMCB8jEwCJGCEQPb+b/DQu/cgoU00Lhl7MSJtUWgR0xKJ9mbVyVShCspBRIwSwdjIWLXVUjtWeCofth6RaNulDXZm7cLVmQPx4sT30a5l1+q4RlcogEaJ8XwSIAG/CPzfnjWY8d5E9OzXA+ntWiItuiVSo1ucTks69kT2XP+7tmTb1eEXpo4l2pPULxnHHbkI7xuO1LQUjH/pMrxw0/vo2q63FtfofxRAo8R4PgmQgGECR08e0MSvz+DeaJ6ehk5J3U/LnS58LvFzJexa1z1BkcSfBRFIUaLZLLo5wsMiEBltx6Q3r8Hff/clWjRrbThfnAhtGBkjkAAJGCFQ4azApJfHaZ6fiF9nTfxE5ETYXF6ey89zpSrCJ0G8PtfS/ajLQwxXxyQdSe/8C3rjusyLcKq8TDvfyH8UQCO0eC4JkIBhAq+vWKz1+Umzt1NSNxXfJXrSvNUlzuXj6UKnS5+YkjP0bTUIsncv1n+9Dlu2favtP1ulJ+l26N0GDy2dJBEMBTaBDeHiySRAAkYIFDsK8betS7UBD+nzC4P4XCJ0LsmTtGSt2hOsdGpHK7XJfrJX/VMaKPHK8isw5txr0LXZuThUehA/FmTjQOlPqh+xJbr3rsTnH32BH/btxNltu0uyPgV6gD5h4kkkQAL+EHhvzUvaVBcZ7U1R/XYidbrY6RIo287KCpxylsGh/UpR5ixB6elfmVPNBywswEXth6ObEj97uB3t4zuia2IvFRNqMKWFGk22a3bueuJqQ9mkABrCxZNJgAR8JVBZ5cRLaxejXZe2aB6TLr5cdVS9sVtVWakJn4hfWYVDCWAxSiqKUax+pRUlrvXyYrSP6owuqT1gj4hSHqErnfDTS0m0hUpf7JQ0y8f+Qz9U26lvhQJYHyEeJwES8ItAfnGe9oaHTHKWKSyuPr+fZdCpmrunKk8pAXRo3l6JeHwieuWF2q+ovADFaj137wlc0nW0Er6acvXtiY0qTVcDWuYRip2Ms1oj87WHfM4v+wB9RsUTSYAEjBD4777N2uttUeHKa9MiuvX2Kc+vvLJcCaDy/JT3JyJ4yqnEUG07q8pRUVXh6gusqMSkQbMQZYupYXrj0TXIKdmrNYfDwyO0c+3KjrxOt/3bb9T7wpVnCGaNBE5v1JRUT2dwHwmQAAn4QWD9jlVIa5GGqIi40/1+4q+5hkBE4MqV9yfiV1ZRqnl+xRXK83MWorCiQC2L4XCUYniry9G5Wc03PYrKi7D2yEpNQMuVWEqQdKOVHbGXdyoXRUX52v76/qMA1keIx0mABPwisGbn50hMTMTO/M0oV0Ln6vcLQ6Vq+laoQY/s77PxzaaN2LU7G/nleShW4lekmrxFFSdRUlYA+/FEjGp31Rm2n9+50OUxireopaWa0sqDFDtiz1HlwJEjOWfE87SDTWBPVLiPBEggYAJ7cn/CqJgR6lNX/1GeXinOTx2ClrHpqonrxHfbfsCkEb9Hq5iz8GPRLry99RUU2wuVN1isHbeVxmD2qPmIUM1bPYhoztx0ByLUvzj10YSIcBtsYaeQV3YMW/M2YvfRdeja7Vw4larl5BxAp071f+iZAqjT5ZIESCCoBNqltdU+aWVTU1R2H12PY6U5ahrL/6BTQldMuXQ6MmLbIFLN7+sQ1xkP9J+H6V/eDlt8JPIPF2JC37uQGpNWIz9/3PYQ8k/lISEyQfUV2gHVFP4ufxv2FGxHfvF+iB35hFZ4BVBaWlIjrrcNNoG9keF+EiCBgAgM7DZC+55fzOkvveQVqbc49r+Hj/e9hQLV5LWHRyJMeXjJ0amIVHP75g16DoVHHOiWcD4u7ziuhu2VOf/GluNfobyqFMfLDiM7/1usOvQPZB36RBM/OVnsyPcDo6oikZravEZ8bxv0AL2R4X4SIIGACAzuORzv7vszEls0V199PlKdVl7RHjyzYy4e7vMM2sa11+b1JUenaP2Cd5w7HRd2HKYGNVzjxhLpWGku5m/5neo7rMDhKjVSrAZLKp2V1enpK4lRzXEs9xjiw1LQqtVZ+u46l/QA68TDgyRAAv4S6NG2Dw7lHNa+3lI7jf879BlmfHOr8gQLtEMyuTk1rjkGtBuEaFt0jdMnrL1MCeghFDuOwlGW71H8JIJ8JUbsJdvSfPYAKYA1UHODBEggWASaJTTHoYM5SLG1RJQ97oxkv1f9grd9NQonVb+ehHD1L0G+8KzeA5Z/Ep7ZOR8H87Zp63X9J+mLnZwDB9EirjXs9przBr3FpQB6I8P9JEACARGQNzdu6D0Rh78/ilaJ3T2mtff4ZiWCl+KEGsmtDsoblH+78nfgzR3zqnfXtSLpi52KfZW4afQkhIf7Jm2+nVWXZR4jARIgAS8Ebrl4KrJ3ZiMjqgNio2uO6mpRVFff/rwtuO3LUWqqjKM6FfEA791wrWtbugPdf9VnuVYkXUlf7LRWywsvHF7rDO+bFEDvbHiEBEggQALxscm4tP212Lf9IM5u1qtmakrUNF0Lr8Khoq3449YHsSMvS/st2PoACk7tRYRdzfqLVM3jCPXNGHWe9qslhpKupF+804EbLrlDNX9r9iHWNFpzi6PANXlwiwRIIMgEplw1F2MX9lN/w6MrOjbvjx+PbtSUTxcz+ahLhC0Mn+W8gBVHlqjmq5odqPZFRdnVmx7lcFaoydARTrUMV92DTrWu+gdPf07m7NSBiDgaj+yN29AxrgeuuuImQ7mnB2gIF08mARIwSsCuRnXlr7d9uz4LSUXp6NRigJaECF+YUrqICDX8oT5zZbdHaYMlsVFxiLbHqz95GaWWsbBHKS9QHbcp4YuwqY/hqzjyAYQuqRciubgVNq/7FmmFGcic9bKaDK3cRQOBAmgAFk8lARLwj4D86crMa1/FptWbEX+iOXq3GoG4qFZqDqDL+7Mr3bJH2hGrmq+xUfHqmBJAEUG1Han+PGakEj5blBI+9cmrZrHt0S9jNJIKWmHTl5sQ9VMCZt6yEBkZbQ1njgJoGBkjkAAJ+EOgb9chyBynRHBlFvJ2lqFvqvrCc8owJXoZ4gqqZm+48vTsiIywqQ+f2tVXZGKU1xel3hJRTWLlJSZEtUfP1EvRP2Ukinc7sX7lesQcTMYDNy7AoEG+D3y45519gO40uE4CJNCgBPp2GYJl09fizsVXYs2B9eh5Tk8M6nwFSqrUV6ArC1CmluXqV1Z1AtFhzZFkT0S08gbjI5KQEJ6Mw3uPYN2ur3F4xz60t/XEzEmL0KNHH7/zTAH0Gx0jkgAJ+EMgNakl3pu3Fh+ueh3PL1+ArVuz0L7d2WjfpgM6qM/epySlKNGLVm99OJBXmI9jJ3KxL2cf9h5YixP7j6BFZUdc3n48pkychZiYeH+yUB2HAliNgiskQAKhIiCTpK8aNh5jL7oZa7M+w5KPnsB/vv0cxeHHUG4vhVOmvDjDEFUegajKNCQ6WyAtsg1GtP41brzxdqSktAxKVimAQcHIREiABPwhEK6+6Xfh+aO1X3m5A0ePHkJW1nocOHAAe/bsQYcOHXD++QPQpcs5iI9P1kZ//bHjLQ4F0BsZ7icBEggpgcjIaDWS20H7hcowR4FDRZp2SIAETEeAAmi6KmGGSIAEQkWAAhgq0rRDAiRgOgIUQNNVCTNEAiQQKgIUwFCRph0SIAHTEaAAmq5KmCESIIFQEfh/y70krdeQ2+IAAAAASUVORK5CYII=";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./MassAndSpring/MassAndSpring.gif"]="data:image/gif;base64,R0lGODlhbwBHAIcAAAAAAP8A/+/v/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAIALAAAAABvAEcAAAj/AAUIHEiwoMGDCBMqXMiwocOHECNKnEixosWLGDNq3Mixo0MAIEOKHEkSgMeTHEuqLImyJcaVMEO6nEkxZkyaOCHahJmzJ8OdK30KRQhU5dCjBIuyRIpUKUmmTZ2KhHpU6lSqQq3KxOpTK0iuXb2C7enV5FicZc+iFat2Ztq2Lt/CRSl3rse6dlOyzUv06se9fAeGDECY8NeGePkCKMy4sNmFie0ubkz5cMLIcCdTrgwZMNGDjwWDNhha9OXNqAOULog5KenVsGG/Pp0a9WrBnmWz1p2UN27atTn31dqbtYDSlgWaRI78+G7gwRnfVg44uXPmxrG71k46uu3hVn+H4l6efXt50dxZe988vezV8c5Nw4cfX3n9670Hr2/c3vN98vKZFyB6Av63H3/gSUWaafWZ9diDAzYYIHIHSpegU6NJaN+GEG4YX4cNwlahapf592GE+KEIIIc/jTjdcSbC+NyMv9FI3UcHvggjcYEdt56OO4bXI0jRWfcajz36mBqQ1CGZpH6OMdmkkEnmZ6RCrVUZUZZaPsRll4jFCKaXYo4ZppNmbllmmliuyeaFSr0p0Zdy7oZmnZ3diWeJeu4Jmpt+BqlgoHlSSSicRR3aZp+KCopho38yqiidkFZq6aVsBgQAOw==";
__base64Images["./MassAndSpring/masses-spring-projectile-screenshot.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
