/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslatorResourceUtil
extends TranslatorUtil {
    private String classname;
    private Simulation simulation;
    private Map<LocaleItem, Map<String, String>> translations = new HashMap<LocaleItem, Map<String, String>>();
    private Map<String, String> currentTranslation;
    private JMenu langMenu = null;

    public TranslatorResourceUtil(String string) {
        this.classname = string.replace('.', '/');
        this.currentTranslation = this.defaultProperties;
        TranslatorResourceUtil.readPropertiesFile(this.defaultProperties, this.classname);
        this.translations.put(LocaleItem.getDefaultItem(), this.defaultProperties);
    }

    @Override
    protected String getValueOf(String string) {
        String string2 = this.currentTranslation.get(string);
        if (string2 == null) {
            string2 = (String)this.defaultProperties.get(string);
        }
        return string2;
    }

    @Override
    public void addTranslation(String string) {
        LocaleItem localeItem = LocaleItem.getLocaleItem(string);
        if (localeItem != null) {
            Map<String, String> map = this.translations.get(localeItem);
            if (map != null) {
                return;
            }
            map = new HashMap<String, String>();
            TranslatorResourceUtil.readPropertiesFile(map, String.valueOf(this.classname) + "_" + localeItem.getKeyword());
            this.translations.put(localeItem, map);
        } else {
            System.out.println("Warning! Ignored invalid locale " + string);
        }
    }

    @Override
    public void setLocaleItem(LocaleItem localeItem) {
        this.currentTranslation = this.translations.get(localeItem);
        if (this.currentTranslation == null) {
            this.currentTranslation = this.defaultProperties;
        }
    }

    @Override
    public void addToMenu(JMenu jMenu, Simulation simulation) {
        this.simulation = simulation;
        this.langMenu = new JMenu(ToolsRes.getString("TranslatorTool.Label.Description"));
        jMenu.add(this.langMenu);
    }

    @Override
    public void refreshMenu() {
        if (this.langMenu == null) {
            return;
        }
        this.langMenu.removeAll();
        ArrayList<LocaleItem> arrayList = new ArrayList<LocaleItem>(this.translations.keySet());
        Collections.sort(arrayList);
        for (LocaleItem localeItem : arrayList) {
            this.langMenu.add(new MyMenuItem(localeItem));
        }
    }

    private static boolean readPropertiesFile(Map<String, String> map, String string) {
        Resource resource = ResourceLoader.getResource(String.valueOf(string) + ".properties");
        if (resource == null) {
            System.out.println("Warning! Ignored unavailable resource file : " + string + ".properties.");
            return false;
        }
        try {
            InputStream inputStream = resource.openInputStream();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, LocaleItem.getCharset()));
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                int n = string2.indexOf("=");
                if (n > -1) {
                    String string3 = string2.substring(0, n);
                    String string4 = string2.substring(n + 1);
                    map.put(string3, string4);
                }
                string2 = bufferedReader.readLine();
            }
            return true;
        }
        catch (IOException iOException) {
            System.out.println("Warning! Error reading resource file " + string + ".");
            return false;
        }
    }

    private class MyMenuItem
    extends JMenuItem {
        LocaleItem item;

        MyMenuItem(LocaleItem localeItem) {
            super(localeItem.toString());
            this.item = localeItem;
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    TranslatorResourceUtil.this.simulation.setLocaleItem(MyMenuItem.this.item);
                }
            });
        }
    }
}

