/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import org.colos.ejs.library.control.displayejs.ControlElementSet;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveSpring;

public class ControlSpringSet
extends ControlElementSet {
    protected Drawable createDrawable() {
        this.elementSet = new ElementSet(1, InteractiveSpring.class);
        this.elementSet.setEnabled(1, true);
        return this.elementSet;
    }

    protected int getPropertiesDisplacement() {
        return 0;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("color")) {
            return "lineColor";
        }
        if (string.equals("secondaryColor")) {
            return "fillColor";
        }
        if (string.equals("enabled")) {
            return "enabledSize";
        }
        if (string.equals("enabledSecondary")) {
            return "enabledPosition";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("radius")) {
            return "int|double|double[]";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 3: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n2 = 0;
                    int n3 = Math.min(this.elementSet.getNumberOfElements(), dArray.length);
                    while (n2 < n3) {
                        ((InteractiveSpring)this.elementSet.elementAt(n2)).setRadius(dArray[n2]);
                        ++n2;
                    }
                } else {
                    double d = value.getDouble();
                    int n4 = 0;
                    int n5 = this.elementSet.getNumberOfElements();
                    while (n4 < n5) {
                        ((InteractiveSpring)this.elementSet.elementAt(n4)).setRadius(d);
                        ++n4;
                    }
                }
                break;
            }
            case 11: {
                if (value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(1, (boolean[])value.getObject());
                    break;
                }
                this.elementSet.setEnabled(1, value.getBoolean());
                break;
            }
            case 12: {
                if (value.getObject() instanceof boolean[]) {
                    this.elementSet.setEnableds(0, (boolean[])value.getObject());
                    break;
                }
                this.elementSet.setEnabled(0, value.getBoolean());
                break;
            }
            default: {
                super.setValue(n, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 3: {
                int n2 = 0;
                int n3 = this.elementSet.getNumberOfElements();
                while (n2 < n3) {
                    ((InteractiveSpring)this.elementSet.elementAt(n2)).setRadius(0.1);
                    ++n2;
                }
                break;
            }
            case 11: {
                this.elementSet.setEnabled(1, true);
                break;
            }
            case 12: {
                this.elementSet.setEnabled(0, false);
                break;
            }
            default: {
                super.setDefaultValue(n);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 3: {
                return "0.1";
            }
            case 11: {
                return "true";
            }
            case 12: {
                return "false";
            }
        }
        return super.getDefaultValueString(n);
    }
}

