/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.JProgressBarDouble;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlBar
extends ControlSwingElement {
    protected JProgressBarDouble bar;
    private String formatStr = null;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.bar = new JProgressBarDouble(0);
        return this.bar;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("minimum");
            infoList.add("maximum");
            infoList.add("format");
            infoList.add("orientation");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "int|double";
        }
        if (string.equals("minimum")) {
            return "int|double";
        }
        if (string.equals("maximum")) {
            return "int|double";
        }
        if (string.equals("format")) {
            return "Format|Object|String  TRANSLATABLE";
        }
        if (string.equals("orientation")) {
            return "Orientation|int";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.bar.setDoubleValue(value.getDouble());
                break;
            }
            case 1: {
                this.bar.setDoubleMinimum(value.getDouble());
                break;
            }
            case 2: {
                this.bar.setDoubleMaximum(value.getDouble());
                break;
            }
            case 3: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.formatStr = null;
                    this.bar.setFormat((DecimalFormat)value.getObject());
                    break;
                }
                String string = TeXParser.parseTeX(value.getString());
                if (string.equals(this.formatStr)) {
                    return;
                }
                this.formatStr = string;
                this.bar.setFormat((DecimalFormat)ConstantParser.formatConstant(this.formatStr).getObject());
                break;
            }
            case 4: {
                if (this.bar.getOrientation() == value.getInteger()) break;
                this.bar.setOrientation(value.getInteger());
                break;
            }
            default: {
                super.setValue(n - 5, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.bar.setDoubleMinimum(0.0);
                break;
            }
            case 2: {
                this.bar.setDoubleMaximum(1.0);
                break;
            }
            case 3: {
                this.formatStr = null;
                this.bar.setFormat((DecimalFormat)null);
                break;
            }
            case 4: {
                this.bar.setOrientation(0);
                break;
            }
            default: {
                super.setDefaultValue(n - 5);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 5);
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "0.0";
            }
            case 2: {
                return "1.0";
            }
            case 3: {
                return "<none>";
            }
            case 4: {
                return "HORIZONTAL";
            }
        }
        return super.getDefaultValueString(n - 5);
    }
}

