/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing2d.ControlSet2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementImage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlImageSet2D
extends ControlSet2D {
    private static final int PROPERTIES_ADDED = 3;
    static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 3;
    }

    @Override
    protected Element createAnElement() {
        ElementImage elementImage = new ElementImage();
        return elementImage;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementImage)element2).setImageFile(((ElementImage)element).getImageFile());
        ((ElementImage)element2).setTrueSize(((ElementImage)element).isTrueSize());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("imageFile");
            infoList.add("trueSize");
            infoList.add("elementposition");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("imageFile")) {
            return "File|String|String[] TRANSLATABLE";
        }
        if (string.equals("trueSize")) {
            return "boolean|boolean[]";
        }
        if (string.equals("elementposition")) {
            return "ElementPosition|int|int[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof String[]) {
                    String[] stringArray = (String[])value.getObject();
                    int n2 = 0;
                    int n3 = Math.min(this.elements.length, stringArray.length);
                    while (n2 < n3) {
                        ((ElementImage)this.elements[n2]).setImageFile(stringArray[n2]);
                        ++n2;
                    }
                } else {
                    String string = value.getString();
                    int n4 = 0;
                    while (n4 < this.elements.length) {
                        ((ElementImage)this.elements[n4]).setImageFile(string);
                        ++n4;
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n5 = 0;
                    int n6 = Math.min(this.elements.length, blArray.length);
                    while (n5 < n6) {
                        ((ElementImage)this.elements[n5]).setTrueSize(blArray[n5]);
                        ++n5;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n7 = 0;
                    while (n7 < this.elements.length) {
                        ((ElementImage)this.elements[n7]).setTrueSize(bl);
                        ++n7;
                    }
                }
                break;
            }
            case 2: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n8 = 0;
                    int n9 = Math.min(this.elements.length, nArray.length);
                    while (n8 < n9) {
                        this.elements[n8].getStyle().setRelativePosition(nArray[n8]);
                        ++n8;
                    }
                } else {
                    int n10 = value.getInteger();
                    int n11 = 0;
                    while (n11 < this.elements.length) {
                        this.elements[n11].getStyle().setRelativePosition(n10);
                        ++n11;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 3, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.elements.length) {
                    ((ElementImage)this.elements[n2]).setImageFile(null);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.elements.length) {
                    ((ElementImage)this.elements[n3]).setTrueSize(false);
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.elements.length) {
                    this.elements[n4].getStyle().setRelativePosition(0);
                    ++n4;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 3);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "false";
            }
            case 2: {
                return "CENTERED";
            }
        }
        return super.getDefaultValueString(n - 3);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(n - 3);
    }
}

