/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.TreeMap;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.media.core.ClipControl;
import org.opensourcephysics.media.core.ClipInspector;
import org.opensourcephysics.media.core.MediaRes;
import org.opensourcephysics.media.core.Video;
import org.opensourcephysics.media.core.VideoClip;
import org.opensourcephysics.media.core.VideoClipControl;
import org.opensourcephysics.media.core.VideoPanel;
import org.opensourcephysics.tools.ResourceLoader;

public class VideoPlayer
extends JComponent
implements PropertyChangeListener {
    protected VideoPanel vidPanel;
    protected ClipControl clipControl;
    private String[] readoutTypes;
    private String readoutType;
    private boolean inspectorButtonVisible = false;
    protected int height = 54;
    private boolean linkedIn;
    private boolean linkedOut;
    private JToolBar toolbar;
    protected JButton readout;
    private JButton playButton;
    private JSpinner rateSpinner;
    private JButton stepButton;
    private JButton stepSizeButton;
    private JButton backButton;
    private JButton loopButton;
    private JButton inspectorButton;
    private JSlider slider;
    private Hashtable<Integer, JLabel> sliderLabels;
    private Icon playIcon;
    private Icon grayPlayIcon;
    private Icon pauseIcon;
    private Icon resetIcon;
    private Icon loopIcon;
    private Icon noloopIcon;
    private JLabel inLabel;
    private JLabel outLabel;
    private NumberFormat timeFormat = NumberFormat.getNumberInstance();
    private String active;

    public VideoPlayer(VideoPanel videoPanel, VideoClip videoClip) {
        this(videoPanel);
        this.setVideoClip(videoClip);
    }

    public VideoPlayer(VideoPanel videoPanel) {
        this.vidPanel = videoPanel;
        this.vidPanel.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                if (VideoPlayer.this.vidPanel.isPlayerVisible()) {
                    VideoPlayer.this.setBounds();
                    VideoPlayer.this.vidPanel.repaint();
                }
            }
        });
        this.createGUI();
        this.timeFormat.setMinimumIntegerDigits(1);
        this.timeFormat.setMaximumFractionDigits(3);
        this.timeFormat.setMinimumFractionDigits(3);
        this.clipControl = ClipControl.getControl(new VideoClip(null));
        this.clipControl.addPropertyChangeListener(this);
        this.getVideoClip().addPropertyChangeListener(this);
        this.updatePlayButtons(false);
        this.updateSlider();
        this.setReadoutTypes("frame time step");
        this.refresh();
    }

    public void setVideoClip(VideoClip videoClip) {
        boolean bl = this.clipControl.isPlaying();
        this.stop();
        if (this.getVideoClip() == videoClip) {
            ClipInspector clipInspector;
            boolean bl2 = this.clipControl.isLooping();
            double d = this.clipControl.getRate();
            double d2 = this.clipControl.getMeanFrameDuration();
            this.clipControl.removePropertyChangeListener(this);
            this.clipControl.dispose();
            this.clipControl = ClipControl.getControl(videoClip);
            this.clipControl.addPropertyChangeListener(this);
            this.clipControl.setLooping(bl2);
            this.clipControl.setRate(d);
            this.clipControl.setFrameDuration(d2);
            if (bl) {
                this.clipControl.play();
            }
            if ((clipInspector = this.getVideoClip().inspector) != null) {
                clipInspector.clipControl = this.clipControl;
            }
        } else {
            VideoClip videoClip2 = this.getVideoClip();
            videoClip2.removePropertyChangeListener(this);
            videoClip2.hideClipInspector();
            Video video2 = videoClip2.getVideo();
            if (video2 != null) {
                video2.dispose();
            }
            videoClip2.video = null;
            if (videoClip == null) {
                videoClip = new VideoClip(null);
            }
            videoClip.addPropertyChangeListener(this);
            this.clipControl.removePropertyChangeListener(this);
            this.clipControl.dispose();
            this.clipControl = ClipControl.getControl(videoClip);
            this.clipControl.addPropertyChangeListener(this);
            this.setReadoutTypes("frame time step");
            this.updatePlayButtons(this.clipControl.isPlaying());
            this.updateLoopButton(this.clipControl.isLooping());
            this.updateReadout();
            this.updateSlider();
            this.firePropertyChange("videoclip", videoClip2, videoClip);
            System.gc();
        }
    }

    public VideoClip getVideoClip() {
        return this.clipControl.getVideoClip();
    }

    public ClipControl getClipControl() {
        return this.clipControl;
    }

    public void setReadoutTypes(String string) {
        TreeMap<Integer, String> treeMap = new TreeMap<Integer, String>();
        String string2 = string.toLowerCase();
        int n = string2.indexOf("time");
        if (n >= 0) {
            treeMap.put(new Integer(n), "time");
        }
        if ((n = string2.indexOf("step")) >= 0) {
            treeMap.put(new Integer(n), "step");
        }
        if ((n = string2.indexOf("frame")) >= 0) {
            treeMap.put(new Integer(n), "frame");
        }
        if (treeMap.isEmpty()) {
            return;
        }
        this.readoutTypes = treeMap.values().toArray(new String[0]);
        this.setReadoutType(this.readoutTypes[0]);
    }

    public void setReadoutType(String string) {
        String string2 = string.toLowerCase();
        String string3 = " " + MediaRes.getString("VideoPlayer.Readout.ToolTip");
        if (string2.indexOf("time") >= 0) {
            this.readoutType = "time";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Time")) + string3);
        } else if (string2.indexOf("step") >= 0) {
            this.readoutType = "step";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Step")) + string3);
        } else if (string2.indexOf("frame") >= 0) {
            this.readoutType = "frame";
            this.readout.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.Readout.ToolTip.Frame")) + string3);
        }
        boolean bl = false;
        int n = 0;
        while (n < this.readoutTypes.length) {
            bl = bl || this.readoutTypes[n] == this.readoutType;
            ++n;
        }
        if (!bl) {
            String[] stringArray = new String[this.readoutTypes.length + 1];
            stringArray[0] = this.readoutType;
            int n2 = 0;
            while (n2 < this.readoutTypes.length) {
                stringArray[n2 + 1] = this.readoutTypes[n2];
                ++n2;
            }
            this.readoutTypes = stringArray;
        }
        this.updateReadout();
    }

    public void play() {
        this.clipControl.play();
    }

    public void stop() {
        this.clipControl.stop();
    }

    public void step() {
        this.stop();
        this.clipControl.step();
    }

    public void back() {
        this.stop();
        this.clipControl.back();
    }

    public void setRate(double d) {
        this.clipControl.setRate(d);
    }

    public double getRate() {
        return this.clipControl.getRate();
    }

    public void setLooping(boolean bl) {
        this.clipControl.setLooping(bl);
    }

    public boolean isLooping() {
        return this.clipControl.isLooping();
    }

    public void setStepNumber(int n) {
        this.clipControl.setStepNumber(n);
    }

    public int getStepNumber() {
        return this.clipControl.getStepNumber();
    }

    public int getFrameNumber() {
        return this.clipControl.getFrameNumber();
    }

    public double getTime() {
        return this.clipControl.getTime() + this.clipControl.clip.getStartTime();
    }

    public double getStepTime(int n) {
        return this.clipControl.getStepTime(n) + this.clipControl.clip.getStartTime();
    }

    public double getFrameTime(int n) {
        return this.clipControl.clip.getStartTime() - (double)(this.clipControl.clip.getStartFrameNumber() - n) * this.clipControl.getMeanFrameDuration();
    }

    public double getMeanStepDuration() {
        return this.getClipControl().getMeanFrameDuration() * (double)this.getVideoClip().getStepSize();
    }

    public void setInspectorButtonVisible(final boolean bl) {
        if (bl == this.inspectorButtonVisible) {
            return;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                VideoPlayer.this.inspectorButtonVisible = bl;
                if (bl) {
                    VideoPlayer.this.toolbar.add(VideoPlayer.this.inspectorButton);
                } else {
                    VideoPlayer.this.toolbar.remove(VideoPlayer.this.inspectorButton);
                }
                VideoPlayer.this.toolbar.revalidate();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void setLoopingButtonVisible(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (bl) {
                    VideoPlayer.this.toolbar.add(VideoPlayer.this.loopButton);
                } else {
                    VideoPlayer.this.toolbar.remove(VideoPlayer.this.loopButton);
                }
                VideoPlayer.this.toolbar.revalidate();
            }
        };
        EventQueue.invokeLater(runnable);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("stepnumber")) {
            this.updateReadout();
            this.updatePlayButtons(this.clipControl.isPlaying());
            int n = this.clipControl.getFrameNumber();
            if (this.active == null) {
                this.linkedIn = n == this.getVideoClip().getStartFrameNumber();
                this.linkedOut = n == this.getVideoClip().getEndFrameNumber();
            }
            this.firePropertyChange("stepnumber", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("frameduration")) {
            this.updateReadout();
            this.firePropertyChange("frameduration", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("playing")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.updatePlayButtons(bl);
            this.firePropertyChange("playing", null, propertyChangeEvent.getNewValue());
        } else if (string.equals("looping")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.updateLoopButton(bl);
        } else if (string.equals("rate")) {
            this.rateSpinner.setValue(new Double(this.getRate()));
        } else if (string.equals("stepcount")) {
            this.updatePlayButtons(this.clipControl.isPlaying());
            this.updateReadout();
            this.updateSlider();
        } else if (string.equals("framecount")) {
            this.updateSlider();
        } else if (string.equals("stepsize")) {
            this.updateReadout();
            this.updateSlider();
        } else if (string.equals("startframe")) {
            this.updateReadout();
            this.updateSlider();
        } else if (string.equals("starttime")) {
            this.updateReadout();
        }
    }

    public void refresh() {
        this.stepButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepForward.ToolTip"));
        this.backButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepBack.ToolTip"));
        this.inspectorButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.ClipSettings.ToolTip"));
        this.loopButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Looping.ToolTip"));
        this.setReadoutType(this.readoutType);
        this.updatePlayButtons(this.clipControl.isPlaying());
        this.updateLoopButton(this.clipControl.isLooping());
        if (this.getVideoClip().inspector != null) {
            this.getVideoClip().inspector.refresh();
        }
    }

    private void setBounds() {
        this.toolbar.revalidate();
        this.height = this.playButton.getPreferredSize().height + 8;
        int n = this.vidPanel.getHeight() - this.height;
        int n2 = this.vidPanel.getWidth();
        this.setBounds(0, n, n2, this.height);
        this.toolbar.revalidate();
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this.toolbar = new JToolBar();
        this.toolbar.setFloatable(false);
        this.add((Component)this.toolbar, "South");
        this.setBorder(BorderFactory.createEtchedBorder());
        this.playIcon = new VideoPlayerIcon("play");
        this.grayPlayIcon = new VideoPlayerIcon("grayplay");
        this.pauseIcon = new VideoPlayerIcon("pause");
        this.resetIcon = new VideoPlayerIcon("reset");
        this.playButton = new PlayerButton(this.playIcon, this.pauseIcon);
        this.playButton.setDisabledIcon(this.grayPlayIcon);
        this.playButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (VideoPlayer.this.playButton.isSelected()) {
                    VideoPlayer.this.stop();
                } else if (VideoPlayer.this.getVideoClip().getStepCount() == VideoPlayer.this.clipControl.getStepNumber() + 1) {
                    VideoPlayer.this.clipControl.setStepNumber(0);
                    VideoPlayer.this.updatePlayButtons(false);
                } else {
                    VideoPlayer.this.play();
                }
            }
        });
        this.playButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    if (VideoPlayer.this.playButton.isSelected()) {
                        VideoPlayer.this.stop();
                    } else if (VideoPlayer.this.getVideoClip().getStepCount() == VideoPlayer.this.clipControl.getStepNumber() + 1) {
                        VideoPlayer.this.clipControl.setStepNumber(0);
                        VideoPlayer.this.updatePlayButtons(false);
                    } else {
                        VideoPlayer.this.play();
                    }
                }
            }
        });
        SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(1.0, 0.01, 5.0, 0.1);
        this.rateSpinner = new JSpinner(spinnerNumberModel){

            public Dimension getPreferredSize() {
                return this.getMinimumSize();
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.height = ((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height;
                dimension.width = 52;
                return dimension;
            }

            public Dimension getMaximumSize() {
                return this.getMinimumSize();
            }
        };
        final JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this.rateSpinner, "0%");
        numberEditor.getTextField().setHorizontalAlignment(2);
        numberEditor.getTextField().setFont(new Font("Dialog", 0, 12));
        this.rateSpinner.setEditor(numberEditor);
        this.rateSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                VideoPlayer.this.setRate((Double)VideoPlayer.this.rateSpinner.getValue());
            }
        });
        numberEditor.getTextField().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    double d = (Double)VideoPlayer.this.rateSpinner.getValue();
                    try {
                        int n = Integer.parseInt(numberEditor.getTextField().getText());
                        double d2 = Math.max((double)n / 100.0, 0.01);
                        d2 = Math.min(d2, 5.0);
                        if (d2 != d) {
                            VideoPlayer.this.rateSpinner.setValue(new Double(d2));
                        } else {
                            int n2 = (int)(d * 100.0);
                            numberEditor.getTextField().setText(String.valueOf(String.valueOf(n2)) + "%");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        int n = (int)(d * 100.0);
                        numberEditor.getTextField().setText(String.valueOf(String.valueOf(n)) + "%");
                    }
                    numberEditor.getTextField().selectAll();
                }
            }
        });
        this.stepButton = new PlayerButton((Icon)new VideoPlayerIcon("step"));
        this.stepButton.setDisabledIcon(new VideoPlayerIcon("graystep"));
        this.stepButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VideoPlayer.this.step();
            }
        });
        this.backButton = new PlayerButton((Icon)new VideoPlayerIcon("back"));
        this.backButton.setDisabledIcon(new VideoPlayerIcon("grayback"));
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VideoPlayer.this.back();
            }
        });
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == VideoPlayer.this.stepButton) {
                    VideoPlayer.this.firePropertyChange("stepbutton", null, new Boolean(true));
                } else {
                    VideoPlayer.this.firePropertyChange("backbutton", null, new Boolean(true));
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                if (mouseEvent.getSource() == VideoPlayer.this.stepButton) {
                    VideoPlayer.this.firePropertyChange("stepbutton", null, new Boolean(false));
                } else {
                    VideoPlayer.this.firePropertyChange("backbutton", null, new Boolean(false));
                }
            }
        };
        this.stepButton.addMouseListener(mouseAdapter);
        this.backButton.addMouseListener(mouseAdapter);
        this.slider = new JSlider(0, 0, 0);
        this.slider.setMinorTickSpacing(1);
        this.slider.setSnapToTicks(true);
        this.slider.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        this.slider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                VideoClip videoClip;
                int n = VideoPlayer.this.slider.getValue();
                if (n < (videoClip = VideoPlayer.this.getVideoClip()).getStartFrameNumber()) {
                    VideoPlayer.this.slider.setValue(videoClip.getStartFrameNumber());
                } else if (n > videoClip.getEndFrameNumber()) {
                    VideoPlayer.this.slider.setValue(videoClip.getEndFrameNumber());
                } else {
                    int n2 = videoClip.frameToStep(n);
                    if (n2 != VideoPlayer.this.getStepNumber()) {
                        VideoPlayer.this.setStepNumber(n2);
                    } else if (!videoClip.includesFrame(n)) {
                        VideoPlayer.this.slider.setValue(videoClip.stepToFrame(n2));
                    }
                }
            }
        });
        String string = "/org/opensourcephysics/cabrillo/tracker/resources/images/in_out.gif";
        ImageIcon imageIcon = ResourceLoader.getIcon(string);
        this.inLabel = new JLabel(imageIcon);
        this.outLabel = new JLabel(imageIcon);
        this.sliderLabels = new Hashtable();
        this.sliderLabels.put(new Integer(0), this.inLabel);
        this.sliderLabels.put(new Integer(9), this.outLabel);
        this.slider.setLabelTable(this.sliderLabels);
        this.slider.setPaintLabels(true);
        final MouseListener mouseListener = this.slider.getMouseListeners()[0];
        this.slider.removeMouseListener(mouseListener);
        final MouseMotionListener mouseMotionListener = this.slider.getMouseMotionListeners()[0];
        this.slider.removeMouseMotionListener(mouseMotionListener);
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            float inset = 0.0f;
            int x;
            int maxEndFrame;

            public void mousePressed(MouseEvent mouseEvent) {
                this.maxEndFrame = VideoPlayer.this.getVideoClip().getEndFrameNumber();
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    JMenuItem jMenuItem;
                    ActionListener actionListener = new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            VideoClip videoClip = VideoPlayer.this.getVideoClip();
                            int n = (this).VideoPlayer.this.clipControl.getFrameNumber();
                            if ("in".equals(actionEvent.getActionCommand())) {
                                videoClip.setStartFrameNumber(n, maxEndFrame);
                                if (videoClip.inspector != null && videoClip.inspector.isVisible()) {
                                    videoClip.inspector.startField.setValue(videoClip.getStartFrameNumber());
                                }
                            } else {
                                videoClip.setEndFrameNumber(n);
                                if (videoClip.inspector != null && videoClip.inspector.isVisible()) {
                                    videoClip.inspector.endField.setValue(videoClip.getEndFrameNumber());
                                }
                            }
                        }
                    };
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    if (VideoPlayer.this.active == null || VideoPlayer.this.active.equals("in")) {
                        jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Slider.Popup.Menu.SetIn"));
                        jMenuItem.setActionCommand("in");
                        jMenuItem.addActionListener(actionListener);
                        jPopupMenu.add(jMenuItem);
                    }
                    if (VideoPlayer.this.active == null || VideoPlayer.this.active.equals("out")) {
                        jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Slider.Popup.Menu.SetOut"));
                        jMenuItem.setActionCommand("out");
                        jMenuItem.addActionListener(actionListener);
                        jPopupMenu.add(jMenuItem);
                    }
                    VideoPlayer.this.active = null;
                    jPopupMenu.show(VideoPlayer.this.slider, mouseEvent.getX(), mouseEvent.getY());
                } else if (VideoPlayer.this.active == null) {
                    mouseListener.mousePressed(mouseEvent);
                } else {
                    VideoPlayer.this.stop();
                    this.x = mouseEvent.getX();
                    if (VideoPlayer.this.active == "in") {
                        int n = VideoPlayer.this.getVideoClip().getStartFrameNumber();
                        VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + n);
                    } else if (VideoPlayer.this.active == "out") {
                        int n = VideoPlayer.this.getVideoClip().getEndFrameNumber();
                        VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + n);
                    }
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (VideoPlayer.this.active == null) {
                    mouseListener.mouseReleased(mouseEvent);
                } else {
                    VideoPlayer.this.getVideoClip().trimFrameCount();
                    VideoPlayer.this.vidPanel.setMessage(null);
                }
            }

            public void mouseExited(MouseEvent mouseEvent) {
                VideoPlayer.this.vidPanel.setMouseCursor(Cursor.getDefaultCursor());
                mouseListener.mouseExited(mouseEvent);
                VideoPlayer.this.firePropertyChange("slider", null, new Boolean(false));
            }

            public void mouseMoved(MouseEvent mouseEvent) {
                VideoPlayer.this.active = null;
                int n = VideoPlayer.this.slider.getHeight() - VideoPlayer.this.inLabel.getHeight() - 2;
                if (this.inset == 0.0f) {
                    this.inset = ((VideoPlayer)VideoPlayer.this).slider.getInsets().left + 7;
                }
                if (mouseEvent.getY() > n) {
                    double d = ((float)VideoPlayer.this.slider.getWidth() - 2.0f * this.inset) / (float)VideoPlayer.this.slider.getMaximum();
                    int n2 = VideoPlayer.this.getVideoClip().getStartFrameNumber();
                    int n3 = (int)((double)this.inset + (double)n2 * d);
                    String string = " " + MediaRes.getString("VideoPlayer.InOutMarker.ToolTip");
                    if (mouseEvent.getX() < n3 + 5 && mouseEvent.getX() > n3 - 5) {
                        VideoPlayer.this.active = "in";
                        VideoPlayer.this.slider.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + n2 + string);
                    } else {
                        int n4 = VideoPlayer.this.getVideoClip().getEndFrameNumber();
                        n3 = (int)((double)this.inset + (double)n4 * d);
                        if (mouseEvent.getX() < n3 + 5 && mouseEvent.getX() > n3 - 5) {
                            VideoPlayer.this.active = "out";
                            VideoPlayer.this.slider.setToolTipText(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + n4 + string);
                        }
                    }
                }
                if (VideoPlayer.this.active == null) {
                    mouseMotionListener.mouseMoved(mouseEvent);
                    VideoPlayer.this.vidPanel.setMouseCursor(Cursor.getDefaultCursor());
                    VideoPlayer.this.slider.setToolTipText(MediaRes.getString("VideoPlayer.Slider.ToolTip"));
                } else {
                    VideoPlayer.this.vidPanel.setMouseCursor(Cursor.getPredefinedCursor(12));
                }
            }

            public void mouseDragged(MouseEvent mouseEvent) {
                if (VideoPlayer.this.active == null) {
                    mouseMotionListener.mouseDragged(mouseEvent);
                    return;
                }
                boolean bl = mouseEvent.getX() > this.x;
                this.x = mouseEvent.getX();
                int n = Math.round((float)VideoPlayer.this.slider.getMaximum() * ((float)mouseEvent.getX() - this.inset) / ((float)VideoPlayer.this.slider.getWidth() - 2.0f * this.inset));
                n = bl ? Math.min(n, VideoPlayer.this.slider.getMaximum() + VideoPlayer.this.getVideoClip().getStepSize()) : Math.min(n, VideoPlayer.this.slider.getMaximum());
                n = Math.max(n, 0);
                if (VideoPlayer.this.active.equals("in")) {
                    VideoClip videoClip = VideoPlayer.this.getVideoClip();
                    int n2 = videoClip.getStartFrameNumber();
                    VideoPlayer.this.linkedIn = VideoPlayer.this.linkedIn || VideoPlayer.this.clipControl.getFrameNumber() == videoClip.getStartFrameNumber();
                    if (videoClip.setStartFrameNumber(n, this.maxEndFrame)) {
                        int n3 = videoClip.getStartFrameNumber();
                        VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.InMarker.ToolTip")) + ": " + n3);
                        if (!videoClip.isDefaultStartTime) {
                            double d = videoClip.getStartTime();
                            videoClip.setStartTime(d += (double)(n3 - n2) * VideoPlayer.this.clipControl.getMeanFrameDuration());
                        }
                        if (VideoPlayer.this.linkedIn) {
                            VideoPlayer.this.clipControl.setStepNumber(0);
                        }
                        if (videoClip.inspector != null && videoClip.inspector.isVisible()) {
                            videoClip.inspector.startField.setValue(n3);
                            videoClip.inspector.t0Field.setValue(videoClip.getStartTime() / 1000.0);
                        }
                        VideoPlayer.this.updateReadout();
                    }
                } else if (VideoPlayer.this.active.equals("out")) {
                    boolean bl2;
                    VideoClip videoClip = VideoPlayer.this.getVideoClip();
                    VideoPlayer.this.linkedOut = VideoPlayer.this.linkedOut || VideoPlayer.this.clipControl.getFrameNumber() == videoClip.getEndFrameNumber();
                    boolean bl3 = bl2 = videoClip.getVideo() == null && n > videoClip.getFrameCount() - 1;
                    if (videoClip.setEndFrameNumber(n)) {
                        int n4 = videoClip.getEndFrameNumber();
                        VideoPlayer.this.vidPanel.setMessage(String.valueOf(MediaRes.getString("VideoPlayer.OutMarker.ToolTip")) + ": " + n4);
                        if (VideoPlayer.this.linkedOut || bl2) {
                            Video video2 = videoClip.getVideo();
                            if (video2 != null && video2.getFrameCount() > 1) {
                                VideoPlayer.this.clipControl.setStepNumber(videoClip.getStepCount() - 1);
                            }
                            VideoPlayer.this.updateReadout();
                        }
                        if (videoClip.inspector != null && videoClip.inspector.isVisible()) {
                            videoClip.inspector.endField.setValue(videoClip.getEndFrameNumber());
                        }
                    }
                }
            }
        };
        this.slider.addMouseListener(mouseInputAdapter);
        this.slider.addMouseMotionListener(mouseInputAdapter);
        InputMap inputMap = this.slider.getInputMap(0);
        ActionMap actionMap = SwingUtilities.getUIActionMap(this.slider);
        actionMap.put(inputMap.get(KeyStroke.getKeyStroke(33, 0)), null);
        actionMap.put(inputMap.get(KeyStroke.getKeyStroke(34, 0)), null);
        this.slider.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                switch (keyEvent.getKeyCode()) {
                    case 33: {
                        VideoPlayer.this.back();
                        break;
                    }
                    case 34: {
                        VideoPlayer.this.step();
                    }
                }
            }
        });
        this.readout = new PlayerButton(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = ((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height;
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.height = ((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height;
                return dimension;
            }

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = ((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height;
                return dimension;
            }
        };
        this.readout.setForeground(new Color(204, 51, 51));
        this.readout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (VideoPlayer.this.readoutTypes.length < 2) {
                    return;
                }
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        VideoPlayer.this.setReadoutType(actionEvent.getActionCommand());
                    }
                };
                ActionListener actionListener2 = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ClipInspector clipInspector;
                        Object object = JOptionPane.showInputDialog((this).VideoPlayer.this.vidPanel, MediaRes.getString("VideoPlayer.Dialog.SetTime.Message"), String.valueOf(MediaRes.getString("VideoPlayer.Dialog.SetTime.Title")) + " " + VideoPlayer.this.getFrameNumber(), -1, null, null, VideoPlayer.this.getTime() / 1000.0);
                        if (object != null) {
                            try {
                                double d = Double.parseDouble(object.toString());
                                double d2 = d * 1000.0 - (this).VideoPlayer.this.clipControl.getTime();
                                VideoPlayer.this.getVideoClip().setStartTime(d2);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        if ((clipInspector = (this).VideoPlayer.this.getVideoClip().inspector) != null && clipInspector.isVisible()) {
                            clipInspector.t0Field.setValue(VideoPlayer.this.getVideoClip().getStartTime() / 1000.0);
                        }
                    }
                };
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenu jMenu = new JMenu(MediaRes.getString("VideoPlayer.Readout.Menu.Display"));
                jPopupMenu.add(jMenu);
                int n = 0;
                while (n < VideoPlayer.this.readoutTypes.length) {
                    JMenuItem jMenuItem;
                    String string = VideoPlayer.this.readoutTypes[n];
                    if (string.equals("step")) {
                        jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Step"));
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(actionListener);
                        jMenu.add(jMenuItem);
                    } else if (string.equals("time")) {
                        jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Time"));
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(actionListener);
                        jMenu.add(jMenuItem);
                        jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.Menu.SetTime"));
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(actionListener2);
                        jMenuItem.addActionListener(actionListener);
                        jPopupMenu.add(jMenuItem);
                    } else {
                        jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Readout.MenuItem.Frame"));
                        jMenuItem.setActionCommand(string);
                        jMenuItem.addActionListener(actionListener);
                        jMenu.add(jMenuItem);
                    }
                    ++n;
                }
                jPopupMenu.show(VideoPlayer.this.readout, 0, VideoPlayer.this.readout.getHeight());
            }
        });
        this.readout.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    VideoPlayer.this.readout.doClick(0);
                }
            }
        });
        this.stepSizeButton = new PlayerButton(){

            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.height = ((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height;
                return dimension;
            }

            public Dimension getMinimumSize() {
                Dimension dimension = super.getMinimumSize();
                dimension.height = ((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height;
                return dimension;
            }

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = ((VideoPlayer)VideoPlayer.this).playButton.getPreferredSize().height;
                return dimension;
            }
        };
        this.stepSizeButton.setForeground(new Color(204, 51, 51));
        this.stepSizeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        VideoClip videoClip;
                        int n;
                        block3: {
                            n = VideoPlayer.this.getFrameNumber();
                            videoClip = VideoPlayer.this.getVideoClip();
                            try {
                                int n2 = Integer.parseInt(actionEvent.getActionCommand());
                                videoClip.setStepSize(n2);
                            }
                            catch (NumberFormatException numberFormatException) {
                                String string = String.valueOf(VideoPlayer.this.getVideoClip().getStepSize());
                                Object object = JOptionPane.showInputDialog((this).VideoPlayer.this.vidPanel, MediaRes.getString("VideoPlayer.Dialog.StepSize.Message"), MediaRes.getString("VideoPlayer.Dialog.StepSize.Title"), -1, null, null, string);
                                if (object == null) break block3;
                                int n3 = Integer.parseInt(object.toString());
                                videoClip.setStepSize(n3);
                            }
                        }
                        VideoPlayer.this.setStepNumber(videoClip.frameToStep(n));
                        if (videoClip.inspector != null && videoClip.inspector.isVisible()) {
                            videoClip.inspector.stepSizeField.setValue(videoClip.getStepSize());
                        }
                    }
                };
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenu jMenu = new JMenu(MediaRes.getString("VideoPlayer.Button.StepSize.Popup.Menu"));
                jPopupMenu.add(jMenu);
                int n = 1;
                while (n < 6) {
                    JMenuItem jMenuItem = new JMenuItem(String.valueOf(n));
                    jMenuItem.addActionListener(actionListener);
                    jMenu.add(jMenuItem);
                    ++n;
                }
                jMenu.addSeparator();
                JMenuItem jMenuItem = new JMenuItem(MediaRes.getString("VideoPlayer.Button.StepSize.Other"));
                jMenuItem.addActionListener(actionListener);
                jMenu.add(jMenuItem);
                jPopupMenu.show(VideoPlayer.this.stepSizeButton, 0, VideoPlayer.this.stepSizeButton.getHeight());
            }
        });
        this.stepSizeButton.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    VideoPlayer.this.stepSizeButton.doClick(0);
                }
            }
        });
        this.inspectorButton = new PlayerButton((Icon)new VideoPlayerIcon("inspector"));
        this.inspectorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClipInspector clipInspector;
                Frame frame = null;
                Container container = VideoPlayer.this.vidPanel.getTopLevelAncestor();
                if (container instanceof Frame) {
                    frame = (Frame)container;
                }
                if ((clipInspector = VideoPlayer.this.getVideoClip().getClipInspector(VideoPlayer.this.clipControl, frame)).isVisible()) {
                    return;
                }
                Point point = clipInspector.getLocation();
                if (point.x == 0 && point.y == 0) {
                    Dimension dimension = VideoPlayer.this.vidPanel.getSize();
                    Point point2 = VideoPlayer.this.vidPanel.getLocationOnScreen();
                    int n = (point2.x + dimension.width - clipInspector.getBounds().width) / 2;
                    int n2 = (point2.y + dimension.height - clipInspector.getBounds().height) / 2;
                    clipInspector.setLocation(n, n2);
                }
                clipInspector.initialize();
                clipInspector.setVisible(true);
            }
        });
        this.loopIcon = new VideoPlayerIcon("loop");
        this.noloopIcon = new VideoPlayerIcon("noloop");
        this.loopButton = new PlayerButton(this.noloopIcon, this.loopIcon);
        this.loopButton.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                VideoPlayer.this.setLooping(!VideoPlayer.this.loopButton.isSelected());
            }
        });
        this.loopButton.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 32) {
                    VideoPlayer.this.setLooping(!VideoPlayer.this.loopButton.isSelected());
                }
            }
        });
        this.toolbar.add(this.readout);
        this.toolbar.add(this.rateSpinner);
        this.toolbar.add(this.playButton);
        this.toolbar.add(this.slider);
        this.toolbar.add(this.backButton);
        this.toolbar.add(this.stepSizeButton);
        this.toolbar.add(this.stepButton);
        this.toolbar.add(this.loopButton);
        if (this.inspectorButtonVisible) {
            this.toolbar.add(this.inspectorButton);
        }
    }

    private void updatePlayButtons(final boolean bl) {
        Runnable runnable = new Runnable(){

            public void run() {
                int n = VideoPlayer.this.getVideoClip().getStepCount();
                boolean bl2 = n > 1;
                VideoPlayer.this.playButton.setEnabled(bl2);
                VideoPlayer.this.stepButton.setEnabled(bl2 && (bl || VideoPlayer.this.getStepNumber() < n - 1));
                VideoPlayer.this.backButton.setEnabled(bl2 && (bl || VideoPlayer.this.getStepNumber() > 0));
                VideoPlayer.this.playButton.setSelected(bl);
                if (bl) {
                    VideoPlayer.this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Pause.ToolTip"));
                    VideoPlayer.this.playButton.setPressedIcon(VideoPlayer.this.pauseIcon);
                    VideoPlayer.this.playButton.setIcon(VideoPlayer.this.pauseIcon);
                } else if (n <= VideoPlayer.this.getStepNumber() + 1 && bl2) {
                    VideoPlayer.this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Reset.ToolTip"));
                    VideoPlayer.this.playButton.setPressedIcon(VideoPlayer.this.resetIcon);
                    VideoPlayer.this.playButton.setIcon(VideoPlayer.this.resetIcon);
                } else {
                    VideoPlayer.this.playButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.Play.ToolTip"));
                    VideoPlayer.this.playButton.setPressedIcon(VideoPlayer.this.playIcon);
                    VideoPlayer.this.playButton.setIcon(VideoPlayer.this.playIcon);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private void updateLoopButton(boolean bl) {
        if (bl == this.loopButton.isSelected()) {
            return;
        }
        this.loopButton.setSelected(bl);
        if (bl) {
            this.loopButton.setPressedIcon(this.loopIcon);
            this.loopButton.setIcon(this.loopIcon);
        } else {
            this.loopButton.setPressedIcon(this.noloopIcon);
            this.loopButton.setIcon(this.noloopIcon);
        }
    }

    private void updateReadout() {
        String string;
        int n = this.clipControl.getFrameNumber();
        int n2 = this.getVideoClip().getStartFrameNumber();
        int n3 = this.getVideoClip().getEndFrameNumber();
        if (n < n2) {
            this.clipControl.setStepNumber(0);
        } else if (n > n3) {
            this.clipControl.setStepNumber(this.getVideoClip().getStepCount());
        }
        this.slider.setValue(this.clipControl.getFrameNumber());
        int n4 = this.clipControl.getStepNumber();
        if (this.readoutType.equals("step")) {
            string = n4 < 10 ? "00" + n4 : (n4 < 100 ? "0" + n4 : "" + n4);
        } else if (this.readoutType.equals("frame")) {
            int n5 = this.clipControl.getFrameNumber();
            if (this.clipControl instanceof VideoClipControl) {
                n5 = this.getVideoClip().getVideo().getFrameNumber();
            }
            string = n5 < 10 ? "00" + n5 : (n5 < 100 ? "0" + n5 : "" + n5);
        } else {
            string = this.timeFormat.format(this.getTime() / 1000.0);
        }
        this.readout.setText(string);
        this.stepSizeButton.setText("" + this.getVideoClip().getStepSize());
        this.stepSizeButton.setToolTipText(MediaRes.getString("VideoPlayer.Button.StepSize.ToolTip"));
        this.rateSpinner.setToolTipText(MediaRes.getString("VideoPlayer.Spinner.Rate.ToolTip"));
        if (n4 == this.getVideoClip().getStepCount() - 1) {
            this.updatePlayButtons(this.clipControl.isPlaying());
        }
    }

    private void updateSlider() {
        VideoClip videoClip = this.getVideoClip();
        this.slider.setMaximum(videoClip.getFrameCount() - 1);
        this.sliderLabels.clear();
        this.sliderLabels.put(new Integer(videoClip.getStartFrameNumber()), this.inLabel);
        this.sliderLabels.put(new Integer(videoClip.getEndFrameNumber()), this.outLabel);
        this.slider.repaint();
    }

    protected class PlayerButton
    extends JButton {
        Icon onIcon;
        Icon offIcon;

        public PlayerButton() {
            this.setOpaque(false);
            this.setBorderPainted(false);
            this.addMouseListener(new MouseAdapter(){

                public void mouseEntered(MouseEvent mouseEvent) {
                    PlayerButton.this.setBorderPainted(true);
                }

                public void mouseExited(MouseEvent mouseEvent) {
                    PlayerButton.this.setBorderPainted(false);
                }
            });
        }

        public PlayerButton(Icon icon) {
            this();
            this.setIcon(icon);
        }

        public PlayerButton(Icon icon, Icon icon2) {
            this();
            this.onIcon = icon2;
            this.offIcon = icon;
            this.setIcon(icon);
        }

        public void setIcon(Icon icon) {
            super.setIcon(icon);
            this.setSelectedIcon(icon);
            this.setRolloverSelectedIcon(icon);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            if (bl && this.onIcon != null) {
                this.setIcon(this.onIcon);
            } else if (!bl && this.offIcon != null) {
                this.setIcon(this.offIcon);
            }
        }
    }

    private class VideoPlayerIcon
    implements Icon {
        private Color shapeColor;
        private Color shadowColor;
        private Color hiliteColor;
        private Shape shape;
        private Shape shadow;
        private Shape hilite;

        VideoPlayerIcon(String string) {
            if (string.equals("play")) {
                this.createPlayIcon();
            } else if (string.equals("grayplay")) {
                this.createPlayIcon();
                this.setToGray();
            } else if (string.equals("pause")) {
                this.createPauseIcon();
            } else if (string.equals("reset")) {
                this.createResetIcon();
            } else if (string.equals("step")) {
                this.createStepIcon();
            } else if (string.equals("graystep")) {
                this.createStepIcon();
                this.setToGray();
            } else if (string.equals("back")) {
                this.createBackIcon();
            } else if (string.equals("grayback")) {
                this.createBackIcon();
                this.setToGray();
            } else if (string.equals("inspector")) {
                this.createInspectorIcon();
            } else if (string.equals("loop")) {
                this.createLoopIcon();
            } else if (string.equals("noloop")) {
                this.createNoloopIcon();
            }
        }

        private void setToGray() {
            this.shapeColor = new Color(204, 204, 204);
            this.shadowColor = new Color(102, 102, 102);
        }

        public int getIconWidth() {
            return 14;
        }

        public int getIconHeight() {
            return 14;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.shape == null) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Paint paint = graphics2D.getPaint();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.translate(n, n2);
            graphics2D.setPaint(this.shapeColor);
            graphics2D.fill(this.shape);
            if (this.shadow != null) {
                graphics2D.setPaint(this.shadowColor);
                graphics2D.fill(this.shadow);
            }
            if (this.hilite != null) {
                graphics2D.setPaint(this.hiliteColor);
                graphics2D.fill(this.hilite);
            }
            graphics2D.setPaint(paint);
            graphics2D.setTransform(affineTransform);
        }

        private void createPlayIcon() {
            this.shapeColor = new Color(51, 204, 51);
            this.shadowColor = new Color(51, 102, 51);
            this.hiliteColor = Color.white;
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(4.5f, 4.5f);
            generalPath.lineTo(4.5f, 10.5f);
            generalPath.moveTo(5.5f, 5.5f);
            generalPath.lineTo(5.5f, 9.5f);
            generalPath.moveTo(6.5f, 5.5f);
            generalPath.lineTo(6.5f, 9.5f);
            generalPath.moveTo(7.5f, 6.5f);
            generalPath.lineTo(7.5f, 8.5f);
            generalPath.moveTo(8.5f, 6.5f);
            generalPath.lineTo(8.5f, 8.5f);
            generalPath.moveTo(9.5f, 7.5f);
            generalPath.lineTo(10.5f, 7.5f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(4.5f, 3.5f);
            generalPath.lineTo(3.5f, 3.5f);
            generalPath.lineTo(3.5f, 10.5f);
            generalPath.moveTo(5.5f, 4.5f);
            generalPath.lineTo(6.5f, 4.5f);
            generalPath.moveTo(7.5f, 5.5f);
            generalPath.lineTo(8.5f, 5.5f);
            generalPath.moveTo(9.5f, 6.5f);
            generalPath.lineTo(10.5f, 6.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(3.5f, 11.5f);
            generalPath.lineTo(4.5f, 11.5f);
            generalPath.moveTo(5.5f, 10.5f);
            generalPath.lineTo(6.5f, 10.5f);
            generalPath.moveTo(7.5f, 9.5f);
            generalPath.lineTo(8.5f, 9.5f);
            generalPath.moveTo(9.5f, 8.5f);
            generalPath.lineTo(10.5f, 8.5f);
            this.hilite = basicStroke.createStrokedShape(generalPath);
        }

        private void createResetIcon() {
            this.shapeColor = Color.black;
            this.shadowColor = new Color(51, 51, 51);
            this.hiliteColor = Color.white;
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(4.5f, 4.5f);
            generalPath.lineTo(4.5f, 10.5f);
            generalPath.moveTo(9.5f, 4.5f);
            generalPath.lineTo(9.5f, 10.5f);
            generalPath.moveTo(8.5f, 5.5f);
            generalPath.lineTo(8.5f, 9.5f);
            generalPath.moveTo(7.5f, 6.5f);
            generalPath.lineTo(7.5f, 8.5f);
            generalPath.moveTo(6.5f, 7.5f);
            generalPath.lineTo(6.5f, 8.0f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(4.5f, 3.5f);
            generalPath.lineTo(5.5f, 3.5f);
            generalPath.lineTo(5.5f, 10.5f);
            generalPath.moveTo(6.5f, 6.5f);
            generalPath.lineTo(7.0f, 6.5f);
            generalPath.moveTo(7.5f, 5.5f);
            generalPath.lineTo(8.0f, 5.5f);
            generalPath.moveTo(8.5f, 4.5f);
            generalPath.lineTo(9.0f, 4.5f);
            generalPath.moveTo(9.5f, 3.5f);
            generalPath.lineTo(10.5f, 3.5f);
            generalPath.lineTo(10.5f, 10.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(5.5f, 11.5f);
            generalPath.lineTo(4.5f, 11.5f);
            generalPath.moveTo(10.5f, 11.5f);
            generalPath.lineTo(9.5f, 11.5f);
            generalPath.moveTo(8.5f, 10.5f);
            generalPath.lineTo(9.0f, 10.5f);
            generalPath.moveTo(7.5f, 9.5f);
            generalPath.lineTo(8.0f, 9.5f);
            generalPath.moveTo(6.5f, 8.5f);
            generalPath.lineTo(7.0f, 8.5f);
            this.hilite = basicStroke.createStrokedShape(generalPath);
        }

        private void createPauseIcon() {
            this.shapeColor = new Color(204, 51, 51);
            this.shadowColor = new Color(102, 51, 51);
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(5.5f, 4.5f);
            generalPath.lineTo(5.5f, 10.5f);
            generalPath.moveTo(9.5f, 4.5f);
            generalPath.lineTo(9.5f, 10.5f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(5.5f, 3.5f);
            generalPath.lineTo(4.5f, 3.5f);
            generalPath.lineTo(4.5f, 10.5f);
            generalPath.moveTo(9.5f, 3.5f);
            generalPath.lineTo(8.5f, 3.5f);
            generalPath.lineTo(8.5f, 10.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
        }

        private void createStepIcon() {
            this.shapeColor = new Color(51, 51, 204);
            this.shadowColor = new Color(51, 51, 102);
            this.hiliteColor = Color.white;
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(4.5f, 4.5f);
            generalPath.lineTo(4.5f, 10.5f);
            generalPath.moveTo(7.5f, 4.5f);
            generalPath.lineTo(7.5f, 10.5f);
            generalPath.moveTo(8.5f, 5.5f);
            generalPath.lineTo(8.5f, 9.5f);
            generalPath.moveTo(9.5f, 6.5f);
            generalPath.lineTo(9.5f, 8.5f);
            generalPath.moveTo(10.5f, 7.5f);
            generalPath.lineTo(10.5f, 8.0f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(4.5f, 3.5f);
            generalPath.lineTo(3.5f, 3.5f);
            generalPath.lineTo(3.5f, 10.5f);
            generalPath.moveTo(10.5f, 6.5f);
            generalPath.lineTo(11.0f, 6.5f);
            generalPath.moveTo(9.5f, 5.5f);
            generalPath.lineTo(10.0f, 5.5f);
            generalPath.moveTo(8.5f, 4.5f);
            generalPath.lineTo(9.0f, 4.5f);
            generalPath.moveTo(7.5f, 3.5f);
            generalPath.lineTo(6.5f, 3.5f);
            generalPath.lineTo(6.5f, 10.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(3.5f, 11.5f);
            generalPath.lineTo(4.5f, 11.5f);
            generalPath.moveTo(6.5f, 11.5f);
            generalPath.lineTo(7.5f, 11.5f);
            generalPath.moveTo(8.5f, 10.5f);
            generalPath.lineTo(9.0f, 10.5f);
            generalPath.moveTo(9.5f, 9.5f);
            generalPath.lineTo(10.0f, 9.5f);
            generalPath.moveTo(10.5f, 8.5f);
            generalPath.lineTo(11.0f, 8.5f);
            this.hilite = basicStroke.createStrokedShape(generalPath);
        }

        private void createBackIcon() {
            this.shapeColor = new Color(51, 51, 204);
            this.shadowColor = new Color(51, 51, 102);
            this.hiliteColor = Color.white;
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(9.5f, 4.5f);
            generalPath.lineTo(9.5f, 10.5f);
            generalPath.moveTo(6.5f, 4.5f);
            generalPath.lineTo(6.5f, 10.5f);
            generalPath.moveTo(5.5f, 5.5f);
            generalPath.lineTo(5.5f, 9.5f);
            generalPath.moveTo(4.5f, 6.5f);
            generalPath.lineTo(4.5f, 8.5f);
            generalPath.moveTo(3.5f, 7.5f);
            generalPath.lineTo(3.5f, 8.0f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(9.5f, 3.5f);
            generalPath.lineTo(10.5f, 3.5f);
            generalPath.lineTo(10.5f, 10.5f);
            generalPath.moveTo(3.5f, 6.5f);
            generalPath.lineTo(4.0f, 6.5f);
            generalPath.moveTo(4.5f, 5.5f);
            generalPath.lineTo(5.0f, 5.5f);
            generalPath.moveTo(5.5f, 4.5f);
            generalPath.lineTo(6.0f, 4.5f);
            generalPath.moveTo(6.5f, 3.5f);
            generalPath.lineTo(7.5f, 3.5f);
            generalPath.lineTo(7.5f, 10.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(10.5f, 11.5f);
            generalPath.lineTo(9.5f, 11.5f);
            generalPath.moveTo(7.5f, 11.5f);
            generalPath.lineTo(6.5f, 11.5f);
            generalPath.moveTo(5.5f, 10.5f);
            generalPath.lineTo(6.0f, 10.5f);
            generalPath.moveTo(4.5f, 9.5f);
            generalPath.lineTo(5.0f, 9.5f);
            generalPath.moveTo(3.5f, 8.5f);
            generalPath.lineTo(4.0f, 8.5f);
            this.hilite = basicStroke.createStrokedShape(generalPath);
        }

        private void createInspectorIcon() {
            this.shapeColor = new Color(51, 51, 51);
            this.shadowColor = Color.black;
            this.hiliteColor = new Color(153, 153, 255);
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(8.5f, 12.5f);
            generalPath.lineTo(2.5f, 12.5f);
            generalPath.lineTo(2.5f, 2.5f);
            generalPath.lineTo(4.5f, 2.5f);
            generalPath.lineTo(4.5f, 11.5f);
            generalPath.moveTo(3.5f, 8.5f);
            generalPath.lineTo(12.5f, 8.5f);
            generalPath.lineTo(12.5f, 2.5f);
            generalPath.lineTo(10.5f, 2.5f);
            generalPath.lineTo(10.5f, 7.5f);
            generalPath.moveTo(3.5f, 4.5f);
            generalPath.lineTo(11.5f, 4.5f);
            generalPath.moveTo(3.5f, 6.5f);
            generalPath.lineTo(3.5f, 6.5f);
            generalPath.moveTo(3.5f, 10.5f);
            generalPath.lineTo(3.5f, 10.5f);
            generalPath.moveTo(11.5f, 6.5f);
            generalPath.lineTo(11.5f, 6.5f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(9.5f, 10.5f);
            generalPath.lineTo(13.5f, 10.5f);
            generalPath.moveTo(10.5f, 11.5f);
            generalPath.lineTo(12.5f, 11.5f);
            generalPath.moveTo(11.5f, 12.5f);
            generalPath.lineTo(12.0f, 12.5f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
            generalPath.reset();
            generalPath.moveTo(5.5f, 2.5f);
            generalPath.lineTo(9.5f, 2.5f);
            generalPath.moveTo(5.5f, 3.5f);
            generalPath.lineTo(9.5f, 3.5f);
            generalPath.moveTo(5.5f, 5.5f);
            generalPath.lineTo(9.5f, 5.5f);
            generalPath.moveTo(5.5f, 6.5f);
            generalPath.lineTo(9.5f, 6.5f);
            generalPath.moveTo(5.5f, 7.5f);
            generalPath.lineTo(9.5f, 7.5f);
            generalPath.moveTo(5.5f, 9.5f);
            generalPath.lineTo(7.5f, 9.5f);
            generalPath.moveTo(5.5f, 10.5f);
            generalPath.lineTo(6.5f, 10.5f);
            generalPath.moveTo(5.5f, 11.5f);
            generalPath.lineTo(7.5f, 11.5f);
            this.hilite = basicStroke.createStrokedShape(generalPath);
        }

        private void createLoopIcon() {
            this.shapeColor = new Color(0, 153, 0);
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(3.5f, 4.5f);
            generalPath.lineTo(3.5f, 2.5f);
            generalPath.lineTo(10.5f, 2.5f);
            generalPath.lineTo(10.5f, 7.5f);
            generalPath.moveTo(7.5f, 4.5f);
            generalPath.lineTo(13.5f, 4.5f);
            generalPath.moveTo(8.5f, 5.5f);
            generalPath.lineTo(12.5f, 5.5f);
            generalPath.moveTo(9.5f, 6.5f);
            generalPath.lineTo(11.5f, 6.5f);
            generalPath.moveTo(10.5f, 9.5f);
            generalPath.lineTo(10.5f, 11.5f);
            generalPath.lineTo(3.5f, 11.5f);
            generalPath.lineTo(3.5f, 6.5f);
            generalPath.moveTo(0.5f, 9.5f);
            generalPath.lineTo(6.5f, 9.5f);
            generalPath.moveTo(1.5f, 8.5f);
            generalPath.lineTo(5.5f, 8.5f);
            generalPath.moveTo(2.5f, 7.5f);
            generalPath.lineTo(4.5f, 7.5f);
            this.shape = basicStroke.createStrokedShape(generalPath);
        }

        private void createNoloopIcon() {
            this.shapeColor = new Color(0, 153, 0);
            this.shadowColor = Color.black;
            GeneralPath generalPath = new GeneralPath();
            BasicStroke basicStroke = new BasicStroke();
            generalPath.moveTo(3.5f, 4.5f);
            generalPath.lineTo(3.5f, 2.5f);
            generalPath.lineTo(10.5f, 2.5f);
            generalPath.lineTo(10.5f, 7.5f);
            generalPath.moveTo(7.5f, 4.5f);
            generalPath.lineTo(13.5f, 4.5f);
            generalPath.moveTo(8.5f, 5.5f);
            generalPath.lineTo(12.5f, 5.5f);
            generalPath.moveTo(9.5f, 6.5f);
            generalPath.lineTo(11.5f, 6.5f);
            this.shape = basicStroke.createStrokedShape(generalPath);
            basicStroke = new BasicStroke(2.0f);
            generalPath.reset();
            generalPath.moveTo(9.0f, 9.0f);
            generalPath.lineTo(12.5f, 9.0f);
            this.shadow = basicStroke.createStrokedShape(generalPath);
        }
    }
}

