/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.image.BufferedImage;
import java.rmi.RemoteException;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.media.core.VideoGrabber;
import org.opensourcephysics.media.core.VideoType;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.VideoTool;

public class VideoCaptureTool
implements Tool,
VideoTool {
    private VideoCaptureTool mediaCap;

    public VideoCaptureTool() {
    }

    protected VideoCaptureTool(boolean bl) {
    }

    @Override
    public boolean addFrame(BufferedImage bufferedImage) {
        return this.getGrabber().addFrame(bufferedImage);
    }

    @Override
    public void clear() {
        this.getGrabber().clear();
    }

    public void setRecording(boolean bl) {
        this.getGrabber().setRecording(bl);
    }

    @Override
    public boolean isRecording() {
        return this.getGrabber().isRecording();
    }

    @Override
    public void setVisible(boolean bl) {
        this.getGrabber().setVisible(bl);
    }

    public boolean isVisible() {
        return this.getGrabber().isVisible();
    }

    public boolean canCapture() {
        return this.getGrabber() != null;
    }

    public void setVideoType(VideoType videoType) {
        this.getGrabber().setVideoType(videoType);
    }

    public void setFrameRate(double d) {
        this.getGrabber().setFrameRate(d);
    }

    @Override
    public void send(Job job, Tool tool) throws RemoteException {
        BufferedImage bufferedImage;
        if (job == null) {
            return;
        }
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        String string = xMLControlElement.getString("imagepath");
        if (string != null && (bufferedImage = ResourceLoader.getBufferedImage(string)) != null) {
            this.addFrame(bufferedImage);
        }
    }

    public static VideoCaptureTool getTool() {
        return VideoGrabber.getTool();
    }

    private VideoCaptureTool getGrabber() {
        if (this.mediaCap == null) {
            this.mediaCap = new VideoGrabber();
        }
        return this.mediaCap;
    }
}

