/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.media.core;

import org.opensourcephysics.media.core.NumberField;

public class ScientificField
extends NumberField {
    private double zeroLimit = 1.0E-10;

    public ScientificField(int n) {
        this(n, 4);
    }

    public ScientificField(int n, int n2) {
        super(n, n2);
        char c = '.';
        this.fixedPattern = true;
        String string = "";
        int n3 = 0;
        while (n3 < this.sigfigs - 1) {
            string = String.valueOf(string) + "0";
            ++n3;
        }
        this.format.applyPattern("0" + c + string + "E0");
    }

    @Override
    public void setValue(double d) {
        if (Math.abs(d) < this.zeroLimit) {
            d = 0.0;
        }
        super.setValue(d);
    }

    @Override
    public void setSigFigs(int n) {
        if (this.sigfigs == n) {
            return;
        }
        n = Math.max(n, 2);
        this.sigfigs = Math.min(n, 6);
    }

    @Override
    public void setExpectedRange(double d, double d2) {
    }
}

