/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;

public class ElementShape
extends Element {
    public static final int NONE = 0;
    public static final int ELLIPSE = 1;
    public static final int RECTANGLE = 2;
    public static final int ROUND_RECTANGLE = 3;
    public static final int WHEEL = 4;
    protected int shapeType = -1;
    protected boolean trueSize = false;
    private double[] coordinates = new double[2];
    private double[] pixel = new double[2];
    private double[] pixelSize = new double[2];
    private RectangularShape shape;
    private Line2D line1;
    private Line2D line2;
    private AffineTransform trueSizeTransform = new AffineTransform();

    public ElementShape() {
        this.setSize(new double[]{0.1, 0.1});
        this.setShapeType(1);
    }

    public void setShapeType(int _type) {
        if (this.shapeType == _type) {
            return;
        }
        this.shapeType = _type;
        this.recreateShape();
    }

    public int getShapeType() {
        return this.shapeType;
    }

    public void setPixelSize(boolean _s) {
        this.trueSize = _s;
        this.setNeedToProject(true);
    }

    public boolean isPixelSize() {
        return this.trueSize;
    }

    @Override
    protected void styleChanged(int styleThatChanged) {
        if (styleThatChanged == 5) {
            this.recreateShape();
            this.setNeedToProject(true);
        }
    }

    @Override
    protected int getCorners(double[] _corners) {
        if (this.trueSize) {
            _corners[1] = 0.0;
            _corners[0] = 0.0;
            return 1;
        }
        switch (this.getStyle().getRelativePosition()) {
            default: {
                _corners[0] = -0.5;
                _corners[1] = -0.5;
                break;
            }
            case 1: {
                _corners[0] = -0.5;
                _corners[1] = -1.0;
                break;
            }
            case 2: {
                _corners[0] = -0.5;
                _corners[1] = 0.0;
                break;
            }
            case 3: {
                _corners[0] = -1.0;
                _corners[1] = -0.5;
                break;
            }
            case 4: {
                _corners[0] = 0.0;
                _corners[1] = -0.5;
                break;
            }
            case 5: {
                _corners[0] = -1.0;
                _corners[1] = -1.0;
                break;
            }
            case 6: {
                _corners[0] = 0.0;
                _corners[1] = -1.0;
                break;
            }
            case 7: {
                _corners[0] = -1.0;
                _corners[1] = 0.0;
                break;
            }
            case 8: {
                _corners[0] = 0.0;
                _corners[1] = 0.0;
            }
        }
        _corners[4] = _corners[2] = _corners[0] + 1.0;
        _corners[6] = _corners[0];
        _corners[3] = _corners[1];
        _corners[5] = _corners[7] = _corners[1] + 1.0;
        return 4;
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        AffineTransform tr;
        if (!this.isReallyVisible()) {
            return;
        }
        Graphics2D g2 = (Graphics2D)_g;
        g2.setStroke(this.getStyle().getLineStroke());
        Color color = this.getStyle().getLineColor();
        if (this.shape == null) {
            if (this.hasChanged() || this.needsToProject()) {
                this.projectPoints();
            }
            g2.setColor(color);
            g2.drawOval((int)this.pixel[0], (int)this.pixel[1], 1, 1);
            return;
        }
        Paint fill = this.getStyle().getFillColor();
        if (this.trueSize) {
            if (this.hasChanged() || this.needsToProject()) {
                this.projectPoints();
            }
            tr = new AffineTransform(this.trueSizeTransform);
            tr.preConcatenate(this.getPixelTransform(_panel));
        } else {
            tr = this.getPixelTransform(_panel);
        }
        Shape trShape = tr.createTransformedShape(this.shape);
        if (fill != null && this.getStyle().isDrawingFill()) {
            g2.setPaint(fill);
            g2.fill(trShape);
        }
        if (color != null && this.getStyle().isDrawingLines()) {
            g2.setColor(color);
            if (this.shapeType == 4) {
                g2.draw(tr.createTransformedShape(this.line1));
                g2.draw(tr.createTransformedShape(this.line2));
            }
            g2.draw(trShape);
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        int sensitivity;
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        if ((sensitivity = this.getStyle().getSensitivity()) <= 0) {
            AffineTransform tr;
            if (this.shape == null) {
                if (Math.abs(this.pixel[0] - (double)_xpix) < 1.0 && Math.abs(this.pixel[1] - (double)_ypix) < 1.0) {
                    return this.targetPosition;
                }
                return null;
            }
            if (this.trueSize) {
                tr = new AffineTransform(this.trueSizeTransform);
                tr.preConcatenate(this.getPixelTransform(_panel));
            } else {
                tr = this.getPixelTransform(_panel);
            }
            Shape trShape = tr.createTransformedShape(this.shape);
            if (trShape.contains(_xpix, _ypix)) {
                return this.targetPosition;
            }
        } else if (Math.abs(this.pixel[0] - (double)_xpix) < (double)sensitivity && Math.abs(this.pixel[1] - (double)_ypix) < (double)sensitivity) {
            return this.targetPosition;
        }
        return null;
    }

    private void recreateShape() {
        double y1;
        double x1;
        if (this.shapeType == 0) {
            this.shape = null;
            return;
        }
        switch (this.getStyle().getRelativePosition()) {
            default: {
                x1 = -0.5;
                y1 = -0.5;
                break;
            }
            case 1: {
                x1 = -0.5;
                y1 = -1.0;
                break;
            }
            case 2: {
                x1 = -0.5;
                y1 = 0.0;
                break;
            }
            case 3: {
                x1 = -1.0;
                y1 = -0.5;
                break;
            }
            case 4: {
                x1 = 0.0;
                y1 = -0.5;
                break;
            }
            case 5: {
                x1 = -1.0;
                y1 = -1.0;
                break;
            }
            case 6: {
                x1 = 0.0;
                y1 = -1.0;
                break;
            }
            case 7: {
                x1 = -1.0;
                y1 = 0.0;
                break;
            }
            case 8: {
                x1 = 0.0;
                y1 = 0.0;
            }
        }
        double x2 = x1 + 1.0;
        double y2 = y1 + 1.0;
        switch (this.shapeType) {
            case 4: {
                this.line1 = new Line2D.Double(x1 + 0.5, y1, x1 + 0.5, y2);
                this.line2 = new Line2D.Double(x1, y1 + 0.5, x2, y1 + 0.5);
            }
            default: {
                this.shape = new Ellipse2D.Double(x1, y1, 1.0, 1.0);
                break;
            }
            case 2: {
                this.shape = new Rectangle2D.Double(x1, y1, 1.0, 1.0);
                break;
            }
            case 3: {
                this.shape = new RoundRectangle2D.Double(x1, y1, 1.0, 1.0, 0.3, 0.3);
            }
        }
        this.setElementChanged();
    }

    private void projectPoints() {
        this.coordinates[0] = 0.0;
        this.coordinates[1] = 0.0;
        this.getTotalTransform().transform(this.coordinates, 0, this.coordinates, 0, 1);
        this.getPanel().projectPosition(this.coordinates, this.pixel);
        if (this.trueSize) {
            this.getPanel().projectSize(this.coordinates, this.getSize(), this.pixelSize);
            this.trueSizeTransform = AffineTransform.getScaleInstance(this.pixelSize[0] == 0.0 ? 0.0 : this.getSizeX() / this.pixelSize[0], this.pixelSize[1] == 0.0 ? 0.0 : this.getSizeY() / this.pixelSize[1]);
        }
        this.setNeedToProject(false);
    }
}

