/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing2d.ControlSet2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementText;

public class ControlTextSet2D
extends ControlSet2D {
    private static final int PROPERTIES_ADDED = 4;
    private Font defaultElementFont;
    static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 4;
    }

    @Override
    protected Element createAnElement() {
        ElementText el = new ElementText();
        return el;
    }

    public ControlTextSet2D() {
        this.defaultElementFont = ((ElementText)this.elements[0]).getFont();
    }

    @Override
    protected void copyAnElement(Element oldElement, Element newElement) {
        super.copyAnElement(oldElement, newElement);
        ((ElementText)newElement).setText(((ElementText)oldElement).getText());
        ((ElementText)newElement).setFont(((ElementText)oldElement).getFont());
        ((ElementText)newElement).setTrueSize(((ElementText)oldElement).isTrueSize());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("text");
            infoList.add("font");
            infoList.add("pixelSize");
            infoList.add("elementposition");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("text")) {
            return "String|String[] TRANSLATABLE";
        }
        if (_property.equals("font")) {
            return "Font|Object|Object[]";
        }
        if (_property.equals("pixelSize")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("elementposition")) {
            return "ElementPosition|int|int[]";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getObject() instanceof String[]) {
                    String[] val = (String[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        ((ElementText)this.elements[i]).setText(val[i]);
                        ++i;
                    }
                } else {
                    String val = _value.getString();
                    int i = 0;
                    while (i < this.elements.length) {
                        ((ElementText)this.elements[i]).setText(val);
                        ++i;
                    }
                }
                break;
            }
            case 1: {
                if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        ((ElementText)this.elements[i]).setFont((Font)val[i]);
                        ++i;
                    }
                } else {
                    Font val = (Font)_value.getObject();
                    int i = 0;
                    while (i < this.elements.length) {
                        ((ElementText)this.elements[i]).setFont(val);
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        ((ElementText)this.elements[i]).setTrueSize(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.elements.length) {
                        ((ElementText)this.elements[i]).setTrueSize(val);
                        ++i;
                    }
                }
                break;
            }
            case 3: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setRelativePosition(val[i]);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setRelativePosition(val);
                        ++i;
                    }
                }
                break;
            }
            default: {
                super.setValue(_index - 4, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                int i = 0;
                while (i < this.elements.length) {
                    ((ElementText)this.elements[i]).setText("");
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < this.elements.length) {
                    ((ElementText)this.elements[i]).setFont(this.defaultElementFont);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.elements.length) {
                    ((ElementText)this.elements[i]).setTrueSize(false);
                    ++i;
                }
                break;
            }
            case 3: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getStyle().setRelativePosition(0);
                    ++i;
                }
                break;
            }
            default: {
                super.setDefaultValue(_index - 4);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "<none>";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "false";
            }
            case 3: {
                return "CENTERED";
            }
        }
        return super.getDefaultValueString(_index - 4);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return null;
            }
        }
        return super.getValue(_index - 4);
    }
}

