/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing2d.ControlSet2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementShape;

public class ControlShapeSet2D
extends ControlSet2D {
    private static final int PROPERTIES_ADDED = 3;
    static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 3;
    }

    @Override
    protected Element createAnElement() {
        ElementShape el = new ElementShape();
        return el;
    }

    @Override
    protected void copyAnElement(Element oldElement, Element newElement) {
        super.copyAnElement(oldElement, newElement);
        ((ElementShape)newElement).setShapeType(((ElementShape)oldElement).getShapeType());
        ((ElementShape)newElement).setPixelSize(((ElementShape)oldElement).isPixelSize());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("style");
            infoList.add("pixelSize");
            infoList.add("elementposition");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("style")) {
            return "MarkerShape|int|int[]";
        }
        if (_property.equals("pixelSize")) {
            return "boolean|boolean[]";
        }
        if (_property.equals("elementposition")) {
            return "ElementPosition|int|int[]";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        ((ElementShape)this.elements[i]).setShapeType(val[i]);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    while (i < this.elements.length) {
                        ((ElementShape)this.elements[i]).setShapeType(val);
                        ++i;
                    }
                }
                break;
            }
            case 1: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        ((ElementShape)this.elements[i]).setPixelSize(val[i]);
                        ++i;
                    }
                } else {
                    boolean val = _value.getBoolean();
                    int i = 0;
                    while (i < this.elements.length) {
                        ((ElementShape)this.elements[i]).setPixelSize(val);
                        ++i;
                    }
                }
                break;
            }
            case 2: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int i = 0;
                    int n = Math.min(this.elements.length, val.length);
                    while (i < n) {
                        this.elements[i].getStyle().setRelativePosition(val[i]);
                        ++i;
                    }
                } else {
                    int val = _value.getInteger();
                    int i = 0;
                    while (i < this.elements.length) {
                        this.elements[i].getStyle().setRelativePosition(val);
                        ++i;
                    }
                }
                break;
            }
            default: {
                super.setValue(_index - 3, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                int i = 0;
                while (i < this.elements.length) {
                    ((ElementShape)this.elements[i]).setShapeType(1);
                    ++i;
                }
                break;
            }
            case 1: {
                int i = 0;
                while (i < this.elements.length) {
                    ((ElementShape)this.elements[i]).setPixelSize(false);
                    ++i;
                }
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.elements.length) {
                    this.elements[i].getStyle().setRelativePosition(0);
                    ++i;
                }
                break;
            }
            default: {
                super.setDefaultValue(_index - 3);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "ELLIPSE";
            }
            case 1: {
                return "false";
            }
            case 2: {
                return "CENTERED";
            }
        }
        return super.getDefaultValueString(_index - 3);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(_index - 3);
    }
}

