/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.longitudinalwave_pkg;

import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.swing.JOptionPane;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ODEInterpolatorEventSolver;
import org.opensourcephysics.numerics.ODESolverInterpolator;
import org.opensourcephysics.numerics.rk.RK4;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.ntnu.fkh.longitudinalwave_pkg.longitudinalwaveSimulation;
import users.ntnu.fkh.longitudinalwave_pkg.longitudinalwaveView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class longitudinalwave
extends AbstractModel {
    public longitudinalwaveSimulation _simulation = null;
    public longitudinalwaveView _view = null;
    public longitudinalwave _model = this;
    protected Hashtable<String, __PrivateODE> _privateOdesList = new Hashtable();
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double range = 200.0;
    public double xmin = -this.range;
    public double xmax = this.range;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.01;
    public double size = this.range / 25.0;
    public double size1 = this.size / 10.0;
    public double size2 = this.size / 2.0;
    public double stroke = 2.0;
    public double pi = Math.PI;
    public double twopi = 2.0 * this.pi;
    public double psize = 1.0;
    public int n = 192;
    public int n2 = 100;
    public int ny = 10;
    public int nxy = this.n * this.ny;
    public double[] x;
    public double[] x0;
    public double[] x2;
    public double[] xs;
    public double[] ys;
    public double[] v2;
    public double[] a2;
    public double[] xl;
    public double[] vxl;
    public double[] yt;
    public double[] ayt;
    public double[] px;
    public double[] py;
    public double wl = this.xmax / 3.0;
    public double k = this.twopi / this.wl;
    public double T = 2.0;
    public double f = 0.5;
    public double w = this.twopi / this.T;
    public double dx;
    public double yl = 0.0;
    public double v = this.w / this.k;
    public double d = this.size;
    public double dy = this.size * 2.0 / (double)this.ny;
    public double dxt;
    public double v0 = this.size;
    public double y1 = 8.0 * this.size;
    public boolean showvx = false;
    public boolean showp = false;
    public double xc = 0.0;
    public double xc2 = 0.0;
    public double vxc = 0.0;
    public double axc = 0.0;
    public double y2c = this.ymin * 0.6;
    public boolean dirx = true;
    public boolean diry = false;
    public int dragid = -1;
    public double ks = 500.0;
    public double ds = 0.0;
    public double bs = 0.1;
    public double wx = 3.0;
    public double wy = 3.0;
    public double m = 1.0;
    public int np = 8;
    public double c = 0.0;
    public double A = 5.0 * this.size;
    public boolean showvy = false;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_constraints1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public ODEInterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).__getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).__setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/longitudinalwave.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.2/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.2/bin/config/");
        }
        longitudinalwave longitudinalwave2 = new longitudinalwave(stringArray);
    }

    public longitudinalwave() {
        this(null, null, null, null, null, false);
    }

    public longitudinalwave(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public longitudinalwave(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new longitudinalwaveSimulation(this, string, frame, uRL, bl);
        this._view = (longitudinalwaveView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.__resetSolver();
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Evol Page".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._resetSolvers();
        }
        if ("FixRel Page".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        int n;
        this.t = 0.0;
        this.dx = (this.xmax - this.xmin) / (double)this.n;
        for (n = 0; n < this.n; ++n) {
            this.x[n] = this.xmin * 0.8 + ((double)n + 0.5) * this.dx;
        }
        this.ds = (this.xmax - this.xmin) * 0.8 / (double)(this.n2 - 1);
        for (n = 0; n < this.n2; ++n) {
            this.x0[n] = this.xmin * 0.8 + (double)n * this.ds;
        }
        for (n = 0; n < this.n2; ++n) {
            this.x2[n] = 0.0;
            this.v2[n] = 0.0;
        }
        this.v = this.w / this.k;
    }

    public void _constraints1() {
        int n;
        for (n = 0; n < this.n; ++n) {
            this.dxt = this.v * this.t > this.x[n] - this.x[0] ? Math.sin(this.k * this.x[n] - this.w * this.t) : -this.d / 10.0;
            this.xl[n] = this.x[n] + this.d * this.dxt;
            this.vxl[n] = this.d * this.dxt;
            this.yt[n] = this.y1 + 2.0 * this.d * this.dxt;
            this.ayt[n] = Math.cos(this.k * this.x[n] - this.w * this.t);
        }
        this.v2[this.n2 - 1] = 0.0;
        if (this.dragid > -1) {
            if (this.dirx) {
                this.ys[this.dragid] = this.y2c;
            } else {
                this.xs[this.dragid] = this.x0[this.dragid];
            }
        }
        this.xc2 = this.xc + this.vxc;
        this.vxc = 2.0 * this.d * Math.sin(this.k * this.xc - this.w * this.t);
        this.axc = this.d * Math.cos(this.k * this.xc - this.w * this.t);
        for (n = 0; n < this.nxy; ++n) {
            this.px[n] = this.xl[n % this.n];
            this.py[n] = (double)(-(n / this.n + 1)) * this.dy;
        }
        this.diry = !this.dirx;
        for (n = 0; n < this.n2; ++n) {
            if (n != this.dragid) {
                if (this.dirx) {
                    this.xs[n] = this.x0[n] + this.x2[n];
                    this.ys[n] = this.y2c;
                    continue;
                }
                this.xs[n] = this.x0[n];
                this.ys[n] = this.y2c + this.x2[n];
                continue;
            }
            if (this.dirx) {
                this.ys[n] = this.y2c;
                continue;
            }
            this.xs[n] = this.x0[n];
        }
    }

    public double calF(int n, double[] dArray, double[] dArray2) {
        if (n == 0) {
            return this.ks * (dArray[1] - dArray[0]);
        }
        if (n == this.n2 - 1) {
            return 0.0;
        }
        return this.ks * (dArray[n + 1] + dArray[n - 1] - 2.0 * dArray[n]);
    }

    public double _method_for_segmentSet_sizeY() {
        return this.size * 2.0;
    }

    public double _method_for_segment_sizeX() {
        return this.xmax - this.xmin;
    }

    public double _method_for_segment2_x() {
        return this.xmax * 0.8;
    }

    public double _method_for_segment2_y() {
        return this.y2c - 3.0 * this.size;
    }

    public double _method_for_segment2_sizeY() {
        return 6.0 * this.size;
    }

    public double _method_for_shape_sizeX() {
        return this.size2 / 2.0;
    }

    public double _method_for_shape_sizeY() {
        return this.size2 / 2.0;
    }

    public double _method_for_segmentSet2_y() {
        return this.y2c - 3.0 * this.size;
    }

    public double _method_for_segmentSet2_sizeY() {
        return 6.0 * this.size;
    }

    public void _method_for_shapeSet_pressAction() {
        this._pause();
    }

    public void _method_for_shapeSet_dragAction() {
        if (this.dirx) {
            this.x2[this.dragid] = this.xs[this.dragid] - this.x0[this.dragid];
            this.ys[this.dragid] = this.y2c;
        } else {
            this.x2[this.dragid] = this.ys[this.dragid] - this.y2c;
            this.xs[this.dragid] = this.x0[this.dragid];
        }
        this.v2[this.dragid] = 0.0;
        this._step();
    }

    public void _method_for_shapeSet_releaseAction() {
        for (int i = 0; i < this.n2; ++i) {
            this.v2[i] = 0.0;
        }
        this._play();
    }

    public double _method_for_shapeSource_x() {
        return this.xl[0];
    }

    public double _method_for_shapeSource_sizeX() {
        return this.size2 / 2.0;
    }

    public double _method_for_shapeSource_sizeY() {
        return this.size * 4.0;
    }

    public void _method_for_sliderT_dragaction() {
        this.f = 1.0 / this.T;
        this.w = this.twopi * this.f;
        this.k = this.w / this.v;
    }

    public void _method_for_sliderV_dragaction() {
        this.k = this.w / this.v;
    }

    public void _method_for_buttoninit_action() {
        this._initialize();
    }

    public void _method_for_buttonimpulse_action() {
        this.A = this.dirx ? this.size * 2.0 : this.size * 5.0;
        for (int i = 0; i < this.np; ++i) {
            this.c = this.pi / 2.0 * (double)i / (double)this.np;
            this.x2[i] = this.A * Math.cos(this.c);
            this.v2[i] = 0.0;
        }
    }

    public void _method_for_radioButtonx_action() {
        this._initialize();
    }

    public void _method_for_radioButtony_actionon() {
        this._initialize();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    public void _method_for_playPauseButton_actionOn() {
        this._play();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._pause();
    }

    public boolean _method_for_buttonstep_enabled() {
        return this._isPaused();
    }

    public void _method_for_buttonstep_action() {
        this._step();
    }

    @Override
    public void reset() {
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_constraints1 = true;
        this.range = 200.0;
        this.xmin = -this.range;
        this.xmax = this.range;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.01;
        this.size = this.range / 25.0;
        this.size1 = this.size / 10.0;
        this.size2 = this.size / 2.0;
        this.stroke = 2.0;
        this.pi = Math.PI;
        this.twopi = 2.0 * this.pi;
        this.psize = 1.0;
        this.n = 192;
        this.n2 = 100;
        this.ny = 10;
        this.nxy = this.n * this.ny;
        this.x = new double[this.n];
        this.x0 = new double[this.n2];
        this.x2 = new double[this.n2];
        this.xs = new double[this.n2];
        this.ys = new double[this.n2];
        this.v2 = new double[this.n2];
        this.a2 = new double[this.n2];
        this.xl = new double[this.n];
        this.vxl = new double[this.n];
        this.yt = new double[this.n];
        this.ayt = new double[this.n];
        this.px = new double[this.nxy];
        this.py = new double[this.nxy];
        this.wl = this.xmax / 3.0;
        this.k = this.twopi / this.wl;
        this.T = 2.0;
        this.f = 0.5;
        this.w = this.twopi / this.T;
        this.yl = 0.0;
        this.v = this.w / this.k;
        this.d = this.size;
        this.dy = this.size * 2.0 / (double)this.ny;
        this.v0 = this.size;
        this.y1 = 8.0 * this.size;
        this.showvx = false;
        this.showp = false;
        this.xc = 0.0;
        this.xc2 = 0.0;
        this.vxc = 0.0;
        this.axc = 0.0;
        this.y2c = this.ymin * 0.6;
        this.dirx = true;
        this.diry = false;
        this.dragid = -1;
        this.ks = 500.0;
        this.ds = 0.0;
        this.bs = 0.1;
        this.wx = 3.0;
        this.wy = 3.0;
        this.m = 1.0;
        this.np = 8;
        this.c = 0.0;
        this.A = 5.0 * this.size;
        this.showvy = false;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    @Override
    public void initialize() {
        if (this._isEnabled_initialization1) {
            this._initialization1();
        }
        this._resetSolvers();
    }

    @Override
    public void step() {
        if (this._isEnabled_evolution1) {
            this._ODEi_evolution1.__stepODE();
        }
    }

    @Override
    public void update() {
        if (this._isEnabled_constraints1) {
            this._constraints1();
        }
    }

    @Override
    public void _freeMemory() {
        this.x = null;
        this.x0 = null;
        this.x2 = null;
        this.xs = null;
        this.ys = null;
        this.v2 = null;
        this.a2 = null;
        this.xl = null;
        this.vxl = null;
        this.yt = null;
        this.ayt = null;
        this.px = null;
        this.py = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class _ODE_evolution1
    implements __PrivateODE {
        private ODESolverInterpolator __solver = null;
        private ODEInterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = RK4.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustReinitialize = true;
        private double[] _x2;
        private double[] _v2;

        _ODE_evolution1() {
            this.__initializeSolver();
            longitudinalwave.this._privateOdesList.put("Evol Page", this);
        }

        @Override
        public ODEInterpolatorEventSolver __getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void __setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__initializeSolver();
        }

        private void __initializeSolver() {
            this.__state = new double[1 + longitudinalwave.this.x2.length + longitudinalwave.this.v2.length];
            this._x2 = new double[longitudinalwave.this.x2.length];
            this._v2 = new double[longitudinalwave.this.v2.length];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{ODE.class};
                Object[] objectArray = new Object[]{this};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (ODESolverInterpolator)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new ODEInterpolatorEventSolver(this.__solver);
            this.__eventSolver.initialize(longitudinalwave.this.dt);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__mustReinitialize = true;
            this.__eventSolver.setTolerances(0.001, 0.001);
        }

        private void __pushState() {
            int n;
            int n2;
            int n3 = 0;
            if (!this.__mustReinitialize) {
                n2 = 0;
                n = n3;
                while (n2 < longitudinalwave.this.x2.length) {
                    if (this.__state[n] != longitudinalwave.this.x2[n2]) {
                        this.__mustReinitialize = true;
                        break;
                    }
                    ++n2;
                    ++n;
                }
            }
            System.arraycopy(longitudinalwave.this.x2, 0, this.__state, n3, longitudinalwave.this.x2.length);
            n3 += longitudinalwave.this.x2.length;
            if (!this.__mustReinitialize) {
                n2 = 0;
                n = n3;
                while (n2 < longitudinalwave.this.v2.length) {
                    if (this.__state[n] != longitudinalwave.this.v2[n2]) {
                        this.__mustReinitialize = true;
                        break;
                    }
                    ++n2;
                    ++n;
                }
            }
            System.arraycopy(longitudinalwave.this.v2, 0, this.__state, n3, longitudinalwave.this.v2.length);
            if (this.__state[n3 += longitudinalwave.this.v2.length] != longitudinalwave.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n3++] = longitudinalwave.this.t;
        }

        private boolean __arraysChanged() {
            if (longitudinalwave.this.x2.length != this._x2.length) {
                return true;
            }
            return longitudinalwave.this.v2.length != this._v2.length;
        }

        public void __resetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            longitudinalwaveSimulation cfr_ignored_0 = longitudinalwave.this._simulation;
            longitudinalwaveSimulation cfr_ignored_1 = longitudinalwave.this._simulation;
            int n = JOptionPane.showConfirmDialog(longitudinalwave.this._view.getComponent(longitudinalwave.this._simulation.getMainWindow()), longitudinalwaveSimulation.getEjsString("ODEError.Continue"), longitudinalwaveSimulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                longitudinalwave.this._pause();
            }
        }

        void __stepODE() {
            if (this.__arraysChanged()) {
                this.__initializeSolver();
            }
            this.__eventSolver.setStepSize(longitudinalwave.this.dt);
            this.__eventSolver.setInternalStepSize(longitudinalwave.this.dt);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setTolerances(0.001, 0.001);
            this.__pushState();
            if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
            }
            double d = this.__eventSolver.step();
            int n = 0;
            System.arraycopy(this.__state, n, longitudinalwave.this.x2, 0, longitudinalwave.this.x2.length);
            System.arraycopy(this.__state, n += longitudinalwave.this.x2.length, longitudinalwave.this.v2, 0, longitudinalwave.this.v2.length);
            n += longitudinalwave.this.v2.length;
            longitudinalwave.this.t = this.__state[n++];
            if (Double.isNaN(d)) {
                this.__errorAction();
            }
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            dArray2[dArray2.length - 1] = 0.0;
            int n2 = -1;
            int n3 = 0;
            double[] dArray3 = this._x2;
            System.arraycopy(dArray, n3, this._x2, 0, this._x2.length);
            double[] dArray4 = this._v2;
            System.arraycopy(dArray, n3 += this._x2.length, this._v2, 0, this._v2.length);
            n3 += this._v2.length;
            double d = dArray[n3++];
            n3 = 0;
            int n4 = this._x2.length;
            for (n = 0; n < n4; ++n) {
                dArray2[n3++] = dArray4[n];
            }
            n4 = this._v2.length;
            for (n = 0; n < n4; ++n) {
                dArray2[n3++] = longitudinalwave.this.a2[n] = (longitudinalwave.this.calF(n, dArray3, dArray4) - longitudinalwave.this.bs * dArray4[n]) / longitudinalwave.this.m;
            }
            dArray2[n3++] = 1.0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface __PrivateODE
    extends ODE {
        public ODEInterpolatorEventSolver __getEventSolver();

        public void __setSolverClass(Class<?> var1);
    }
}

