/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.applet.AudioClip;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.JarTool;
import org.opensourcephysics.tools.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceLoader {
    protected static ArrayList<String> searchPaths = new ArrayList();
    protected static int maxPaths = 20;
    protected static Hashtable<String, Resource> resources = new Hashtable();
    protected static boolean cacheEnabled = false;
    protected static Map<String, URLClassLoader> zipLoaders = new TreeMap<String, URLClassLoader>();
    protected static URLClassLoader xsetZipLoader;
    protected static ArrayList<String> extractExtensions;

    static {
        extractExtensions = new ArrayList();
    }

    private ResourceLoader() {
    }

    public static Resource getResource(String string) {
        return ResourceLoader.getResource(string, true);
    }

    public static Resource getResource(String string, boolean bl) {
        return ResourceLoader.getResource(string, Resource.class, bl);
    }

    public static Resource getResource(String string, Class<?> clazz) {
        return ResourceLoader.getResource(string, clazz, true);
    }

    public static Resource getResource(String string, Class<?> clazz, boolean bl) {
        Object object;
        Object object2;
        Resource resource;
        if (string == null || string.equals("")) {
            return null;
        }
        if (string.startsWith("\"")) {
            string = string.substring(1);
        }
        if (string.endsWith("\"")) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.startsWith("./")) {
            string = string.substring(2);
        }
        if (OSPRuntime.isAppletMode() || OSPRuntime.applet != null) {
            resource = null;
            object2 = searchPaths.iterator();
            while (object2.hasNext()) {
                object = ResourceLoader.getPath(object2.next(), string);
                resource = ResourceLoader.findResourceInClass((String)object, clazz, bl);
                if (resource == null) continue;
                return resource;
            }
            resource = ResourceLoader.findResourceInClass(string, clazz, bl);
            if (resource != null) {
                return resource;
            }
        }
        if ((resource = ResourceLoader.findResource(string, clazz, bl)) != null) {
            return resource;
        }
        object2 = new StringBuffer("Not found: " + string);
        ((StringBuffer)object2).append(" [searched " + string);
        object = searchPaths.iterator();
        while (object.hasNext()) {
            String string2 = ResourceLoader.getPath((String)object.next(), string);
            resource = ResourceLoader.findResource(string2, clazz, bl);
            if (resource != null) {
                return resource;
            }
            ((StringBuffer)object2).append(";" + string2);
        }
        ((StringBuffer)object2).append("]");
        OSPLog.fine(((StringBuffer)object2).toString());
        return null;
    }

    public static Resource getResource(String string, String string2) {
        return ResourceLoader.getResource(string, string2, Resource.class);
    }

    public static Resource getResource(String string, String string2, boolean bl) {
        return ResourceLoader.getResource(string, string2, Resource.class, bl);
    }

    public static Resource getResource(String string, String string2, Class<Resource> clazz) {
        return ResourceLoader.getResource(string, string2, clazz, true);
    }

    public static Resource getResource(String string, String string2, Class<Resource> clazz, boolean bl) {
        Object object;
        String string3;
        Resource resource;
        if (string == null) {
            return ResourceLoader.getResource(string2, clazz);
        }
        if (string2.startsWith("./")) {
            string2 = string2.substring(2);
        }
        if ((resource = ResourceLoader.findResource(string3 = ResourceLoader.getPath(string, string2), clazz, bl)) != null) {
            return resource;
        }
        if (string.startsWith("/") || string.indexOf(":/") > -1) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer("Not found: " + string3);
        stringBuffer.append(" [searched " + string3);
        if (OSPRuntime.applet != null) {
            object = OSPRuntime.applet.getDocumentBase().toExternalForm();
            string3 = ResourceLoader.getPath(ResourceLoader.getPath((String)(object = String.valueOf(XML.getDirectoryPath((String)object)) + "/"), string), string2);
            resource = ResourceLoader.findResource(string3, clazz, bl);
            if (resource != null) {
                return resource;
            }
            stringBuffer.append(";" + string3);
            String string4 = OSPRuntime.applet.getCodeBase().toExternalForm();
            if (!string4.equals(object)) {
                string3 = ResourceLoader.getPath(ResourceLoader.getPath(string4, string), string2);
                resource = ResourceLoader.findResource(string3, clazz, bl);
                if (resource != null) {
                    return resource;
                }
                stringBuffer.append(";" + string3);
            }
        }
        object = searchPaths.iterator();
        while (object.hasNext()) {
            string3 = ResourceLoader.getPath(ResourceLoader.getPath((String)object.next(), string), string2);
            resource = ResourceLoader.findResource(string3, clazz, bl);
            if (resource != null) {
                return resource;
            }
            stringBuffer.append(";" + string3);
        }
        stringBuffer.append("]");
        OSPLog.fine(stringBuffer.toString());
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSearchPath(String string) {
        if (string == null || string.equals("") || maxPaths < 1) {
            return;
        }
        ArrayList<String> arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(string)) {
                searchPaths.remove(string);
            } else {
                OSPLog.fine("Added path: " + string);
            }
            searchPaths.add(0, string);
            while (searchPaths.size() > Math.max(maxPaths, 0)) {
                string = searchPaths.get(searchPaths.size() - 1);
                OSPLog.fine("Removed path: " + string);
                searchPaths.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSearchPath(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        ArrayList<String> arrayList = searchPaths;
        synchronized (arrayList) {
            if (searchPaths.contains(string)) {
                OSPLog.fine("Removed path: " + string);
                searchPaths.remove(string);
            }
        }
    }

    public static void setCacheEnabled(boolean bl) {
        cacheEnabled = bl;
    }

    public static boolean isCacheEnabled() {
        return cacheEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addExtractExtension(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        OSPLog.finest("Added extension: " + string);
        ArrayList<String> arrayList = extractExtensions;
        synchronized (arrayList) {
            extractExtensions.add(string);
        }
    }

    public static InputStream openInputStream(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.openInputStream();
    }

    public static Reader openReader(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.openReader();
    }

    public static String getString(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getString();
    }

    public static ImageIcon getIcon(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getIcon();
    }

    public static Image getImage(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getImage();
    }

    public static BufferedImage getBufferedImage(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getBufferedImage();
    }

    public static AudioClip getAudioClip(String string) {
        Resource resource = ResourceLoader.getResource(string);
        return resource == null ? null : resource.getAudioClip();
    }

    private static Resource createFileResource(String string) {
        if (OSPRuntime.applet != null) {
            return null;
        }
        if (string.indexOf(".zip") > -1 || string.indexOf(".jar") > -1) {
            return null;
        }
        File file = new File(string);
        try {
            if (file.exists() && file.canRead()) {
                Resource resource = new Resource(file);
                if (string.endsWith("xset")) {
                    xsetZipLoader = null;
                }
                OSPLog.fine("File: " + XML.forwardSlash(resource.getAbsolutePath()));
                return resource;
            }
        }
        catch (AccessControlException accessControlException) {}
        return null;
    }

    private static Resource createURLResource(String string) {
        if (string.indexOf(".zip") > -1 || string.indexOf(".jar") > -1) {
            return null;
        }
        Resource resource = null;
        if (string.indexOf(":/") > -1) {
            try {
                URL uRL = new URL(string);
                resource = ResourceLoader.createResource(uRL);
            }
            catch (Exception exception) {}
        } else if (OSPRuntime.applet != null && !string.startsWith("/")) {
            URL uRL;
            URL uRL2 = OSPRuntime.applet.getDocumentBase();
            try {
                uRL = new URL(uRL2, string);
                resource = ResourceLoader.createResource(uRL);
            }
            catch (Exception exception) {}
            if (resource == null) {
                uRL = OSPRuntime.applet.getCodeBase();
                String string2 = String.valueOf(XML.getDirectoryPath(uRL2.toExternalForm())) + "/";
                if (!uRL.toExternalForm().equals(string2)) {
                    try {
                        URL uRL3 = new URL(uRL, string);
                        resource = ResourceLoader.createResource(uRL3);
                    }
                    catch (Exception exception) {}
                }
            }
        }
        if (resource != null) {
            if (string.endsWith(".xset")) {
                xsetZipLoader = null;
            }
            OSPLog.fine("URL: " + XML.forwardSlash(resource.getAbsolutePath()));
        }
        return resource;
    }

    private static Resource createZipResource(String string) {
        URL[] uRLArray;
        Object object3;
        Object object4 = null;
        String string2 = string;
        int n = string.indexOf("zip!/");
        if (n == -1) {
            n = string.indexOf("jar!/");
        }
        if (n == -1) {
            n = string.indexOf("exe!/");
        }
        if (n > -1) {
            object4 = string.substring(0, n + 3);
            string2 = string.substring(n + 5);
        }
        if (object4 == null) {
            if (string.endsWith(".zip") || string.endsWith(".jar") || string.endsWith(".exe")) {
                object3 = XML.stripExtension(XML.getName(string));
                object4 = string;
                string2 = String.valueOf(object3) + ".xset";
            } else if (string.endsWith(".xset")) {
                object4 = String.valueOf(string.substring(0, string.length() - 4)) + "zip";
            }
        }
        object3 = null;
        URL uRL = null;
        if (object4 != null) {
            object3 = zipLoaders.get(object4);
            if (object3 != null) {
                uRL = ((URLClassLoader)object3).findResource(string2);
            } else {
                try {
                    URL object22;
                    uRLArray = new URL[]{new URL("file", null, (String)object4)};
                    object3 = new URLClassLoader(uRLArray);
                    uRL = ((URLClassLoader)object3).findResource(string2);
                    if (uRL == null && (object22 = Resource.class.getResource("/" + (String)object4)) != null) {
                        uRLArray = new URL[]{object22};
                        object3 = new URLClassLoader(uRLArray);
                        uRL = ((URLClassLoader)object3).findResource(string2);
                    }
                    if (uRL != null) {
                        zipLoaders.put((String)object4, (URLClassLoader)object3);
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (uRL == null && xsetZipLoader != null && (uRL = xsetZipLoader.findResource(string2)) != null) {
            for (Object e : zipLoaders.keySet()) {
                if (zipLoaders.get(e) != xsetZipLoader) continue;
                object4 = (String)e;
                break;
            }
        }
        uRLArray = OSPRuntime.getLaunchJarPath();
        if (uRL == null && uRLArray != null) {
            object3 = zipLoaders.get(uRLArray);
            if (object3 != null) {
                uRL = ((URLClassLoader)object3).findResource(string2);
            } else {
                try {
                    URL uRL2;
                    URL[] uRLArray2 = new URL[]{new URL("file", null, (String)uRLArray)};
                    object3 = new URLClassLoader(uRLArray2);
                    uRL = ((URLClassLoader)object3).findResource(string2);
                    if (uRL == null && (uRL2 = Resource.class.getResource("/" + (String)uRLArray)) != null) {
                        URL[] uRLArray3 = new URL[]{uRL2};
                        object3 = new URLClassLoader(uRLArray3);
                        uRL = ((URLClassLoader)object3).findResource(string2);
                    }
                    if (uRL != null) {
                        zipLoaders.put((String)uRLArray, (URLClassLoader)object3);
                    }
                }
                catch (Exception exception) {}
            }
            if (uRL != null) {
                object4 = uRLArray;
            }
        }
        if (uRL != null) {
            Resource resource;
            block31: {
                for (String string3 : extractExtensions) {
                    if (!uRL.getFile().endsWith(string3)) continue;
                    File file = new File((String)object4);
                    File file2 = new File(string2);
                    if (!file2.exists()) {
                        file2 = JarTool.extract(file, string2, string2);
                    }
                    return ResourceLoader.createFileResource(file2.getAbsolutePath());
                }
                try {
                    resource = ResourceLoader.createResource(uRL);
                    if (resource != null && resource.getAbsolutePath().indexOf(string) != -1) break block31;
                    return null;
                }
                catch (IOException iOException) {}
            }
            if (string2.endsWith("xset")) {
                xsetZipLoader = object3;
            }
            OSPLog.fine("Zip: " + XML.forwardSlash(resource.getAbsolutePath()));
            return resource;
        }
        return null;
    }

    private static Resource createClassResource(String string, Class<?> clazz) {
        Object object;
        if (string.indexOf(":/") != -1) {
            return null;
        }
        String string2 = string;
        int n = string.indexOf("jar!/");
        if (n == -1) {
            n = string.indexOf("exe!/");
        }
        if (n != -1) {
            string = string.substring(n + 5);
        }
        Resource resource = null;
        try {
            object = clazz.getResource("/" + string);
            resource = ResourceLoader.createResource((URL)object);
        }
        catch (Exception exception) {}
        if (resource == null) {
            try {
                object = clazz.getResource(string);
                resource = ResourceLoader.createResource((URL)object);
            }
            catch (Exception exception) {}
        }
        if (resource != null) {
            object = XML.forwardSlash(resource.getAbsolutePath());
            if (((String)object).indexOf("/jre") > -1 && ((String)object).indexOf("/lib") > -1) {
                return null;
            }
            if (((String)object).indexOf(string2) == -1) {
                return null;
            }
            if (string.endsWith("xset")) {
                xsetZipLoader = null;
            }
            OSPLog.fine("Class resource: " + (String)object);
            OSPRuntime.setLaunchJarPath((String)object);
        }
        return resource;
    }

    private static Resource createResource(URL uRL) throws IOException {
        if (uRL == null) {
            return null;
        }
        InputStream inputStream = uRL.openStream();
        if (inputStream.read() == -1) {
            return null;
        }
        inputStream.close();
        return new Resource(uRL);
    }

    private static Resource findResourceInClass(String string, Class<?> clazz, boolean bl) {
        string = string.replaceAll("/\\./", "/");
        if (clazz == null) {
            clazz = Resource.class;
        }
        Resource resource = null;
        if (cacheEnabled && (resource = resources.get(string)) != null && (bl || resource.getFile() == null)) {
            OSPLog.finest("Found in cache: " + string);
            return resource;
        }
        resource = ResourceLoader.createClassResource(string, clazz);
        if (resource != null) {
            if (cacheEnabled) {
                resources.put(string, resource);
            }
            return resource;
        }
        return null;
    }

    private static Resource findResource(String string, Class<?> clazz, boolean bl) {
        string = string.replaceAll("/\\./", "/");
        if (clazz == null) {
            clazz = Resource.class;
        }
        Resource resource = null;
        if (cacheEnabled && (resource = resources.get(string)) != null && (bl || resource.getFile() == null)) {
            OSPLog.finest("Found in cache: " + string);
            return resource;
        }
        if (bl && (resource = ResourceLoader.createFileResource(string)) != null || (resource = ResourceLoader.createURLResource(string)) != null || (resource = ResourceLoader.createZipResource(string)) != null || (resource = ResourceLoader.createClassResource(string, clazz)) != null) {
            if (cacheEnabled) {
                resources.put(string, resource);
            }
            return resource;
        }
        return null;
    }

    private static String getPath(String string, String string2) {
        if (string == null) {
            string = "";
        }
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            string = String.valueOf(string) + "!";
        }
        String string3 = XML.getResolvedPath(string2, string);
        if (OSPRuntime.isMac() && string3.startsWith("file:/") && !string3.startsWith("file:///")) {
            string3 = string3.substring(6);
            while (string3.startsWith("/")) {
                string3 = string3.substring(1);
            }
            string3 = "file:///" + string3;
        }
        return string3;
    }
}

