/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.controls;

import java.awt.Rectangle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Style;
import org.opensourcephysics.controls.ConsoleLevel;
import org.opensourcephysics.controls.OSPLog;

class OSPLogHandler
extends Handler {
    JTextPane log;

    public OSPLogHandler(JTextPane jTextPane) {
        this.log = jTextPane;
    }

    public void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        String string = this.getFormatter().format(logRecord);
        Style style = OSPLog.green;
        int n = logRecord.getLevel().intValue();
        if (n == ConsoleLevel.ERR_CONSOLE.intValue()) {
            style = OSPLog.magenta;
        } else if (n == ConsoleLevel.OUT_CONSOLE.intValue()) {
            style = OSPLog.gray;
        } else if (n >= Level.WARNING.intValue()) {
            style = OSPLog.red;
        } else if (n >= Level.INFO.intValue()) {
            style = OSPLog.black;
        } else if (n >= Level.CONFIG.intValue()) {
            style = OSPLog.green;
        } else if (n >= Level.FINEST.intValue()) {
            style = OSPLog.blue;
        }
        try {
            Document document = this.log.getDocument();
            document.insertString(document.getLength(), String.valueOf(string) + '\n', style);
            Rectangle rectangle = this.log.getBounds();
            rectangle.y = rectangle.height;
            this.log.scrollRectToVisible(rectangle);
        }
        catch (BadLocationException badLocationException) {
            System.err.println(badLocationException);
        }
    }

    public void flush() {
    }

    public void close() {
    }
}

