/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.utils;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.OutputStream;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.SpecialRender;
import org.colos.ejs.library.utils.GIFEncoder;
import org.colos.ejs.library.utils.VideoUtil;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.media.core.VideoGrabber;
import org.opensourcephysics.tools.VideoCaptureTool;

public class VideoUtilClass
extends VideoUtil {
    private VideoCaptureTool videoTool = null;
    private Component videoComponent;
    private BufferedImage videoImage = null;
    private SpecialRender videoSpecialRender = null;

    public boolean isFullClass() {
        return true;
    }

    public void takeSnapshot(Component component) {
        try {
            PrintUtils.saveComponentAsEPS(component);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean startVideoTool(View view, String string) {
        this.videoImage = null;
        this.videoComponent = null;
        this.videoSpecialRender = null;
        if (view == null) {
            return false;
        }
        Component component = view.getComponent(string);
        if (component == null) {
            System.err.println("Component not found: " + string);
            return false;
        }
        if (component instanceof JFrame) {
            component = ((JFrame)component).getContentPane();
        } else if (component instanceof JDialog) {
            component = ((JDialog)component).getContentPane();
        }
        this.videoImage = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        this.videoComponent = component;
        ControlElement controlElement = view.getElement(string);
        if (controlElement instanceof SpecialRender) {
            this.videoSpecialRender = (SpecialRender)((Object)controlElement);
        }
        if (this.videoTool == null) {
            this.videoTool = VideoGrabber.getTool();
        }
        this.videoTool.setVisible(true);
        this.videoTool.clear();
        return true;
    }

    public void captureVideoImage() {
        if (this.videoImage == null) {
            return;
        }
        if (this.videoSpecialRender != null) {
            this.videoSpecialRender.render(this.videoImage);
        } else {
            Graphics graphics = this.videoImage.getGraphics();
            this.videoComponent.paint(graphics);
            graphics.dispose();
        }
        this.videoTool.addFrame(this.videoImage);
    }

    public boolean writeGIF(OutputStream outputStream, BufferedImage bufferedImage) {
        try {
            GIFEncoder gIFEncoder = new GIFEncoder(bufferedImage);
            gIFEncoder.Write(outputStream);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }
}

