/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.event.MouseInputAdapter;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.PlottingPanel;
import org.opensourcephysics.display.Selectable;
import org.opensourcephysics.display.axes.CartesianType1;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.media.core.ScientificField;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.ResourceLoader;

public class CartesianInteractive
extends CartesianType1
implements Selectable {
    public static final int INSIDE = 0;
    public static final int HORZ_MIN = 1;
    public static final int HORZ_MAX = 2;
    public static final int VERT_MIN = 3;
    public static final int VERT_MAX = 4;
    public static final int HORZ_AXIS = 5;
    public static final int HORZ_AXIS_MIN = 6;
    public static final int HORZ_AXIS_MAX = 7;
    public static final int VERT_AXIS = 8;
    public static final int VERT_AXIS_MIN = 9;
    public static final int VERT_AXIS_MAX = 10;
    public static final int HORZ_VAR = 11;
    public static final int VERT_VAR = 12;
    Rectangle hitRect = new Rectangle();
    boolean drawHitRect;
    ScaleSetter scaleSetter;
    JPanel scaleSetterPanel;
    AxisMouseListener axisListener;
    int mouseRegion;
    Point mouseLoc;
    double mouseX;
    double mouseY;
    PlottingPanel plot;
    boolean enabled = true;
    boolean altDown;
    Cursor horzCenter;
    Cursor horzRight;
    Cursor horzLeft;
    Cursor vertCenter;
    Cursor vertUp;
    Cursor vertDown;
    Cursor move;

    public CartesianInteractive(PlottingPanel plottingPanel) {
        super(plottingPanel);
        this.plot = plottingPanel;
        this.axisListener = new AxisMouseListener();
        plottingPanel.addMouseListener(this.axisListener);
        plottingPanel.addMouseMotionListener(this.axisListener);
        plottingPanel.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (CartesianInteractive.this.mouseRegion == 0 && !CartesianInteractive.this.drawingPanel.isFixedScale() && keyEvent.getKeyCode() == 18) {
                    CartesianInteractive.this.altDown = true;
                    CartesianInteractive.this.plot.setMouseCursor(CartesianInteractive.this.getPreferredCursor());
                }
            }

            public void keyReleased(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 18) {
                    CartesianInteractive.this.altDown = false;
                    CartesianInteractive.this.plot.setMouseCursor(Cursor.getPredefinedCursor(1));
                }
            }
        });
        this.scaleSetter = new ScaleSetter();
        this.scaleSetterPanel = new JPanel(null);
        this.scaleSetterPanel.setOpaque(false);
        this.scaleSetterPanel.add(this.scaleSetter);
        this.plot.getGlassPanel().add((Component)this.scaleSetterPanel, "Center");
    }

    public int getMouseRegion() {
        return this.mouseRegion;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        super.draw(drawingPanel, graphics);
        if (this.drawHitRect) {
            graphics.drawRect(this.hitRect.x, this.hitRect.y, this.hitRect.width, this.hitRect.height);
        }
        if (!drawingPanel.isFixedScale() && this.scaleSetter.isVisible() && this.scaleSetter.scaleField.getBackground() != Color.yellow) {
            switch (this.scaleSetter.region) {
                case 1: {
                    this.scaleSetter.scaleField.setValue(this.drawingPanel.getXMin());
                    this.scaleSetter.autoscaleCheckbox.setSelected(this.drawingPanel.isAutoscaleXMin());
                    break;
                }
                case 2: {
                    this.scaleSetter.scaleField.setValue(this.drawingPanel.getXMax());
                    this.scaleSetter.autoscaleCheckbox.setSelected(this.drawingPanel.isAutoscaleXMax());
                    break;
                }
                case 3: {
                    this.scaleSetter.scaleField.setValue(this.drawingPanel.getYMin());
                    this.scaleSetter.autoscaleCheckbox.setSelected(this.drawingPanel.isAutoscaleYMin());
                    break;
                }
                case 4: {
                    this.scaleSetter.scaleField.setValue(this.drawingPanel.getYMax());
                    this.scaleSetter.autoscaleCheckbox.setSelected(this.drawingPanel.isAutoscaleYMax());
                }
            }
        }
    }

    public double getX() {
        return Double.isNaN(this.mouseX) ? this.plot.pixToX(this.plot.getMouseIntX()) : this.mouseX;
    }

    public double getY() {
        return Double.isNaN(this.mouseY) ? this.plot.pixToY(this.plot.getMouseIntY()) : this.mouseY;
    }

    public void setSelected(boolean bl) {
    }

    public boolean isSelected() {
        return false;
    }

    public void toggleSelected() {
    }

    public Cursor getPreferredCursor() {
        switch (this.mouseRegion) {
            case 6: {
                if (this.horzLeft == null) {
                    String string = "/org/opensourcephysics/resources/tools/images/horzleft.gif";
                    Image image = ResourceLoader.getImage(string);
                    this.horzLeft = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "Horizontal Left");
                }
                return this.horzLeft;
            }
            case 7: {
                if (this.horzRight == null) {
                    String string = "/org/opensourcephysics/resources/tools/images/horzright.gif";
                    Image image = ResourceLoader.getImage(string);
                    this.horzRight = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "Horizontal Right");
                }
                return this.horzRight;
            }
            case 5: {
                if (this.horzCenter == null) {
                    String string = "/org/opensourcephysics/resources/tools/images/horzcenter.gif";
                    Image image = ResourceLoader.getImage(string);
                    this.horzCenter = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "Horizontal Center");
                }
                return this.horzCenter;
            }
            case 9: {
                if (this.vertDown == null) {
                    String string = "/org/opensourcephysics/resources/tools/images/vertdown.gif";
                    Image image = ResourceLoader.getImage(string);
                    this.vertDown = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "Vertical Down");
                }
                return this.vertDown;
            }
            case 10: {
                if (this.vertUp == null) {
                    String string = "/org/opensourcephysics/resources/tools/images/vertup.gif";
                    Image image = ResourceLoader.getImage(string);
                    this.vertUp = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "Vertical Up");
                }
                return this.vertUp;
            }
            case 8: {
                if (this.vertCenter == null) {
                    String string = "/org/opensourcephysics/resources/tools/images/vertcenter.gif";
                    Image image = ResourceLoader.getImage(string);
                    this.vertCenter = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "Vertical Center");
                }
                return this.vertCenter;
            }
            case 0: {
                if (this.move == null) {
                    String string = "/org/opensourcephysics/resources/tools/images/movecursor.gif";
                    Image image = ResourceLoader.getImage(string);
                    this.move = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(16, 16), "Move All Ways");
                }
                return this.move;
            }
            case 11: 
            case 12: {
                return Cursor.getPredefinedCursor(12);
            }
        }
        return Cursor.getDefaultCursor();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (this.drawingPanel.isFixedScale()) {
            return null;
        }
        if (this.mouseRegion >= 1) {
            return this;
        }
        if (this.mouseRegion == -1) {
            return this;
        }
        if (this.mouseRegion == 0 && this.altDown) {
            return this;
        }
        return null;
    }

    public void setXY(double d, double d2) {
    }

    public boolean isMeasured() {
        return true;
    }

    public double getXMin() {
        return this.drawingPanel.getXMin();
    }

    public double getXMax() {
        return this.drawingPanel.getXMax();
    }

    public double getYMin() {
        return this.drawingPanel.getYMin();
    }

    public double getYMax() {
        return this.drawingPanel.getYMax();
    }

    public void hideScaleSetter() {
        if (this.scaleSetter != null) {
            this.scaleSetter.autoscaleCheckbox.requestFocusInWindow();
            this.scaleSetter.setVisible(false);
        }
    }

    public void resizeFonts(double d, DrawingPanel drawingPanel) {
        super.resizeFonts(d, drawingPanel);
        if (this.scaleSetter != null) {
            this.scaleSetter.scaleField.setFont(FontSizer.getResizedFont(this.scaleSetter.scaleField.getFont(), d));
            this.scaleSetter.autoscaleCheckbox.setFont(FontSizer.getResizedFont(this.scaleSetter.autoscaleCheckbox.getFont(), d));
        }
    }

    protected boolean hasHorzVariablesPopup() {
        return false;
    }

    protected JPopupMenu getHorzVariablesPopup() {
        return null;
    }

    protected boolean hasVertVariablesPopup() {
        return false;
    }

    protected JPopupMenu getVertVariablesPopup() {
        return null;
    }

    protected int findRegion(Point point) {
        int n = this.drawingPanel.getLeftGutter();
        int n2 = this.drawingPanel.getRightGutter();
        int n3 = this.drawingPanel.getTopGutter();
        int n4 = this.drawingPanel.getBottomGutter();
        Dimension dimension = this.drawingPanel.getSize();
        int n5 = dimension.width - n2 - n;
        this.hitRect.setSize(n5 / 4, 12);
        this.hitRect.setLocation(n + n5 / 2 - this.hitRect.width / 2, dimension.height - n4 - this.hitRect.height / 2);
        if (this.hitRect.contains(point)) {
            return 5;
        }
        this.hitRect.setLocation(n + 4, dimension.height - n4 - this.hitRect.height / 2);
        if (this.hitRect.contains(point)) {
            return 6;
        }
        this.hitRect.setLocation(n + n5 - this.hitRect.width - 4, dimension.height - n4 - this.hitRect.height / 2);
        if (this.hitRect.contains(point)) {
            return 7;
        }
        n5 = dimension.height - n3 - n4;
        this.hitRect.setSize(12, n5 / 4);
        this.hitRect.setLocation(n - this.hitRect.width / 2, n3 + n5 / 2 - this.hitRect.height / 2);
        if (this.hitRect.contains(point)) {
            return 8;
        }
        this.hitRect.setLocation(n - this.hitRect.width / 2, n3 + 4);
        if (this.hitRect.contains(point)) {
            return 10;
        }
        this.hitRect.setLocation(n - this.hitRect.width / 2, n3 + n5 - this.hitRect.height - 4);
        if (this.hitRect.contains(point)) {
            return 9;
        }
        Graphics graphics = this.drawingPanel.getGraphics();
        int n6 = this.xLine.getWidth(graphics) + 8;
        int n7 = this.xLine.getHeight(graphics);
        this.hitRect.setSize(n6, n7);
        int n8 = (int)(this.xLine.getX() - (double)(n6 / 2));
        int n9 = (int)(this.xLine.getY() - (double)(n7 / 2) - (double)(this.xLine.getFontSize() / 3));
        this.hitRect.setLocation(n8, n9);
        if (this.hitRect.contains(point) && this.hasHorzVariablesPopup()) {
            return 11;
        }
        n6 = this.yLine.getHeight(graphics);
        n7 = this.yLine.getWidth(graphics) + 8;
        this.hitRect.setSize(n6, n7);
        n8 = (int)(this.yLine.getX() - (double)(n6 / 2) - (double)(this.yLine.getFontSize() / 3));
        n9 = (int)(this.yLine.getY() - (double)(n7 / 2) - 1.0);
        this.hitRect.setLocation(n8, n9);
        if (this.hitRect.contains(point) && this.hasVertVariablesPopup()) {
            return 12;
        }
        if (point.x >= n && point.y >= n3 && point.x <= dimension.width - n2 && point.y <= dimension.height - n4) {
            return 0;
        }
        ScientificField scientificField = this.scaleSetter.scaleField;
        Dimension dimension2 = scientificField.getPreferredSize();
        this.hitRect.setSize(dimension2);
        double d = this.drawingPanel.getXMin();
        double d2 = this.drawingPanel.getXMax();
        double d3 = this.drawingPanel.getYMin();
        double d4 = this.drawingPanel.getYMax();
        int n10 = 8;
        this.hitRect.setLocation(n - 12, dimension.height - n4 + 6 + n10);
        if (this.hitRect.contains(point)) {
            Point point2 = this.hitRect.getLocation();
            this.scaleSetter.add((Component)this.scaleSetter.autoscaleCheckbox, "North");
            this.scaleSetter.validate();
            Point point3 = scientificField.getLocation();
            Dimension dimension3 = this.scaleSetter.getPreferredSize();
            this.scaleSetter.setBounds(point2.x - point3.x, point2.y - point3.y - n10, dimension3.width, dimension3.height);
            return 1;
        }
        this.hitRect.setLocation(dimension.width - n2 - dimension2.width + 12, dimension.height - n4 + 6 + n10);
        if (this.hitRect.contains(point)) {
            scientificField.setExpectedRange(d, d2);
            Point point4 = this.hitRect.getLocation();
            this.scaleSetter.add((Component)this.scaleSetter.autoscaleCheckbox, "North");
            this.scaleSetter.validate();
            Point point5 = scientificField.getLocation();
            Dimension dimension4 = this.scaleSetter.getPreferredSize();
            this.scaleSetter.setBounds(point4.x - point5.x, point4.y - point5.y - n10, dimension4.width, dimension4.height);
            return 2;
        }
        this.hitRect.setLocation(n - dimension2.width - 1 - n10, dimension.height - n4 - dimension2.height + 8);
        if (this.hitRect.contains(point)) {
            scientificField.setExpectedRange(d3, d4);
            Point point6 = this.hitRect.getLocation();
            this.scaleSetter.add((Component)this.scaleSetter.autoscaleCheckbox, "East");
            this.scaleSetter.validate();
            Point point7 = scientificField.getLocation();
            int n11 = point6.x - point7.x;
            Dimension dimension5 = this.scaleSetter.getPreferredSize();
            this.scaleSetter.setBounds(Math.max(n11, 1 - point7.x), point6.y - point7.y, dimension5.width, dimension5.height);
            return 3;
        }
        this.hitRect.setLocation(n - dimension2.width - 1 - n10, n3 - 8);
        if (this.hitRect.contains(point)) {
            scientificField.setExpectedRange(d3, d4);
            Point point8 = this.hitRect.getLocation();
            this.scaleSetter.add((Component)this.scaleSetter.autoscaleCheckbox, "East");
            this.scaleSetter.validate();
            Point point9 = scientificField.getLocation();
            int n12 = point8.x - point9.x;
            Dimension dimension6 = this.scaleSetter.getPreferredSize();
            this.scaleSetter.setBounds(Math.max(n12, 1 - point9.x), point8.y - point9.y, dimension6.width, dimension6.height);
            return 4;
        }
        return -1;
    }

    public ScaleSetter getScaleSetter() {
        String string = DialogsRes.SCALE_AUTO;
        if (!string.equals(this.scaleSetter.autoscaleCheckbox.getText())) {
            this.scaleSetter.autoscaleCheckbox.setText(string);
        }
        return this.scaleSetter;
    }

    class AxisMouseListener
    extends MouseInputAdapter {
        AxisMouseListener() {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            CartesianInteractive.this.plot.requestFocusInWindow();
            CartesianInteractive.this.altDown = mouseEvent.isAltDown();
            Point point = mouseEvent.getPoint();
            CartesianInteractive.this.mouseRegion = CartesianInteractive.this.findRegion(point);
            if (CartesianInteractive.this.mouseRegion > 0 && CartesianInteractive.this.mouseRegion < 5 && !CartesianInteractive.this.drawingPanel.isFixedScale()) {
                CartesianInteractive.this.getScaleSetter().setRegion(CartesianInteractive.this.mouseRegion);
                CartesianInteractive.this.scaleSetter.validate();
                CartesianInteractive.this.scaleSetter.setVisible(true);
            } else {
                CartesianInteractive.this.scaleSetter.hideIfInactive();
            }
            CartesianInteractive.this.drawHitRect = CartesianInteractive.this.mouseRegion == 11 || CartesianInteractive.this.mouseRegion == 12;
            CartesianInteractive.this.plot.repaint();
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            double d = 0.0;
            double d2 = 0.0;
            double d3 = 0.0;
            double d4 = 0.0;
            switch (CartesianInteractive.this.mouseRegion) {
                case 0: {
                    if (!CartesianInteractive.this.altDown || CartesianInteractive.this.drawingPanel.isFixedScale()) {
                        return;
                    }
                    d = (double)(CartesianInteractive.this.mouseLoc.x - mouseEvent.getX()) / CartesianInteractive.this.plot.getXPixPerUnit();
                    d3 = CartesianInteractive.this.plot.getXMin() + d;
                    d4 = CartesianInteractive.this.plot.getXMax() + d;
                    d = 0.0;
                    CartesianInteractive.this.plot.setPreferredMinMaxX(d3, d4);
                    d2 = (double)(mouseEvent.getY() - CartesianInteractive.this.mouseLoc.y) / CartesianInteractive.this.plot.getYPixPerUnit();
                    d3 = CartesianInteractive.this.plot.getYMin() + d2;
                    d4 = CartesianInteractive.this.plot.getYMax() + d2;
                    break;
                }
                case 5: {
                    d = (double)(CartesianInteractive.this.mouseLoc.x - mouseEvent.getX()) / CartesianInteractive.this.plot.getXPixPerUnit();
                    d3 = CartesianInteractive.this.plot.getXMin() + d;
                    d4 = CartesianInteractive.this.plot.getXMax() + d;
                    break;
                }
                case 6: {
                    d = (double)(2 * (CartesianInteractive.this.mouseLoc.x - mouseEvent.getX())) / CartesianInteractive.this.plot.getXPixPerUnit();
                    d3 = CartesianInteractive.this.plot.getXMin() + d;
                    d4 = CartesianInteractive.this.plot.isAutoscaleXMax() ? Double.NaN : CartesianInteractive.this.plot.getXMax();
                    break;
                }
                case 7: {
                    d = (double)(2 * (CartesianInteractive.this.mouseLoc.x - mouseEvent.getX())) / CartesianInteractive.this.plot.getXPixPerUnit();
                    d3 = CartesianInteractive.this.plot.isAutoscaleXMin() ? Double.NaN : CartesianInteractive.this.plot.getXMin();
                    d4 = CartesianInteractive.this.plot.getXMax() + d;
                    break;
                }
                case 8: {
                    d2 = (double)(mouseEvent.getY() - CartesianInteractive.this.mouseLoc.y) / CartesianInteractive.this.plot.getYPixPerUnit();
                    d3 = CartesianInteractive.this.plot.getYMin() + d2;
                    d4 = CartesianInteractive.this.plot.getYMax() + d2;
                    break;
                }
                case 9: {
                    d2 = (double)(2 * (mouseEvent.getY() - CartesianInteractive.this.mouseLoc.y)) / CartesianInteractive.this.plot.getYPixPerUnit();
                    d3 = CartesianInteractive.this.plot.getYMin() + d2;
                    d4 = CartesianInteractive.this.plot.isAutoscaleYMax() ? Double.NaN : CartesianInteractive.this.plot.getYMax();
                    break;
                }
                case 10: {
                    d2 = (double)(2 * (mouseEvent.getY() - CartesianInteractive.this.mouseLoc.y)) / CartesianInteractive.this.plot.getYPixPerUnit();
                    d3 = CartesianInteractive.this.plot.isAutoscaleYMin() ? Double.NaN : CartesianInteractive.this.plot.getYMin();
                    d4 = CartesianInteractive.this.plot.getYMax() + d2;
                }
            }
            if (d != 0.0) {
                CartesianInteractive.this.plot.setPreferredMinMaxX(d3, d4);
            } else if (d2 != 0.0) {
                CartesianInteractive.this.plot.setPreferredMinMaxY(d3, d4);
            }
            CartesianInteractive.this.plot.invalidateImage();
            CartesianInteractive.this.plot.repaint();
            CartesianInteractive.this.mouseLoc = mouseEvent.getPoint();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            CartesianInteractive.this.altDown = mouseEvent.isAltDown();
            CartesianInteractive.this.mouseLoc = mouseEvent.getPoint();
            CartesianInteractive.this.mouseX = CartesianInteractive.this.plot.pixToX(CartesianInteractive.this.plot.getMouseIntX());
            CartesianInteractive.this.mouseY = CartesianInteractive.this.plot.pixToY(CartesianInteractive.this.plot.getMouseIntY());
            CartesianInteractive.this.mouseRegion = CartesianInteractive.this.findRegion(CartesianInteractive.this.mouseLoc);
            if (CartesianInteractive.this.scaleSetter == null) {
                return;
            }
            if (CartesianInteractive.this.mouseRegion > 0 && CartesianInteractive.this.mouseRegion < 5 && !CartesianInteractive.this.drawingPanel.isFixedScale()) {
                CartesianInteractive.this.scaleSetter.setVisible(true);
                return;
            }
            CartesianInteractive.this.hideScaleSetter();
            if (CartesianInteractive.this.mouseRegion == 11) {
                CartesianInteractive.this.drawHitRect = false;
                CartesianInteractive.this.getHorzVariablesPopup().show(CartesianInteractive.this.plot, CartesianInteractive.this.mouseLoc.x - 20, CartesianInteractive.this.mouseLoc.y - 12);
            } else if (CartesianInteractive.this.mouseRegion == 12) {
                CartesianInteractive.this.drawHitRect = false;
                CartesianInteractive.this.getVertVariablesPopup().show(CartesianInteractive.this.plot, CartesianInteractive.this.mouseLoc.x - 20, CartesianInteractive.this.mouseLoc.y - 12);
            }
            CartesianInteractive.this.plot.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            CartesianInteractive.this.mouseX = Double.NaN;
            CartesianInteractive.this.mouseY = Double.NaN;
        }

        public void mouseExited(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            if (!new Rectangle(CartesianInteractive.this.plot.getSize()).contains(point) && CartesianInteractive.this.scaleSetter != null && "".equals(InputEvent.getModifiersExText(mouseEvent.getModifiersEx()))) {
                CartesianInteractive.this.hideScaleSetter();
            }
        }
    }

    public class ScaleSetter
    extends JPanel {
        Action scaleAction;
        JCheckBox autoscaleCheckbox;
        ScientificField scaleField;
        int region;
        boolean pinned;

        private ScaleSetter() {
            super(new BorderLayout());
            this.pinned = false;
            this.scaleAction = new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    double d;
                    ScaleSetter.this.scaleField.setBackground(Color.white);
                    ScaleSetter.this.pinned = false;
                    boolean bl = ScaleSetter.this.autoscaleCheckbox.isSelected();
                    boolean bl2 = true;
                    double d2 = d = bl ? Double.NaN : ScaleSetter.this.scaleField.getValue();
                    switch (ScaleSetter.this.region) {
                        case 1: {
                            d2 = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleXMax() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getXMax();
                            break;
                        }
                        case 2: {
                            d = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleXMin() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getXMin();
                            break;
                        }
                        case 3: {
                            bl2 = false;
                            d2 = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleYMax() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getYMax();
                            break;
                        }
                        case 4: {
                            bl2 = false;
                            double d3 = d = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.isAutoscaleYMin() ? Double.NaN : ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getYMin();
                        }
                    }
                    if (bl2) {
                        ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.setPreferredMinMaxX(d, d2);
                    } else {
                        ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.setPreferredMinMaxY(d, d2);
                    }
                    Rectangle rectangle = ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.getBounds();
                    rectangle.setLocation(0, 0);
                    ((ScaleSetter)ScaleSetter.this).CartesianInteractive.this.drawingPanel.paintImmediately(rectangle);
                }
            };
            this.autoscaleCheckbox = new JCheckBox();
            this.autoscaleCheckbox.setBorder(BorderFactory.createEmptyBorder(1, 2, 2, 1));
            this.autoscaleCheckbox.setBackground(CartesianInteractive.this.drawingPanel.getBackground());
            this.autoscaleCheckbox.setHorizontalTextPosition(4);
            this.autoscaleCheckbox.addActionListener(this.scaleAction);
            this.scaleField = new ScientificField(6, 3){

                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    dimension.width -= 4;
                    return dimension;
                }
            };
            this.scaleField.addActionListener(new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ScaleSetter.this.autoscaleCheckbox.setSelected(false);
                    ScaleSetter.this.scaleAction.actionPerformed(null);
                }
            });
            this.scaleField.addFocusListener(new FocusAdapter(){

                public void focusLost(FocusEvent focusEvent) {
                    if (ScaleSetter.this.scaleField.getBackground() == Color.yellow) {
                        ScaleSetter.this.autoscaleCheckbox.setSelected(false);
                        ScaleSetter.this.scaleAction.actionPerformed(null);
                    }
                }
            });
            this.scaleField.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    ScaleSetter.this.pinned = true;
                    if (mouseEvent.getClickCount() == 2) {
                        ScaleSetter.this.scaleField.selectAll();
                    }
                }
            });
            this.add((Component)this.scaleField, "Center");
        }

        void hideIfInactive() {
            if (this.scaleField.getBackground() != Color.yellow && this.scaleField.getSelectedText() == null && !this.pinned) {
                CartesianInteractive.this.hideScaleSetter();
            }
        }

        void setRegion(int n) {
            if (this.region != n) {
                this.autoscaleCheckbox.requestFocusInWindow();
                if (this.scaleField.getBackground() == Color.yellow) {
                    this.autoscaleCheckbox.setSelected(false);
                    this.scaleAction.actionPerformed(null);
                }
                this.region = n;
                this.pinned = false;
                this.scaleField.select(20, 20);
                this.scaleField.requestFocusInWindow();
            }
        }
    }
}

