/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Map;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.numerics.ParsedMultiVarFunction;
import org.opensourcephysics.numerics.ParserException;
import org.opensourcephysics.tools.ToolsRes;

public class DataFunction
extends Dataset {
    DatasetManager inputData;
    ParsedMultiVarFunction function;
    String functionString;
    String inputString;
    int varCount;
    ArrayList<double[]> data = new ArrayList();

    public DataFunction(DatasetManager datasetManager) {
        this.inputData = datasetManager;
        String string = ToolsRes.getString("DataFunction.DefaultName");
        this.setXYColumnNames(datasetManager.getDataset(0).getXColumnName(), string);
        this.setXColumnVisible(false);
        this.setExpression("");
    }

    public DataFunction(DatasetManager datasetManager, String string, String string2) {
        this.inputData = datasetManager;
        this.setXYColumnNames(datasetManager.getDataset(0).getXColumnName(), string);
        this.setXColumnVisible(false);
        this.setExpression(string2);
    }

    public void setExpression(String string) {
        this.varCount = this.getVarCount();
        try {
            this.function = new ParsedMultiVarFunction(string, this.getVarNames());
            this.functionString = string;
            this.inputString = string;
            this.refreshFunctionData();
        }
        catch (ParserException parserException) {
            this.setExpression("0");
            this.inputString = string;
            this.refreshFunctionData();
        }
    }

    public String getExpression() {
        return this.functionString;
    }

    public void setYColumnName(String string) {
        if (string == null || string.equals("")) {
            return;
        }
        this.setXYColumnNames(this.getXColumnName(), string);
    }

    public String getInputString() {
        return this.inputString;
    }

    public void refreshFunctionData() {
        super.clear();
        if (this.function == null) {
            return;
        }
        if (this.varCount != this.getVarCount()) {
            this.setExpression(this.inputString);
            return;
        }
        double[][] dArray = this.getFunctionData();
        if (dArray.length == 0) {
            return;
        }
        double[] dArray2 = new double[dArray.length];
        int n = dArray[0].length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = 0;
            while (n3 < dArray.length) {
                dArray2[n3] = n2 < dArray[n3].length ? dArray[n3][n2] : Double.NaN;
                ++n3;
            }
            double d = Double.NaN;
            if (!"0".equals(this.functionString) || "0".equals(this.inputString)) {
                d = this.function.evaluate(dArray2);
                String[] stringArray = this.getVarNames();
                int n4 = 0;
                while (n4 < stringArray.length) {
                    if (this.getExpression().indexOf(stringArray[n4]) > -1 && Double.isNaN(dArray2[n4])) {
                        d = Double.NaN;
                    }
                    ++n4;
                }
            }
            super.append(dArray2[0], d);
            ++n2;
        }
    }

    public String toString() {
        return this.getYColumnName();
    }

    public void append(double d, double d2) {
    }

    public void append(double d, double d2, double d3, double d4) {
    }

    public void append(double[] dArray, double[] dArray2) {
    }

    public void append(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
    }

    public void clear() {
    }

    private double[][] getFunctionData() {
        Object object;
        int n = 0;
        this.data.clear();
        for (Dataset object22 : this.inputData.getDatasets()) {
            if (object22 == this) continue;
            if (this.data.isEmpty()) {
                object = object22.getXPoints();
                n = ((Object)object).length;
                this.data.add((double[])object);
            }
            this.data.add(object22.getYPoints());
        }
        Map<String, Double> map = this.inputData.getProperties();
        object = map.keySet().iterator();
        while (object.hasNext()) {
            double[] dArray = new double[n];
            Double d = map.get(object.next());
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = d;
                ++n2;
            }
            this.data.add(dArray);
        }
        return (double[][])this.data.toArray((T[])new double[0][0]);
    }

    private int getVarCount() {
        ArrayList<Dataset> arrayList = this.inputData.getDatasets();
        int n = arrayList.contains(this) ? arrayList.size() : arrayList.size() + 1;
        return n + this.inputData.getProperties().size();
    }

    private String[] getVarNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Dataset dataset : this.inputData.getDatasets()) {
            if (dataset == this) continue;
            String string = null;
            if (arrayList.isEmpty()) {
                string = TeXParser.removeSubscripting(dataset.getXColumnName());
                arrayList.add(string);
            }
            string = TeXParser.removeSubscripting(dataset.getYColumnName());
            arrayList.add(string);
        }
        arrayList.addAll(this.inputData.getProperties().keySet());
        return arrayList.toArray(new String[0]);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    protected static class Loader
    extends XMLLoader {
        protected Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            DataFunction dataFunction = (DataFunction)object;
            xMLControl.setValue("function_name", dataFunction.getYColumnName());
            xMLControl.setValue("function", dataFunction.getInputString());
            XML.getLoader(Dataset.class).saveObject(xMLControl, object);
        }

        public Object createObject(XMLControl xMLControl) {
            return null;
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            DataFunction dataFunction = (DataFunction)object;
            dataFunction.setYColumnName(xMLControl.getString("function_name"));
            dataFunction.setExpression(xMLControl.getString("function"));
            dataFunction.setID(xMLControl.getInt("datasetID"));
            if (xMLControl.getPropertyNames().contains("marker_shape")) {
                dataFunction.setMarkerShape(xMLControl.getInt("marker_shape"));
            }
            if (xMLControl.getPropertyNames().contains("marker_size")) {
                dataFunction.setMarkerSize(xMLControl.getInt("marker_size"));
            }
            dataFunction.setSorted(xMLControl.getBoolean("sorted"));
            dataFunction.setConnected(xMLControl.getBoolean("connected"));
            Color color = (Color)xMLControl.getObject("line_color");
            if (color != null) {
                dataFunction.setLineColor(color);
            }
            Color color2 = (Color)xMLControl.getObject("fill_color");
            color = (Color)xMLControl.getObject("edge_color");
            if (color2 != null) {
                if (color != null) {
                    dataFunction.setMarkerColor(color2, color);
                } else {
                    dataFunction.setMarkerColor(color2);
                }
            }
            return object;
        }
    }
}

