/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Dictionary;
import java.util.EventObject;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.opensourcephysics.display.ArrayTableModel;
import org.opensourcephysics.display.CellBorder;

public class ArrayTable
extends JTable
implements ActionListener {
    int refreshDelay = 300;
    Timer refreshTimer = new Timer(this.refreshDelay, this);
    ArrayTableModel tableModel;
    ArrayIndexRenderer indexRenderer = new ArrayIndexRenderer();
    ArrayCellRenderer cellRenderer = new ArrayCellRenderer();
    Dictionary<Integer, DecimalFormat> formatDictionary = new Hashtable<Integer, DecimalFormat>();
    String formatPattern = "0.000";
    DecimalFormat defaultFormat = new DecimalFormat(this.formatPattern);
    Object prevValue;

    public ArrayTable(int[] nArray) {
        this.tableModel = new ArrayTableModel(nArray);
        this.init();
    }

    public ArrayTable(int[][] nArray) {
        this.tableModel = new ArrayTableModel(nArray);
        this.init();
    }

    public ArrayTable(double[] dArray) {
        this.tableModel = new ArrayTableModel(dArray);
        this.init();
    }

    public ArrayTable(double[][] dArray) {
        this.tableModel = new ArrayTableModel(dArray);
        this.init();
    }

    public ArrayTable(String[] stringArray) {
        this.tableModel = new ArrayTableModel(stringArray);
        this.init();
    }

    public ArrayTable(String[][] stringArray) {
        this.tableModel = new ArrayTableModel(stringArray);
        this.init();
    }

    public ArrayTable(boolean[] blArray) {
        this.tableModel = new ArrayTableModel(blArray);
        this.init();
    }

    public ArrayTable(boolean[][] blArray) {
        this.tableModel = new ArrayTableModel(blArray);
        this.init();
    }

    protected void init() {
        TableColumn tableColumn;
        String string;
        this.refreshTimer.setRepeats(false);
        this.refreshTimer.setCoalesce(true);
        this.setModel(this.tableModel);
        this.tableModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                int n;
                int n2 = tableModelEvent.getFirstRow();
                Object object = ArrayTable.this.getValueAt(n2, n = ArrayTable.this.tableModel.showRowNumber ? tableModelEvent.getColumn() + 1 : tableModelEvent.getColumn());
                if (object != null && !object.equals(ArrayTable.this.prevValue)) {
                    ArrayTable.this.firePropertyChange("cell", null, tableModelEvent);
                }
            }
        });
        this.setDefaultRenderer(Object.class, this.cellRenderer);
        this.setColumnSelectionAllowed(true);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(this.indexRenderer);
        this.setAutoResizeMode(0);
        this.setGridColor(Color.BLACK);
        int n = 24;
        if (this.getColumnCount() > 0) {
            string = this.getColumnName(0);
            tableColumn = this.getColumn(string);
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(2 * n);
            tableColumn.setWidth(n);
        }
        ((Hashtable)this.formatDictionary).clear();
        n = 60;
        int n2 = 1;
        int n3 = this.getColumnCount();
        while (n2 < n3) {
            string = this.getColumnName(n2);
            tableColumn = this.getColumn(string);
            tableColumn.setMinWidth(n);
            tableColumn.setMaxWidth(3 * n);
            tableColumn.setWidth(n);
            ++n2;
        }
        InputMap inputMap = this.getInputMap(1);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(9, 0);
        final Action action = this.getActionMap().get(inputMap.get(keyStroke));
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                action.actionPerformed(actionEvent);
                JTable jTable = (JTable)actionEvent.getSource();
                int n = jTable.getRowCount();
                int n2 = jTable.getSelectedRow();
                int n3 = jTable.getSelectedColumn();
                while (!jTable.isCellEditable(n2, n3)) {
                    if (n3 == 0) {
                        n3 = 1;
                    } else {
                        ++n2;
                    }
                    if (n2 == n) {
                        n2 = 0;
                    }
                    if (n2 == jTable.getSelectedRow() && n3 == jTable.getSelectedColumn()) break;
                }
                jTable.changeSelection(n2, n3, false, false);
            }
        };
        this.getActionMap().put(inputMap.get(keyStroke), abstractAction);
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTable jTable = (JTable)actionEvent.getSource();
                int n = jTable.getSelectedRow();
                int n2 = jTable.getSelectedColumn();
                jTable.editCellAt(n, n2, actionEvent);
                Component component = jTable.getEditorComponent();
                if (component instanceof JTextField) {
                    JTextField jTextField = (JTextField)component;
                    jTextField.requestFocus();
                    jTextField.selectAll();
                }
            }
        };
        KeyStroke keyStroke2 = KeyStroke.getKeyStroke(10, 0);
        this.getActionMap().put(inputMap.get(keyStroke2), abstractAction2);
    }

    public boolean editCellAt(int n, int n2, EventObject eventObject) {
        boolean bl = super.editCellAt(n, n2, eventObject);
        if (bl) {
            this.prevValue = this.getValueAt(n, n2);
        }
        return bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.tableChanged(new TableModelEvent(this.tableModel, -1));
    }

    public void setRefreshDelay(int n) {
        this.refreshTimer.setInitialDelay(n);
    }

    public void refreshTable() {
        this.refreshTimer.start();
    }

    public void setNumericFormat(String string) {
        if (string != null && !string.equals(this.formatPattern)) {
            this.formatPattern = string;
            this.defaultFormat = new DecimalFormat(string);
            this.refreshTable();
        }
    }

    public void setNumericFormat(String[] stringArray) {
        ((Hashtable)this.formatDictionary).clear();
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            this.formatDictionary.put(n, new DecimalFormat(stringArray[n]));
            ++n;
        }
        this.refreshTable();
    }

    public void setFirstRowIndex(int n) {
        if (n == this.tableModel.firstRow) {
            return;
        }
        this.tableModel.setFirstRowIndex(n);
        this.refreshTable();
    }

    public void setFirstColIndex(int n) {
        if (n == this.tableModel.firstCol) {
            return;
        }
        this.tableModel.setFirstColIndex(n);
        this.refreshTable();
    }

    public void setRowNumberVisible(boolean bl) {
        if (bl == this.tableModel.showRowNumber) {
            return;
        }
        this.tableModel.setRowNumberVisible(bl);
        this.refreshTable();
    }

    public void setEditable(boolean bl) {
        if (bl == this.tableModel.editable) {
            return;
        }
        this.tableModel.setEditable(bl);
        this.refreshTable();
    }

    public boolean isTransposed() {
        return this.tableModel.isTransposed();
    }

    public void setTransposed(boolean bl) {
        if (bl == this.tableModel.transposed) {
            return;
        }
        this.tableModel.transposed = bl;
        this.refreshTable();
    }

    public void setColumnNames(String[] stringArray) {
        if (this.tableModel.setColumnNames(stringArray)) {
            this.refreshTable();
        }
    }

    public void setColumnLock(int n, boolean bl) {
        if (this.tableModel.setColumnLock(n, bl)) {
            this.refreshTable();
        }
    }

    public void setColumnLocks(boolean[] blArray) {
        if (this.tableModel.setColumnLocks(blArray)) {
            this.refreshTable();
        }
    }

    public Font getFont() {
        if (this.indexRenderer == null) {
            this.indexRenderer = new ArrayIndexRenderer();
        }
        return this.indexRenderer.getFont();
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.indexRenderer == null) {
            this.indexRenderer = new ArrayIndexRenderer();
        }
        if (this.cellRenderer == null) {
            this.cellRenderer = new ArrayCellRenderer();
        }
        this.indexRenderer.setFont(font);
        this.cellRenderer.setFont(font);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.indexRenderer == null) {
            this.indexRenderer = new ArrayIndexRenderer();
        }
        this.indexRenderer.setForeground(color);
    }

    public void setDataForeground(Color color) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new ArrayCellRenderer();
        }
        this.cellRenderer.setForeground(color);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.indexRenderer == null) {
            this.indexRenderer = new ArrayIndexRenderer();
        }
        this.indexRenderer.setBackground(color);
    }

    public void setDataBackground(Color color) {
        if (this.cellRenderer == null) {
            this.cellRenderer = new ArrayCellRenderer();
        }
        this.cellRenderer.setBackground(color);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        int n3 = this.convertColumnIndexToModel(n2);
        if (n3 == 0 && this.tableModel.showRowNumber) {
            return this.indexRenderer;
        }
        return this.getDefaultRenderer(this.getColumnClass(n2));
    }

    static class ArrayCellRenderer
    extends DefaultTableCellRenderer {
        public ArrayCellRenderer() {
            this.setForeground(Color.BLACK);
            this.setHorizontalAlignment(4);
            this.setBackground(Color.WHITE);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            boolean bl3 = jTable.isCellEditable(n, n2);
            this.setEnabled(bl3);
            ArrayTable arrayTable = (ArrayTable)jTable;
            DecimalFormat decimalFormat = arrayTable.formatDictionary.get(n2);
            if (decimalFormat == null) {
                decimalFormat = arrayTable.defaultFormat;
            }
            if (object == null) {
                this.setText("");
            } else if (decimalFormat == null) {
                this.setText(object.toString());
            } else {
                try {
                    this.setText(decimalFormat.format(object));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.setText(object.toString());
                }
            }
            this.setBorder(new CellBorder(new Color(224, 224, 224)));
            return this;
        }
    }

    static class ArrayIndexRenderer
    extends JLabel
    implements TableCellRenderer {
        public ArrayIndexRenderer() {
            this.setBorder(BorderFactory.createEtchedBorder());
            this.setOpaque(true);
            this.setForeground(Color.BLACK);
            this.setBackground(UIManager.getColor("Panel.background"));
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 == 0) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(0);
            }
            if (object == null) {
                this.setText("");
            } else {
                this.setText(object.toString());
            }
            this.setPreferredSize(new Dimension(20, 18));
            return this;
        }
    }
}

