/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.beans.PropertyChangeEvent;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.tools.DataFunctionEditor;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.Parameter;
import org.opensourcephysics.tools.ToolsRes;

public class DataFunctionPanel
extends FunctionPanel {
    public DataFunctionPanel(DatasetManager datasetManager) {
        this(new DataFunctionEditor(datasetManager));
    }

    public DataFunctionPanel(DataFunctionEditor dataFunctionEditor) {
        super(dataFunctionEditor);
        String string = dataFunctionEditor.getData().getName();
        this.setName(string.equals("") ? "data" : string);
    }

    public DatasetManager getData() {
        return ((DataFunctionEditor)this.functionEditor).getData();
    }

    public String getLabel() {
        return ToolsRes.getString("DataFunctionPanel.SpinnerLabel");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("edit")) {
            super.propertyChange(propertyChangeEvent);
        } else if (propertyChangeEvent.getPropertyName().equals("function")) {
            if (propertyChangeEvent.getNewValue() != null) {
                DataFunction dataFunction = (DataFunction)propertyChangeEvent.getNewValue();
                this.getData().addDataset(dataFunction);
            } else if (propertyChangeEvent.getOldValue() != null) {
                DataFunction dataFunction = (DataFunction)propertyChangeEvent.getOldValue();
                int n = this.getData().getDatasetIndex(dataFunction.getYColumnName());
                this.getData().removeDataset(n);
            }
            this.refreshFunctions();
            this.refreshGUI();
            this.functionTool.firePropertyChange("function", propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void refreshFunctions() {
        void parameter;
        String[] stringArray = this.getData().getConstantNames();
        int n = stringArray.length;
        boolean n2 = false;
        while (parameter < n) {
            String string = stringArray[parameter];
            this.getData().clearConstant(string);
            ++parameter;
        }
        for (Parameter parameter2 : this.paramEditor.getObjects()) {
            String string = parameter2.getName();
            double d = parameter2.getValue();
            this.getData().setConstant(string, d, parameter2.getExpression());
        }
        this.functionEditor.evaluateAll();
    }
}

