/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.awt.Color;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.drawing2d.ControlElement2D;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.InterpretedValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.Set;
import org.opensourcephysics.drawing2d.interaction.InteractionEvent;
import org.opensourcephysics.drawing2d.interaction.InteractionTarget;
import org.opensourcephysics.tools.ToolForData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlSet2D
extends ControlElement2D {
    protected static final int SET2D_ADDED = 2;
    protected static final int NUM_ELEMENTS = 0;
    protected static final int ELEMENT_SELECTED = 1;
    protected Set set;
    protected Element[] elements;
    protected int numElements = 0;
    protected ObjectValue[] allposValues;
    protected ObjectValue[] allsizesValues;
    protected IntegerValue selectedValue = new IntegerValue(-1);
    protected double[] theXs;
    protected double[] theYs;
    protected double[] theSizeXs;
    protected double[] theSizeYs;
    protected double[][] allThePos;
    protected double[][] allTheSizes;
    protected double allScalex = 1.0;
    protected double allScaley = 1.0;
    protected double allLineWidth = 1.0;
    protected boolean numberOfElements_isSet = false;
    private boolean propagatingValue = false;
    protected double defaultElementX;
    protected double defaultElementY;
    protected double defaultElementSizeX;
    protected double defaultElementSizeY;
    protected Color defElementLines;
    protected Paint defElementFill;
    private static List<String> infoList = null;

    public ControlSet2D() {
        this.checkNumberOfElements(1, true);
        this.defaultElementX = this.elements[0].getX();
        this.defaultElementY = this.elements[0].getY();
        this.defaultElementSizeX = this.elements[0].getSizeX();
        this.defaultElementSizeY = this.elements[0].getSizeY();
        this.defElementLines = this.elements[0].getStyle().getLineColor();
        this.defElementFill = this.elements[0].getStyle().getFillColor();
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.drawing2d.Set";
    }

    @Override
    protected Drawable createDrawable() {
        this.set = new Set();
        return this.set;
    }

    protected abstract Element createAnElement();

    protected abstract int getPropertiesAddedToSet();

    @Override
    protected final int getPropertiesDisplacement() {
        return this.getPropertiesAddedToSet() + 2;
    }

    protected void copyAnElement(Element element, Element element2) {
        element.getStyle().copyTo(element2);
        element2.setDataObject(element.getDataObject());
        element2.setPanel(element.getPanel());
        element2.setName(element.getName());
        element2.setXY(element.getX(), element.getY());
        element2.setSizeXY(element.getSizeX(), element.getSizeY());
        element2.setVisible(element.isVisible());
        element2.setCanBeMeasured(element.getCanBeMeasured());
        element2.setTransformation(element.getTransformation());
        element2.getInteractionTarget(0).setEnabled(element.getInteractionTarget(0).getEnabled());
        element2.getInteractionTarget(0).setAffectsGroup(element.getInteractionTarget(0).getAffectsGroup());
        element2.getInteractionTarget(1).setEnabled(element.getInteractionTarget(1).getEnabled());
        element2.getInteractionTarget(1).setAffectsGroup(element.getInteractionTarget(1).getAffectsGroup());
    }

    protected final void checkNumberOfElements(int n, boolean bl) {
        if (this.numElements == n && !bl) {
            return;
        }
        if (n < 1) {
            return;
        }
        this.setNumberOfElements(n);
        EjsControl ejsControl = this.getGroup();
        if (ejsControl != null && !ejsControl.isReportingChange() && !this.propagatingValue) {
            this.propagatingValue = true;
            ejsControl.propagateValues();
            this.propagatingValue = false;
        }
    }

    protected void setNumberOfElements(int n) {
        Element[] elementArray = this.elements;
        this.elements = new Element[n];
        int n2 = 0;
        while (n2 < n) {
            this.elements[n2] = this.createAnElement();
            Element element = null;
            if (n2 < this.numElements) {
                element = elementArray[n2];
            } else if (elementArray != null) {
                element = elementArray[0];
            }
            if (element != null) {
                this.copyAnElement(element, this.elements[n2]);
            }
            ++n2;
        }
        this.set.removeAllElements();
        n2 = 0;
        while (n2 < n) {
            this.set.addElement(this.elements[n2]);
            this.elements[n2].setName(String.valueOf(this.set.getName()) + "[" + n2 + "]");
            ++n2;
        }
        this.theXs = new double[n];
        this.theYs = new double[n];
        this.theSizeXs = new double[n];
        this.theSizeYs = new double[n];
        n2 = 0;
        while (n2 < n) {
            this.theXs[n2] = this.elements[n2].getX();
            this.theYs[n2] = this.elements[n2].getY();
            this.theSizeXs[n2] = this.elements[n2].getSizeX();
            this.theSizeYs[n2] = this.elements[n2].getSizeY();
            this.elements[n2].addInteractionListener(this);
            ++n2;
        }
        this.allposValues = new ObjectValue[2];
        this.allsizesValues = new ObjectValue[2];
        this.allposValues[0] = new ObjectValue(this.theXs);
        this.allposValues[1] = new ObjectValue(this.theYs);
        this.allsizesValues[0] = new ObjectValue(this.theSizeXs);
        this.allsizesValues[1] = new ObjectValue(this.theSizeYs);
        this.numElements = n;
        elementArray = null;
    }

    public Element elementAt(int n) {
        return this.elements[n];
    }

    @Override
    public void reset() {
        this.set.clear();
    }

    @Override
    public void initialize() {
        this.set.initialize();
    }

    @Override
    public void setName(String string) {
        super.setName(string);
        int n = 0;
        while (n < this.numElements) {
            this.elements[n].setName(String.valueOf(string) + "[" + n + "]");
            ++n;
        }
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("numberOfElements");
            infoList.add("elementSelected");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("numberOfElements")) {
            return "int PREVIOUS";
        }
        if (string.equals("elementSelected")) {
            return "int";
        }
        if (string.equals("x")) {
            return "int|double|double[]";
        }
        if (string.equals("y")) {
            return "int|double|double[]";
        }
        if (string.equals("position")) {
            return "double[][]";
        }
        if (string.equals("sizeX")) {
            return "int|double|double[]";
        }
        if (string.equals("sizeY")) {
            return "int|double|double[]";
        }
        if (string.equals("size")) {
            return "double[][]";
        }
        if (string.equals("scalex")) {
            return "int|double";
        }
        if (string.equals("scaley")) {
            return "int|double";
        }
        if (string.equals("transformation")) {
            return "AffineTransform|double|double[]|Object|Object[]";
        }
        if (string.equals("visible")) {
            return "boolean|boolean[]";
        }
        if (string.equals("lineColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (string.equals("lineWidth")) {
            return "int|double|double[]";
        }
        if (string.equals("fillColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (string.equals("drawingFill")) {
            return "boolean|boolean[]";
        }
        if (string.equals("drawingLines")) {
            return "boolean|boolean[]";
        }
        if (string.equals("enabledPosition")) {
            return "Interaction2D|int|int[]|boolean|boolean[]";
        }
        if (string.equals("movesGroup")) {
            return "boolean|boolean[]";
        }
        if (string.equals("enabledSize")) {
            return "Interaction2D|int|int[]|boolean|boolean[]";
        }
        if (string.equals("resizesGroup")) {
            return "boolean|boolean[]";
        }
        if (string.equals("sensitivity")) {
            return "int|int[]";
        }
        if (string.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("measured")) {
            return "boolean|boolean[]";
        }
        if (string.equals("extraColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public ControlElement setProperty(String string, String string2) {
        string = string.trim();
        if (string2 != null) {
            boolean bl;
            boolean bl2 = bl = string2.startsWith("%_model.") && string2.endsWith("()%");
            if (string.equals("x")) {
                this.set.setXLabel(bl ? "x" : string2);
            } else if (string.equals("y")) {
                this.set.setYLabel(bl ? "y" : string2);
            }
        }
        return super.setProperty(string, string2);
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlSet2D.getDataInformationMenuEntries(this.getParent().getDrawingPanel(), this.set));
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getInteger() != this.numElements) {
                    this.checkNumberOfElements(value.getInteger(), true);
                }
                this.numberOfElements_isSet = true;
                return;
            }
            case 1: {
                this.selectedValue.value = value.getInteger();
                return;
            }
        }
        switch (n -= 2) {
            case 0: {
                this.allThePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n2 = 0;
                    int n3 = Math.min(this.numElements, dArray.length);
                    while (n2 < n3) {
                        this.theXs[n2] = dArray[n2];
                        this.elements[n2].setX(this.theXs[n2]);
                        ++n2;
                    }
                } else {
                    double d = value.getDouble();
                    int n4 = 0;
                    while (n4 < this.numElements) {
                        this.theXs[n4] = d;
                        this.elements[n4].setX(this.theXs[n4]);
                        ++n4;
                    }
                }
                break;
            }
            case 1: {
                this.allThePos = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n5 = 0;
                    int n6 = Math.min(this.numElements, dArray.length);
                    while (n5 < n6) {
                        this.theYs[n5] = dArray[n5];
                        this.elements[n5].setY(this.theYs[n5]);
                        ++n5;
                    }
                } else {
                    double d = value.getDouble();
                    int n7 = 0;
                    while (n7 < this.numElements) {
                        this.theYs[n7] = d;
                        this.elements[n7].setY(this.theYs[n7]);
                        ++n7;
                    }
                }
                break;
            }
            case 2: {
                if (!(value.getObject() instanceof double[][])) break;
                this.allThePos = (double[][])value.getObject();
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(this.allThePos.length, false);
                }
                int n8 = 0;
                int n9 = Math.min(this.numElements, this.allThePos.length);
                while (n8 < n9) {
                    double[] dArray = this.allThePos[n8];
                    this.theXs[n8] = dArray[0];
                    this.theYs[n8] = dArray[1];
                    this.elements[n8].setXY(this.theXs[n8], this.theYs[n8]);
                    ++n8;
                }
                break;
            }
            case 3: {
                this.allTheSizes = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n10 = 0;
                    int n11 = Math.min(this.numElements, dArray.length);
                    while (n10 < n11) {
                        this.theSizeXs[n10] = dArray[n10];
                        this.elements[n10].setSizeX(this.theSizeXs[n10] * this.allScalex);
                        ++n10;
                    }
                } else {
                    double d = value.getDouble();
                    int n12 = 0;
                    while (n12 < this.numElements) {
                        this.theSizeXs[n12] = d;
                        this.elements[n12].setSizeX(this.theSizeXs[n12] * this.allScalex);
                        ++n12;
                    }
                }
                break;
            }
            case 4: {
                this.allTheSizes = null;
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    if (!this.numberOfElements_isSet) {
                        this.checkNumberOfElements(dArray.length, false);
                    }
                    int n13 = 0;
                    int n14 = Math.min(this.numElements, dArray.length);
                    while (n13 < n14) {
                        this.theSizeYs[n13] = dArray[n13];
                        this.elements[n13].setSizeY(this.theSizeYs[n13] * this.allScaley);
                        ++n13;
                    }
                } else {
                    double d = value.getDouble();
                    int n15 = 0;
                    while (n15 < this.numElements) {
                        this.theSizeYs[n15] = d;
                        this.elements[n15].setSizeY(this.theSizeYs[n15] * this.allScaley);
                        ++n15;
                    }
                }
                break;
            }
            case 5: {
                if (!(value.getObject() instanceof double[][])) break;
                this.allTheSizes = (double[][])value.getObject();
                if (!this.numberOfElements_isSet) {
                    this.checkNumberOfElements(this.allTheSizes.length, false);
                }
                int n16 = 0;
                int n17 = Math.min(this.numElements, this.allTheSizes.length);
                while (n16 < n17) {
                    double[] dArray = this.allTheSizes[n16];
                    this.theSizeXs[n16] = dArray[0];
                    this.theSizeYs[n16] = this.allTheSizes[n16][1];
                    this.elements[n16].setSizeXY(this.theSizeXs[n16] * this.allScalex, this.theSizeYs[n16] * this.allScaley);
                    ++n16;
                }
                break;
            }
            case 6: {
                this.allScalex = value.getDouble();
                int n18 = 0;
                while (n18 < this.numElements) {
                    this.elements[n18].setSizeX(this.theSizeXs[n18] * this.allScalex);
                    ++n18;
                }
                break;
            }
            case 7: {
                this.allScaley = value.getDouble();
                int n19 = 0;
                while (n19 < this.numElements) {
                    this.elements[n19].setSizeY(this.theSizeYs[n19] * this.allScaley);
                    ++n19;
                }
                break;
            }
            case 8: {
                if (value.getObject() instanceof AffineTransform) {
                    AffineTransform affineTransform = (AffineTransform)value.getObject();
                    int n20 = 0;
                    while (n20 < this.numElements) {
                        this.elements[n20].setTransformation(affineTransform);
                        ++n20;
                    }
                } else if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n21 = 0;
                    int n22 = Math.min(dArray.length, this.numElements);
                    while (n21 < n22) {
                        this.elements[n21].setTransformation(AffineTransform.getRotateInstance(dArray[n21]));
                        ++n21;
                    }
                } else if (value instanceof DoubleValue || value instanceof InterpretedValue) {
                    AffineTransform affineTransform = AffineTransform.getRotateInstance(value.getDouble());
                    int n23 = 0;
                    while (n23 < this.numElements) {
                        this.elements[n23].setTransformation(affineTransform);
                        ++n23;
                    }
                } else if (value.getObject() instanceof AffineTransform[]) {
                    AffineTransform[] affineTransformArray = (AffineTransform[])value.getObject();
                    int n24 = 0;
                    int n25 = Math.min(affineTransformArray.length, this.numElements);
                    while (n24 < n25) {
                        this.elements[n24].setTransformation(affineTransformArray[n24]);
                        ++n24;
                    }
                } else {
                    AffineTransform affineTransform = ControlSet2D.decodeAffineTransform(value.getString());
                    int n26 = 0;
                    while (n26 < this.numElements) {
                        this.elements[n26].setTransformation(affineTransform);
                        ++n26;
                    }
                }
                break;
            }
            case 9: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n27 = 0;
                    int n28 = Math.min(this.numElements, blArray.length);
                    while (n27 < n28) {
                        this.elements[n27].setVisible(blArray[n27]);
                        ++n27;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n29 = 0;
                    while (n29 < this.numElements) {
                        this.elements[n29].setVisible(bl);
                        ++n29;
                    }
                }
                break;
            }
            case 10: {
                if (value instanceof IntegerValue) {
                    Color color = DisplayColors.getLineColor(value.getInteger());
                    int n30 = 0;
                    while (n30 < this.numElements) {
                        this.elements[n30].getStyle().setLineColor(color);
                        ++n30;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n31 = 0;
                    int n32 = Math.min(this.numElements, nArray.length);
                    while (n31 < n32) {
                        this.elements[n31].getStyle().setLineColor(DisplayColors.getLineColor(nArray[n31]));
                        ++n31;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n33 = 0;
                    int n34 = Math.min(this.numElements, objectArray.length);
                    while (n33 < n34) {
                        this.elements[n33].getStyle().setLineColor((Color)objectArray[n33]);
                        ++n33;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n35 = 0;
                    while (n35 < this.numElements) {
                        this.elements[n35].getStyle().setLineColor(color);
                        ++n35;
                    }
                }
                break;
            }
            case 11: {
                if (value.getObject() instanceof double[]) {
                    double[] dArray = (double[])value.getObject();
                    int n36 = 0;
                    int n37 = Math.min(this.numElements, dArray.length);
                    while (n36 < n37) {
                        this.elements[n36].getStyle().setLineWidth((float)dArray[n36]);
                        ++n36;
                    }
                } else {
                    float f = (float)value.getDouble();
                    int n38 = 0;
                    while (n38 < this.numElements) {
                        this.elements[n38].getStyle().setLineWidth(f);
                        ++n38;
                    }
                }
                break;
            }
            case 12: {
                if (value instanceof IntegerValue) {
                    Color color = DisplayColors.getLineColor(value.getInteger());
                    int n39 = 0;
                    while (n39 < this.numElements) {
                        this.elements[n39].getStyle().setFillColor(color);
                        ++n39;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n40 = 0;
                    int n41 = Math.min(this.numElements, nArray.length);
                    while (n40 < n41) {
                        this.elements[n40].getStyle().setFillColor(DisplayColors.getLineColor(nArray[n40]));
                        ++n40;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n42 = 0;
                    int n43 = Math.min(this.numElements, objectArray.length);
                    while (n42 < n43) {
                        this.elements[n42].getStyle().setFillColor((Color)objectArray[n42]);
                        ++n42;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n44 = 0;
                    while (n44 < this.numElements) {
                        this.elements[n44].getStyle().setFillColor(color);
                        ++n44;
                    }
                }
                break;
            }
            case 13: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n45 = 0;
                    int n46 = Math.min(this.numElements, blArray.length);
                    while (n45 < n46) {
                        this.elements[n45].getStyle().setDrawingFill(blArray[n45]);
                        ++n45;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n47 = 0;
                    while (n47 < this.numElements) {
                        this.elements[n47].getStyle().setDrawingFill(bl);
                        ++n47;
                    }
                }
                break;
            }
            case 14: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n48 = 0;
                    int n49 = Math.min(this.numElements, blArray.length);
                    while (n48 < n49) {
                        this.elements[n48].getStyle().setDrawingLines(blArray[n48]);
                        ++n48;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n50 = 0;
                    while (n50 < this.numElements) {
                        this.elements[n50].getStyle().setDrawingLines(bl);
                        ++n50;
                    }
                }
                break;
            }
            case 15: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n51 = 0;
                    int n52 = Math.min(this.numElements, blArray.length);
                    while (n51 < n52) {
                        this.elements[n51].getInteractionTarget(0).setEnabled(blArray[n51]);
                        ++n51;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n53 = 0;
                    int n54 = Math.min(this.numElements, nArray.length);
                    while (n53 < n54) {
                        this.elements[n53].getInteractionTarget(0).setEnabled(nArray[n53]);
                        ++n53;
                    }
                } else if (value instanceof BooleanValue) {
                    boolean bl = value.getBoolean();
                    int n55 = 0;
                    while (n55 < this.numElements) {
                        this.elements[n55].getInteractionTarget(0).setEnabled(bl);
                        ++n55;
                    }
                } else {
                    int n56 = value.getInteger();
                    int n57 = 0;
                    while (n57 < this.numElements) {
                        this.elements[n57].getInteractionTarget(0).setEnabled(n56);
                        ++n57;
                    }
                }
                break;
            }
            case 16: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n58 = 0;
                    int n59 = Math.min(this.numElements, blArray.length);
                    while (n58 < n59) {
                        this.elements[n58].getInteractionTarget(0).setAffectsGroup(blArray[n58]);
                        ++n58;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n60 = 0;
                    while (n60 < this.numElements) {
                        this.elements[n60].getInteractionTarget(0).setAffectsGroup(bl);
                        ++n60;
                    }
                }
                break;
            }
            case 17: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n61 = 0;
                    int n62 = Math.min(this.numElements, blArray.length);
                    while (n61 < n62) {
                        this.elements[n61].getInteractionTarget(1).setEnabled(blArray[n61]);
                        ++n61;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n63 = 0;
                    int n64 = Math.min(this.numElements, nArray.length);
                    while (n63 < n64) {
                        this.elements[n63].getInteractionTarget(1).setEnabled(nArray[n63]);
                        ++n63;
                    }
                } else if (value instanceof BooleanValue) {
                    boolean bl = value.getBoolean();
                    int n65 = 0;
                    while (n65 < this.numElements) {
                        this.elements[n65].getInteractionTarget(1).setEnabled(bl);
                        ++n65;
                    }
                } else {
                    int n66 = value.getInteger();
                    int n67 = 0;
                    while (n67 < this.numElements) {
                        this.elements[n67].getInteractionTarget(1).setEnabled(n66);
                        ++n67;
                    }
                }
                break;
            }
            case 18: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n68 = 0;
                    int n69 = Math.min(this.numElements, blArray.length);
                    while (n68 < n69) {
                        this.elements[n68].getInteractionTarget(1).setAffectsGroup(blArray[n68]);
                        ++n68;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n70 = 0;
                    while (n70 < this.numElements) {
                        this.elements[n70].getInteractionTarget(1).setAffectsGroup(bl);
                        ++n70;
                    }
                }
                break;
            }
            case 19: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n71 = 0;
                    int n72 = Math.min(this.numElements, nArray.length);
                    while (n71 < n72) {
                        this.elements[n71].getStyle().setSensitivity(nArray[n71]);
                        ++n71;
                    }
                } else {
                    int n73 = value.getInteger();
                    int n74 = 0;
                    while (n74 < this.numElements) {
                        this.elements[n74].getStyle().setSensitivity(n73);
                        ++n74;
                    }
                }
                break;
            }
            case 25: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n75 = 0;
                    int n76 = Math.min(this.numElements, blArray.length);
                    while (n75 < n76) {
                        this.elements[n75].setCanBeMeasured(blArray[n75]);
                        ++n75;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n77 = 0;
                    while (n77 < this.numElements) {
                        this.elements[n77].setCanBeMeasured(bl);
                        ++n77;
                    }
                }
                break;
            }
            case 26: {
                if (value instanceof IntegerValue) {
                    Color color = DisplayColors.getLineColor(value.getInteger());
                    int n78 = 0;
                    while (n78 < this.numElements) {
                        this.elements[n78].getStyle().setExtraColor(color);
                        ++n78;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n79 = 0;
                    int n80 = Math.min(this.numElements, nArray.length);
                    while (n79 < n80) {
                        this.elements[n79].getStyle().setExtraColor(DisplayColors.getLineColor(nArray[n79]));
                        ++n79;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n81 = 0;
                    int n82 = Math.min(this.numElements, objectArray.length);
                    while (n81 < n82) {
                        this.elements[n81].getStyle().setExtraColor((Color)objectArray[n81]);
                        ++n81;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n83 = 0;
                    while (n83 < this.numElements) {
                        this.elements[n83].getStyle().setExtraColor(color);
                        ++n83;
                    }
                }
                break;
            }
            default: {
                super.setValue(n, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.checkNumberOfElements(1, true);
                this.numberOfElements_isSet = false;
                return;
            }
            case 1: {
                this.selectedValue.value = -1;
                return;
            }
        }
        switch (n -= 2) {
            case 0: {
                int n2 = 0;
                while (n2 < this.numElements) {
                    this.theXs[n2] = this.defaultElementX;
                    this.elements[n2].setX(this.theXs[n2]);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.numElements) {
                    this.theYs[n3] = this.defaultElementY;
                    this.elements[n3].setY(this.theYs[n3]);
                    ++n3;
                }
                break;
            }
            case 2: {
                this.allThePos = null;
                break;
            }
            case 3: {
                int n4 = 0;
                while (n4 < this.numElements) {
                    this.theSizeXs[n4] = this.defaultElementSizeX;
                    this.elements[n4].setSizeX(this.theSizeXs[n4] * this.allScalex);
                    ++n4;
                }
                break;
            }
            case 4: {
                int n5 = 0;
                while (n5 < this.numElements) {
                    this.theSizeYs[n5] = this.defaultElementSizeY;
                    this.elements[n5].setSizeY(this.theSizeYs[n5] * this.allScaley);
                    ++n5;
                }
                break;
            }
            case 5: {
                this.allTheSizes = null;
                break;
            }
            case 6: {
                this.allScalex = 1.0;
                int n6 = 0;
                while (n6 < this.numElements) {
                    this.elements[n6].setSizeX(this.theSizeXs[n6] * this.allScalex);
                    ++n6;
                }
                break;
            }
            case 7: {
                this.allScaley = 1.0;
                int n7 = 0;
                while (n7 < this.numElements) {
                    this.elements[n7].setSizeY(this.theSizeYs[n7] * this.allScaley);
                    ++n7;
                }
                break;
            }
            case 8: {
                int n8 = 0;
                while (n8 < this.numElements) {
                    this.elements[n8].setTransformation(null);
                    ++n8;
                }
                break;
            }
            case 9: {
                int n9 = 0;
                while (n9 < this.numElements) {
                    this.elements[n9].setVisible(true);
                    ++n9;
                }
                break;
            }
            case 10: {
                int n10 = 0;
                while (n10 < this.numElements) {
                    this.elements[n10].getStyle().setLineColor(this.defElementLines);
                    ++n10;
                }
                break;
            }
            case 11: {
                int n11 = 0;
                while (n11 < this.numElements) {
                    this.elements[n11].getStyle().setLineWidth(1.0f);
                    ++n11;
                }
                break;
            }
            case 12: {
                int n12 = 0;
                while (n12 < this.numElements) {
                    this.elements[n12].getStyle().setFillColor(this.defElementFill);
                    ++n12;
                }
                break;
            }
            case 13: {
                int n13 = 0;
                while (n13 < this.numElements) {
                    this.elements[n13].getStyle().setDrawingFill(true);
                    ++n13;
                }
                break;
            }
            case 14: {
                int n14 = 0;
                while (n14 < this.numElements) {
                    this.elements[n14].getStyle().setDrawingLines(true);
                    ++n14;
                }
                break;
            }
            case 15: {
                int n15 = 0;
                while (n15 < this.numElements) {
                    this.elements[n15].getInteractionTarget(0).setEnabled(false);
                    ++n15;
                }
                break;
            }
            case 16: {
                int n16 = 0;
                while (n16 < this.numElements) {
                    this.elements[n16].getInteractionTarget(0).setAffectsGroup(false);
                    ++n16;
                }
                break;
            }
            case 17: {
                int n17 = 0;
                while (n17 < this.numElements) {
                    this.elements[n17].getInteractionTarget(1).setEnabled(false);
                    ++n17;
                }
                break;
            }
            case 18: {
                int n18 = 0;
                while (n18 < this.numElements) {
                    this.elements[n18].getInteractionTarget(1).setAffectsGroup(false);
                    ++n18;
                }
                break;
            }
            case 19: {
                int n19 = 0;
                while (n19 < this.numElements) {
                    this.elements[n19].getStyle().setSensitivity(5);
                    ++n19;
                }
                break;
            }
            case 25: {
                int n20 = 0;
                while (n20 < this.numElements) {
                    this.elements[n20].setCanBeMeasured(true);
                    ++n20;
                }
                break;
            }
            case 26: {
                int n21 = 0;
                while (n21 < this.numElements) {
                    this.elements[n21].getStyle().setExtraColor(this.defExtraColor);
                    ++n21;
                }
                break;
            }
            default: {
                super.setDefaultValue(n);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "1";
            }
            case 1: {
                return "-1";
            }
        }
        switch (n -= 2) {
            case 0: {
                return Double.toString(this.defaultElementX);
            }
            case 1: {
                return Double.toString(this.defaultElementY);
            }
            case 3: {
                return Double.toString(this.defaultElementSizeX);
            }
            case 4: {
                return Double.toString(this.defaultElementSizeY);
            }
            case 10: {
                return this.defElementLines.toString();
            }
            case 12: {
                return this.defElementFill.toString();
            }
        }
        return super.getDefaultValueString(n);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
            case 1: {
                return this.selectedValue;
            }
        }
        switch (n -= 2) {
            case 0: {
                return this.allposValues[0];
            }
            case 1: {
                return this.allposValues[1];
            }
            case 2: {
                return new ObjectValue(this.allThePos);
            }
            case 5: {
                return new ObjectValue(this.allTheSizes);
            }
            case 3: {
                return this.allsizesValues[0];
            }
            case 4: {
                return this.allsizesValues[1];
            }
        }
        return super.getValue(n);
    }

    protected void propagatePosition(ControlElement2D controlElement2D, int n) {
        this.theXs[n] = this.elements[n].getX();
        this.theYs[n] = this.elements[n].getY();
        if (this.allThePos != null) {
            this.allThePos[n][0] = this.theXs[n];
            this.allThePos[n][1] = this.theYs[n];
            ObjectValue objectValue = new ObjectValue(this.allThePos);
            this.variableChanged(this.getFullPositionSpot(), objectValue);
            if (this != controlElement2D) {
                controlElement2D.variableChanged(controlElement2D.getFullPositionSpot(), objectValue);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullPositionSpot(), objectValue);
            }
        } else {
            this.variablesChanged(this.getPosSpot(), this.allposValues);
            if (this != controlElement2D) {
                controlElement2D.variablesChanged(controlElement2D.getPosSpot(), this.allposValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getPosSpot(), this.allposValues);
            }
        }
    }

    protected void propagateSize(ControlElement2D controlElement2D, int n) {
        this.theSizeXs[n] = this.allScalex != 0.0 ? this.elements[n].getSizeX() / this.allScalex : this.elements[n].getSizeX();
        this.theSizeYs[n] = this.allScaley != 0.0 ? this.elements[n].getSizeY() / this.allScaley : this.elements[n].getSizeY();
        if (this.allTheSizes != null) {
            this.allTheSizes[n][0] = this.theSizeXs[n];
            this.allTheSizes[n][1] = this.theSizeYs[n];
            ObjectValue objectValue = new ObjectValue(this.allTheSizes);
            this.variableChanged(this.getFullSizeSpot(), objectValue);
            if (this != controlElement2D) {
                controlElement2D.variableChanged(controlElement2D.getFullSizeSpot(), objectValue);
            }
            if (this.isUnderEjs) {
                this.setFieldListValue(this.getFullSizeSpot(), objectValue);
            }
        } else {
            this.variablesChanged(this.getSizeSpot(), this.allsizesValues);
            if (this != controlElement2D) {
                controlElement2D.variablesChanged(controlElement2D.getSizeSpot(), this.allsizesValues);
            }
            if (this.isUnderEjs) {
                this.setFieldListValues(this.getSizeSpot(), this.allsizesValues);
            }
        }
    }

    protected final void reportMouseMotion(Object object, int n) {
        InteractionTarget interactionTarget = (InteractionTarget)object;
        ControlSet2D controlSet2D = this;
        if (interactionTarget == this.elements[n].getInteractionTarget(0)) {
            if (interactionTarget.getAffectsGroup()) {
                controlSet2D.propagatePosition(this);
            } else {
                this.propagatePosition(this, n);
            }
        } else if (interactionTarget == this.elements[n].getInteractionTarget(1)) {
            if (interactionTarget.getAffectsGroup()) {
                controlSet2D.propagateSize(this);
            } else {
                this.propagateSize(this, n);
            }
        }
    }

    @Override
    public void interactionPerformed(InteractionEvent interactionEvent) {
        switch (interactionEvent.getID()) {
            case 2003: {
                this.selectedValue.value = this.set.getInteractedIndex();
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
                this.invokeActions(31);
                break;
            }
            case 2004: {
                this.invokeActions(32);
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
                break;
            }
            case 2000: {
                this.selectedValue.value = this.set.getInteractedIndex();
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
                this.reportMouseMotion(interactionEvent.getInfo(), this.selectedValue.value);
                this.invokeActions(10);
                break;
            }
            case 2001: {
                this.reportMouseMotion(interactionEvent.getInfo(), this.selectedValue.value);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.variableExtraChanged(1 + this.getPropertiesAddedToSet(), this.selectedValue);
            }
        }
    }
}

