/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.twoslitswithmedium_taha_pkg;

import java.awt.Color;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.ntnu.fkh.twoslitswithmedium_taha_pkg.twoslitswithmedium_tahaSimulation;
import users.ntnu.fkh.twoslitswithmedium_taha_pkg.twoslitswithmedium_tahaView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class twoslitswithmedium_taha
extends AbstractModel {
    public twoslitswithmedium_tahaSimulation _simulation = null;
    public twoslitswithmedium_tahaView _view = null;
    public twoslitswithmedium_taha _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double range = 200.0;
    public double pi = Math.PI;
    public double L = 1000.0;
    public double xmin = -this.range / 4.0;
    public double xmax = this.range / 4.0;
    public double ymin = 0.0;
    public double ymax = this.range / 2.0;
    public double zmin = -this.range / 2.0;
    public double zmax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 40.0;
    public double um = 1.0E-6;
    public double mouseReading = 0.0;
    public int nx = 1200;
    public int ny = 100;
    public double[][] Intensity;
    public double lambda;
    public double lambdar = 0.543079;
    public double a = 10.0;
    public double spectrumy = this.ymin;
    public double spectrumy1 = this.ymin + 0.01 * this.ymax;
    public double spectrumy2 = this.spectrumy1 + 1.9 * this.ymax;
    public double Imax = this.ny;
    public double[] XP;
    public double[] YP;
    public double[] YP2;
    public double xscale = 0.2;
    public double yscale = 1.0;
    public double d = 10.0 * this.a;
    public int N = 2;
    public boolean singleSlit = false;
    public double ar = 10.0;
    public double dr = 100.0015;
    public boolean showXY = true;
    public Color[] colors;
    public Object lambda_color = new Color(255, 0, 0);
    public int ng = 3;
    public double[] xg;
    public double[] dxg;
    public double gscale = 4.0;
    public double m_l = 1.0;
    public Object medium_color = new Color(0, 50, 0);
    public double m_n = 1.0;
    public double path_change = (this.m_n - 1.0) * this.m_l / this.lambda;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/twoslitswithmedium_taha.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("users/ntnu/fkh/taha/MultipleSlitDiffraction.html");
        hashSet.add("users/ntnu/fkh/taha/two_slit.jpg");
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        twoslitswithmedium_taha twoslitswithmedium_taha2 = new twoslitswithmedium_taha(stringArray);
    }

    public twoslitswithmedium_taha() {
        this(null, null, null, null, null, false);
    }

    public twoslitswithmedium_taha(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public twoslitswithmedium_taha(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new twoslitswithmedium_tahaSimulation(this, string, frame, uRL, bl);
        this._view = (twoslitswithmedium_tahaView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        double d = (this.xmax - this.xmin) / (double)(this.nx - 1);
        for (int i = 0; i < this.nx; ++i) {
            this.XP[i] = this.xmin + (double)i * d;
        }
        this.gratings();
    }

    public void _constraints1() {
        this.medium_color = Color.getHSBColor(50.5f, 0.005f, (float)(1.0 - this.m_n / 10.0));
        this._view.multipleSlitTrail.clear();
        this.lambda = this.lambdar * this.um;
        this.path_change = (this.m_n - 1.0) * this.m_l * 0.001;
        if (this.dr < 1.2 * this.ar) {
            this.dr = 1.2 * this.ar;
        }
        this.a = this.ar * this.um;
        this.d = this.dr * this.um;
        this.Imax = this.a * this.a * 3.0E8 / (double)this.N;
        double d = this.spectrumy2 - this.spectrumy1;
        for (int i = 0; i < this.nx; ++i) {
            double d2;
            double d3;
            double d4 = this.XP[i] / Math.sqrt(this.XP[i] * this.XP[i] + this.L * this.L) * this.xscale;
            double d5 = this.pi * this.a * (d4 += this.path_change * this.xscale) / this.lambda;
            double d6 = this.pi * this.d * d4 / this.lambda;
            if (d5 == 0.0) {
                d2 = d3 = this.Imax;
            } else {
                double d7 = Math.sin(d5) / d5;
                double d8 = d7 * Math.sin((double)this.N * d6) / Math.sin(d6) / (double)this.N;
                d3 = d8 * d8;
                d2 = d7 * d7;
            }
            for (int j = 0; j < this.ny; ++j) {
                this.Intensity[i][j] = d3 * this.Imax * (double)this.N / 2.0;
            }
            this.YP[i] = this.spectrumy1 + d * d3 * this.yscale;
            this.YP[i] = this.YP[i] / 100.0;
        }
    }

    public void lightPalette(double d) {
        int n = this.colors.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = i;
            int n4 = i;
            float f = (float)(-2.5 * d + 1.625);
            float f2 = 1.0f;
            if (d >= 0.65) {
                f = 0.0f;
                f2 = (float)(1.0 - d) / 0.35f;
            }
            if (d <= 0.35) {
                f = 0.75f;
                f2 = (float)(d / (double)0.35f);
            }
            this.colors[i] = Color.getHSBColor(f, f2, (float)((double)i / 255.0));
            this.lambda_color = Color.getHSBColor(f, f2, (float)((double)i / 255.0));
        }
    }

    public void computeIntensity() {
        double d = this._view.DrawingPanel.getMouseX();
        double d2 = d / Math.sqrt(d * d + this.L * this.L) * this.xscale;
        double d3 = this.pi * this.a * d2 / this.lambda;
        double d4 = this.pi * this.d * d2 / this.lambda;
        if (d3 == 0.0) {
            this.mouseReading = this.Imax * this.yscale;
            return;
        }
        double d5 = Math.sin(d3) / d3;
        d5 = d5 * Math.sin((double)this.N * d4) / Math.sin(d4) / (double)this.N;
        this.mouseReading = d5 * d5 * this.yscale;
    }

    public void gratings() {
        this.xg[1] = (-this.dr + this.ar) * 0.5 * 0.1;
        this.dxg[1] = this.dr * 0.1;
        this.xg[0] = this.xg[1] - this.ar * 0.1;
        this.dxg[0] = -35.0;
        this.xg[2] = this.xg[1] + this.dxg[1] + this.ar * 0.1;
        this.dxg[2] = 35.0;
    }

    public void _method_for_DrawingPanel_pressaction() {
        this._simulation.disableLoop();
        this.computeIntensity();
        this._simulation.enableLoop();
    }

    public void _method_for_DrawingPanel_dragaction() {
        this._simulation.disableLoop();
        this.computeIntensity();
        this._simulation.enableLoop();
    }

    public double _method_for_scalarField_maximumZ() {
        return 0.05 / this.yscale / (double)this.N;
    }

    public Color _method_for_scalarField_ceilingcolor() {
        return this.colors[255];
    }

    public double _method_for_medium_sizeY() {
        return 0.1 * this.m_l;
    }

    public double _method_for_xaxis_sizex() {
        return this.xmax - this.xmin;
    }

    public void _method_for_reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    public void _method_for_distanceField_action() {
        this._simulation.disableLoop();
        this.xscale = Math.max(0.1, this.xscale);
        this.xscale = Math.min(this.xscale, 2.0);
        this._simulation.enableLoop();
    }

    public void _method_for_m_l_dragaction() {
        this._simulation.disableLoop();
        this.gratings();
        this._simulation.enableLoop();
    }

    public void _method_for_m_n_dragaction() {
        this._simulation.disableLoop();
        this.gratings();
        this._simulation.enableLoop();
    }

    public void _method_for_SliderA_pressaction() {
        this._simulation.disableLoop();
        this.gratings();
        this._simulation.enableLoop();
    }

    public void _method_for_SliderA_dragaction() {
        this._simulation.disableLoop();
        this.gratings();
        this._simulation.enableLoop();
    }

    public void _method_for_Sliderd_pressaction() {
        this._simulation.disableLoop();
        this.gratings();
        this._simulation.enableLoop();
    }

    public void _method_for_Sliderd_dragaction() {
        this._simulation.disableLoop();
        this.gratings();
        this._simulation.enableLoop();
    }

    public void _method_for_Sliderlambda_dragaction() {
        this._simulation.disableLoop();
        this.lightPalette(this.lambdar);
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        this.range = 200.0;
        this.pi = Math.PI;
        this.L = 1000.0;
        this.xmin = -this.range / 4.0;
        this.xmax = this.range / 4.0;
        this.ymin = 0.0;
        this.ymax = this.range / 2.0;
        this.zmin = -this.range / 2.0;
        this.zmax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 40.0;
        this.um = 1.0E-6;
        this.mouseReading = 0.0;
        this.nx = 1200;
        this.ny = 100;
        this.Intensity = new double[this.nx][this.ny];
        this.lambdar = 0.543079;
        this.a = 10.0;
        this.spectrumy = this.ymin;
        this.spectrumy1 = this.ymin + 0.01 * this.ymax;
        this.spectrumy2 = this.spectrumy1 + 1.9 * this.ymax;
        this.Imax = this.ny;
        this.XP = new double[this.nx];
        this.YP = new double[this.nx];
        this.YP2 = new double[this.nx];
        this.xscale = 0.2;
        this.yscale = 1.0;
        this.d = 10.0 * this.a;
        this.N = 2;
        this.singleSlit = false;
        this.ar = 10.0;
        this.dr = 100.0015;
        this.showXY = true;
        this.colors = new Color[256];
        for (int i = 0; i < 256; ++i) {
            this.colors[i] = Color.GRAY;
        }
        this.lambda_color = new Color(255, 0, 0);
        this.ng = 3;
        this.xg = new double[this.ng];
        this.dxg = new double[this.ng];
        this.gscale = 4.0;
        this.m_l = 1.0;
        this.medium_color = new Color(0, 50, 0);
        this.m_n = 1.0;
        this.path_change = (this.m_n - 1.0) * this.m_l / this.lambda;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.Intensity = null;
        this.XP = null;
        this.YP = null;
        this.YP2 = null;
        this.colors = null;
        this.xg = null;
        this.dxg = null;
        System.gc();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }
}

