/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.swing.JFrame;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Grid;
import org.opensourcephysics.display.MeasuredImage;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.ZExpansion;

public class InterpolatedPlot
extends MeasuredImage
implements Plot2D {
    GridData griddata;
    byte[][] rgbData;
    Grid grid;
    ColorMapper colorMap;
    boolean autoscaleZ = true;
    int ampIndex = 0;
    int leftPix;
    int rightPix;
    int topPix;
    int bottomPix;
    int ixsize;
    int iysize;
    double top;
    double left;
    double bottom;
    double right;

    public InterpolatedPlot() {
        this((GridData)null);
    }

    public InterpolatedPlot(GridData gridData) {
        this.griddata = gridData;
        this.colorMap = new ColorMapper(100, -1.0, 1.0, 0);
        this.grid = this.griddata == null ? new Grid(1, 1, this.xmin, this.xmax, this.ymin, this.ymax) : new Grid(this.griddata.getNx(), this.griddata.getNy(), this.xmin, this.xmax, this.ymin, this.ymax);
        this.grid.setColor(Color.lightGray);
        this.grid.setVisible(false);
        this.update();
    }

    public byte[][] getRGBData() {
        return this.rgbData;
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public double indexToX(int n) {
        return this.griddata.indexToX(n);
    }

    public double indexToY(int n) {
        return this.griddata.indexToY(n);
    }

    public int xToIndex(double d) {
        return this.griddata.xToIndex(d);
    }

    public int yToIndex(double d) {
        return this.griddata.yToIndex(d);
    }

    public void setAll(Object object) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        this.update();
    }

    public void setAll(Object object, double d, double d2, double d3, double d4) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(d, d2, d3, d4);
        } else {
            this.griddata.setScale(d, d2, d3, d4);
        }
        this.update();
    }

    private void copyData(double[][] dArray) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != dArray.length || this.griddata.getNy() != dArray[0].length) {
            this.griddata = new ArrayData(dArray.length, dArray[0].length, 1);
            this.setGridData(this.griddata);
        }
        double[][] dArray2 = this.griddata.getData()[0];
        int n = dArray2[0].length;
        int n2 = 0;
        int n3 = dArray2.length;
        while (n2 < n3) {
            System.arraycopy(dArray[n2], 0, dArray2[n2], 0, n);
            ++n2;
        }
    }

    public void setGridData(GridData gridData) {
        this.griddata = gridData;
        if (this.griddata == null) {
            return;
        }
        int n = this.griddata.getNx();
        int n2 = this.griddata.getNy();
        Grid grid = new Grid(n, n2, this.xmin, this.xmax, this.ymin, this.ymax);
        if (this.grid != null) {
            grid.setColor(this.grid.getColor());
            grid.setVisible(this.grid.isVisible());
        }
        this.grid = grid;
        this.update();
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.autoscaleZ = bl;
        if (!this.autoscaleZ) {
            this.colorMap.setScale(d, d2);
        }
        this.update();
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return this.colorMap.getFloor();
    }

    public double getCeiling() {
        return this.colorMap.getCeil();
    }

    public void setShowGridLines(boolean bl) {
        this.grid.setVisible(bl);
    }

    public void setGridLineColor(Color color) {
        this.grid.setColor(color);
    }

    public void setIndexes(int[] nArray) {
        this.ampIndex = nArray[0];
    }

    public void setPaletteType(int n) {
        this.colorMap.setPaletteType(n);
    }

    public void setColorPalette(Color[] colorArray) {
        this.colorMap.setColorPalette(colorArray);
    }

    public void setFloorCeilColor(Color color, Color color2) {
        this.colorMap.setFloorCeilColor(color, color2);
    }

    public void setExpandedZ(boolean bl, double d) {
        if (bl && d > 0.0) {
            ZExpansion zExpansion = new ZExpansion(d);
            this.colorMap.setZMap(zExpansion);
        } else {
            this.colorMap.setZMap(null);
        }
    }

    public synchronized void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.autoscaleZ) {
            double[] dArray = this.griddata.getZRange(this.ampIndex);
            this.colorMap.setScale(dArray[0], dArray[1]);
        }
        this.recolorImage();
        this.colorMap.updateLegend(null);
    }

    protected synchronized void checkImage(DrawingPanel drawingPanel) {
        int n;
        int n2;
        int n3;
        int n4;
        if (this.griddata.isCellData()) {
            double d = this.griddata.getDx();
            double d2 = this.griddata.getDy();
            n4 = drawingPanel.xToPix(this.griddata.getLeft() - d / 2.0);
            n3 = drawingPanel.xToPix(this.griddata.getRight() + d / 2.0);
            n2 = drawingPanel.yToPix(this.griddata.getBottom() + d2 / 2.0);
            n = drawingPanel.yToPix(this.griddata.getTop() - d2 / 2.0);
        } else {
            n4 = drawingPanel.xToPix(this.griddata.getLeft());
            n3 = drawingPanel.xToPix(this.griddata.getRight());
            n2 = drawingPanel.yToPix(this.griddata.getBottom());
            n = drawingPanel.yToPix(this.griddata.getTop());
        }
        this.leftPix = Math.min(n4, n3);
        this.rightPix = Math.max(n4, n3);
        this.bottomPix = Math.max(n2, n);
        this.topPix = Math.min(n2, n);
        this.ixsize = this.rightPix - this.leftPix + 1;
        this.iysize = this.bottomPix - this.topPix + 1;
        this.leftPix = Math.max(0, this.leftPix);
        this.rightPix = Math.min(this.rightPix, drawingPanel.getWidth());
        this.topPix = Math.max(0, this.topPix);
        this.bottomPix = Math.min(this.bottomPix, drawingPanel.getHeight());
        int n5 = this.bottomPix - this.topPix + 1;
        int n6 = this.rightPix - this.leftPix + 1;
        if (this.image != null && this.image.getWidth() == n6 && this.image.getHeight() == n5 && this.left == drawingPanel.pixToX(this.leftPix) && this.top == drawingPanel.pixToY(this.topPix) && this.bottom == drawingPanel.pixToX(this.bottomPix) && this.right == drawingPanel.pixToY(this.rightPix)) {
            return;
        }
        this.left = drawingPanel.pixToX(this.leftPix);
        this.top = drawingPanel.pixToY(this.topPix);
        this.bottom = drawingPanel.pixToX(this.bottomPix);
        this.right = drawingPanel.pixToY(this.rightPix);
        if (this.image != null && this.image.getWidth() == n6 && this.image.getHeight() == n5) {
            this.recolorImage();
            return;
        }
        int n7 = n5 * n6;
        if (n7 < 4 || n5 > 4000 || n6 > 4000) {
            this.image = null;
            return;
        }
        OSPLog.finer("InterpolatedPlot image created with row=" + n5 + " and col=" + n6);
        ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), new int[]{8, 8, 8}, false, false, 1, 0);
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        BandedSampleModel bandedSampleModel = new BandedSampleModel(0, n6, n5, n6, nArray, new int[3]);
        this.rgbData = new byte[3][n7];
        DataBufferByte dataBufferByte = new DataBufferByte(this.rgbData, n7);
        WritableRaster writableRaster = Raster.createWritableRaster(bandedSampleModel, dataBufferByte, new Point(0, 0));
        this.image = new BufferedImage(componentColorModel, writableRaster, false, null);
        this.recolorImage();
    }

    protected void recolorImage() {
        if (!this.visible) {
            return;
        }
        GridData gridData = this.griddata;
        BufferedImage bufferedImage = this.image;
        byte[][] byArray = this.rgbData;
        if (gridData == null) {
            return;
        }
        if (gridData.isCellData()) {
            double d = gridData.getDx();
            double d2 = gridData.getDy();
            this.xmin = gridData.getLeft() - d / 2.0;
            this.xmax = gridData.getRight() + d / 2.0;
            this.ymin = gridData.getBottom() + d2 / 2.0;
            this.ymax = gridData.getTop() - d2 / 2.0;
        } else {
            this.xmin = gridData.getLeft();
            this.xmax = gridData.getRight();
            this.ymin = gridData.getBottom();
            this.ymax = gridData.getTop();
        }
        this.grid.setMinMax(this.xmin, this.xmax, this.ymin, this.ymax);
        if (bufferedImage == null) {
            return;
        }
        if (byArray[0].length != bufferedImage.getWidth() * bufferedImage.getHeight()) {
            return;
        }
        byte[] byArray2 = new byte[3];
        double d = this.top;
        double d3 = (this.xmax - this.xmin) / (double)(this.ixsize - 1);
        double d4 = (this.ymin - this.ymax) / (double)(this.iysize - 1);
        if (gridData.getDx() < 0.0) {
            d3 = -d3;
        }
        if (gridData.getDy() > 0.0) {
            d4 = -d4;
        }
        int n = bufferedImage.getWidth();
        int n2 = 0;
        int n3 = bufferedImage.getHeight();
        while (n2 < n3) {
            double d5 = this.left;
            int n4 = 0;
            while (n4 < n) {
                this.colorMap.doubleToComponents(gridData.interpolate(d5, d, this.ampIndex), byArray2);
                int n5 = n2 * n + n4;
                byArray[0][n5] = byArray2[0];
                byArray[1][n5] = byArray2[1];
                byArray[2][n5] = byArray2[2];
                d5 += d3;
                ++n4;
            }
            d += d4;
            ++n2;
        }
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend();
    }

    public boolean isMeasured() {
        return this.griddata != null;
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible || this.griddata == null) {
            return;
        }
        this.checkImage(drawingPanel);
        if (this.image != null) {
            graphics.drawImage(this.image, this.leftPix, this.topPix, drawingPanel);
        }
        this.grid.draw(drawingPanel, graphics);
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public Object createObject(XMLControl xMLControl) {
                return new InterpolatedPlot(null);
            }

            public void saveObject(XMLControl xMLControl, Object object) {
                super.saveObject(xMLControl, object);
                InterpolatedPlot interpolatedPlot = (InterpolatedPlot)object;
                xMLControl.setValue("color map", interpolatedPlot.colorMap);
            }

            public Object loadObject(XMLControl xMLControl, Object object) {
                super.loadObject(xMLControl, object);
                InterpolatedPlot interpolatedPlot = (InterpolatedPlot)object;
                interpolatedPlot.colorMap = (ColorMapper)xMLControl.getObject("color map");
                return interpolatedPlot;
            }
        };
    }
}

