/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display2d;

import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display2d.ArrayData;
import org.opensourcephysics.display2d.ColorMapper;
import org.opensourcephysics.display2d.ContourAccumulator;
import org.opensourcephysics.display2d.GridData;
import org.opensourcephysics.display2d.GridPointData;
import org.opensourcephysics.display2d.Plot2D;
import org.opensourcephysics.display2d.Plot2DLoader;
import org.opensourcephysics.display2d.ZExpansion;

public class ContourPlot
implements Plot2D {
    private GridData griddata;
    private Color lineColor = new Color(0, 64, 0);
    private boolean visible = true;
    private int contour_lines = 12;
    private boolean showContourLines = true;
    private boolean showColoredLevels = true;
    private double contour_stepz;
    private int[] xpoints = new int[8];
    private int[] ypoints = new int[8];
    private int[] contour_x = new int[8];
    private int[] contour_y = new int[8];
    private double[] delta = new double[4];
    private double[] intersection = new double[4];
    private double[][] contour_vertex = new double[4][3];
    private ContourAccumulator accumulator = new ContourAccumulator();
    private double zmin = 0.0;
    private double zmax = 1.0;
    private boolean autoscaleZ = true;
    protected ZExpansion zMap = null;
    protected ColorMapper colorMap = new ColorMapper(this.contour_lines, this.zmin, this.zmax, 0);
    private Color[] contourColors = new Color[this.contour_lines + 2];
    private double[][] internalData = new double[1][1];
    private int ampIndex = 0;
    private int nx = 0;
    private int ny = 0;
    private int maxGridSize = 48;
    protected boolean interpolateLargeGrids = true;

    public ContourPlot() {
    }

    public ContourPlot(GridData gridData) {
        this.griddata = gridData;
        if (this.griddata == null) {
            return;
        }
        this.nx = this.interpolateLargeGrids && this.griddata.getNx() > this.maxGridSize ? 32 : this.griddata.getNx();
        this.ny = this.interpolateLargeGrids && this.griddata.getNy() > this.maxGridSize ? 32 : this.griddata.getNy();
        this.internalData = new double[this.nx][this.ny];
        this.update();
    }

    public double indexToX(int n) {
        return this.griddata.indexToX(n);
    }

    public double indexToY(int n) {
        return this.griddata.indexToY(n);
    }

    public int xToIndex(double d) {
        return this.griddata.xToIndex(d);
    }

    public int yToIndex(double d) {
        return this.griddata.yToIndex(d);
    }

    public void setAll(Object object) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        this.update();
    }

    public void setAll(Object object, double d, double d2, double d3, double d4) {
        double[][] dArray = (double[][])object;
        this.copyData(dArray);
        if (this.griddata.isCellData()) {
            this.griddata.setCellScale(d, d2, d3, d4);
        } else {
            this.griddata.setScale(d, d2, d3, d4);
        }
        this.update();
    }

    private void copyData(double[][] dArray) {
        if (this.griddata != null && !(this.griddata instanceof ArrayData)) {
            throw new IllegalStateException("SetAll only supports ArrayData for data storage.");
        }
        if (this.griddata == null || this.griddata.getNx() != dArray.length || this.griddata.getNy() != dArray[0].length) {
            this.griddata = new ArrayData(dArray.length, dArray[0].length, 1);
            this.setGridData(this.griddata);
        }
        double[][] dArray2 = this.griddata.getData()[0];
        int n = dArray2[0].length;
        int n2 = 0;
        int n3 = dArray2.length;
        while (n2 < n3) {
            System.arraycopy(dArray[n2], 0, dArray2[n2], 0, n);
            ++n2;
        }
    }

    public GridData getGridData() {
        return this.griddata;
    }

    public void setGridData(GridData gridData) {
        this.griddata = gridData;
        if (this.griddata == null) {
            return;
        }
        this.nx = this.interpolateLargeGrids && this.griddata.getNx() > this.maxGridSize ? 32 : this.griddata.getNx();
        this.ny = this.interpolateLargeGrids && this.griddata.getNy() > this.maxGridSize ? 32 : this.griddata.getNy();
        this.internalData = new double[this.nx][this.ny];
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public JFrame showLegend() {
        return this.colorMap.showLegend(this.zMap);
    }

    public void setShowGridLines(boolean bl) {
        this.showContourLines = bl;
    }

    public void setGridLineColor(Color color) {
        this.lineColor = color;
    }

    public synchronized void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n;
        int n2;
        if (!this.visible || this.griddata == null) {
            return;
        }
        if (!this.autoscaleZ) {
            graphics.setColor(this.colorMap.getFloorColor());
            int n3 = drawingPanel.getWidth() - drawingPanel.getLeftGutter() - drawingPanel.getRightGutter();
            int n4 = drawingPanel.getHeight() - drawingPanel.getTopGutter() - drawingPanel.getBottomGutter();
            graphics.fillRect(drawingPanel.getLeftGutter(), drawingPanel.getTopGutter(), Math.max(n3, 0), Math.max(n4, 0));
        }
        this.accumulator.clearAccumulator();
        this.contour_stepz = (this.zmax - this.zmin) / (double)(this.contour_lines + 1);
        double d = this.zmin;
        int n5 = 0;
        while (n5 < this.contourColors.length) {
            this.contourColors[n5] = !this.autoscaleZ && n5 == this.contourColors.length - 1 ? this.colorMap.getCeilColor() : this.colorMap.doubleToColor(d);
            d += this.contour_stepz;
            ++n5;
        }
        double d2 = this.griddata.getLeft();
        double d3 = (this.griddata.getRight() - this.griddata.getLeft()) / (double)(this.nx - 1);
        double d4 = this.griddata.getTop();
        double d5 = -(this.griddata.getTop() - this.griddata.getBottom()) / (double)(this.ny - 1);
        int n6 = 0;
        int n7 = this.internalData.length - 1;
        while (n6 < n7) {
            d4 = this.griddata.getTop();
            n2 = 0;
            n = this.internalData[0].length - 1;
            while (n2 < n) {
                this.contour_vertex[0][0] = d2;
                this.contour_vertex[0][1] = d4;
                this.contour_vertex[0][2] = this.internalData[n6][n2];
                this.contour_vertex[1][0] = d2;
                this.contour_vertex[1][1] = d4 + d5;
                this.contour_vertex[1][2] = this.internalData[n6][n2 + 1];
                this.contour_vertex[2][0] = d2 + d3;
                this.contour_vertex[2][1] = d4 + d5;
                this.contour_vertex[2][2] = this.internalData[n6 + 1][n2 + 1];
                this.contour_vertex[3][0] = d2 + d3;
                this.contour_vertex[3][1] = d4;
                this.contour_vertex[3][2] = this.internalData[n6 + 1][n2];
                this.createContour(drawingPanel, graphics);
                d4 += d5;
                ++n2;
            }
            d2 += d3;
            ++n6;
        }
        if (this.showContourLines) {
            graphics.setColor(this.lineColor);
            this.accumulator.drawAll(graphics);
            n6 = drawingPanel.xToPix(this.griddata.getLeft());
            n7 = drawingPanel.yToPix(this.griddata.getTop());
            n2 = drawingPanel.xToPix(this.griddata.getRight());
            n = drawingPanel.yToPix(this.griddata.getBottom());
            graphics.drawRect(Math.min(n6, n2), Math.min(n7, n), Math.abs(n6 - n2), Math.abs(n7 - n));
        }
    }

    public void setAutoscaleZ(boolean bl, double d, double d2) {
        this.autoscaleZ = bl;
        if (this.autoscaleZ) {
            this.update();
        } else {
            this.zmax = d2;
            this.zmin = d;
            if (this.zMap != null) {
                this.zMap.setMinMax(this.zmin, this.zmax);
            }
            this.colorMap.setScale(this.zmin, this.zmax);
        }
    }

    public void setInterpolateLargeGrids(boolean bl) {
        this.interpolateLargeGrids = bl;
    }

    public boolean isInterpolateLargeGrids() {
        return this.interpolateLargeGrids;
    }

    public void setExpandedZ(boolean bl, double d) {
        if (bl && d > 0.0) {
            this.zMap = new ZExpansion(d);
            this.zMap.setMinMax(this.zmin, this.zmax);
        } else {
            this.zMap = null;
        }
    }

    public boolean isAutoscaleZ() {
        return this.autoscaleZ;
    }

    public double getFloor() {
        return this.colorMap.getFloor();
    }

    public double getCeiling() {
        return this.colorMap.getCeil();
    }

    public void update() {
        if (this.griddata == null) {
            return;
        }
        if (this.interpolateLargeGrids && this.nx != this.griddata.getNx() || this.ny != this.griddata.getNy()) {
            this.updateInterpolated(this.griddata);
        } else {
            this.updateDirect(this.griddata);
        }
        this.colorMap.updateLegend(this.zMap);
    }

    void updateInterpolated(GridData gridData) {
        if (this.autoscaleZ) {
            double[] dArray = gridData.getZRange(this.ampIndex);
            this.zmax = dArray[1];
            this.zmin = dArray[0];
            if (this.zMap != null) {
                this.zMap.setMinMax(this.zmin, this.zmax);
            }
            this.colorMap.setScale(this.zmin, this.zmax);
        }
        double d = gridData.getLeft();
        double d2 = (gridData.getRight() - gridData.getLeft()) / (double)(this.nx - 1);
        double d3 = gridData.getTop();
        double d4 = -(gridData.getTop() - gridData.getBottom()) / (double)(this.ny - 1);
        int n = 0;
        while (n < this.nx) {
            d3 = gridData.getTop();
            int n2 = 0;
            while (n2 < this.ny) {
                this.internalData[n][n2] = gridData.interpolate(d, d3, this.ampIndex);
                if (this.zMap != null) {
                    this.internalData[n][n2] = this.zMap.evaluate(this.internalData[n][n2]);
                }
                d3 += d4;
                ++n2;
            }
            d += d2;
            ++n;
        }
    }

    void updateDirect(GridData gridData) {
        block10: {
            Object object;
            block9: {
                if (gridData == null) {
                    return;
                }
                if (this.autoscaleZ) {
                    object = gridData.getZRange(this.ampIndex);
                    this.zmax = object[1];
                    this.zmin = object[0];
                    if (this.zMap != null) {
                        this.zMap.setMinMax(this.zmin, this.zmax);
                    }
                    this.colorMap.setScale(this.zmin, this.zmax);
                }
                if (!(gridData instanceof ArrayData)) break block9;
                object = gridData.getData()[this.ampIndex];
                int n = 0;
                while (n < this.nx) {
                    System.arraycopy(object[n], 0, this.internalData[n], 0, this.ny);
                    if (this.zMap != null) {
                        int n2 = 0;
                        while (n2 < this.ny) {
                            this.internalData[n][n2] = this.zMap.evaluate(this.internalData[n][n2]);
                            ++n2;
                        }
                    }
                    ++n;
                }
                break block10;
            }
            if (!(gridData instanceof GridPointData)) break block10;
            object = gridData.getData();
            int n = 0;
            int n3 = ((double[])object).length;
            while (n < n3) {
                int n4 = 0;
                int n5 = ((double)object[0]).length;
                while (n4 < n5) {
                    this.internalData[n][n4] = object[n][n4][2 + this.ampIndex];
                    if (this.zMap != null) {
                        this.internalData[n][n4] = this.zMap.evaluate(this.internalData[n][n4]);
                    }
                    ++n4;
                }
                ++n;
            }
        }
    }

    private final void createContour(DrawingPanel drawingPanel, Graphics graphics) {
        double d = this.zmin;
        this.xpoints[0] = drawingPanel.xToPix(this.contour_vertex[0][0]) + 1;
        this.xpoints[2] = drawingPanel.xToPix(this.contour_vertex[1][0]) + 1;
        this.xpoints[4] = drawingPanel.xToPix(this.contour_vertex[2][0]) + 1;
        this.xpoints[6] = drawingPanel.xToPix(this.contour_vertex[3][0]) + 1;
        this.xpoints[7] = -1;
        this.xpoints[5] = -1;
        this.xpoints[3] = -1;
        this.xpoints[1] = -1;
        this.ypoints[0] = drawingPanel.yToPix(this.contour_vertex[0][1]) + 1;
        this.ypoints[4] = drawingPanel.yToPix(this.contour_vertex[2][1]) + 1;
        this.ypoints[2] = this.ypoints[3] = drawingPanel.yToPix(this.contour_vertex[1][1]) + 1;
        this.ypoints[6] = this.ypoints[7] = drawingPanel.yToPix(this.contour_vertex[3][1]) + 1;
        int n = this.xpoints[0];
        int n2 = this.xpoints[4];
        int n3 = 0;
        while (n3 <= this.contour_lines + 1) {
            int n4;
            int n5;
            int n6 = 0;
            while (n6 < 4) {
                n5 = (n6 << 1) + 1;
                n4 = n6 + 1 & 3;
                if (d > this.contour_vertex[n6][2]) {
                    this.xpoints[n5 - 1] = -2;
                    if (d > this.contour_vertex[n4][2]) {
                        this.xpoints[n5 + 1 & 7] = -2;
                        this.xpoints[n5] = -2;
                    }
                } else if (d > this.contour_vertex[n4][2]) {
                    this.xpoints[n5 + 1 & 7] = -2;
                }
                if (this.xpoints[n5] != -2) {
                    if (this.xpoints[n5] != -1) {
                        int n7 = n6;
                        this.intersection[n7] = this.intersection[n7] + this.delta[n6];
                        if (n5 == 1 || n5 == 5) {
                            this.ypoints[n5] = drawingPanel.yToPix(this.intersection[n6]) + 1;
                        } else {
                            this.xpoints[n5] = drawingPanel.xToPix(this.intersection[n6]) + 1;
                        }
                    } else if (d > this.contour_vertex[n6][2] || d > this.contour_vertex[n4][2]) {
                        switch (n5) {
                            case 1: {
                                this.delta[n6] = (this.contour_vertex[n4][1] - this.contour_vertex[n6][1]) * this.contour_stepz / (this.contour_vertex[n4][2] - this.contour_vertex[n6][2]);
                                this.intersection[n6] = (this.contour_vertex[n4][1] * (d - this.contour_vertex[n6][2]) + this.contour_vertex[n6][1] * (this.contour_vertex[n4][2] - d)) / (this.contour_vertex[n4][2] - this.contour_vertex[n6][2]);
                                this.xpoints[n5] = n;
                                this.ypoints[n5] = drawingPanel.yToPix(this.intersection[n6]) + 1;
                                break;
                            }
                            case 3: {
                                this.delta[n6] = (this.contour_vertex[n4][0] - this.contour_vertex[n6][0]) * this.contour_stepz / (this.contour_vertex[n4][2] - this.contour_vertex[n6][2]);
                                this.intersection[n6] = (this.contour_vertex[n4][0] * (d - this.contour_vertex[n6][2]) + this.contour_vertex[n6][0] * (this.contour_vertex[n4][2] - d)) / (this.contour_vertex[n4][2] - this.contour_vertex[n6][2]);
                                this.xpoints[n5] = drawingPanel.xToPix(this.intersection[n6]) + 1;
                                break;
                            }
                            case 5: {
                                this.delta[n6] = (this.contour_vertex[n6][1] - this.contour_vertex[n4][1]) * this.contour_stepz / (this.contour_vertex[n6][2] - this.contour_vertex[n4][2]);
                                this.intersection[n6] = (this.contour_vertex[n6][1] * (d - this.contour_vertex[n4][2]) + this.contour_vertex[n4][1] * (this.contour_vertex[n6][2] - d)) / (this.contour_vertex[n6][2] - this.contour_vertex[n4][2]);
                                this.xpoints[n5] = n2;
                                this.ypoints[n5] = drawingPanel.yToPix(this.intersection[n6]) + 1;
                                break;
                            }
                            case 7: {
                                this.delta[n6] = (this.contour_vertex[n6][0] - this.contour_vertex[n4][0]) * this.contour_stepz / (this.contour_vertex[n6][2] - this.contour_vertex[n4][2]);
                                this.intersection[n6] = (this.contour_vertex[n6][0] * (d - this.contour_vertex[n4][2]) + this.contour_vertex[n4][0] * (this.contour_vertex[n6][2] - d)) / (this.contour_vertex[n6][2] - this.contour_vertex[n4][2]);
                                this.xpoints[n5] = drawingPanel.xToPix(this.intersection[n6]) + 1;
                            }
                        }
                    }
                }
                ++n6;
            }
            n6 = 0;
            n5 = 0;
            while (n5 < 8) {
                if (this.xpoints[n5] >= 0) {
                    this.contour_x[n6] = this.xpoints[n5];
                    this.contour_y[n6] = this.ypoints[n5];
                    ++n6;
                }
                ++n5;
            }
            if (this.showColoredLevels && this.colorMap.getPaletteType() != 7) {
                graphics.setColor(this.contourColors[n3]);
                if (n6 > 0) {
                    graphics.fillPolygon(this.contour_x, this.contour_y, n6);
                }
            }
            if (this.showContourLines) {
                n5 = -1;
                n4 = -1;
                int n8 = 1;
                while (n8 < 8) {
                    if (this.xpoints[n8] >= 0) {
                        if (n5 != -1) {
                            this.accumulator.addLine(n5, n4, this.xpoints[n8], this.ypoints[n8]);
                        }
                        n5 = this.xpoints[n8];
                        n4 = this.ypoints[n8];
                    }
                    n8 += 2;
                }
                if (this.xpoints[1] > 0 && n5 != -1) {
                    this.accumulator.addLine(n5, n4, this.xpoints[1], this.ypoints[1]);
                }
            }
            if (n6 < 3) break;
            d += this.contour_stepz;
            ++n3;
        }
    }

    public void setColorPalette(Color[] colorArray) {
        this.colorMap.setColorPalette(colorArray);
    }

    public void setPaletteType(int n) {
        this.colorMap.setPaletteType(n);
    }

    public void setFloorCeilColor(Color color, Color color2) {
        this.colorMap.setFloorCeilColor(color, color2);
    }

    public void setIndexes(int[] nArray) {
        this.ampIndex = nArray[0];
    }

    public void setNumberOfLevels(int n) {
        this.contour_lines = n;
        this.colorMap.setNumberOfColors(n);
        this.contourColors = new Color[this.contour_lines + 2];
    }

    public double getXMin() {
        return this.griddata.getLeft();
    }

    public double getXMax() {
        return this.griddata.getRight();
    }

    public double getYMin() {
        return this.griddata.getBottom();
    }

    public double getYMax() {
        return this.griddata.getTop();
    }

    public boolean isMeasured() {
        return this.griddata != null;
    }

    public static XML.ObjectLoader getLoader() {
        return new Plot2DLoader(){

            public void saveObject(XMLControl xMLControl, Object object) {
                super.saveObject(xMLControl, object);
                ContourPlot contourPlot = (ContourPlot)object;
                xMLControl.setValue("line color", contourPlot.lineColor);
                xMLControl.setValue("color map", contourPlot.colorMap);
            }

            public Object createObject(XMLControl xMLControl) {
                return new ContourPlot(null);
            }

            public Object loadObject(XMLControl xMLControl, Object object) {
                super.loadObject(xMLControl, object);
                ContourPlot contourPlot = (ContourPlot)object;
                contourPlot.lineColor = (Color)xMLControl.getObject("line color");
                contourPlot.colorMap = (ColorMapper)xMLControl.getObject("color map");
                return contourPlot;
            }
        };
    }
}

