/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetPoligonMovingPoint;
import org.opensourcephysics.displayejs.InteractionTargetPoligonPoint;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;

public class InteractivePoligon
extends AbstractInteractiveElement
implements Data {
    public static final int PLAIN = 0;
    public static final int CIRCLE = 1;
    public static final int DIAMOND = 2;
    public static final int SQUARE = 3;
    public static final int ARROW = 4;
    public static final int LINE = 5;
    public static final int FILLED_CIRCLE = 6;
    public static final int FILLED_DIAMOND = 7;
    public static final int FILLED_SQUARE = 8;
    public static final int FILLED_ARROW = 9;
    protected boolean closed = true;
    protected int numPoints = -1;
    protected int startType = 0;
    protected int endType = 0;
    protected double neumaticDash = 0.0;
    protected double startSize = Double.NaN;
    protected double endSize = Double.NaN;
    protected double[][] coordinates = null;
    protected boolean[] connect = null;
    protected boolean[] pointSizeEnabled = null;
    protected Color[] lineColors = null;
    protected int[] shapeType = null;
    protected Color[] shapeEdgeColor = null;
    protected Color[] shapeFillColor = null;
    protected int[] shapeSize = null;
    protected int sides = 0;
    protected int dashSize = 0;
    protected int theStartSize = 0;
    protected int theEndSize = 0;
    protected int[] aPoints = null;
    protected int[] bPoints = null;
    protected double[] center = new double[3];
    protected double[] pixel = new double[3];
    protected double[] pixelOrigin = new double[5];
    protected double[] point = new double[3];
    protected double[] origin = new double[6];
    protected double[] size = new double[3];
    protected Object3D[] lineObjects = null;
    protected Object3D[] closedObject = new Object3D[]{new Object3D(this, -1)};
    protected InteractionTargetPoligonPoint targetPoint = new InteractionTargetPoligonPoint(this, -1);
    protected Shape[] shape = null;
    private boolean showZ = false;
    private boolean allowTable = false;
    protected String name = "polygon";
    protected int datasetID = this.hashCode();
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;
    private static final int MAX = 10;
    private int startPoints = 0;
    private int endPoints = 0;
    private int[] startA = new int[10];
    private int[] startB = new int[10];
    private int[] endA = new int[10];
    private int[] endB = new int[10];

    public InteractivePoligon() {
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    @Override
    public void copyFrom(InteractiveElement _element) {
        super.copyFrom(_element);
        if (_element instanceof InteractivePoligon) {
            InteractivePoligon old = (InteractivePoligon)_element;
            this.setNumberOfPoints(old.getNumberOfPoints());
            this.setClosed(old.isClosed());
            this.setData(old.getData());
            int i = 0;
            while (i < this.numPoints) {
                this.connect[i] = old.connect[i];
                ++i;
            }
            i = 0;
            while (i < this.numPoints) {
                this.pointSizeEnabled[i] = old.pointSizeEnabled[i];
                ++i;
            }
            i = 0;
            while (i < this.numPoints) {
                this.shapeType[i] = old.shapeType[i];
                ++i;
            }
            i = 0;
            while (i < this.numPoints) {
                this.shapeSize[i] = old.shapeSize[i];
                ++i;
            }
            i = 0;
            while (i < this.numPoints) {
                this.shapeEdgeColor[i] = old.shapeEdgeColor[i];
                ++i;
            }
            i = 0;
            while (i < this.numPoints) {
                this.shapeFillColor[i] = old.shapeFillColor[i];
                ++i;
            }
            i = 0;
            while (i < this.numPoints) {
                this.shape[i] = old.shape[i];
                ++i;
            }
            this.setName(((InteractivePoligon)_element).getName());
            this.setAllowTable(((InteractivePoligon)_element).allowTable);
        }
    }

    public void setNumberOfPoints(int _n) {
        if (_n == this.numPoints) {
            return;
        }
        if (_n < 1) {
            return;
        }
        this.numPoints = _n;
        this.sides = this.numPoints - 1;
        this.coordinates = new double[3][this.numPoints];
        this.connect = new boolean[this.numPoints];
        this.pointSizeEnabled = new boolean[this.numPoints];
        this.aPoints = new int[this.numPoints];
        this.bPoints = new int[this.numPoints];
        this.lineObjects = new Object3D[this.numPoints];
        this.lineColors = new Color[this.numPoints];
        this.shapeType = new int[this.numPoints];
        this.shapeSize = new int[this.numPoints];
        this.shapeEdgeColor = new Color[this.numPoints];
        this.shapeFillColor = new Color[this.numPoints];
        this.shape = new Shape[this.numPoints];
        int i = 0;
        while (i < this.numPoints) {
            this.coordinates[2][i] = 0.0;
            this.coordinates[1][i] = 0.0;
            this.coordinates[0][i] = 0.0;
            this.connect[i] = true;
            this.lineColors[i] = null;
            this.pointSizeEnabled[i] = true;
            this.lineObjects[i] = new Object3D(this, i);
            this.shapeType[i] = 0;
            this.shapeSize[i] = 10;
            this.shapeEdgeColor[i] = Color.BLACK;
            this.shapeFillColor[i] = Color.RED;
            this.shape[i] = null;
            ++i;
        }
        this.connect[this.sides] = this.closed;
        this.hasChanged = true;
    }

    public int getNumberOfPoints() {
        return this.numPoints;
    }

    public void setStartType(int _type) {
        if (_type == this.startType) {
            return;
        }
        this.startType = _type;
        this.hasChanged = true;
    }

    public int getStartType() {
        return this.startType;
    }

    public void setStartSize(double _size) {
        if (_size == this.startSize) {
            return;
        }
        this.startSize = _size;
        this.hasChanged = true;
    }

    public double getStartSize() {
        return this.startSize;
    }

    public void setEndType(int _type) {
        if (_type == this.endType) {
            return;
        }
        this.endType = _type;
        this.hasChanged = true;
    }

    public int getEndType() {
        return this.endType;
    }

    public void setEndSize(double _size) {
        if (_size == this.endSize) {
            return;
        }
        this.endSize = _size;
        this.hasChanged = true;
    }

    public double getEndSize() {
        return this.endSize;
    }

    public void setNeumatic(double _dash) {
        if (this.neumaticDash == _dash) {
            return;
        }
        this.neumaticDash = _dash;
        this.hasChanged = true;
    }

    public void setClosed(boolean _closed) {
        this.closed = _closed;
        if (this.sides > 0) {
            this.connect[this.sides] = this.closed;
        }
        this.hasChanged = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void setAllowTable(boolean _allow) {
        this.allowTable = _allow;
    }

    public void setData(double[][] _data) {
        if (this.numPoints != _data.length) {
            this.setNumberOfPoints(_data.length);
        }
        int maxPoints = Math.min(_data.length, this.numPoints);
        int n = Math.min(_data[0].length, 3);
        int i = 0;
        while (i < maxPoints) {
            int k = 0;
            while (k < n) {
                this.coordinates[k][i] = _data[i][k];
                ++k;
            }
            ++i;
        }
        this.hasChanged = true;
    }

    public double[][] getData() {
        return this.coordinates;
    }

    public double[] getPoint(int _index) {
        double[] thePoint = new double[this.coordinates.length];
        int i = 0;
        while (i < this.coordinates.length) {
            thePoint[i] = this.coordinates[i][_index];
            ++i;
        }
        return thePoint;
    }

    public void setXs(double[] _data) {
        int i = 0;
        int n = Math.min(_data.length, this.numPoints);
        while (i < n) {
            this.coordinates[0][i] = _data[i];
            ++i;
        }
        this.hasChanged = true;
    }

    public void setXs(double _data) {
        int i = 0;
        while (i < this.numPoints) {
            this.coordinates[0][i] = _data;
            ++i;
        }
        this.hasChanged = true;
    }

    public void setYs(double[] _data) {
        int i = 0;
        int n = Math.min(_data.length, this.numPoints);
        while (i < n) {
            this.coordinates[1][i] = _data[i];
            ++i;
        }
        this.hasChanged = true;
    }

    public void setYs(double _data) {
        int i = 0;
        while (i < this.numPoints) {
            this.coordinates[1][i] = _data;
            ++i;
        }
        this.hasChanged = true;
    }

    public void setZs(double[] _data) {
        int i = 0;
        int n = Math.min(_data.length, this.numPoints);
        while (i < n) {
            this.coordinates[2][i] = _data[i];
            ++i;
        }
        this.showZ = true;
        this.hasChanged = true;
    }

    public void setZs(double _data) {
        int i = 0;
        while (i < this.numPoints) {
            this.coordinates[2][i] = _data;
            ++i;
        }
        this.showZ = true;
        this.hasChanged = true;
    }

    public void setConnections(boolean[] _c) {
        if (_c == null) {
            int i = 0;
            while (i < this.numPoints) {
                this.connect[i] = true;
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.numPoints) {
                this.connect[i] = _c[i];
                ++i;
            }
        }
        if (this.connect != null) {
            this.connect[this.sides] = this.closed;
        }
        this.hasChanged = true;
    }

    public void setConnected(int _index, boolean _c) {
        if (_index < this.numPoints) {
            this.connect[_index] = _c;
        }
        this.hasChanged = true;
    }

    public void setPointSizeEnableds(boolean[] _enabled) {
        int i = 0;
        int n = Math.min(_enabled.length, this.numPoints);
        while (i < n) {
            this.pointSizeEnabled[i] = _enabled[i];
            ++i;
        }
    }

    public void setPointSizeEnabled(int _index, boolean _enabled) {
        if (_index > -1 && _index < this.numPoints) {
            this.pointSizeEnabled[_index] = _enabled;
        }
    }

    public void setColors(Color[] _c) {
        if (_c == null) {
            int i = 0;
            while (i < this.numPoints) {
                this.lineColors[i] = null;
                ++i;
            }
        } else {
            int i = 0;
            int n = Math.min(_c.length, this.numPoints);
            while (i < n) {
                this.lineColors[i] = _c[i];
                ++i;
            }
        }
    }

    public void setName(String _name) {
        this.name = _name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setID(int id) {
        this.datasetID = id;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[][] getData2D() {
        double[][] dArray = this.coordinates;
        synchronized (this.coordinates) {
            double[][] data;
            if (this.showZ) {
                data = new double[3][this.numPoints];
                int i = 0;
                while (i < this.numPoints) {
                    data[0][i] = this.coordinates[0][i];
                    data[1][i] = this.coordinates[1][i];
                    data[2][i] = this.coordinates[2][i];
                    ++i;
                }
            } else {
                data = new double[2][this.numPoints];
                int i = 0;
                while (i < this.numPoints) {
                    data[0][i] = this.coordinates[0][i];
                    data[1][i] = this.coordinates[1][i];
                    ++i;
                }
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return data;
        }
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public String[] getColumnNames() {
        String[] stringArray;
        if (this.showZ) {
            String[] stringArray2 = new String[3];
            stringArray2[0] = "x";
            stringArray2[1] = "y";
            stringArray = stringArray2;
            stringArray2[2] = "z";
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = "x";
            stringArray = stringArray3;
            stringArray3[1] = "y";
        }
        return stringArray;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{Color.BLACK, this.getStyle().getEdgeColor()};
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{Color.BLACK, new Color(255, 128, 128, 128)};
    }

    @Override
    public List<Data> getDataList() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        return null;
    }

    public void setShapesType(int[] _c) {
        if (_c == null) {
            int i = 0;
            while (i < this.numPoints) {
                this.createShape(i, 0);
                ++i;
            }
        } else {
            int i = 0;
            int n = Math.min(_c.length, this.numPoints);
            while (i < n) {
                this.createShape(i, _c[i]);
                ++i;
            }
        }
    }

    public void setShapesType(int _c) {
        int i = 0;
        while (i < this.numPoints) {
            this.createShape(i, _c);
            ++i;
        }
    }

    public void setShapesSize(int[] _c) {
        if (_c == null) {
            int i = 0;
            while (i < this.numPoints) {
                this.shapeSize[i] = 10;
                ++i;
            }
        } else {
            int i = 0;
            int n = Math.min(_c.length, this.numPoints);
            while (i < n) {
                this.shapeSize[i] = _c[i];
                ++i;
            }
        }
    }

    public void setShapesSize(int _c) {
        int i = 0;
        while (i < this.numPoints) {
            this.shapeSize[i] = _c;
            ++i;
        }
    }

    public void setShapesEdgeColor(Object[] _c) {
        if (_c == null) {
            int i = 0;
            while (i < this.numPoints) {
                this.shapeEdgeColor[i] = Color.BLACK;
                ++i;
            }
        } else {
            int i = 0;
            int n = Math.min(_c.length, this.numPoints);
            while (i < n) {
                this.shapeEdgeColor[i] = (Color)_c[i];
                ++i;
            }
        }
    }

    public void setShapesEdgeColor(Color _c) {
        int i = 0;
        while (i < this.numPoints) {
            this.shapeEdgeColor[i] = _c;
            ++i;
        }
    }

    public void setShapesFillColor(Object[] _c) {
        if (_c == null) {
            int i = 0;
            while (i < this.numPoints) {
                this.shapeFillColor[i] = Color.RED;
                ++i;
            }
        } else {
            int i = 0;
            int n = Math.min(_c.length, this.numPoints);
            while (i < n) {
                this.shapeFillColor[i] = (Color)_c[i];
                ++i;
            }
        }
    }

    public void setShapesFillColor(Color _c) {
        int i = 0;
        while (i < this.numPoints) {
            this.shapeFillColor[i] = _c;
            ++i;
        }
    }

    private void createShape(int index, int _type) {
        if (this.shapeType[index] == _type) {
            return;
        }
        this.shapeType[index] = _type;
        switch (this.shapeType[index]) {
            default: {
                this.shape[index] = null;
                break;
            }
            case 1: {
                this.shape[index] = new Ellipse2D.Float();
                break;
            }
            case 2: {
                this.shape[index] = new Rectangle2D.Float();
                break;
            }
            case 3: {
                this.shape[index] = new RoundRectangle2D.Float();
            }
        }
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        int i;
        if (this.numPoints <= 0 || !this.visible) {
            return null;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        if (this.sizeEnabled) {
            i = 0;
            while (i < this.numPoints) {
                if (this.pointSizeEnabled[i] && Math.abs(this.aPoints[i] - _xpix) < SENSIBILITY && Math.abs(this.bPoints[i] - _ypix) < SENSIBILITY) {
                    return new InteractionTargetPoligonPoint(this, i);
                }
                ++i;
            }
        }
        if (this.positionEnabled) {
            i = 0;
            while (i < this.numPoints) {
                if (Math.abs(this.aPoints[i] - _xpix) < SENSIBILITY && Math.abs(this.bPoints[i] - _ypix) < SENSIBILITY) {
                    return new InteractionTargetPoligonMovingPoint(this, i);
                }
                ++i;
            }
        }
        if (this.allowTable) {
            i = 0;
            while (i < this.numPoints) {
                if (Math.abs(this.aPoints[i] - _xpix) < SENSIBILITY && Math.abs(this.bPoints[i] - _ypix) < SENSIBILITY) {
                    return this;
                }
                ++i;
            }
        }
        return null;
    }

    @Override
    public Object3D[] getObjects3D(DrawingPanel3D _panel) {
        if (this.numPoints <= 0 || !this.visible) {
            return null;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        if (this.closed && this.style.fillPattern != null) {
            return this.closedObject;
        }
        return this.lineObjects;
    }

    @Override
    public void draw(DrawingPanel3D _panel, Graphics2D _g2, int _index) {
        if (_index < 0) {
            Paint theFillPattern = this.style.fillPattern;
            if (theFillPattern instanceof Color) {
                theFillPattern = _panel.projectColor((Color)theFillPattern, this.closedObject[0].distance);
            }
            _g2.setPaint(theFillPattern);
            _g2.setStroke(this.style.edgeStroke);
            _g2.fillPolygon(this.aPoints, this.bPoints, this.numPoints);
            if (this.style.edgeColor == null && this.lineColors[0] == null) {
                return;
            }
            if (this.connect[0]) {
                if (this.lineColors[0] != null) {
                    _g2.setColor(_panel.projectColor(this.lineColors[0], this.lineObjects[0].distance));
                } else {
                    _g2.setColor(_panel.projectColor(this.style.edgeColor, this.lineObjects[0].distance));
                }
                this.drawStart(_g2);
            }
            int i = 1;
            while (i < this.sides) {
                if (this.connect[i]) {
                    if (this.lineColors[i] != null) {
                        _g2.setColor(_panel.projectColor(this.lineColors[i], this.lineObjects[i].distance));
                    } else {
                        _g2.setColor(_panel.projectColor(this.style.edgeColor, this.lineObjects[i].distance));
                    }
                    this.drawLine(_g2, this.aPoints[i], this.bPoints[i], this.aPoints[i + 1], this.bPoints[i + 1]);
                }
                ++i;
            }
            if (this.connect[this.sides]) {
                if (this.lineColors[this.sides] != null) {
                    _g2.setColor(_panel.projectColor(this.lineColors[this.sides], this.lineObjects[this.sides].distance));
                } else {
                    _g2.setColor(_panel.projectColor(this.style.edgeColor, this.lineObjects[this.sides].distance));
                }
                this.drawEnd(_g2, this.aPoints[this.sides], this.bPoints[this.sides], this.aPoints[0], this.bPoints[0]);
            }
            return;
        }
        if (this.connect[_index] && (this.lineColors[_index] != null || this.style.edgeColor != null)) {
            if (this.lineColors[_index] != null) {
                _g2.setColor(_panel.projectColor(this.lineColors[_index], this.lineObjects[_index].distance));
            } else {
                _g2.setColor(_panel.projectColor(this.style.edgeColor, this.lineObjects[_index].distance));
            }
            _g2.setStroke(this.style.edgeStroke);
            if (_index == 0) {
                if (this.numPoints == 2) {
                    this.drawStartAndEnd(_g2);
                } else {
                    this.drawStart(_g2);
                }
            } else if (_index < this.sides - 1) {
                this.drawLine(_g2, this.aPoints[_index], this.bPoints[_index], this.aPoints[_index + 1], this.bPoints[_index + 1]);
            } else if (_index < this.sides) {
                if (this.closed) {
                    this.drawLine(_g2, this.aPoints[_index], this.bPoints[_index], this.aPoints[this.sides], this.bPoints[this.sides]);
                } else {
                    this.drawEnd(_g2, this.aPoints[_index], this.bPoints[_index], this.aPoints[this.sides], this.bPoints[this.sides]);
                }
            } else {
                this.drawEnd(_g2, this.aPoints[_index], this.bPoints[_index], this.aPoints[0], this.bPoints[0]);
            }
        }
        if (this.shapeType[_index] != 0) {
            this.drawMarker(_g2, this.aPoints[_index], this.bPoints[_index], _index);
        }
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (this.numPoints <= 0 || !this.visible) {
            return;
        }
        Graphics2D g2 = (Graphics2D)_g;
        this.projectPoints(_panel);
        g2.setStroke(this.style.edgeStroke);
        if (this.closed && this.style.fillPattern != null) {
            g2.setPaint(this.style.fillPattern);
            g2.fillPolygon(this.aPoints, this.bPoints, this.numPoints);
        }
        if (this.style.edgeColor != null || this.lineColors[0] != null) {
            if (this.lineColors[0] != null) {
                g2.setColor(this.lineColors[0]);
            } else {
                g2.setColor(this.style.edgeColor);
            }
            if (this.numPoints == 2) {
                if (this.connect[0]) {
                    this.drawStartAndEnd(g2);
                }
                this.drawMarkers(g2);
                return;
            }
            if (this.connect[0]) {
                this.drawStart(g2);
            }
            int last = this.sides;
            int first = 0;
            if (!this.closed) {
                last = this.sides - 1;
                first = this.sides;
            }
            int i = 1;
            while (i < last) {
                if (this.connect[i]) {
                    if (this.lineColors[i] != null) {
                        g2.setColor(this.lineColors[i]);
                    } else {
                        g2.setColor(this.style.edgeColor);
                    }
                    this.drawLine(g2, this.aPoints[i], this.bPoints[i], this.aPoints[i + 1], this.bPoints[i + 1]);
                }
                ++i;
            }
            if (this.connect[last]) {
                if (this.lineColors[last] != null) {
                    g2.setColor(this.lineColors[last]);
                } else {
                    g2.setColor(this.style.edgeColor);
                }
                this.drawEnd(g2, this.aPoints[last], this.bPoints[last], this.aPoints[first], this.bPoints[first]);
            }
        }
        this.drawMarkers(g2);
    }

    private void drawMarker(Graphics2D _g2, int a1, int b1, int index) {
        RectangularShape theShape = (RectangularShape)this.shape[index];
        int minus = this.shapeSize[index] / 2;
        theShape.setFrame(a1 - minus, b1 - minus, this.shapeSize[index], this.shapeSize[index]);
        if (this.shapeFillColor[index] != null) {
            _g2.setPaint(this.shapeFillColor[index]);
            _g2.fill(theShape);
        }
        if (this.shapeEdgeColor[index] != null) {
            _g2.setColor(this.shapeEdgeColor[index]);
            _g2.setStroke(this.style.edgeStroke);
            _g2.draw(theShape);
        }
    }

    private void drawMarkers(Graphics2D _g2) {
        int i = 0;
        while (i < this.numPoints) {
            if (this.shapeType[i] != 0) {
                this.drawMarker(_g2, this.aPoints[i], this.bPoints[i], i);
            }
            ++i;
        }
    }

    @Override
    public boolean isMeasured() {
        return this.canBeMeasured && this.visible && this.numPoints > 0;
    }

    @Override
    public double getXMin() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.numPoints) {
            if (this.coordinates[0][i] < min) {
                min = this.coordinates[0][i];
            }
            ++i;
        }
        if (this.group == null) {
            return this.x + min * this.sizex;
        }
        return this.group.x + (this.x + min * this.sizex) * this.group.sizex;
    }

    @Override
    public double getXMax() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.numPoints) {
            if (this.coordinates[0][i] > max) {
                max = this.coordinates[0][i];
            }
            ++i;
        }
        if (this.group == null) {
            return this.x + max * this.sizex;
        }
        return this.group.x + (this.x + max * this.sizex) * this.group.sizex;
    }

    @Override
    public double getYMin() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.numPoints) {
            if (this.coordinates[1][i] < min) {
                min = this.coordinates[1][i];
            }
            ++i;
        }
        if (this.group == null) {
            return this.y + min * this.sizey;
        }
        return this.group.y + (this.y + min * this.sizey) * this.group.sizey;
    }

    @Override
    public double getYMax() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.numPoints) {
            if (this.coordinates[1][i] > max) {
                max = this.coordinates[1][i];
            }
            ++i;
        }
        if (this.group == null) {
            return this.y + max * this.sizey;
        }
        return this.group.y + (this.y + max * this.sizey) * this.group.sizey;
    }

    @Override
    public double getZMin() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < this.numPoints) {
            if (this.coordinates[2][i] < min) {
                min = this.coordinates[2][i];
            }
            ++i;
        }
        if (this.group == null) {
            return this.z + min * this.sizez;
        }
        return this.group.z + (this.z + min * this.sizez) * this.group.sizez;
    }

    @Override
    public double getZMax() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double max = -1.7976931348623157E308;
        int i = 0;
        while (i < this.numPoints) {
            if (this.coordinates[2][i] > max) {
                max = this.coordinates[2][i];
            }
            ++i;
        }
        if (this.group == null) {
            return this.z + max * this.sizez;
        }
        return this.group.z + (this.z + max * this.sizez) * this.group.sizez;
    }

    protected void projectPoints(DrawingPanel _panel) {
        this.center[0] = 0.0;
        this.center[1] = 0.0;
        this.center[2] = 0.0;
        if (this.group == null) {
            this.origin[0] = this.x;
            this.origin[1] = this.y;
            this.origin[2] = this.z;
            this.size[0] = this.sizex;
            this.size[1] = this.sizey;
            this.size[2] = this.sizez;
        } else {
            this.origin[0] = this.group.x + this.x * this.group.sizex;
            this.origin[1] = this.group.y + this.y * this.group.sizey;
            this.origin[2] = this.group.z + this.z * this.group.sizez;
            this.size[0] = this.sizex * this.group.sizex;
            this.size[1] = this.sizey * this.group.sizey;
            this.size[2] = this.sizez * this.group.sizez;
        }
        this.origin[4] = this.origin[5] = this.neumaticDash;
        this.origin[3] = this.origin[5];
        _panel.project(this.origin, this.pixelOrigin);
        this.dashSize = this.neumaticDash > 0.0 ? (int)(Math.max(this.pixelOrigin[2], this.pixelOrigin[3]) / 2.82) : (int)(Math.min(this.pixelOrigin[2], this.pixelOrigin[3]) / 2.82);
        if (this.startType != 0 && !Double.isNaN(this.startSize)) {
            this.origin[4] = this.origin[5] = this.startSize;
            this.origin[3] = this.origin[5];
            _panel.project(this.origin, this.pixelOrigin);
            this.theStartSize = (int)Math.max(this.pixelOrigin[2], this.pixelOrigin[3]);
        }
        if (this.endType != 0 && !Double.isNaN(this.endSize)) {
            this.origin[4] = this.origin[5] = this.endSize;
            this.origin[3] = this.origin[5];
            _panel.project(this.origin, this.pixelOrigin);
            this.theEndSize = (int)Math.max(this.pixelOrigin[2], this.pixelOrigin[3]);
        }
        int i = 0;
        while (i < this.numPoints) {
            int k = 0;
            while (k < 3) {
                double delta = this.coordinates[k][i] * this.size[k];
                int n = k;
                this.center[n] = this.center[n] + delta;
                this.point[k] = this.origin[k] + delta;
                ++k;
            }
            _panel.project(this.point, this.pixel);
            this.aPoints[i] = (int)this.pixel[0];
            this.bPoints[i] = (int)this.pixel[1];
            this.lineObjects[i].distance = this.connect[i] ? this.pixel[2] : Double.NaN;
            ++i;
        }
        int k = 0;
        while (k < 3) {
            this.center[k] = this.origin[k] + this.center[k] / (double)this.numPoints;
            ++k;
        }
        if (this.closed && this.style.fillPattern != null) {
            _panel.project(this.center, this.pixel);
            this.closedObject[0].distance = this.pixel[2];
        } else {
            this.closedObject[0].distance = Double.NaN;
        }
        this.computeStart();
        this.computeEnd();
        this.hasChanged = false;
        this.panelWithValidProjection = _panel;
    }

    private void computeStart() {
        this.startPoints = this.computeExtreme(this.startA, this.startB, 1, 0, this.startType, this.startSize, this.theStartSize);
    }

    private void computeEnd() {
        this.endPoints = this.closed ? this.computeExtreme(this.endA, this.endB, this.numPoints - 1, 0, this.endType, this.endSize, this.theEndSize) : this.computeExtreme(this.endA, this.endB, this.numPoints - 2, this.numPoints - 1, this.endType, this.endSize, this.theEndSize);
    }

    private int computeExtreme(int[] A, int[] B, int from, int to, int type, double _size, int theSize) {
        double q0;
        double p0;
        if (type == 0) {
            A[0] = this.aPoints[to];
            B[0] = this.bPoints[to];
            A[1] = this.aPoints[from];
            B[1] = this.bPoints[from];
            return 2;
        }
        double a = this.aPoints[to] - this.aPoints[from];
        double b = this.bPoints[to] - this.bPoints[from];
        double h = Math.sqrt(a * a + b * b);
        if (h == 0.0) {
            A[0] = this.aPoints[to];
            B[0] = this.bPoints[to];
            A[1] = this.aPoints[from];
            B[1] = this.bPoints[from];
            return 2;
        }
        if (Double.isNaN(_size)) {
            a *= 0.35 / h;
            b *= 0.35 / h;
            if (h > 25.0) {
                h = 25.0;
            }
            p0 = (double)this.aPoints[to] - a * h;
            q0 = (double)this.bPoints[to] - b * h;
        } else {
            h = (double)theSize / h;
            p0 = (double)this.aPoints[to] - a * h;
            q0 = (double)this.bPoints[to] - b * h;
        }
        a *= h / 2.0;
        b *= h / 2.0;
        switch (type) {
            default: {
                A[0] = this.aPoints[to];
                B[0] = this.bPoints[to];
                A[1] = this.aPoints[from];
                B[1] = this.bPoints[from];
                return 2;
            }
            case 1: 
            case 6: {
                int n = 9;
                double angle1 = Math.atan2(b, a);
                double delta = Math.PI * 2 / (double)(n - 1);
                double r = Math.sqrt(a * a + b * b);
                int i = 0;
                while (i < n) {
                    double angle = angle1 + (double)i * delta;
                    A[i] = (int)((double)this.aPoints[to] - a - r * Math.cos(angle));
                    B[i] = (int)((double)this.bPoints[to] - b - r * Math.sin(angle));
                    ++i;
                }
                A[n] = this.aPoints[from];
                B[n] = this.bPoints[from];
                return 10;
            }
            case 2: 
            case 7: {
                A[0] = (int)p0;
                B[0] = (int)q0;
                A[1] = (int)((double)this.aPoints[to] - a - b);
                B[1] = (int)((double)this.bPoints[to] - b + a);
                A[2] = this.aPoints[to];
                B[2] = this.bPoints[to];
                A[3] = (int)((double)this.aPoints[to] - a + b);
                B[3] = (int)((double)this.bPoints[to] - b - a);
                A[4] = (int)p0;
                B[4] = (int)q0;
                A[5] = this.aPoints[from];
                B[5] = this.bPoints[from];
                return 6;
            }
            case 3: 
            case 8: {
                A[0] = (int)p0;
                B[0] = (int)q0;
                A[1] = (int)(p0 - b);
                B[1] = (int)(q0 + a);
                A[2] = (int)((double)this.aPoints[to] - b);
                B[2] = (int)((double)this.bPoints[to] + a);
                A[3] = (int)((double)this.aPoints[to] + b);
                B[3] = (int)((double)this.bPoints[to] - a);
                A[4] = (int)(p0 + b);
                B[4] = (int)(q0 - a);
                A[5] = (int)p0;
                B[5] = (int)q0;
                A[6] = this.aPoints[from];
                B[6] = this.bPoints[from];
                return 7;
            }
            case 5: {
                A[0] = (int)((double)this.aPoints[to] - b);
                B[0] = (int)((double)this.bPoints[to] + a);
                A[1] = (int)((double)this.aPoints[to] + b);
                B[1] = (int)((double)this.bPoints[to] - a);
                A[2] = this.aPoints[to];
                B[2] = this.bPoints[to];
                A[3] = this.aPoints[from];
                B[3] = this.bPoints[from];
                return 4;
            }
            case 4: 
            case 9: 
        }
        A[0] = (int)p0;
        B[0] = (int)q0;
        A[1] = (int)(p0 - b);
        B[1] = (int)(q0 + a);
        A[2] = this.aPoints[to];
        B[2] = this.bPoints[to];
        A[3] = (int)(p0 + b);
        B[3] = (int)(q0 - a);
        A[4] = (int)p0;
        B[4] = (int)q0;
        A[5] = this.aPoints[from];
        B[5] = this.bPoints[from];
        return 6;
    }

    private void drawStart(Graphics2D _g2) {
        if (this.startType >= 6 && this.style.fillPattern != null) {
            Color color = _g2.getColor();
            _g2.setPaint(this.style.fillPattern);
            _g2.fillPolygon(this.startA, this.startB, this.startPoints - 1);
            _g2.setColor(color);
        }
        _g2.drawPolyline(this.startA, this.startB, this.startPoints);
        this.drawDash(_g2, this.aPoints[0], this.bPoints[0], this.aPoints[1], this.bPoints[1]);
    }

    private void drawEnd(Graphics2D _g2, int a1, int b1, int a2, int b2) {
        if (this.endType >= 6 && this.style.fillPattern != null) {
            Color color = _g2.getColor();
            _g2.setPaint(this.style.fillPattern);
            _g2.fillPolygon(this.endA, this.endB, this.endPoints - 1);
            _g2.setColor(color);
        }
        _g2.drawPolyline(this.endA, this.endB, this.endPoints);
        this.drawDash(_g2, a1, b1, a2, b2);
    }

    private void drawStartAndEnd(Graphics2D _g2) {
        if (this.style.fillPattern != null) {
            Color color = _g2.getColor();
            _g2.setPaint(this.style.fillPattern);
            if (this.startType >= 6) {
                _g2.fillPolygon(this.startA, this.startB, this.startPoints - 1);
            }
            if (this.endType >= 6) {
                _g2.fillPolygon(this.endA, this.endB, this.endPoints - 1);
            }
            _g2.setColor(color);
        }
        _g2.drawPolyline(this.startA, this.startB, this.startPoints - 1);
        _g2.drawPolyline(this.endA, this.endB, this.endPoints - 1);
        _g2.drawLine(this.startA[this.startPoints - 2], this.startB[this.startPoints - 2], this.endA[this.endPoints - 2], this.endB[this.endPoints - 2]);
        this.drawDash(_g2, this.startA[this.startPoints - 2], this.startB[this.startPoints - 2], this.endA[this.endPoints - 2], this.endB[this.endPoints - 2]);
    }

    private void drawLine(Graphics2D _g2, int a1, int b1, int a2, int b2) {
        _g2.drawLine(a1, b1, a2, b2);
        this.drawDash(_g2, a1, b1, a2, b2);
    }

    private void drawDash(Graphics2D _g2, int a1, int b1, int a2, int b2) {
        if (this.neumaticDash == 0.0) {
            return;
        }
        if ((double)Math.max(Math.abs(a2 - a1), Math.abs(b2 - b1)) < 2.82 * (double)this.dashSize) {
            return;
        }
        int amed = (a1 + a2) / 2;
        int bmed = (b1 + b2) / 2;
        if (this.neumaticDash > 0.0) {
            _g2.drawLine(amed - this.dashSize, bmed + this.dashSize, amed + this.dashSize, bmed - this.dashSize);
        } else {
            _g2.drawLine(amed - this.dashSize, bmed - this.dashSize, amed + this.dashSize, bmed + this.dashSize);
        }
    }
}

