/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;

public class InteractiveImage
extends AbstractInteractiveElement {
    private double a1 = 0.0;
    private double b1 = 0.0;
    private double[] coordinates = new double[6];
    private double[] pixelOrigin = new double[5];
    private Object3D[] objects = new Object3D[]{new Object3D(this, 0)};
    private AffineTransform transform = new AffineTransform();
    private boolean trueSize = false;
    private Image currentImage = null;

    @Override
    public void copyFrom(InteractiveElement _element) {
        super.copyFrom(_element);
        if (_element instanceof InteractiveImage) {
            this.setTrueSize(((InteractiveImage)_element).getTrueSize());
        }
    }

    public void setTrueSize(boolean _s) {
        this.trueSize = _s;
    }

    public boolean getTrueSize() {
        return this.trueSize;
    }

    @Override
    public void needsToProject(DrawingPanel _panel) {
        super.needsToProject(_panel);
        if (this.style.displayObject != this.currentImage && this.style.displayObject instanceof Image) {
            this.currentImage = (Image)this.style.displayObject;
            Toolkit.getDefaultToolkit().prepareImage(this.currentImage, -1, -1, _panel);
        }
        this.panelWithValidProjection = null;
    }

    @Override
    public void setSensitivity(int _s) {
        this.actualSensitivity = _s;
    }

    @Override
    public Interactive findInteractive(DrawingPanel _panel, int _xpix, int _ypix) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        if (this.positionEnabled) {
            if (this.actualSensitivity <= 0) {
                double xI = this.pixelOrigin[0] - (double)_xpix;
                double yI = this.pixelOrigin[1] - (double)_ypix;
                if (this.style.angle != 0.0) {
                    double aux = xI * this.style.cosAngle - yI * this.style.sinAngle;
                    yI = xI * this.style.sinAngle + yI * this.style.cosAngle;
                    xI = aux;
                }
                if (Math.abs(xI) < this.pixelOrigin[2] / 2.0 && Math.abs(yI) < this.pixelOrigin[3] / 2.0) {
                    return new InteractionTargetElementPosition(this);
                }
            } else if (Math.abs(this.pixelOrigin[0] - (double)_xpix) < (double)this.actualSensitivity && Math.abs(this.pixelOrigin[1] - (double)_ypix) < (double)this.actualSensitivity) {
                return new InteractionTargetElementPosition(this);
            }
        }
        return null;
    }

    @Override
    public Object3D[] getObjects3D(DrawingPanel3D _panel) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged || _panel != this.panelWithValidProjection) {
            this.projectPoints(_panel);
        }
        return this.objects;
    }

    @Override
    public void draw(DrawingPanel3D _panel, Graphics2D _g2, int _index) {
        this.drawIt(_panel, _g2);
    }

    @Override
    public void draw(DrawingPanel _panel, Graphics _g) {
        if (!this.visible) {
            return;
        }
        this.projectPoints(_panel);
        this.drawIt(_panel, (Graphics2D)_g);
    }

    protected void projectPoints(DrawingPanel _panel) {
        if (this.group != null) {
            this.coordinates[0] = this.group.x + this.x * this.group.sizex;
            this.coordinates[1] = this.group.y + this.y * this.group.sizey;
            this.coordinates[2] = this.group.z + this.z * this.group.sizez;
            this.coordinates[3] = this.sizex * this.group.sizex;
            this.coordinates[4] = this.sizey * this.group.sizey;
            this.coordinates[5] = this.sizez * this.group.sizez;
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.coordinates[3] = this.sizex;
            this.coordinates[4] = this.sizey;
            this.coordinates[5] = this.sizez;
        }
        _panel.project(this.coordinates, this.pixelOrigin);
        this.objects[0].distance = this.pixelOrigin[4];
        this.a1 = this.pixelOrigin[0];
        this.b1 = this.pixelOrigin[1];
        double sx = this.pixelOrigin[2];
        double sy = this.pixelOrigin[3];
        if (this.trueSize && this.style.displayObject instanceof Image) {
            sx = ((Image)this.style.displayObject).getWidth(null);
            sy = ((Image)this.style.displayObject).getHeight(null);
        }
        switch (this.style.position) {
            default: {
                this.a1 -= sx / 2.0;
                this.b1 -= sy / 2.0;
                break;
            }
            case 1: {
                this.a1 -= sx / 2.0;
                break;
            }
            case 2: {
                this.a1 -= sx / 2.0;
                this.b1 -= sy;
                break;
            }
            case 3: {
                this.a1 -= sx;
                this.b1 -= sy / 2.0;
                break;
            }
            case 7: {
                this.a1 -= sx;
                this.b1 -= sy;
                break;
            }
            case 5: {
                this.a1 -= sx;
                break;
            }
            case 4: {
                this.b1 -= sy / 2.0;
                break;
            }
            case 8: {
                this.b1 -= sy;
            }
            case 6: 
        }
        this.hasChanged = false;
        this.panelWithValidProjection = _panel;
    }

    private void drawIt(DrawingPanel _panel, Graphics2D _g2) {
        if (!(this.style.displayObject instanceof Image)) {
            return;
        }
        AffineTransform originalTransform = _g2.getTransform();
        this.transform.setTransform(originalTransform);
        this.transform.rotate(-this.style.angle, this.pixelOrigin[0], this.pixelOrigin[1]);
        _g2.setTransform(this.transform);
        if (this.trueSize) {
            _g2.drawImage((Image)this.style.displayObject, (int)this.a1, (int)this.b1, null);
        } else {
            _g2.drawImage((Image)this.style.displayObject, (int)this.a1, (int)this.b1, (int)this.pixelOrigin[2], (int)this.pixelOrigin[3], null);
        }
        _g2.setTransform(originalTransform);
    }
}

