/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.displayejs.Point3D;

public class InteractionTargetPoligonPoint
extends InteractionTargetElementSize {
    protected InteractivePoligon poligon = null;
    protected int index = -1;

    InteractionTargetPoligonPoint(InteractivePoligon _poligon, int _index) {
        super(_poligon);
        this.poligon = _poligon;
        this.index = _index;
    }

    public int getPointIndex() {
        return this.index;
    }

    @Override
    public Point3D getHotspot(DrawingPanel _panel) {
        if (this.element.getGroup() == null) {
            return new Point3D(this.poligon.x + this.poligon.coordinates[0][this.index] * this.poligon.sizex, this.poligon.y + this.poligon.coordinates[1][this.index] * this.poligon.sizey, this.poligon.z + this.poligon.coordinates[2][this.index] * this.poligon.sizez);
        }
        return new Point3D(this.element.getGroup().getX() + (this.poligon.x + this.poligon.coordinates[0][this.index] * this.poligon.sizex) * this.element.getGroup().getSizeX(), this.element.getGroup().getY() + (this.poligon.y + this.poligon.coordinates[1][this.index] * this.poligon.sizey) * this.element.getGroup().getSizeY(), this.element.getGroup().getZ() + (this.poligon.z + this.poligon.coordinates[2][this.index] * this.poligon.sizez) * this.element.getGroup().getSizeZ());
    }

    @Override
    public void updateHotspot(DrawingPanel _panel, Point3D _point) {
        if (this.element.getGroup() == null) {
            this.poligon.coordinates[0][this.index] = (_point.x - this.poligon.x) / this.poligon.sizex;
            this.poligon.coordinates[1][this.index] = (_point.y - this.poligon.y) / this.poligon.sizey;
            this.poligon.coordinates[2][this.index] = (_point.z - this.poligon.z) / this.poligon.sizez;
        } else if (this.element.isGroupEnabled(1)) {
            double dx = this.poligon.x + this.poligon.coordinates[0][this.index] * this.poligon.sizex;
            double dy = this.poligon.y + this.poligon.coordinates[1][this.index] * this.poligon.sizey;
            double dz = this.poligon.z + this.poligon.coordinates[2][this.index] * this.poligon.sizez;
            dx = dx == 0.0 ? this.element.getGroup().getSizeX() : (_point.x - this.element.getGroup().getX()) / dx;
            dy = dy == 0.0 ? this.element.getGroup().getSizeY() : (_point.y - this.element.getGroup().getY()) / dy;
            dz = dz == 0.0 ? this.element.getGroup().getSizeZ() : (_point.z - this.element.getGroup().getZ()) / dz;
            this.element.getGroup().setSizeXYZ(dx, dy, dz);
        } else {
            if (this.element.getGroup().getSizeX() != 0.0 && this.poligon.sizex != 0.0) {
                this.poligon.coordinates[0][this.index] = ((_point.x - this.element.getGroup().getX()) / this.element.getGroup().getSizeX() - this.poligon.x) / this.poligon.sizex;
            }
            if (this.element.getGroup().getSizeY() != 0.0 && this.poligon.sizey != 0.0) {
                this.poligon.coordinates[1][this.index] = ((_point.y - this.element.getGroup().getY()) / this.element.getGroup().getSizeY() - this.poligon.y) / this.poligon.sizey;
            }
            if (this.element.getGroup().getSizeZ() != 0.0 && this.poligon.sizez != 0.0) {
                this.poligon.coordinates[2][this.index] = ((_point.z - this.element.getGroup().getZ()) / this.element.getGroup().getSizeZ() - this.poligon.z) / this.poligon.sizez;
            }
        }
        this.poligon.hasChanged = true;
    }
}

