/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.desktop.OSPDesktop;
import org.opensourcephysics.desktop.ostermiller.Browser;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;

public class TextFrame
extends JFrame {
    HyperlinkListener hyperlinkListener;
    JTextPane textPane = new JTextPane(){

        @Override
        public void paintComponent(Graphics graphics) {
            if (OSPRuntime.antiAliasText.booleanValue()) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                RenderingHints renderingHints = graphics2D.getRenderingHints();
                renderingHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            }
            super.paintComponent(graphics);
        }
    };
    JScrollPane textScroller;

    public TextFrame() {
        this((String)null, (Class<?>)null);
    }

    public TextFrame(String string) {
        this(string, (Class<?>)null);
    }

    public TextFrame(String string, Class<?> clazz) {
        this.setSize(300, 300);
        this.textPane.setEditable(false);
        this.textScroller = new JScrollPane(this.textPane);
        this.setContentPane(this.textScroller);
        if (string != null) {
            this.loadResource(string, clazz);
        }
    }

    public JTextPane getTextPane() {
        return this.textPane;
    }

    public void enableHyperlinks() {
        if (this.hyperlinkListener != null) {
            this.textPane.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        TextFrame.this.textPane.setPage(hyperlinkEvent.getURL());
                    }
                    catch (IOException iOException) {}
                }
            }
        };
        this.textPane.addHyperlinkListener(this.hyperlinkListener);
    }

    public void enableDesktopHyperlinks() {
        if (this.hyperlinkListener != null) {
            this.textPane.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.hyperlinkListener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        if (!OSPDesktop.browse(hyperlinkEvent.getURL().toURI())) {
                            Browser.init();
                            Browser.displayURL(hyperlinkEvent.getURL().toString());
                        }
                    }
                    catch (Exception exception) {}
                }
            }
        };
        this.textPane.addHyperlinkListener(this.hyperlinkListener);
    }

    public void disableHyperlinks() {
        if (this.hyperlinkListener != null) {
            this.textPane.removeHyperlinkListener(this.hyperlinkListener);
        }
        this.hyperlinkListener = null;
    }

    public boolean loadResource(String string, Class<?> clazz) {
        Resource resource = null;
        try {
            resource = ResourceLoader.getResource(string, clazz);
        }
        catch (Exception exception) {
            OSPLog.fine("Error getting resource: " + string);
            return false;
        }
        if (resource == null) {
            OSPLog.fine("Resource not found: " + string);
            return false;
        }
        try {
            this.textPane.setPage(resource.getURL());
        }
        catch (IOException iOException) {
            OSPLog.fine("Resource not loadeded: " + string);
            return false;
        }
        this.setTitle(string);
        return true;
    }
}

