/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.displayejs.ControlInteractiveElement;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractionTargetPoligonMovingPoint;
import org.opensourcephysics.displayejs.InteractionTargetPoligonPoint;
import org.opensourcephysics.displayejs.InteractivePoligon;
import org.opensourcephysics.tools.ToolForData;

public class ControlPoligon
extends ControlInteractiveElement {
    protected static final int POLIGON_ADDED = 17;
    protected static final int INPUT_X = 17;
    protected static final int INPUT_Y = 18;
    protected static final int INPUT_Z = 19;
    protected static final int MY_SIZE_X = 20;
    protected static final int MY_SIZE_Y = 21;
    protected static final int MY_SIZE_Z = 22;
    protected static final int MY_LINE_COLOR = 36;
    protected static final int MY_FILL_COLOR = 35;
    protected static final int INDEX_SELECTED = 12;
    protected InteractivePoligon poligon;
    protected ObjectValue[] coordinatesValues;
    protected IntegerValue pointValue = new IntegerValue(-1);
    protected int insensitiveCorner = -1;
    private int[] myPosSpot;
    private int[] mySizeSpot;
    private int[] coordinatesSpot;
    private int myFullPosition;
    private int myFullSize;
    private static List<String> infoList = null;

    public ControlPoligon() {
        int disp = this.getPropertiesDisplacement();
        this.myPosSpot = new int[]{4 + disp, 5 + disp, 6 + disp};
        this.mySizeSpot = new int[]{20 + disp, 21 + disp, 22 + disp};
        this.coordinatesSpot = new int[]{17 + disp, 18 + disp, 19 + disp};
        this.myFullPosition = 45 + disp;
        this.myFullSize = 46 + disp;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 0;
    }

    public final int[] getMyPosSpot() {
        return this.myPosSpot;
    }

    public final int[] getMySizeSpot() {
        return this.mySizeSpot;
    }

    public final int getMyFullPositionSpot() {
        return this.myFullPosition;
    }

    public final int getMyFullSizeSpot() {
        return this.myFullSize;
    }

    private final int[] getCoordinatesSpot() {
        return this.coordinatesSpot;
    }

    @Override
    protected void setName(String _name) {
        this.poligon.setName(_name);
    }

    @Override
    protected Drawable createDrawable() {
        this.poligon = new InteractivePoligon();
        double[][] data = this.poligon.getData();
        this.coordinatesValues = new ObjectValue[3];
        if (data != null) {
            this.coordinatesValues[0] = new ObjectValue(data[0]);
            this.coordinatesValues[1] = new ObjectValue(data[1]);
            this.coordinatesValues[2] = new ObjectValue(data[2]);
        }
        this.poligon.setAllowTable(true);
        return this.poligon;
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null || !ToolForData.getTool().isFullTool()) {
            return;
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), ControlPoligon.getDataInformationMenuEntries(this.getParent().getDrawingPanel(), this.poligon));
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("maxpoints");
            infoList.add("connected");
            infoList.add("closed");
            infoList.add("fixed");
            infoList.add("positionx");
            infoList.add("positiony");
            infoList.add("positionz");
            infoList.add("startType");
            infoList.add("startSize");
            infoList.add("endType");
            infoList.add("endSize");
            infoList.add("neumatic");
            infoList.add("indexSelected");
            infoList.add("markershape");
            infoList.add("markersize");
            infoList.add("markerColor");
            infoList.add("markerFill");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyCommonName(String _property) {
        if (_property.equals("maxpoints")) {
            return "points";
        }
        return super.getPropertyCommonName(_property);
    }

    @Override
    public String getPropertyInfo(String _property) {
        if (_property.equals("maxpoints")) {
            return "int PREVIOUS";
        }
        if (_property.equals("x")) {
            return "int|double|double[]";
        }
        if (_property.equals("y")) {
            return "int|double|double[]";
        }
        if (_property.equals("z")) {
            return "int|double|double[] DEPRECATED";
        }
        if (_property.equals("connected")) {
            return "boolean[]";
        }
        if (_property.equals("closed")) {
            return "boolean";
        }
        if (_property.equals("startType")) {
            return "int|ExtremeType";
        }
        if (_property.equals("startSize")) {
            return "int|double";
        }
        if (_property.equals("endType")) {
            return "int|ExtremeType";
        }
        if (_property.equals("endSize")) {
            return "int|double";
        }
        if (_property.equals("neumatic")) {
            return "int|double";
        }
        if (_property.equals("fixed")) {
            return "int|boolean[]";
        }
        if (_property.equals("positionx")) {
            return "int|double";
        }
        if (_property.equals("positiony")) {
            return "int|double";
        }
        if (_property.equals("positionz")) {
            return "int|double DEPRECATED";
        }
        if (_property.equals("secondaryColor")) {
            return "int|int[]|Color|Object|Object[]";
        }
        if (_property.equals("indexSelected")) {
            return "int";
        }
        if (_property.equals("markershape")) {
            return "MarkerShape|int|int[]";
        }
        if (_property.equals("markersize")) {
            return "int|int[]";
        }
        if (_property.equals("markerColor")) {
            return "Color|Object|Object[]";
        }
        if (_property.equals("markerFill")) {
            return "Color|Object|Object[]";
        }
        return super.getPropertyInfo(_property);
    }

    @Override
    public ControlElement setProperty(String _property, String _value) {
        if ((_property = _property.trim()).equals("linecolor")) {
            return super.setProperty("secondaryColor", _value);
        }
        return super.setProperty(_property, _value);
    }

    @Override
    public Value parseConstant(String _propertyType, String _value) {
        if (_value == null) {
            return null;
        }
        if (_propertyType.indexOf("ExtremeType") >= 0 || _propertyType.indexOf("PoligonShape") >= 0) {
            if ((_value = _value.trim().toLowerCase()).equals("plain")) {
                return new IntegerValue(0);
            }
            if (_value.equals("circle")) {
                return new IntegerValue(1);
            }
            if (_value.equals("diamond")) {
                return new IntegerValue(2);
            }
            if (_value.equals("square")) {
                return new IntegerValue(3);
            }
            if (_value.equals("line")) {
                return new IntegerValue(5);
            }
            if (_value.equals("arrow")) {
                return new IntegerValue(4);
            }
            if (_value.equals("filled_circle")) {
                return new IntegerValue(6);
            }
            if (_value.equals("filled_diamond")) {
                return new IntegerValue(7);
            }
            if (_value.equals("filled_square")) {
                return new IntegerValue(8);
            }
            if (_value.equals("filled_arrow")) {
                return new IntegerValue(9);
            }
        }
        return super.parseConstant(_propertyType, _value);
    }

    @Override
    public void setValue(int _index, Value _value) {
        switch (_index) {
            case 0: {
                if (this.poligon.getNumberOfPoints() == _value.getInteger()) break;
                this.poligon.setNumberOfPoints(_value.getInteger());
                double[][] data = this.poligon.getData();
                if (data != null) {
                    this.coordinatesValues[0] = new ObjectValue(data[0]);
                    this.coordinatesValues[1] = new ObjectValue(data[1]);
                    this.coordinatesValues[2] = new ObjectValue(data[2]);
                }
                if (this.insensitiveCorner > -1 && this.insensitiveCorner < this.poligon.getNumberOfPoints()) {
                    this.poligon.setPointSizeEnabled(this.insensitiveCorner, false);
                    break;
                }
                this.insensitiveCorner = -1;
                break;
            }
            case 1: {
                if (!(_value.getObject() instanceof boolean[])) break;
                this.poligon.setConnections((boolean[])_value.getObject());
                break;
            }
            case 2: {
                this.poligon.setClosed(_value.getBoolean());
                break;
            }
            case 3: {
                if (_value.getObject() instanceof boolean[]) {
                    boolean[] val = (boolean[])_value.getObject();
                    int i = 0;
                    int n = Math.min(val.length, this.poligon.getNumberOfPoints());
                    while (i < n) {
                        this.poligon.setPointSizeEnabled(i, !val[i]);
                        ++i;
                    }
                    this.insensitiveCorner = -1;
                    break;
                }
                if (this.insensitiveCorner < 0) {
                    int i = 0;
                    int n = this.poligon.getNumberOfPoints();
                    while (i < n) {
                        this.poligon.setPointSizeEnabled(i, true);
                        ++i;
                    }
                } else {
                    this.poligon.setPointSizeEnabled(this.insensitiveCorner, true);
                }
                this.insensitiveCorner = _value.getInteger();
                this.poligon.setPointSizeEnabled(this.insensitiveCorner, false);
                break;
            }
            case 4: {
                super.setValue(0, _value);
                break;
            }
            case 5: {
                super.setValue(1, _value);
                break;
            }
            case 6: {
                super.setValue(2, _value);
                break;
            }
            case 7: {
                this.poligon.setStartType(_value.getInteger());
                break;
            }
            case 8: {
                this.poligon.setStartSize(_value.getDouble());
                break;
            }
            case 9: {
                this.poligon.setEndType(_value.getInteger());
                break;
            }
            case 10: {
                this.poligon.setEndSize(_value.getDouble());
                break;
            }
            case 11: {
                this.poligon.setNeumatic(_value.getDouble());
                break;
            }
            case 12: {
                this.pointValue.value = _value.getInteger();
                break;
            }
            case 13: {
                if (_value.getObject() instanceof int[]) {
                    this.poligon.setShapesType((int[])_value.getObject());
                    break;
                }
                this.poligon.setShapesType(_value.getInteger());
                break;
            }
            case 14: {
                if (_value.getObject() instanceof int[]) {
                    this.poligon.setShapesSize((int[])_value.getObject());
                    break;
                }
                this.poligon.setShapesSize(_value.getInteger());
                break;
            }
            case 15: {
                if (_value.getObject() instanceof Object[]) {
                    this.poligon.setShapesEdgeColor((Object[])_value.getObject());
                    break;
                }
                if (!(_value.getObject() instanceof Color)) break;
                this.poligon.setShapesEdgeColor((Color)_value.getObject());
                break;
            }
            case 16: {
                if (_value.getObject() instanceof Object[]) {
                    this.poligon.setShapesFillColor((Object[])_value.getObject());
                    break;
                }
                if (!(_value.getObject() instanceof Color)) break;
                this.poligon.setShapesFillColor((Color)_value.getObject());
                break;
            }
            case 17: {
                if (_value.getObject() instanceof double[]) {
                    this.poligon.setXs((double[])_value.getObject());
                    break;
                }
                this.poligon.setXs(_value.getDouble());
                break;
            }
            case 18: {
                if (_value.getObject() instanceof double[]) {
                    this.poligon.setYs((double[])_value.getObject());
                    break;
                }
                this.poligon.setYs(_value.getDouble());
                break;
            }
            case 19: {
                if (_value.getObject() instanceof double[]) {
                    this.poligon.setZs((double[])_value.getObject());
                    break;
                }
                this.poligon.setZs(_value.getDouble());
                break;
            }
            case 35: {
                super.setValue(19, _value);
                break;
            }
            case 36: {
                if (_value.getObject() instanceof int[]) {
                    int[] val = (int[])_value.getObject();
                    int n = val.length;
                    Color[] colors = new Color[n];
                    int i = 0;
                    while (i < n) {
                        colors[i] = DisplayColors.getLineColor(val[i]);
                        ++i;
                    }
                    this.poligon.setColors(colors);
                    break;
                }
                if (_value.getObject() instanceof Object[]) {
                    Object[] val = (Object[])_value.getObject();
                    int n = val.length;
                    Color[] colors = new Color[n];
                    int i = 0;
                    while (i < n) {
                        colors[i] = (Color)val[i];
                        ++i;
                    }
                    this.poligon.setColors(colors);
                    break;
                }
                super.setValue(18, _value);
                this.poligon.setColors(null);
                break;
            }
            default: {
                super.setValue(_index - 17, _value);
            }
        }
    }

    @Override
    public void setDefaultValue(int _index) {
        switch (_index) {
            case 0: {
                this.poligon.setNumberOfPoints(0);
                break;
            }
            case 1: {
                this.poligon.setConnections(null);
                break;
            }
            case 2: {
                this.poligon.setClosed(true);
                break;
            }
            case 3: {
                int i = 0;
                int n = this.poligon.getNumberOfPoints();
                while (i < n) {
                    this.poligon.setPointSizeEnabled(i, true);
                    ++i;
                }
                this.insensitiveCorner = -1;
                break;
            }
            case 4: {
                super.setDefaultValue(0);
                break;
            }
            case 5: {
                super.setDefaultValue(1);
                break;
            }
            case 6: {
                super.setDefaultValue(2);
                break;
            }
            case 7: {
                this.poligon.setStartType(0);
                break;
            }
            case 8: {
                this.poligon.setStartSize(Double.NaN);
                break;
            }
            case 9: {
                this.poligon.setEndType(0);
                break;
            }
            case 10: {
                this.poligon.setEndSize(Double.NaN);
                break;
            }
            case 11: {
                this.poligon.setNeumatic(0.0);
                break;
            }
            case 12: {
                this.pointValue.value = -1;
                break;
            }
            case 13: {
                this.poligon.setShapesType(null);
                break;
            }
            case 14: {
                this.poligon.setShapesSize(null);
                break;
            }
            case 15: {
                this.poligon.setShapesEdgeColor((Object[])null);
                break;
            }
            case 16: {
                this.poligon.setShapesFillColor((Object[])null);
                break;
            }
            case 17: {
                this.poligon.setXs(0.0);
                break;
            }
            case 18: {
                this.poligon.setYs(0.0);
                break;
            }
            case 19: {
                this.poligon.setZs(0.0);
                break;
            }
            case 20: {
                this.sizeValues[0].value = 1.0;
                this.myElement.setSizeX(1.0 * this.scalex);
                break;
            }
            case 21: {
                this.sizeValues[1].value = 1.0;
                this.myElement.setSizeY(1.0 * this.scaley);
                break;
            }
            case 22: {
                this.sizeValues[2].value = 1.0;
                this.myElement.setSizeZ(1.0 * this.scalez);
                break;
            }
            case 35: {
                super.setDefaultValue(19);
                break;
            }
            case 36: {
                super.setDefaultValue(18);
                this.poligon.setColors(null);
                break;
            }
            default: {
                super.setDefaultValue(_index - 17);
            }
        }
    }

    @Override
    public String getDefaultValueString(int _index) {
        switch (_index) {
            case 0: {
                return "0";
            }
            case 1: {
                return "<none>";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "<none>";
            }
            case 4: {
                return super.getDefaultValueString(0);
            }
            case 5: {
                return super.getDefaultValueString(1);
            }
            case 6: {
                return super.getDefaultValueString(2);
            }
            case 7: {
                return "PLAIN";
            }
            case 8: {
                return "<none>";
            }
            case 9: {
                return "PLAIN";
            }
            case 10: {
                return "<none>";
            }
            case 11: {
                return "0";
            }
            case 12: {
                return "<none>";
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return "<none>";
            }
            case 17: 
            case 18: 
            case 19: {
                return "<none>";
            }
            case 20: 
            case 21: 
            case 22: {
                return "1";
            }
            case 35: {
                return super.getDefaultValueString(19);
            }
            case 36: {
                return super.getDefaultValueString(18);
            }
        }
        return super.getDefaultValueString(_index - 17);
    }

    @Override
    public Value getValue(int _index) {
        switch (_index) {
            case 17: {
                return this.coordinatesValues[0];
            }
            case 18: {
                return this.coordinatesValues[1];
            }
            case 19: {
                return this.coordinatesValues[2];
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return null;
            }
            case 4: {
                return super.getValue(0);
            }
            case 5: {
                return super.getValue(1);
            }
            case 6: {
                return super.getValue(2);
            }
            case 12: {
                return this.pointValue;
            }
        }
        return super.getValue(_index - 17);
    }

    private int getIndex(Object _target) {
        if (_target instanceof InteractionTargetPoligonPoint) {
            return ((InteractionTargetPoligonPoint)_target).getPointIndex();
        }
        if (_target instanceof InteractionTargetPoligonMovingPoint) {
            return ((InteractionTargetPoligonMovingPoint)_target).getPointIndex();
        }
        return -1;
    }

    @Override
    public void interactionPerformed(InteractionEvent _event) {
        switch (_event.getID()) {
            case 2004: {
                this.invokeActions(12);
                this.variableChanged(12, this.pointValue);
                break;
            }
            case 2003: {
                this.pointValue.value = this.getIndex(_event.getTarget());
                this.variableChanged(12, this.pointValue);
                this.invokeActions(11);
                break;
            }
            case 2000: {
                this.pointValue.value = this.getIndex(_event.getTarget());
                this.variableChanged(12, this.pointValue);
                this.invokeActions(10);
            }
            case 2001: {
                if (_event.getTarget().getClass() == InteractionTargetPoligonPoint.class) {
                    this.variablesChanged(this.getCoordinatesSpot(), this.coordinatesValues);
                    if (!this.isUnderEjs) break;
                    this.setFieldListValues(this.getCoordinatesSpot(), this.coordinatesValues);
                    break;
                }
                if (_event.getTarget().getClass() == InteractionTargetElementSize.class) {
                    this.sizeValues[0].value = this.scalex != 0.0 ? this.myElement.getSizeX() / this.scalex : this.myElement.getSizeX();
                    this.sizeValues[1].value = this.scaley != 0.0 ? this.myElement.getSizeY() / this.scaley : this.myElement.getSizeY();
                    this.sizeValues[2].value = this.scalez != 0.0 ? this.myElement.getSizeZ() / this.scalez : this.myElement.getSizeZ();
                    if (this.theSize != null) {
                        this.theSize[0] = this.sizeValues[0].value;
                        this.theSize[1] = this.sizeValues[1].value;
                        if (this.theSize.length > 2) {
                            this.theSize[2] = this.sizeValues[2].value;
                        }
                        ObjectValue objVal = new ObjectValue(this.theSize);
                        this.variableChanged(this.getMyFullSizeSpot(), objVal);
                        if (!this.isUnderEjs || !this.enabledEjsEdit) break;
                        this.setFieldListValue(this.getMyFullSizeSpot(), objVal);
                        break;
                    }
                    this.variablesChanged(this.getMySizeSpot(), this.sizeValues);
                    if (!this.isUnderEjs || !this.enabledEjsEdit) break;
                    this.setFieldListValues(this.getMySizeSpot(), this.sizeValues);
                    break;
                }
                this.posValues[0].value = this.myElement.getX();
                this.posValues[1].value = this.myElement.getY();
                this.posValues[2].value = this.myElement.getZ();
                if (this.thePos != null) {
                    this.thePos[0] = this.posValues[0].value;
                    this.thePos[1] = this.posValues[1].value;
                    if (this.thePos.length > 2) {
                        this.thePos[2] = this.posValues[2].value;
                    }
                    ObjectValue objVal = new ObjectValue(this.thePos);
                    this.variableChanged(this.getMyFullPositionSpot(), objVal);
                    if (!this.isUnderEjs || !this.enabledEjsEdit) break;
                    this.setFieldListValue(this.getMyFullPositionSpot(), objVal);
                    break;
                }
                this.variablesChanged(this.getMyPosSpot(), this.posValues);
                if (!this.isUnderEjs || !this.enabledEjsEdit) break;
                this.setFieldListValues(this.getMyPosSpot(), this.posValues);
                break;
            }
            case 2002: {
                this.invokeActions(0);
                this.variableChanged(12, this.pointValue);
            }
        }
    }
}

