/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.tools;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.controls.XMLProperty;
import org.opensourcephysics.controls.XMLTree;
import org.opensourcephysics.controls.XMLTreeChooser;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.DataFunction;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DatasetManager;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.OSPFrame;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.TextFrame;
import org.opensourcephysics.tools.DataColumn;
import org.opensourcephysics.tools.DataFunctionPanel;
import org.opensourcephysics.tools.DataToolTab;
import org.opensourcephysics.tools.DatasetCurveFitter;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.FunctionPanel;
import org.opensourcephysics.tools.FunctionTool;
import org.opensourcephysics.tools.Job;
import org.opensourcephysics.tools.LocalJob;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.Tool;
import org.opensourcephysics.tools.Toolbox;
import org.opensourcephysics.tools.ToolsRes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTool
extends OSPFrame
implements Tool,
PropertyChangeListener {
    public static boolean loadClass = false;
    protected static JFileChooser chooser;
    protected static Dimension dim;
    protected static final int defaultButtonHeight = 28;
    protected static int buttonHeight;
    protected static String[] delimiters;
    protected static TextFrame helpFrame;
    protected static String helpName;
    protected static String helpBase;
    private static ArrayList<Data> processedData;
    protected JTabbedPane tabbedPane;
    protected boolean useChooser = true;
    protected JPanel contentPane = new JPanel(new BorderLayout());
    protected PropertyChangeSupport support;
    protected XMLControlElement control = new XMLControlElement();
    protected Data addableData = null;
    protected boolean controlContainsData;
    protected JMenuBar emptyMenubar;
    protected JMenu emptyFileMenu;
    protected JMenuItem emptyNewTabItem;
    protected JMenuItem emptyOpenItem;
    protected JMenuItem emptyExitItem;
    protected JMenu emptyEditMenu;
    protected JMenuItem emptyPasteItem;
    protected JMenuBar menubar;
    protected JMenu fileMenu;
    protected JMenuItem newTabItem;
    protected JMenuItem openItem;
    protected JMenuItem importItem;
    protected JMenuItem exportItem;
    protected JMenuItem saveItem;
    protected JMenuItem saveAsItem;
    protected JMenuItem closeItem;
    protected JMenuItem closeAllItem;
    protected JMenuItem printItem;
    protected JMenuItem exitItem;
    protected JMenu editMenu;
    protected JMenuItem undoItem;
    protected JMenuItem redoItem;
    protected JMenu copyMenu;
    protected JMenuItem copyImageItem;
    protected JMenuItem copyTabItem;
    protected JMenuItem copyDataItem;
    protected JMenu pasteMenu;
    protected JMenuItem pasteTabItem;
    protected JMenuItem pasteColumnsItem;
    protected JMenu displayMenu;
    protected JMenu languageMenu;
    protected JMenuItem[] languageItems;
    protected JMenu fontSizeMenu;
    protected JMenuItem defaultFontSizeItem;
    protected JMenu helpMenu;
    protected JMenuItem helpItem;
    protected JMenuItem logItem;
    protected JMenuItem aboutItem;
    protected FunctionTool dataBuilder;
    protected int fontLevel = FontSizer.getLevel();
    protected boolean exitOnClose = false;
    protected boolean saveChangesOnClose = false;
    static final DataTool DATATOOL;

    static {
        dim = new Dimension(720, 500);
        buttonHeight = 28;
        delimiters = new String[]{" ", "\t", ",", ";"};
        helpName = "data_tool_help.html";
        helpBase = "http://www.opensourcephysics.org/online_help/tools/";
        processedData = new ArrayList();
        DATATOOL = new DataTool();
    }

    public static DataTool getTool() {
        return DATATOOL;
    }

    public static void main(String[] stringArray) {
        DataTool.DATATOOL.exitOnClose = true;
        DataTool.DATATOOL.saveChangesOnClose = true;
        DATATOOL.setVisible(true);
        if (stringArray != null && stringArray.length > 0 && stringArray[0] != null) {
            DATATOOL.open(stringArray[0]);
        } else {
            DataToolTab dataToolTab = DataTool.createTab(null);
            dataToolTab.setUserEditable(true);
            DATATOOL.addTab(dataToolTab);
        }
    }

    public DataTool() {
        this(ToolsRes.getString("DataTool.Frame.Title"), "DataTool");
    }

    public DataTool(String string) {
        this();
        this.open(string);
    }

    public DataTool(XMLControl xMLControl) {
        this();
        this.addTabs(xMLControl);
    }

    public DataTool(Data data) {
        this();
        ArrayList<DataToolTab> arrayList = DataTool.createTabs(data);
        for (DataToolTab dataToolTab : arrayList) {
            this.addTab(dataToolTab);
        }
    }

    public void setSaveChangesOnClose(boolean bl) {
        this.saveChangesOnClose = bl && !OSPRuntime.appletMode;
    }

    public ArrayList<DataToolTab> addTabs(XMLControl xMLControl) {
        if (DataToolTab.class.isAssignableFrom(xMLControl.getObjectClass())) {
            DataToolTab dataToolTab = (DataToolTab)xMLControl.loadObject(null);
            this.addTab(dataToolTab);
            dataToolTab.refreshGUI();
            ArrayList<DataToolTab> arrayList = new ArrayList<DataToolTab>();
            arrayList.add(dataToolTab);
            return arrayList;
        }
        ArrayList<DataToolTab> arrayList = DataTool.loadTabsFromXML(xMLControl, this.useChooser);
        for (DataToolTab dataToolTab : arrayList) {
            this.addTab(dataToolTab);
            dataToolTab.refreshGUI();
        }
        return arrayList;
    }

    public static ArrayList<DataToolTab> createTabs(Data data) {
        ArrayList<Data> arrayList = DataTool.getSelfContainedData(data);
        ArrayList<DataToolTab> arrayList2 = new ArrayList<DataToolTab>();
        for (Data data2 : arrayList) {
            DataToolTab dataToolTab = DataTool.createTab(data2);
            if (dataToolTab == null) continue;
            arrayList2.add(dataToolTab);
        }
        return arrayList2;
    }

    private static DataToolTab createTab(Data data) {
        String string;
        DataToolTab dataToolTab = new DataToolTab(data);
        if (data != null && (string = data.getName()) != null && !string.equals("")) {
            dataToolTab.setName(string);
        }
        return dataToolTab;
    }

    public DataToolTab removeTab(int n, boolean bl) {
        if (n >= 0 && n < this.tabbedPane.getTabCount()) {
            if (bl && !this.saveChangesAt(n)) {
                return null;
            }
            DataToolTab dataToolTab = this.getTab(n);
            DatasetCurveFitter.fitBuilder.curveFitters.remove(dataToolTab.curveFitter);
            DatasetCurveFitter.fitBuilder.removePropertyChangeListener(dataToolTab.curveFitter.fitListener);
            String string = this.tabbedPane.getTitleAt(n);
            OSPLog.finer("removing tab " + string);
            this.tabbedPane.removeTabAt(n);
            this.refreshTabTitles();
            this.refreshMenubar();
            this.refreshDataBuilder();
            return dataToolTab;
        }
        return null;
    }

    public DataToolTab removeTab(DataToolTab dataToolTab) {
        return this.removeTab(this.getTabIndex(dataToolTab), true);
    }

    public ArrayList<DataToolTab> loadData(Data data) {
        DataToolTab dataToolTab = null;
        ArrayList<DataToolTab> arrayList = new ArrayList<DataToolTab>();
        for (Data data2 : DataTool.getSelfContainedData(data)) {
            dataToolTab = this.getTab(data2);
            if (dataToolTab != null) {
                dataToolTab.loadData(data2);
            } else {
                dataToolTab = DataTool.createTab(data2);
                this.addTab(dataToolTab);
            }
            arrayList.add(dataToolTab);
        }
        if (dataToolTab != null) {
            this.setSelectedTab(dataToolTab);
        }
        return arrayList;
    }

    public DataToolTab loadData(Data ... dataArray) {
        Object object;
        if (dataArray == null) {
            return null;
        }
        ArrayList<Data> arrayList = new ArrayList<Data>();
        Object object2 = dataArray;
        int n = dataArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = object2[n2];
            arrayList.addAll(DataTool.getSelfContainedData((Data)object));
            ++n2;
        }
        object = null;
        for (Data data : arrayList) {
            if (object == null) {
                object = this.getTab(data);
                if (object != null) {
                    ((DataToolTab)object).loadData(data);
                    continue;
                }
                object = DataTool.createTab(data);
                this.addTab((DataToolTab)object);
                continue;
            }
            object2 = DataTool.getDataColumns(data);
            ((ArrayList)object2).remove(0);
            ((DataToolTab)object).addColumns((ArrayList<DataColumn>)object2, false, false, false);
        }
        if (object != null) {
            this.setSelectedTab((DataToolTab)object);
        }
        return object;
    }

    public DataToolTab getTab(Data data) {
        int n = this.getTabIndex(data);
        return n > -1 ? this.getTab(n) : null;
    }

    public DataToolTab getTab(int n) {
        return n > -1 && n < this.tabbedPane.getTabCount() ? (DataToolTab)this.tabbedPane.getComponentAt(n) : null;
    }

    public int getTabCount() {
        return this.tabbedPane.getTabCount();
    }

    public String open(String string) {
        OSPLog.fine("opening " + string);
        Resource resource = ResourceLoader.getResource(string);
        if (resource != null) {
            DatasetManager datasetManager;
            BufferedReader bufferedReader = resource.openReader();
            String string2 = this.readFirstLine(bufferedReader);
            if (string2.startsWith("<?xml")) {
                XMLControlElement xMLControlElement = new XMLControlElement(string);
                ArrayList<DataToolTab> arrayList = this.addTabs(xMLControlElement);
                if (!arrayList.isEmpty()) {
                    for (DataToolTab dataToolTab : arrayList) {
                        this.refreshDataBuilder();
                        if (arrayList.size() == 1) {
                            dataToolTab.fileName = string;
                        }
                        dataToolTab.tabChanged(false);
                    }
                    return string;
                }
            } else if (resource.getString() != null && (datasetManager = DataTool.parseData(resource.getString(), string)) != null) {
                DataToolTab dataToolTab = DataTool.createTab(datasetManager);
                this.addTab(dataToolTab);
                this.refreshDataBuilder();
                dataToolTab.fileName = string;
                dataToolTab.tabChanged(false);
                return string;
            }
        }
        OSPLog.finest("no data found");
        return null;
    }

    public String importFileIntoTab(DataToolTab dataToolTab, String string) {
        OSPLog.fine("importing " + string);
        Resource resource = ResourceLoader.getResource(string);
        if (resource != null) {
            DatasetManager datasetManager;
            BufferedReader bufferedReader = resource.openReader();
            String string2 = this.readFirstLine(bufferedReader);
            if (string2.startsWith("<?xml")) {
                XMLControlElement xMLControlElement = new XMLControlElement(string);
                ArrayList<Data> arrayList = DataTool.getSelfContainedData(xMLControlElement, false);
                if (!arrayList.isEmpty()) {
                    DatasetManager datasetManager2 = new DatasetManager();
                    for (Data data : arrayList) {
                        for (DataColumn dataColumn : DataTool.getDataColumns(data)) {
                            datasetManager2.addDataset(dataColumn);
                        }
                    }
                    dataToolTab.addColumns(datasetManager2, true, true, true);
                    return string;
                }
            } else if (resource.getString() != null && (datasetManager = DataTool.parseData(resource.getString(), string)) != null) {
                dataToolTab.addColumns(datasetManager, true, true, true);
                return string;
            }
        }
        OSPLog.finest("no data found");
        return null;
    }

    @Override
    public void send(Job job, Tool tool) throws RemoteException {
        XMLControlElement xMLControlElement = new XMLControlElement(job.getXML());
        if (xMLControlElement.failedToRead() || xMLControlElement.getObjectClass() == Object.class) {
            return;
        }
        if (Data.class.isAssignableFrom(xMLControlElement.getObjectClass())) {
            Data data = (Data)xMLControlElement.loadObject(null, true, true);
            if (DataTool.isSelfContained(data)) {
                DataToolTab dataToolTab = this.getTab(data);
                if (dataToolTab != null) {
                    dataToolTab.send(job, tool);
                } else {
                    dataToolTab = DataTool.createTab(data);
                    this.addTab(dataToolTab);
                }
            } else {
                for (Data data2 : DataTool.getSelfContainedData(data)) {
                    DataToolTab dataToolTab = this.getTab(data2);
                    if (dataToolTab != null) {
                        dataToolTab.send(new LocalJob(data2), tool);
                        continue;
                    }
                    dataToolTab = DataTool.createTab(data2);
                    this.addTab(dataToolTab);
                }
            }
        } else {
            this.addTabs(xMLControlElement);
        }
    }

    public void setUseChooser(boolean bl) {
        this.useChooser = bl;
    }

    public boolean isUseChooser() {
        return this.useChooser;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DataToolTab dataToolTab;
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("function") && (dataToolTab = this.getSelectedTab()) != null) {
            String string2;
            dataToolTab.tabChanged(true);
            dataToolTab.dataTable.refreshTable();
            dataToolTab.statsTable.refreshStatistics();
            if (propertyChangeEvent.getNewValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getNewValue().toString();
                dataToolTab.dataTable.getWorkingData(string2);
            }
            if (propertyChangeEvent.getOldValue() instanceof DataFunction) {
                string2 = propertyChangeEvent.getOldValue().toString();
                dataToolTab.dataTable.removeWorkingData(string2);
            }
            if (propertyChangeEvent.getNewValue() instanceof String) {
                string2 = propertyChangeEvent.getNewValue().toString();
                if (propertyChangeEvent.getOldValue() instanceof String) {
                    String string3 = propertyChangeEvent.getOldValue().toString();
                    dataToolTab.columnNameChanged(string3, string2);
                } else {
                    dataToolTab.dataTable.getWorkingData(string2);
                }
            }
            dataToolTab.refreshPlot();
            dataToolTab.varPopup = null;
        }
    }

    protected static boolean containsDuplicateValues(double[] dArray) {
        int n = 0;
        while (n < dArray.length) {
            if (Double.isNaN(dArray[n])) {
                return true;
            }
            int n2 = DataTool.getIndex(dArray[n], dArray, n);
            if (n2 > -1) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected static int getIndex(double d, double[] dArray, int n) {
        int n2 = 0;
        while (n2 < dArray.length) {
            if (n2 != n && dArray[n2] == d) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    protected static double[] getRowArray(int n) {
        double[] dArray = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray[n2] = n2;
            ++n2;
        }
        return dArray;
    }

    protected static String[] parseStrings(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            String string3 = string;
            int n = string.indexOf(string2);
            if (n == -1) {
                arrayList.add(DataTool.stripQuotes(string3));
                string = null;
            } else {
                string3 = string.substring(0, n);
                string = string.substring(n + 1);
            }
            while (string != null) {
                arrayList.add(DataTool.stripQuotes(string3));
                n = string.indexOf(string2);
                if (n == -1) {
                    string3 = string;
                    arrayList.add(DataTool.stripQuotes(string3));
                    string = null;
                    continue;
                }
                string3 = string.substring(0, n).trim();
                string = string.substring(n + 1);
            }
        }
        return arrayList.toArray(new String[0]);
    }

    private static String stripQuotes(String string) {
        String string2;
        int n;
        if (string.startsWith("\"") && (n = (string2 = string.substring(1)).indexOf("\"")) == string2.length() - 1) {
            return string2.substring(0, n);
        }
        return string;
    }

    protected static double[] parseDoubles(String string, String string2) {
        String[] stringArray = DataTool.parseStrings(string, string2);
        return DataTool.parseDoubles(stringArray);
    }

    protected static double[] parseDoubles(String[] stringArray) {
        double[] dArray = new double[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].indexOf("\t") > -1) {
                dArray[n] = Double.NaN;
            } else {
                try {
                    dArray[n] = Double.parseDouble(stringArray[n]);
                }
                catch (NumberFormatException numberFormatException) {
                    dArray[n] = Double.NaN;
                }
            }
            ++n;
        }
        return dArray;
    }

    protected static String[][] parseStrings(String string, String string2, String string3) {
        String[] stringArray = DataTool.parseStrings(string, string2);
        String[][] stringArray2 = new String[stringArray.length][0];
        int n = 0;
        while (n < stringArray.length) {
            stringArray2[n] = DataTool.parseStrings(stringArray[n], string3);
            ++n;
        }
        return stringArray2;
    }

    protected static double[][] parseDoubles(String string, String string2, String string3) {
        String[][] stringArray = DataTool.parseStrings(string, string2, string3);
        double[][] dArray = new double[stringArray.length][0];
        int n = 0;
        while (n < stringArray.length) {
            double[] dArray2 = new double[stringArray[n].length];
            int n2 = 0;
            while (n2 < dArray2.length) {
                try {
                    dArray2[n2] = Double.parseDouble(stringArray[n][n2]);
                }
                catch (NumberFormatException numberFormatException) {
                    dArray2[n2] = Double.NaN;
                }
                ++n2;
            }
            dArray[n] = dArray2;
            ++n;
        }
        return dArray;
    }

    public static DatasetManager parseData(String string, String string2) {
        BufferedReader bufferedReader = new BufferedReader(new StringReader(string));
        try {
            String string3 = bufferedReader.readLine();
            int n = 0;
            while (n < delimiters.length) {
                int n2;
                ArrayList<double[]> arrayList = new ArrayList<double[]>();
                int n3 = Integer.MAX_VALUE;
                String[] stringArray = null;
                String string4 = null;
                int n4 = 0;
                while (string3 != null) {
                    if (string3.contains("#")) {
                        string3 = string3.trim();
                    }
                    if (string3.startsWith("#")) {
                        int n5 = string3.indexOf("name:");
                        if (n5 > -1) {
                            string4 = string3.substring(n5 + 5).trim();
                        }
                        if ((n5 = string3.indexOf("columnNames:")) > -1) {
                            string3 = string3.substring(n5 + 12).trim();
                        } else {
                            string3 = bufferedReader.readLine();
                            continue;
                        }
                    }
                    if (string3.indexOf("Vernier Format") > -1 || string3.indexOf(".cmbl") > -1) {
                        string3 = bufferedReader.readLine();
                        continue;
                    }
                    String[] stringArray2 = DataTool.parseStrings(string3, delimiters[n]);
                    double[] dArray = DataTool.parseDoubles(stringArray2);
                    if (arrayList.isEmpty() && stringArray2.length > 0 && string4 == null) {
                        String string5 = "";
                        n2 = 0;
                        while (n2 < stringArray2.length) {
                            if (Double.isNaN(dArray[n2]) && !stringArray2[n2].equals("")) {
                                if (string5.equals("")) {
                                    string5 = stringArray2[n2];
                                } else {
                                    string5 = "";
                                    break;
                                }
                            }
                            ++n2;
                        }
                        if (!string5.equals("")) {
                            string4 = string5;
                            string3 = bufferedReader.readLine();
                            continue;
                        }
                    }
                    if (arrayList.isEmpty() && stringArray2.length > 0 && stringArray == null) {
                        boolean bl = true;
                        n2 = 0;
                        while (n2 < stringArray2.length) {
                            if (!Double.isNaN(dArray[n2]) || stringArray2[n2].equals("")) {
                                bl = false;
                                break;
                            }
                            ++n2;
                        }
                        if (bl) {
                            stringArray = stringArray2;
                            string3 = bufferedReader.readLine();
                            continue;
                        }
                    }
                    if (stringArray2.length > 0) {
                        ++n4;
                        boolean bl = true;
                        n2 = 1;
                        int n6 = 0;
                        while (n6 < stringArray2.length) {
                            if (Double.isNaN(dArray[n6]) && !stringArray2[n6].equals("")) {
                                bl = false;
                            }
                            if (!stringArray2[n6].equals("")) {
                                n2 = 0;
                            }
                            ++n6;
                        }
                        if (arrayList.isEmpty() && n2 != 0) {
                            bl = false;
                        }
                        if (bl) {
                            arrayList.add(dArray);
                            n3 = Math.min(dArray.length, n3);
                        }
                    }
                    if (arrayList.isEmpty() && n4 > 10) break;
                    string3 = bufferedReader.readLine();
                }
                if (!arrayList.isEmpty() && n3 > 0) {
                    bufferedReader.close();
                    double[][] dArray = new double[n3][arrayList.size()];
                    int n7 = 0;
                    while (n7 < arrayList.size()) {
                        double[] dArray2 = (double[])arrayList.get(n7);
                        n2 = 0;
                        while (n2 < n3) {
                            dArray[n2][n7] = dArray2[n2];
                            ++n2;
                        }
                        ++n7;
                    }
                    DatasetManager datasetManager = new DatasetManager();
                    datasetManager.setName(string4 == null ? XML.getName(string2) : string4);
                    double[] dArray3 = DataTool.getRowArray(arrayList.size());
                    n2 = 0;
                    while (n2 < n3) {
                        Dataset dataset = datasetManager.getDataset(n2);
                        String string6 = stringArray != null && stringArray.length >= n2 ? stringArray[n2] : (n2 == 0 && string4 != null ? string4 : "?");
                        dataset.setXYColumnNames("row", string6);
                        dataset.setXColumnVisible(false);
                        dataset.append(dArray3, dArray[n2]);
                        ++n2;
                    }
                    OSPLog.finest("data found using delimiter \"" + delimiters[n] + "\"");
                    return datasetManager;
                }
                bufferedReader.close();
                bufferedReader = new BufferedReader(new StringReader(string));
                string3 = bufferedReader.readLine();
                ++n;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    protected String readFirstLine(Reader reader) {
        String string;
        BufferedReader bufferedReader = null;
        bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            string = bufferedReader.readLine();
            while (string == null || string.equals("")) {
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return string;
    }

    protected String getUniqueTabName(String string) {
        if (string == null || string.equals("")) {
            string = ToolsRes.getString("DataToolTab.DefaultName");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.getTabCount()) {
            DataToolTab dataToolTab = this.getTab(n);
            arrayList.add(dataToolTab.getName());
            ++n;
        }
        if (!arrayList.contains(string)) {
            return string;
        }
        String string2 = TeXParser.getSubscript(string);
        try {
            Integer.parseInt(string2);
            string = TeXParser.removeSubscript(string);
        }
        catch (Exception exception) {}
        string = String.valueOf(string) + "_";
        int n2 = 1;
        String string3 = String.valueOf(string) + n2;
        while (arrayList.contains(string3)) {
            string3 = String.valueOf(string) + ++n2;
        }
        return string3;
    }

    private static ArrayList<Data> getSelfContainedData(XMLControl xMLControl, boolean bl) {
        List<XMLProperty> list;
        HashSet<Integer> hashSet;
        ArrayList<Data> arrayList = new ArrayList<Data>();
        if (bl) {
            hashSet = new XMLTreeChooser(ToolsRes.getString("Chooser.Title"), ToolsRes.getString("Chooser.Label"), null);
            list = ((XMLTreeChooser)((Object)hashSet)).choose(xMLControl, Data.class);
        } else {
            hashSet = new XMLTree(xMLControl);
            ((XMLTree)((Object)hashSet)).setHighlightedClass(Data.class);
            ((XMLTree)((Object)hashSet)).selectHighlightedProperties();
            list = ((XMLTree)((Object)hashSet)).getSelectedProperties();
            if (list.isEmpty()) {
                JOptionPane.showMessageDialog(null, ToolsRes.getString("Dialog.NoDatasets.Message"));
            }
        }
        hashSet = new HashSet<Integer>();
        for (XMLProperty xMLProperty : list) {
            XMLControl xMLControl2 = (XMLControl)xMLProperty;
            Data data = null;
            if (xMLControl2 instanceof XMLControlElement) {
                XMLControlElement xMLControlElement = (XMLControlElement)xMLControl2;
                data = (Data)xMLControlElement.loadObject(null, true, true);
            } else {
                data = (Data)xMLControl2.loadObject(null);
            }
            if (data == null) continue;
            for (Data data2 : DataTool.getSelfContainedData(data)) {
                Integer n = new Integer(data2.getID());
                if (hashSet.contains(n)) continue;
                hashSet.add(n);
                arrayList.add(data2);
                if (!(data2 instanceof DatasetManager)) continue;
                for (Dataset dataset : data2.getDatasets()) {
                    arrayList.remove(dataset);
                    n = new Integer(dataset.getID());
                    hashSet.add(n);
                }
            }
        }
        return arrayList;
    }

    private static ArrayList<DataToolTab> loadTabsFromXML(XMLControl xMLControl, boolean bl) {
        ArrayList<DataToolTab> arrayList = new ArrayList<DataToolTab>();
        ArrayList<Data> arrayList2 = DataTool.getSelfContainedData(xMLControl, bl);
        for (Data data : arrayList2) {
            arrayList.add(DataTool.createTab(data));
        }
        return arrayList;
    }

    public static ArrayList<Dataset> getDatasets(Data data) {
        int n;
        ArrayList<Dataset> arrayList = data.getDatasets();
        if (arrayList != null) {
            return arrayList;
        }
        arrayList = new ArrayList();
        double[][] dArray = data.getData2D();
        if (dArray == null || dArray.length == 0 || dArray[0] == null) {
            return arrayList;
        }
        String[] stringArray = data.getColumnNames();
        if (stringArray == null) {
            stringArray = new String[2];
            if (dArray.length == 1) {
                stringArray[0] = "n";
            }
        }
        if (stringArray.length > (n = Math.max(2, dArray.length))) {
            ++n;
        }
        boolean bl = (stringArray = DataTool.getColumnNames(stringArray, n)).length > dArray.length;
        double[] dArray2 = bl ? DataTool.getRowArray(dArray[0].length) : dArray[0];
        int n2 = 1;
        while (n2 < stringArray.length) {
            double[] dArray3 = bl ? dArray[n2 - 1] : dArray[n2];
            Dataset dataset = DataTool.createDataset(dArray2, dArray3, stringArray[0], stringArray[n2], n2, data);
            if (dataset != null) {
                arrayList.add(dataset);
            }
            ++n2;
        }
        return arrayList;
    }

    public static ArrayList<Dataset> getAllDatasets(Data data) {
        ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
        for (Data data2 : DataTool.getSelfContainedData(data)) {
            arrayList.addAll(DataTool.getDatasets(data2));
        }
        return arrayList;
    }

    protected static ArrayList<Data> getSelfContainedData(Data data) {
        processedData.clear();
        ArrayList<Data> arrayList = DataTool.getSelfContainedDataWithTrap(data);
        return arrayList;
    }

    protected static ArrayList<DataColumn> getDataColumns(Data data) {
        if (!DataTool.isSelfContained(data)) {
            return null;
        }
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>();
        ArrayList<Dataset> arrayList2 = data.getDatasets();
        if (arrayList2 != null) {
            for (Dataset dataset : arrayList2) {
                arrayList.addAll(DataTool.createDataColumns(dataset));
            }
        } else {
            int n;
            double[][] dArray = data.getData2D();
            if (dArray == null || dArray.length == 0 || dArray[0] == null) {
                return null;
            }
            String[] stringArray = data.getColumnNames();
            if (stringArray == null) {
                stringArray = new String[2];
                if (dArray.length == 1) {
                    stringArray[0] = "n";
                }
            }
            if (stringArray.length > (n = Math.max(2, dArray.length))) {
                ++n;
            }
            boolean bl = (stringArray = DataTool.getColumnNames(stringArray, n)).length > dArray.length;
            int n2 = dArray[0].length;
            int n3 = 0;
            while (n3 < dArray.length) {
                if (dArray[n3] != null) {
                    n2 = Math.max(n2, dArray[n3].length);
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < stringArray.length) {
                double[] dArray2 = bl ? (n3 == 0 ? DataTool.getRowArray(n2) : dArray[n3 - 1]) : dArray[n3];
                DataColumn dataColumn = DataTool.createDataColumn(dArray2, stringArray[n3], n3, data);
                if (dataColumn != null) {
                    arrayList.add(dataColumn);
                }
                ++n3;
            }
        }
        return arrayList;
    }

    protected static ArrayList<DataColumn> getAllDataColumns(Data data) {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>();
        for (Data data2 : DataTool.getSelfContainedData(data)) {
            arrayList.addAll(DataTool.getDataColumns(data2));
        }
        return arrayList;
    }

    private static String[] getColumnNames(String[] stringArray, int n) {
        String[] stringArray2 = stringArray;
        if (stringArray2.length != n) {
            stringArray2 = new String[n];
            int n2 = Math.min(stringArray.length, stringArray2.length);
            System.arraycopy(stringArray, 0, stringArray2, 0, n2);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        char c = 'A';
        int n3 = 0;
        while (n3 < n) {
            String string = stringArray2[n3];
            if (string != null && !arrayList.contains(string)) {
                arrayList.add(string);
            } else if (string == null) {
                char c2 = c;
                c = (char)(c2 + 1);
                string = String.valueOf(c2);
                while (arrayList.contains(string)) {
                    char c3 = c;
                    c = (char)(c3 + '\u0001');
                    string = String.valueOf(c3);
                }
                stringArray2[n3] = string;
                arrayList.add(string);
            }
            ++n3;
        }
        return stringArray2;
    }

    private static ArrayList<Data> getSelfContainedDataWithTrap(Data data) {
        ArrayList<Data> arrayList = new ArrayList<Data>();
        if (data == null || processedData.contains(data)) {
            return arrayList;
        }
        processedData.add(data);
        if (DataTool.isSelfContained(data)) {
            arrayList.add(data);
        } else {
            for (Data data2 : data.getDataList()) {
                ArrayList<Data> arrayList2 = DataTool.getSelfContainedDataWithTrap(data2);
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    private static boolean isSelfContained(Data data) {
        return data.getDataList() == null;
    }

    private static ArrayList<DataColumn> createDataColumns(Dataset dataset) {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>();
        if (dataset instanceof DataColumn) {
            arrayList.add((DataColumn)dataset);
            return arrayList;
        }
        String[] stringArray = dataset.getColumnNames();
        String string = "row";
        int n = 0;
        while (n < 2) {
            if ((n != 0 || dataset.isXColumnVisible()) && (n != 1 || dataset.isYColumnVisible())) {
                DataColumn dataColumn = new DataColumn();
                dataColumn.setName(dataset.getName());
                dataColumn.setXYColumnNames(string, stringArray[n]);
                dataColumn.setConnected(dataset.isConnected());
                dataColumn.setLineColor(dataset.getLineColor());
                dataColumn.setMarkerSize(dataset.getMarkerSize());
                dataColumn.setMarkerShape(dataset.getMarkerShape());
                dataColumn.setMarkerColor(dataset.getFillColor(), dataset.getLineColor());
                dataColumn.setID(dataset.getID());
                dataColumn.setColumnID(n);
                dataColumn.setPoints(n == 0 ? dataset.getXPoints() : dataset.getYPoints());
                dataColumn.setXColumnVisible(false);
                arrayList.add(dataColumn);
            }
            ++n;
        }
        return arrayList;
    }

    private static DataColumn createDataColumn(double[] dArray, String string, int n, Data data) {
        if (dArray == null) {
            return null;
        }
        DataColumn dataColumn = new DataColumn();
        dataColumn.setXYColumnNames("row", string);
        dataColumn.setConnected(true);
        Color[] colorArray = data.getLineColors();
        if (colorArray != null && colorArray[n] != null) {
            dataColumn.setLineColor(colorArray[n]);
        } else {
            dataColumn.setLineColor(DisplayColors.getLineColor(n));
        }
        dataColumn.setMarkerShape(2);
        Color[] colorArray2 = data.getFillColors();
        if (colorArray != null && colorArray[n] != null && colorArray2 != null && colorArray2[n] != null) {
            dataColumn.setMarkerColor(colorArray2[n], colorArray[n]);
        } else {
            dataColumn.setMarkerColor(DisplayColors.getMarkerColor(n), DisplayColors.getLineColor(n));
        }
        dataColumn.setID(data.getID());
        dataColumn.setColumnID(n);
        dataColumn.setPoints(dArray);
        return dataColumn;
    }

    private static Dataset createDataset(double[] dArray, double[] dArray2, String string, String string2, int n, Data data) {
        if (dArray2 == null) {
            return null;
        }
        Dataset dataset = new Dataset();
        dataset.setXYColumnNames(string, string2);
        dataset.setConnected(true);
        Color[] colorArray = data.getLineColors();
        if (colorArray != null && colorArray[n] != null) {
            dataset.setLineColor(colorArray[n]);
        } else {
            dataset.setLineColor(DisplayColors.getLineColor(n));
        }
        dataset.setMarkerShape(2);
        Color[] colorArray2 = data.getFillColors();
        if (colorArray != null && colorArray[n] != null && colorArray2 != null && colorArray2[n] != null) {
            dataset.setMarkerColor(colorArray2[n], colorArray[n]);
        } else {
            dataset.setMarkerColor(DisplayColors.getMarkerColor(n), DisplayColors.getLineColor(n));
        }
        dataset.setID(data.getID());
        dataset.append(dArray, dArray2);
        return dataset;
    }

    protected static double[] insert(double d, double[] dArray, int n) {
        int n2 = dArray.length;
        double[] dArray2 = new double[n2 + 1];
        if (n == 0) {
            System.arraycopy(dArray, 0, dArray2, 0, n2);
            dArray2[n2] = d;
        } else if (n > 0) {
            int n3 = 0;
            while (n3 < n2) {
                if (d < dArray[n3]) {
                    System.arraycopy(dArray, 0, dArray2, 0, n3);
                    System.arraycopy(dArray, n3, dArray2, n3 + 1, n2 - n3);
                    dArray2[n3] = d;
                    return dArray2;
                }
                ++n3;
            }
            System.arraycopy(dArray, 0, dArray2, 0, n2);
            dArray2[n2] = d;
        } else {
            int n4 = 0;
            while (n4 < n2) {
                if (d > dArray[n4]) {
                    System.arraycopy(dArray, 0, dArray2, 0, n4);
                    System.arraycopy(dArray, n4, dArray2, n4 + 1, n2 - n4);
                    dArray2[n4] = d;
                    return dArray2;
                }
                ++n4;
            }
            System.arraycopy(dArray, 0, dArray2, 0, n2);
            dArray2[n2] = d;
        }
        return dArray2;
    }

    public void addTab(DataToolTab dataToolTab) {
        if (this.getTabCount() == 1) {
            DataToolTab dataToolTab2 = this.getTab(0);
            if (dataToolTab2.originatorID == 0) {
                dataToolTab2.tabChanged(false);
                this.removeTab(0, false);
            }
        }
        dataToolTab.dataTool = this;
        dataToolTab.setName(this.getUniqueTabName(dataToolTab.getName()));
        OSPLog.finer("adding tab " + dataToolTab.getName());
        this.tabbedPane.addTab("", dataToolTab);
        this.tabbedPane.setSelectedComponent(dataToolTab);
        this.refreshTabTitles();
        this.refreshMenubar();
        dataToolTab.setFontLevel(this.fontLevel);
    }

    protected boolean saveChangesAt(int n) {
        if (OSPRuntime.appletMode) {
            return true;
        }
        DataToolTab dataToolTab = this.getTab(n);
        if (!dataToolTab.tabChanged) {
            return true;
        }
        String string = dataToolTab.getName();
        if (ToolsRes.getString("DataToolTab.DefaultName").equals(string) && dataToolTab.originatorID == 0) {
            return true;
        }
        int n2 = JOptionPane.showConfirmDialog(this, String.valueOf(ToolsRes.getString("DataTool.Dialog.SaveChanges.Message1")) + " \"" + string + "\" " + ToolsRes.getString("DataTool.Dialog.SaveChanges.Message2"), ToolsRes.getString("DataTool.Dialog.SaveChanges.Title"), 1);
        if (n2 == 2) {
            return false;
        }
        return n2 != 0 || this.save(dataToolTab, dataToolTab.fileName) != null;
    }

    public DataToolTab getSelectedTab() {
        return (DataToolTab)this.tabbedPane.getSelectedComponent();
    }

    public void setSelectedTab(DataToolTab dataToolTab) {
        this.tabbedPane.setSelectedComponent(dataToolTab);
    }

    @Override
    public void clearData() {
        this.removeAllTabs();
    }

    @Override
    public void setFontLevel(int n) {
        this.fontLevel = Math.max(n, 0);
        super.setFontLevel(this.fontLevel);
        double d = FontSizer.getFactor(this.fontLevel);
        buttonHeight = (int)(d * 28.0);
        if (this.tabbedPane != null) {
            int n2 = 0;
            while (n2 < this.getTabCount()) {
                this.getTab(n2).setFontLevel(this.fontLevel);
                ++n2;
            }
        }
        if (this.dataBuilder != null) {
            this.dataBuilder.setFontLevel(this.fontLevel);
        }
    }

    protected static String write(String string, String string2) {
        Object object;
        block7: {
            block8: {
                File file;
                int n = string2.lastIndexOf("/");
                if (n < 0) {
                    n = string2.lastIndexOf("\\");
                }
                if (n > 0 && !(file = new File((String)(object = string2.substring(0, n + 1)))).exists() && !file.mkdir()) {
                    return null;
                }
                object = new File(string2);
                if (!((File)object).exists()) break block7;
                if (((File)object).canWrite()) break block8;
                JOptionPane.showMessageDialog(null, "File is read-only.");
                return null;
            }
            int n = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + ((File)object).getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1);
            if (n == 0) break block7;
            return null;
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream((File)object);
            Charset charset = Charset.forName("UTF-8");
            DataTool.write(string, new OutputStreamWriter((OutputStream)fileOutputStream, charset));
            if (((File)object).exists()) {
                return ((File)object).getAbsolutePath();
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return null;
    }

    protected static void write(String string, Writer writer) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(string);
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected String open() {
        int n = OSPRuntime.getChooser().showOpenDialog(null);
        if (n == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String string = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            string = XML.getRelativePath(string);
            return this.open(string);
        }
        return null;
    }

    protected String importFileIntoTab(DataToolTab dataToolTab) {
        int n = OSPRuntime.getChooser().showOpenDialog(null);
        if (n == 0) {
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            String string = OSPRuntime.getChooser().getSelectedFile().getAbsolutePath();
            string = XML.getRelativePath(string);
            return this.importFileIntoTab(dataToolTab, string);
        }
        return null;
    }

    protected String save(String string) {
        return this.save(this.getSelectedTab(), string);
    }

    protected String save(DataToolTab dataToolTab, String string) {
        if (string == null || string.equals("")) {
            return this.saveAs();
        }
        XMLControlElement xMLControlElement = new XMLControlElement(dataToolTab);
        if (xMLControlElement.write(string) == null) {
            return null;
        }
        dataToolTab.fileName = string;
        dataToolTab.tabChanged(false);
        return string;
    }

    protected String saveAs() {
        int n = OSPRuntime.getChooser().showSaveDialog(this);
        if (n == 0) {
            int n2;
            OSPRuntime.chooserDir = OSPRuntime.getChooser().getCurrentDirectory().toString();
            File file = OSPRuntime.getChooser().getSelectedFile();
            if (file.exists() && (n2 = JOptionPane.showConfirmDialog(null, String.valueOf(ToolsRes.getString("Tool.Dialog.ReplaceFile.Message")) + " " + file.getName() + "?", ToolsRes.getString("Tool.Dialog.ReplaceFile.Title"), 1)) != 0) {
                return null;
            }
            String string = file.getAbsolutePath();
            if (string == null || string.trim().equals("")) {
                return null;
            }
            if (XML.getExtension(string) == null) {
                string = String.valueOf(string) + ".xml";
            }
            return this.save(XML.getRelativePath(string));
        }
        return null;
    }

    protected int getTabIndex(Data data) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            DataToolTab dataToolTab = (DataToolTab)this.tabbedPane.getComponentAt(n);
            if (dataToolTab.isOwnedBy(data)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int getTabIndex(DataToolTab dataToolTab) {
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            if (dataToolTab == this.tabbedPane.getComponentAt(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected DataTool(String string, String string2) {
        super(string);
        this.setName(string2);
        this.createGUI();
        Toolbox.addTool(string2, this);
        ToolsRes.addPropertyChangeListener("locale", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                DataTool.this.refreshGUI();
            }
        });
    }

    protected boolean removeAllButTab(int n) {
        int n2 = this.tabbedPane.getTabCount() - 1;
        while (n2 >= 0) {
            if (n2 != n) {
                if (!this.saveChangesAt(n2)) {
                    return false;
                }
                String string = this.tabbedPane.getTitleAt(n2);
                OSPLog.finer("removing tab " + string);
                DataToolTab dataToolTab = this.getTab(n2);
                DatasetCurveFitter.fitBuilder.curveFitters.remove(dataToolTab.curveFitter);
                DatasetCurveFitter.fitBuilder.removePropertyChangeListener(dataToolTab.curveFitter.fitListener);
                this.tabbedPane.removeTabAt(n2);
            }
            --n2;
        }
        this.refreshTabTitles();
        this.refreshDataBuilder();
        return true;
    }

    protected boolean removeAllTabs() {
        int n = this.tabbedPane.getTabCount() - 1;
        while (n >= 0) {
            if (!this.saveChangesAt(n)) {
                return false;
            }
            String string = this.tabbedPane.getTitleAt(n);
            OSPLog.finer("removing tab " + string);
            DataToolTab dataToolTab = this.getTab(n);
            DatasetCurveFitter.fitBuilder.curveFitters.remove(dataToolTab.curveFitter);
            DatasetCurveFitter.fitBuilder.removePropertyChangeListener(dataToolTab.curveFitter.fitListener);
            this.tabbedPane.removeTabAt(n);
            --n;
        }
        this.refreshMenubar();
        this.refreshDataBuilder();
        return true;
    }

    protected void refreshTabTitles() {
        String[] stringArray = new String[this.tabbedPane.getTabCount()];
        int n = 0;
        while (n < stringArray.length) {
            String string;
            DataToolTab dataToolTab = (DataToolTab)this.tabbedPane.getComponentAt(n);
            stringArray[n] = string = dataToolTab.getName();
            ++n;
        }
        n = 0;
        while (n < stringArray.length) {
            this.tabbedPane.setTitleAt(n, stringArray[n]);
            ++n;
        }
    }

    protected void refreshMenubar() {
        if (this.getTabCount() == 0) {
            this.emptyMenubar.add(this.displayMenu);
            this.emptyMenubar.add(this.helpMenu);
            this.setJMenuBar(this.emptyMenubar);
        } else {
            this.menubar.add(this.displayMenu);
            this.menubar.add(this.helpMenu);
            this.setJMenuBar(this.menubar);
        }
    }

    protected FunctionTool getDataBuilder() {
        if (this.dataBuilder == null) {
            this.dataBuilder = new FunctionTool((Component)this);
            this.dataBuilder.setFontLevel(this.fontLevel);
            this.dataBuilder.setHelpPath("data_builder_help.html");
            this.dataBuilder.addPropertyChangeListener("function", this);
            this.dataBuilder.setTitle(ToolsRes.getString("DataTool.DataBuilder.Title"));
        }
        this.refreshDataBuilder();
        return this.dataBuilder;
    }

    protected void refreshDataBuilder() {
        Object object;
        Iterator iterator;
        if (this.dataBuilder == null) {
            return;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < this.tabbedPane.getTabCount()) {
            iterator = this.getTab(n);
            arrayList.add(((Component)((Object)iterator)).getName());
            if (this.dataBuilder.getPanel(((Component)((Object)iterator)).getName()) == null) {
                object = new DataFunctionPanel(((DataToolTab)((Object)iterator)).dataManager);
                this.dataBuilder.addPanel(((Component)((Object)iterator)).getName(), (FunctionPanel)object);
            }
            ++n;
        }
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        iterator = this.dataBuilder.panels.keySet().iterator();
        while (iterator.hasNext()) {
            object = ((String)iterator.next()).toString();
            if (arrayList.contains(object)) continue;
            arrayList2.add(object);
        }
        iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            object = ((String)iterator.next()).toString();
            this.dataBuilder.removePanel((String)object);
        }
    }

    protected static void copy(String string) {
        StringSelection stringSelection = new StringSelection(string);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(stringSelection, stringSelection);
    }

    protected static String paste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                return string;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    protected static void showHelp(String string) {
        Object object;
        String string2 = XML.getResolvedPath(string, helpBase);
        if (ResourceLoader.getResource(string2) == null) {
            object = "/org/opensourcephysics/resources/tools/html/";
            string2 = XML.getResolvedPath(string, (String)object);
        }
        if (helpFrame == null || !string2.equals(helpFrame.getTitle())) {
            helpFrame = new TextFrame(string2);
            helpFrame.enableHyperlinks();
            helpFrame.setSize(760, 560);
            object = Toolkit.getDefaultToolkit().getScreenSize();
            int n = (((Dimension)object).width - DataTool.helpFrame.getBounds().width) / 2;
            int n2 = (((Dimension)object).height - DataTool.helpFrame.getBounds().height) / 2;
            helpFrame.setLocation(n, n2);
        }
        helpFrame.setVisible(true);
    }

    @Override
    public void setDefaultCloseOperation(int n) {
        if (n == 3) {
            this.exitOnClose = true;
            n = 0;
        }
        if (n != 0) {
            this.saveChangesOnClose = false;
        }
        super.setDefaultCloseOperation(n);
    }

    protected void createGUI() {
        this.contentPane.setPreferredSize(dim);
        this.setContentPane(this.contentPane);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.contentPane.add((Component)jPanel, "Center");
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                DataTool.this.exitItem.doClick(0);
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                if (dataToolTab == null) {
                    return;
                }
                if (!dataToolTab.propsCheckbox.isSelected() && !dataToolTab.statsCheckbox.isSelected()) {
                    dataToolTab.splitPanes[2].setDividerLocation(0);
                }
            }
        });
        this.tabbedPane = new JTabbedPane(1);
        jPanel.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                if (dataToolTab != null) {
                    dataToolTab.dataTable.refreshTable();
                    dataToolTab.statsTable.refreshStatistics();
                    dataToolTab.propsTable.refreshTable();
                    dataToolTab.refreshPlot();
                    DataTool.this.refreshGUI();
                    dataToolTab.dataTable.requestFocusInWindow();
                    if (dataToolTab.dataTable.workingData != null && DatasetCurveFitter.fitBuilder != null) {
                        String string = dataToolTab.dataTable.workingData.getXColumnName();
                        string = TeXParser.removeSubscripting(string);
                        DatasetCurveFitter.fitBuilder.setDefaultVariables(new String[]{string});
                    }
                }
            }
        });
        this.tabbedPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (OSPRuntime.isPopupTrigger(mouseEvent)) {
                    final int n = DataTool.this.tabbedPane.getSelectedIndex();
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    JMenuItem jMenuItem = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Name"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataToolTab dataToolTab = DataTool.this.getTab(n);
                            String string = dataToolTab.getName();
                            Object object = JOptionPane.showInputDialog(DataTool.this, ToolsRes.getString("DataTool.Dialog.Name.Message"), ToolsRes.getString("DataTool.Dialog.Name.Title"), 3, null, null, string);
                            if (object == null) {
                                return;
                            }
                            dataToolTab.setName("");
                            dataToolTab.setName(DataTool.this.getUniqueTabName(object.toString()));
                            dataToolTab.tabChanged(true);
                            DataTool.this.refreshTabTitles();
                            DataTool.this.refreshDataBuilder();
                        }
                    });
                    if (!DataTool.this.getTab((int)n).dataManager.getDatasets().isEmpty()) {
                        jPopupMenu.addSeparator();
                        jMenuItem = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.NewTab"));
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                (this).DataTool.this.newTabItem.doClick(0);
                            }
                        });
                        jPopupMenu.add(jMenuItem);
                        JMenu jMenu = new JMenu(ToolsRes.getString("DataTool.Menu.Clone"));
                        jPopupMenu.add(jMenu);
                        final JMenuItem jMenuItem2 = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Editable"));
                        jMenu.add(jMenuItem2);
                        jMenuItem2.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                String string;
                                String string2 = DataTool.this.getTab(n).getName();
                                int n2 = string2.indexOf(string = "_" + ToolsRes.getString("DataTool.Clone.Subscript"));
                                if (n2 > -1) {
                                    string2 = string2.substring(0, n2);
                                }
                                string2 = String.valueOf(string2) + string;
                                string2 = DataTool.this.getUniqueTabName(string2);
                                (this).DataTool.this.copyTabItem.doClick(0);
                                (this).DataTool.this.pasteTabItem.doClick(0);
                                DataTool.this.getTab(DataTool.this.getTabCount() - 1).setName(string2);
                                DataTool.this.refreshTabTitles();
                            }
                        });
                        jMenuItem = new JMenuItem(ToolsRes.getString("DataTool.MenuItem.Noneditable"));
                        jMenu.add(jMenuItem);
                        jMenuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent actionEvent) {
                                jMenuItem2.doClick(0);
                                DataToolTab dataToolTab = DataTool.this.getTab(DataTool.this.getTabCount() - 1);
                                dataToolTab.setUserEditable(false);
                                for (Dataset dataset : dataToolTab.dataManager.getDatasets()) {
                                    if (!(dataset instanceof DataColumn)) continue;
                                    ((DataColumn)dataset).deletable = false;
                                }
                            }
                        });
                    }
                    jPopupMenu.addSeparator();
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.Close"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataTool.this.removeTab(n, true);
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseOthers"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataTool.this.removeAllButTab(n);
                        }
                    });
                    jMenuItem = new JMenuItem(ToolsRes.getString("MenuItem.CloseAll"));
                    jPopupMenu.add(jMenuItem);
                    jMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent actionEvent) {
                            DataTool.this.removeAllTabs();
                        }
                    });
                    FontSizer.setFonts(jPopupMenu, DataTool.this.fontLevel);
                    jPopupMenu.show(DataTool.this.tabbedPane, mouseEvent.getX(), mouseEvent.getY() + 8);
                }
            }
        });
        int n = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.menubar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.menubar.add(this.fileMenu);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                boolean bl;
                boolean bl2 = bl = DataTool.this.getSelectedTab().originatorID == 0;
                if (!OSPRuntime.appletMode) {
                    DataTool.this.exportItem.setEnabled(!bl);
                    DataTool.this.saveItem.setEnabled(!bl);
                    DataTool.this.saveAsItem.setEnabled(!bl);
                    int[] nArray = DataTool.this.getSelectedTab().dataTable.getSelectedRows();
                    int n = DataTool.this.getSelectedTab().dataTable.getRowCount() - 1;
                    if (nArray.length == 0 || nArray.length == 1 && nArray[0] == n && DataTool.this.getSelectedTab().dataTable.isEmptyRow(n)) {
                        DataTool.this.exportItem.setText(ToolsRes.getString("DataTool.MenuItem.Export"));
                    } else {
                        DataTool.this.exportItem.setText(ToolsRes.getString("DataTool.MenuItem.ExportSelection"));
                    }
                }
            }
        };
        this.fileMenu.addMouseListener(mouseAdapter);
        this.newTabItem = new JMenuItem();
        this.newTabItem.setAccelerator(KeyStroke.getKeyStroke(78, n));
        this.newTabItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab dataToolTab = DataTool.createTab(null);
                dataToolTab.userEditable = true;
                DataTool.this.addTab(dataToolTab);
                dataToolTab.refreshGUI();
            }
        });
        this.fileMenu.add(this.newTabItem);
        if (!OSPRuntime.appletMode) {
            this.openItem = new JMenuItem();
            this.openItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
            this.openItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataTool.this.open();
                }
            });
            this.fileMenu.add(this.openItem);
        }
        this.fileMenu.addSeparator();
        this.closeItem = new JMenuItem();
        this.closeItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DataTool.this.tabbedPane.getSelectedIndex();
                DataTool.this.removeTab(n, true);
            }
        });
        this.fileMenu.add(this.closeItem);
        this.closeAllItem = new JMenuItem();
        this.closeAllItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.removeAllTabs();
            }
        });
        this.fileMenu.add(this.closeAllItem);
        this.fileMenu.addSeparator();
        if (!OSPRuntime.appletMode) {
            this.importItem = new JMenuItem();
            this.importItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                    DataTool.this.importFileIntoTab(dataToolTab);
                }
            });
            this.fileMenu.add(this.importItem);
            this.exportItem = new JMenuItem();
            this.exportItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataTool.this.getSelectedTab().saveTableDataToFile();
                }
            });
            this.fileMenu.add(this.exportItem);
            this.fileMenu.addSeparator();
            this.saveItem = new JMenuItem();
            this.saveItem.setAccelerator(KeyStroke.getKeyStroke(83, n));
            this.saveItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                    DataTool.this.save(dataToolTab.fileName);
                }
            });
            this.fileMenu.add(this.saveItem);
            this.saveAsItem = new JMenuItem();
            this.saveAsItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataTool.this.saveAs();
                }
            });
            this.fileMenu.add(this.saveAsItem);
            this.fileMenu.addSeparator();
        }
        this.printItem = new JMenuItem();
        this.printItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SnapshotTool.getTool().printImage(DataTool.this);
            }
        });
        this.printItem.setAccelerator(KeyStroke.getKeyStroke(80, n));
        this.fileMenu.add(this.printItem);
        this.fileMenu.addSeparator();
        this.exitItem = new JMenuItem();
        this.exitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        this.exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!DataTool.this.saveChangesOnClose || DataTool.this.removeAllTabs()) {
                    if (DataTool.this.exitOnClose) {
                        System.exit(0);
                    } else {
                        DataTool.this.setVisible(false);
                    }
                }
            }
        });
        this.fileMenu.add(this.exitItem);
        this.editMenu = new JMenu();
        MouseAdapter mouseAdapter2 = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (!DataTool.this.editMenu.isPopupMenuVisible() && !DataTool.this.emptyEditMenu.isPopupMenuVisible()) {
                    return;
                }
                DataToolTab dataToolTab = DataTool.this.getSelectedTab();
                if (dataToolTab != null) {
                    DataTool.this.undoItem.setEnabled(dataToolTab.undoManager.canUndo());
                    DataTool.this.redoItem.setEnabled(dataToolTab.undoManager.canRedo());
                }
                boolean bl = DataTool.this.hasPastableData();
                DataTool.this.emptyPasteItem.setEnabled(bl);
                DataTool.this.pasteMenu.setEnabled(bl);
                DataTool.this.copyMenu.removeAll();
                if (dataToolTab != null) {
                    ArrayList<Dataset> arrayList = dataToolTab.dataManager.getDatasets();
                    DataTool.this.copyDataItem.setEnabled(!arrayList.isEmpty());
                    if (!arrayList.isEmpty()) {
                        boolean bl2;
                        DataTool.this.copyTabItem.setText(ToolsRes.getString("DataTool.MenuItem.CopyTab"));
                        DataTool.this.copyMenu.add(DataTool.this.copyTabItem);
                        DataTool.this.copyMenu.addSeparator();
                        String string = ToolsRes.getString("DataTool.MenuItem.CopyData");
                        int[] nArray = DataTool.this.getSelectedTab().dataTable.getSelectedRows();
                        int n = DataTool.this.getSelectedTab().dataTable.getRowCount() - 1;
                        boolean bl3 = bl2 = nArray.length == 1 && nArray[0] == n && DataTool.this.getSelectedTab().dataTable.isEmptyRow(n);
                        if (nArray.length > 0 && !bl2) {
                            string = ToolsRes.getString("DataTool.MenuItem.CopySelectedData");
                        }
                        DataTool.this.copyDataItem.setText(string);
                        DataTool.this.copyMenu.add(DataTool.this.copyDataItem);
                        DataTool.this.copyMenu.addSeparator();
                    }
                }
                DataTool.this.copyMenu.add(DataTool.this.copyImageItem);
                FontSizer.setFonts(DataTool.this.copyMenu, DataTool.this.fontLevel);
            }
        };
        this.editMenu.addMouseListener(mouseAdapter2);
        this.menubar.add(this.editMenu);
        this.undoItem = new JMenuItem();
        this.undoItem.setEnabled(false);
        this.undoItem.setAccelerator(KeyStroke.getKeyStroke(90, n));
        this.undoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.getSelectedTab().undoManager.undo();
            }
        });
        this.editMenu.add(this.undoItem);
        this.redoItem = new JMenuItem();
        this.redoItem.setEnabled(false);
        this.redoItem.setAccelerator(KeyStroke.getKeyStroke(89, n));
        this.redoItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.getSelectedTab().undoManager.redo();
            }
        });
        this.editMenu.add(this.redoItem);
        this.editMenu.addSeparator();
        this.copyMenu = new JMenu();
        this.editMenu.add(this.copyMenu);
        this.copyTabItem = new JMenuItem();
        this.copyTabItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = DataTool.this.tabbedPane.getSelectedIndex();
                String string = DataTool.this.tabbedPane.getTitleAt(n);
                OSPLog.finest("copying tab " + string);
                XMLControlElement xMLControlElement = new XMLControlElement(DataTool.this.getSelectedTab());
                DataTool.copy(xMLControlElement.toXML());
            }
        });
        this.copyDataItem = new JMenuItem();
        this.copyDataItem.setAccelerator(KeyStroke.getKeyStroke(67, n));
        this.copyDataItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.getSelectedTab().copyTableDataToClipboard();
            }
        });
        this.copyImageItem = new JMenuItem();
        this.copyImageItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = DataTool.this.getSelectedTab().getName();
                OSPLog.finest("copying image of " + string);
                SnapshotTool.getTool().copyImage(DataTool.this);
            }
        });
        MouseAdapter mouseAdapter3 = new MouseAdapter(){

            public void mouseEntered(MouseEvent mouseEvent) {
                if (!DataTool.this.pasteMenu.isEnabled() || DataTool.this.pasteMenu.isPopupMenuVisible()) {
                    return;
                }
                if (DataTool.this.hasPastableColumns(DataTool.this.getSelectedTab())) {
                    DataTool.this.pasteMenu.add(DataTool.this.pasteColumnsItem);
                } else {
                    DataTool.this.addableData = null;
                    DataTool.this.pasteMenu.remove(DataTool.this.pasteColumnsItem);
                }
                FontSizer.setFonts(DataTool.this.pasteMenu, DataTool.this.fontLevel);
            }
        };
        this.pasteMenu = new JMenu();
        this.pasteMenu.addMouseListener(mouseAdapter3);
        this.editMenu.add(this.pasteMenu);
        this.pasteTabItem = new JMenuItem();
        this.pasteTabItem.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = false;
                String string = DataTool.paste();
                if (string != null) {
                    Object object;
                    if (!string.startsWith("<?xml")) {
                        object = DataTool.parseData(string, null);
                        if (object != null) {
                            OSPLog.finest("pasting imported clipboard data into new tab");
                            DataToolTab dataToolTab = DataTool.createTab((Data)object);
                            dataToolTab.userEditable = true;
                            DataTool.this.addTab(dataToolTab);
                            dataToolTab.refreshGUI();
                            DataTool.this.refreshDataBuilder();
                            return;
                        }
                        bl = true;
                    }
                    if (!bl) {
                        DataTool.this.control = new XMLControlElement();
                        DataTool.this.control.readXML(string);
                        if (DataTool.this.control.failedToRead()) {
                            bl = true;
                        }
                    }
                    if (!bl) {
                        OSPLog.finest("pasting clipboard XML into new tabs");
                        if (Data.class.isAssignableFrom(DataTool.this.control.getObjectClass())) {
                            object = (Data)DataTool.this.control.loadObject(null, true, true);
                            if (object == null) {
                                bl = true;
                            } else {
                                for (Data data : DataTool.getSelfContainedData((Data)object)) {
                                    DataToolTab dataToolTab = DataTool.createTab(data);
                                    DataTool.this.addTab(dataToolTab);
                                }
                                int n = DataTool.this.getTabCount() - 1;
                                DataTool.this.tabbedPane.setSelectedIndex(n);
                            }
                        } else {
                            object = DataTool.this.addTabs(DataTool.this.control);
                            Iterator iterator = ((ArrayList)object).iterator();
                            while (iterator.hasNext()) {
                                DataToolTab dataToolTab = (DataToolTab)iterator.next();
                                dataToolTab.setUserEditable(true);
                            }
                            int n = DataTool.this.getTabCount() - 1;
                            DataTool.this.tabbedPane.setSelectedIndex(n);
                        }
                    }
                    if (!bl) {
                        DataTool.this.refreshDataBuilder();
                    }
                }
                if (bl) {
                    JOptionPane.showMessageDialog(DataTool.this, ToolsRes.getString("Tool.Dialog.NoData.Message"), ToolsRes.getString("Tool.Dialog.NoData.Title"), 2);
                }
            }
        });
        this.pasteMenu.add(this.pasteTabItem);
        this.pasteColumnsItem = new JMenuItem();
        this.pasteColumnsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Serializable serializable;
                if (DataTool.this.controlContainsData && !((ArrayList)(serializable = DataTool.getSelfContainedData(DataTool.this.control, DataTool.this.useChooser))).isEmpty()) {
                    DatasetManager datasetManager = new DatasetManager();
                    Iterator iterator = ((ArrayList)serializable).iterator();
                    while (iterator.hasNext()) {
                        Data data = (Data)iterator.next();
                        for (DataColumn dataColumn : DataTool.getDataColumns(data)) {
                            datasetManager.addDataset(dataColumn);
                        }
                    }
                    DataTool.this.addableData = datasetManager;
                }
                if (DataTool.this.addableData != null) {
                    serializable = DataTool.this.getSelectedTab();
                    OSPLog.finest("pasting columns into " + ((Component)serializable).getName());
                    ((DataToolTab)serializable).addColumns(DataTool.this.addableData, true, true, true);
                }
            }
        });
        this.pasteMenu.add(this.pasteColumnsItem);
        this.displayMenu = new JMenu();
        this.menubar.add(this.displayMenu);
        this.languageMenu = new JMenu();
        String string = "/org/opensourcephysics/resources/tools/html/";
        String string2 = XML.getResolvedPath(helpName, string);
        ResourceLoader.getResource(string2);
        final Locale[] localeArray = OSPRuntime.getInstalledLocales();
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                OSPLog.finest("setting language to " + string);
                int n = 0;
                while (n < localeArray.length) {
                    if (string.equals(localeArray[n].getDisplayName())) {
                        ToolsRes.setLocale(localeArray[n]);
                        return;
                    }
                    ++n;
                }
            }
        };
        ButtonGroup buttonGroup = new ButtonGroup();
        this.languageItems = new JMenuItem[localeArray.length];
        int n2 = 0;
        while (n2 < localeArray.length) {
            this.languageItems[n2] = new JRadioButtonMenuItem(localeArray[n2].getDisplayName(localeArray[n2]));
            this.languageItems[n2].setActionCommand(localeArray[n2].getDisplayName());
            this.languageItems[n2].addActionListener(abstractAction);
            this.languageMenu.add(this.languageItems[n2]);
            buttonGroup.add(this.languageItems[n2]);
            ++n2;
        }
        this.displayMenu.add(this.languageMenu);
        this.fontSizeMenu = new JMenu();
        this.displayMenu.add(this.fontSizeMenu);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        AbstractAction abstractAction2 = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                DataTool.this.setFontLevel(n);
            }
        };
        int n3 = 0;
        while (n3 < 4) {
            JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem("+" + n3);
            if (n3 == 0) {
                this.defaultFontSizeItem = jRadioButtonMenuItem;
            }
            jRadioButtonMenuItem.addActionListener(abstractAction2);
            jRadioButtonMenuItem.setActionCommand("" + n3);
            this.fontSizeMenu.add(jRadioButtonMenuItem);
            buttonGroup2.add(jRadioButtonMenuItem);
            if (n3 == FontSizer.getLevel()) {
                jRadioButtonMenuItem.setSelected(true);
            }
            ++n3;
        }
        this.helpMenu = new JMenu();
        this.menubar.add(this.helpMenu);
        this.helpItem = new JMenuItem();
        this.helpItem.setAccelerator(KeyStroke.getKeyStroke(72, n));
        this.helpItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.showHelp(helpName);
            }
        });
        this.helpMenu.add(this.helpItem);
        this.helpMenu.addSeparator();
        this.logItem = new JMenuItem();
        this.logItem.setAccelerator(KeyStroke.getKeyStroke(76, n));
        this.logItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OSPLog oSPLog = OSPLog.getOSPLog();
                if (oSPLog.getLocation().x == 0 && oSPLog.getLocation().y == 0) {
                    Point point = DataTool.this.getLocation();
                    oSPLog.setLocation(point.x + 28, point.y + 28);
                }
                ((Window)oSPLog).setVisible(true);
            }
        });
        this.helpMenu.add(this.logItem);
        this.helpMenu.addSeparator();
        this.aboutItem = new JMenuItem();
        this.aboutItem.setAccelerator(KeyStroke.getKeyStroke(65, n));
        this.aboutItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.showAboutDialog();
            }
        });
        this.helpMenu.add(this.aboutItem);
        this.setJMenuBar(this.menubar);
        this.emptyMenubar = new JMenuBar();
        this.emptyFileMenu = new JMenu();
        this.emptyMenubar.add(this.emptyFileMenu);
        this.emptyNewTabItem = new JMenuItem();
        this.emptyNewTabItem.setAccelerator(KeyStroke.getKeyStroke(78, n));
        this.emptyNewTabItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataToolTab dataToolTab = DataTool.createTab(null);
                dataToolTab.userEditable = true;
                DataTool.this.addTab(dataToolTab);
                dataToolTab.refreshGUI();
            }
        });
        this.emptyFileMenu.add(this.emptyNewTabItem);
        this.emptyOpenItem = new JMenuItem();
        this.emptyOpenItem.setAccelerator(KeyStroke.getKeyStroke(79, n));
        this.emptyOpenItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataTool.this.open();
            }
        });
        this.emptyFileMenu.add(this.emptyOpenItem);
        this.emptyFileMenu.addSeparator();
        this.emptyExitItem = new JMenuItem();
        this.emptyExitItem.setAccelerator(KeyStroke.getKeyStroke(81, n));
        this.emptyExitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.exit(0);
            }
        });
        this.emptyFileMenu.add(this.emptyExitItem);
        this.emptyEditMenu = new JMenu();
        this.emptyEditMenu.addMouseListener(mouseAdapter2);
        this.emptyMenubar.add(this.emptyEditMenu);
        this.emptyPasteItem = new JMenuItem();
        this.emptyPasteItem.addActionListener(this.pasteTabItem.getAction());
        this.emptyEditMenu.add(this.emptyPasteItem);
        this.refreshGUI();
        this.refreshMenubar();
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n4 = (dimension.width - this.getBounds().width) / 2;
        int n5 = (dimension.height - this.getBounds().height) / 2;
        this.setLocation(n4, n5);
    }

    @Override
    protected void refreshGUI() {
        this.setTitle(ToolsRes.getString("DataTool.Frame.Title"));
        this.emptyFileMenu.setText(ToolsRes.getString("Menu.File"));
        this.emptyNewTabItem.setText(ToolsRes.getString("DataTool.MenuItem.NewTab"));
        this.emptyOpenItem.setText(ToolsRes.getString("MenuItem.Open"));
        this.emptyExitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.emptyEditMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.emptyPasteItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteTab"));
        this.fileMenu.setText(ToolsRes.getString("Menu.File"));
        this.newTabItem.setText(ToolsRes.getString("DataTool.MenuItem.NewTab"));
        if (!OSPRuntime.appletMode) {
            this.openItem.setText(ToolsRes.getString("MenuItem.Open"));
            this.importItem.setText(ToolsRes.getString("DataTool.MenuItem.Import"));
            this.saveItem.setText(ToolsRes.getString("DataTool.MenuItem.Save"));
            this.saveAsItem.setText(ToolsRes.getString("DataTool.MenuItem.SaveAs"));
        }
        this.closeItem.setText(ToolsRes.getString("MenuItem.Close"));
        this.closeAllItem.setText(ToolsRes.getString("MenuItem.CloseAll"));
        this.printItem.setText(ToolsRes.getString("DataTool.MenuItem.Print"));
        this.exitItem.setText(ToolsRes.getString("MenuItem.Exit"));
        this.editMenu.setText(ToolsRes.getString("Menu.Edit"));
        this.undoItem.setText(ToolsRes.getString("DataTool.MenuItem.Undo"));
        this.redoItem.setText(ToolsRes.getString("DataTool.MenuItem.Redo"));
        this.copyMenu.setText(ToolsRes.getString("DataTool.Menu.Copy"));
        this.copyImageItem.setText(ToolsRes.getString("DataTool.MenuItem.CopyImage"));
        this.pasteMenu.setText(ToolsRes.getString("MenuItem.Paste"));
        this.pasteTabItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewTab"));
        this.pasteColumnsItem.setText(ToolsRes.getString("DataTool.MenuItem.PasteNewColumns"));
        this.displayMenu.setText(ToolsRes.getString("Tool.Menu.Display"));
        this.languageMenu.setText(ToolsRes.getString("Tool.Menu.Language"));
        this.fontSizeMenu.setText(ToolsRes.getString("Tool.Menu.FontSize"));
        this.defaultFontSizeItem.setText(ToolsRes.getString("Tool.MenuItem.DefaultFontSize"));
        this.helpMenu.setText(ToolsRes.getString("Menu.Help"));
        this.helpItem.setText(ToolsRes.getString("DataTool.MenuItem.Help"));
        this.logItem.setText(ToolsRes.getString("MenuItem.Log"));
        this.aboutItem.setText(ToolsRes.getString("MenuItem.About"));
        Locale[] localeArray = OSPRuntime.getInstalledLocales();
        int n = 0;
        while (n < localeArray.length) {
            if (localeArray[n].getLanguage().equals(ToolsRes.resourceLocale.getLanguage())) {
                this.languageItems[n].setSelected(true);
            }
            ++n;
        }
    }

    protected boolean hasPastableData() {
        boolean bl;
        this.controlContainsData = false;
        String string = DataTool.paste();
        boolean bl2 = bl = string != null;
        if (bl) {
            if (!string.startsWith("<?xml")) {
                this.addableData = DataTool.parseData(string, null);
                bl = this.addableData != null;
            } else {
                this.control = new XMLControlElement();
                this.control.readXML(string);
                Class<?> clazz = this.control.getObjectClass();
                if (Data.class.isAssignableFrom(clazz)) {
                    this.addableData = (Data)this.control.loadObject(null);
                } else if (!DataToolTab.class.isAssignableFrom(clazz)) {
                    XMLTree xMLTree = new XMLTree(this.control);
                    xMLTree.setHighlightedClass(Data.class);
                    xMLTree.selectHighlightedProperties();
                    if (!xMLTree.getSelectedProperties().isEmpty()) {
                        this.controlContainsData = true;
                    }
                }
                bl = this.addableData != null || DataToolTab.class.isAssignableFrom(clazz) || this.controlContainsData;
            }
        }
        return bl;
    }

    protected boolean hasPastableColumns(DataToolTab dataToolTab) {
        boolean bl = false;
        if (this.addableData != null) {
            String string = this.addableData.getName();
            if (dataToolTab.dataManager.getDatasets().isEmpty() || string != null && !string.equals(dataToolTab.getName())) {
                bl = true;
            }
        }
        return bl || this.controlContainsData;
    }

    protected void showAboutDialog() {
        String string = String.valueOf(this.getName()) + " 1.5  March 2009\n" + "Code Author: Douglas Brown\n" + "Open Source Physics Project\n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(this, string, String.valueOf(ToolsRes.getString("Dialog.About.Title")) + " " + this.getName(), 1);
    }

    protected static JButton createButton(String string) {
        JButton jButton = new JButton(string){

            public Dimension getMaximumSize() {
                Dimension dimension = super.getMaximumSize();
                dimension.height = buttonHeight;
                return dimension;
            }
        };
        return jButton;
    }
}

