/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display3d.core.VisualizationHints;
import org.opensourcephysics.display3d.java3d.DrawingPanel3D;

public class VisualizationHints
implements org.opensourcephysics.display3d.core.VisualizationHints {
    static final int HINT_DECORATION_TYPE = 0;
    static final int HINT_REMOVE_HIDDEN_LINES = 1;
    static final int HINT_ALLOW_QUICK_REDRAW = 2;
    static final int HINT_USE_COLOR_DEPTH = 3;
    static final int HINT_CURSOR_TYPE = 4;
    static final int HINT_SHOW_COORDINATES = 5;
    static final int HINT_AXES_LABELS = 6;
    private boolean removeHiddenLines = true;
    private boolean allowQuickRedraw = true;
    private boolean useColorDepth = true;
    private int cursorType = 1;
    private int showCoordinates = 0;
    private int decorationType = 2;
    private String formatX = "x = 0.00;x = -0.00";
    private String formatY = "y = 0.00;y = -0.00";
    private String formatZ = "z = 0.00;z = -0.00";
    private String[] axesLabels = new String[]{"X", "Y", "Z"};
    private NumberFormat theFormatX = new DecimalFormat(this.formatX);
    private NumberFormat theFormatY = new DecimalFormat(this.formatY);
    private NumberFormat theFormatZ = new DecimalFormat(this.formatZ);
    private DrawingPanel3D panel;

    VisualizationHints(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
    }

    public void copyFrom(org.opensourcephysics.display3d.core.VisualizationHints visualizationHints) {
        this.decorationType = visualizationHints.getDecorationType();
        this.cursorType = visualizationHints.getCursorType();
        this.axesLabels = visualizationHints.getAxesLabels();
        this.removeHiddenLines = visualizationHints.isRemoveHiddenLines();
        this.allowQuickRedraw = visualizationHints.isAllowQuickRedraw();
        this.useColorDepth = visualizationHints.isUseColorDepth();
        this.showCoordinates = visualizationHints.getShowCoordinates();
        this.formatX = visualizationHints.getXFormat();
        if (this.formatX != null) {
            this.theFormatX = new DecimalFormat(this.formatX);
        }
        this.formatZ = visualizationHints.getYFormat();
        if (this.formatY != null) {
            this.theFormatY = new DecimalFormat(this.formatY);
        }
        this.formatZ = visualizationHints.getZFormat();
        if (this.formatZ != null) {
            this.theFormatZ = new DecimalFormat(this.formatZ);
        }
    }

    void setPanel(DrawingPanel3D drawingPanel3D) {
        this.panel = drawingPanel3D;
    }

    public void setCursorType(int n) {
        this.cursorType = n;
        if (this.panel != null) {
            this.panel.hintChanged(4);
        }
    }

    public final int getCursorType() {
        return this.cursorType;
    }

    public void setDecorationType(int n) {
        this.decorationType = n;
        if (this.panel != null) {
            this.panel.hintChanged(0);
        }
    }

    public final int getDecorationType() {
        return this.decorationType;
    }

    public final void setAxesLabels(String[] stringArray) {
        this.axesLabels = stringArray;
        if (this.panel != null) {
            this.panel.hintChanged(6);
        }
    }

    public final String[] getAxesLabels() {
        return this.axesLabels;
    }

    public void setRemoveHiddenLines(boolean bl) {
        this.removeHiddenLines = bl;
        if (this.panel != null) {
            this.panel.hintChanged(1);
        }
    }

    public final boolean isRemoveHiddenLines() {
        return this.removeHiddenLines;
    }

    public void setAllowQuickRedraw(boolean bl) {
        this.allowQuickRedraw = bl;
        if (this.panel != null) {
            this.panel.hintChanged(2);
        }
    }

    public final boolean isAllowQuickRedraw() {
        return this.allowQuickRedraw;
    }

    public void setUseColorDepth(boolean bl) {
        this.useColorDepth = bl;
        if (this.panel != null) {
            this.panel.hintChanged(3);
        }
    }

    public final boolean isUseColorDepth() {
        return this.useColorDepth;
    }

    public void setShowCoordinates(int n) {
        this.showCoordinates = n;
        if (this.panel != null) {
            this.panel.hintChanged(5);
        }
    }

    public int getShowCoordinates() {
        return this.showCoordinates;
    }

    public void setXFormat(String string) {
        this.formatX = string;
        if (this.formatX != null) {
            this.theFormatX = new DecimalFormat(this.formatX);
        }
    }

    public String getXFormat() {
        return this.formatX;
    }

    public void setYFormat(String string) {
        this.formatY = string;
        if (this.formatY != null) {
            this.theFormatY = new DecimalFormat(this.formatY);
        }
    }

    public String getYFormat() {
        return this.formatY;
    }

    public void setZFormat(String string) {
        this.formatZ = string;
        if (this.formatZ != null) {
            this.theFormatZ = new DecimalFormat(this.formatZ);
        }
    }

    public String getZFormat() {
        return this.formatZ;
    }

    public void displayPosition(int n, double[] dArray) {
        if (this.showCoordinates < 0) {
            return;
        }
        if (dArray == null) {
            this.panel.setMessage(null, this.showCoordinates);
            return;
        }
        String string = "";
        switch (n) {
            case 0: {
                if (this.formatX != null) {
                    string = this.theFormatX.format(dArray[0]);
                }
                if (this.formatY == null) break;
                string = String.valueOf(string) + ", " + this.theFormatY.format(dArray[1]);
                break;
            }
            case 1: {
                if (this.formatX != null) {
                    string = this.theFormatX.format(dArray[0]);
                }
                if (this.formatZ == null) break;
                string = String.valueOf(string) + ", " + this.theFormatZ.format(dArray[2]);
                break;
            }
            case 2: {
                if (this.formatY != null) {
                    string = this.theFormatY.format(dArray[1]);
                }
                if (this.formatZ == null) break;
                string = String.valueOf(string) + ", " + this.theFormatZ.format(dArray[2]);
                break;
            }
            default: {
                if (this.formatX != null) {
                    string = this.theFormatX.format(dArray[0]);
                }
                if (this.formatY != null) {
                    string = String.valueOf(string) + ", " + this.theFormatY.format(dArray[1]);
                }
                if (this.formatZ == null) break;
                string = String.valueOf(string) + ", " + this.theFormatZ.format(dArray[2]);
            }
        }
        if (string.startsWith(", ")) {
            string = string.substring(2);
        }
        this.panel.setMessage(string, this.showCoordinates);
    }

    public static XML.ObjectLoader getLoader() {
        return new VisualizationHintsLoader();
    }

    protected static class VisualizationHintsLoader
    extends VisualizationHints.Loader {
        protected VisualizationHintsLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new VisualizationHints(null);
        }
    }
}

