/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import java.awt.Color;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleFanArray;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.opensourcephysics.display3d.java3d.Element;

public class ElementPolygon
extends Element
implements org.opensourcephysics.display3d.core.ElementPolygon {
    private GeometryArray tsa;
    private double[][] data;
    private Shape3D shape;

    public ElementPolygon() {
        this.getStyle().setDrawingLines(false);
        this.getStyle().setLineColor(Color.black);
        this.getStyle().setFillColor(Color.blue);
        this.getAppearance().getPolygonAttributes().setCullFace(0);
        this.shape = new Shape3D();
        this.shape.setAppearance(this.getAppearance());
        this.setNode((Node)this.shape);
    }

    public boolean isClosed() {
        return true;
    }

    public void setClosed(boolean bl) {
    }

    public void setData(double[][] dArray) {
        this.data = dArray;
        int n = dArray.length + (this.isClosed() ? 1 : 0);
        this.tsa = new TriangleFanArray(n * 3, 3, new int[]{n});
        int n2 = 0;
        while (n2 < dArray.length) {
            this.tsa.setCoordinates(n2, dArray[n2]);
            ++n2;
        }
        if (this.isClosed()) {
            this.tsa.setCoordinates(n2, dArray[0]);
        }
        Vector3f vector3f = this.computeNormal();
        this.tsa.setNormal(0, vector3f);
        this.shape.setGeometry((Geometry)this.tsa);
    }

    public void setData(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null || dArray2 == null || dArray3 == null) {
            return;
        }
        int n = Math.max(dArray.length, Math.max(dArray2.length, dArray3.length));
        if (this.data.length != n) {
            this.data = new double[n][3];
        }
        if (dArray.length == dArray2.length && dArray.length == dArray3.length) {
            int n2 = 0;
            while (n2 < n) {
                this.data[n2][0] = dArray[n2];
                this.data[n2][1] = dArray2[n2];
                this.data[n2][2] = dArray3[n2];
                ++n2;
            }
        } else {
            double d = dArray[dArray.length - 1];
            double d2 = dArray2[dArray2.length - 1];
            double d3 = dArray3[dArray3.length - 1];
            int n3 = 0;
            while (n3 < n) {
                this.data[n3][0] = n3 < dArray.length ? dArray[n3] : d;
                this.data[n3][1] = n3 < dArray2.length ? dArray2[n3] : d2;
                this.data[n3][2] = n3 < dArray3.length ? dArray3[n3] : d3;
                ++n3;
            }
        }
        this.setData(this.data);
    }

    public double[][] getData() {
        double[][] dArray = new double[this.data.length][3];
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            System.arraycopy(this.data[n], 0, dArray[n], 0, 3);
            ++n;
        }
        return dArray;
    }

    private Vector3f computeNormal() {
        Vector3f vector3f = new Vector3f();
        vector3f.sub((Tuple3f)new Vector3f((float)this.data[0][0], (float)this.data[0][1], (float)this.data[0][2]), (Tuple3f)new Vector3f((float)this.data[1][0], (float)this.data[1][1], (float)this.data[1][2]));
        Vector3f vector3f2 = new Vector3f();
        vector3f2.sub((Tuple3f)new Vector3f((float)this.data[3][0], (float)this.data[3][1], (float)this.data[3][2]), (Tuple3f)new Vector3f((float)this.data[0][0], (float)this.data[0][1], (float)this.data[0][2]));
        Vector3f vector3f3 = new Vector3f();
        vector3f3.cross(vector3f2, vector3f);
        vector3f3.normalize();
        return vector3f3;
    }
}

