/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.TableModelEvent;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.EjsArrayPanel;
import org.opensourcephysics.display.TeXParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlArrayPanel
extends ControlSwingElement {
    private static final int ARRAY_PANEL_ADDED = 13;
    protected EjsArrayPanel panel;
    private boolean isStatic;
    protected ObjectValue dataValue;
    private static List<String> infoList = null;

    @Override
    protected Component createVisual() {
        this.panel = new EjsArrayPanel();
        double[][] dArrayArray = new double[][]{{0.0, 0.0}, {0.0, 0.0}};
        this.panel.setArray(dArrayArray);
        this.dataValue = new ObjectValue(dArrayArray);
        this.panel.setNumericFormat("0.00;-0.00");
        this.panel.setRowNumberVisible(true);
        this.panel.setEditable(true);
        this.panel.setFirstRowIndex(0);
        this.panel.setFirstColIndex(0);
        this.isStatic = false;
        this.panel.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("cell")) {
                    ControlArrayPanel.this.panel.saveLastEdit((TableModelEvent)propertyChangeEvent.getNewValue());
                    ControlArrayPanel.this.variableChanged(0, ControlArrayPanel.this.dataValue);
                    if (ControlArrayPanel.this.isUnderEjs) {
                        ControlArrayPanel.this.setFieldListValue(0, ControlArrayPanel.this.dataValue);
                    }
                }
            }
        });
        return this.panel;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("data");
            infoList.add("action");
            infoList.add("format");
            infoList.add("showRowNumber");
            infoList.add("columnNames");
            infoList.add("firstRowIndex");
            infoList.add("firstColIndex");
            infoList.add("editable");
            infoList.add("columnsLocked");
            infoList.add("static");
            infoList.add("transposed");
            infoList.add("alignment");
            infoList.add("columnWidth");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("data")) {
            return "int[]|int[][]|int[][][]|double[]|double[][]|double[][][]|boolean[]|boolean[][]|boolean[][][]|String[]|String[][]|String[][][]|Object";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("format")) {
            return "String|String[] TRANSLATABLE";
        }
        if (string.equals("showRowNumber")) {
            return "boolean";
        }
        if (string.equals("columnNames")) {
            return "String[] TRANSLATABLE";
        }
        if (string.equals("firstRowIndex")) {
            return "int";
        }
        if (string.equals("firstColIndex")) {
            return "int";
        }
        if (string.equals("editable")) {
            return "boolean";
        }
        if (string.equals("columnsLocked")) {
            return "boolean[]";
        }
        if (string.equals("static")) {
            return "boolean";
        }
        if (string.equals("transposed")) {
            return "boolean";
        }
        if (string.equals("alignment")) {
            return "Alignment|int|int[]";
        }
        if (string.equals("columnWidth")) {
            return "int|int[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                Object object = value.getObject();
                if (object != null && object != this.panel.getArray()) {
                    this.panel.setArray(object);
                    this.dataValue.value = object;
                    break;
                }
                this.panel.setFirstRowIndex(this.panel.getFirstRowIndex());
                if (this.isStatic) break;
                this.panel.refreshTable();
                break;
            }
            case 1: {
                this.removeAction(1, this.getProperty("action"));
                this.addAction(1, value.getString());
                break;
            }
            case 2: {
                if (value.getObject() instanceof String[]) {
                    this.panel.setNumericFormat((String[])value.getObject());
                    break;
                }
                String string = value.getString();
                if (string.indexOf(44) < 0) {
                    this.panel.setNumericFormat(string);
                    break;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                String[] stringArray = new String[stringTokenizer.countTokens()];
                int n2 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    stringArray[n2] = TeXParser.parseTeX(stringTokenizer.nextToken());
                    ++n2;
                }
                this.panel.setNumericFormat(stringArray);
                break;
            }
            case 3: {
                this.panel.setRowNumberVisible(value.getBoolean());
                break;
            }
            case 4: {
                this.panel.setColumnNames((String[])value.getObject());
                break;
            }
            case 5: {
                this.panel.setFirstRowIndex(value.getInteger());
                break;
            }
            case 6: {
                this.panel.setFirstColIndex(value.getInteger());
                break;
            }
            case 7: {
                this.panel.setEditable(value.getBoolean());
                break;
            }
            case 8: {
                if (!(value.getObject() instanceof boolean[])) break;
                boolean[] blArray = (boolean[])value.getObject();
                int n3 = 0;
                int n4 = blArray.length;
                while (n3 < n4) {
                    this.panel.setColumnLock(n3, blArray[n3]);
                    ++n3;
                }
                break;
            }
            case 9: {
                this.isStatic = value.getBoolean();
                break;
            }
            case 10: {
                this.panel.setTransposed(value.getBoolean());
                break;
            }
            case 11: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n5 = 0;
                    int n6 = nArray.length;
                    while (n5 < n6) {
                        this.panel.setColumnAlignment(n5, nArray[n5]);
                        ++n5;
                    }
                } else {
                    this.panel.setColumnAlignment(value.getInteger());
                }
                if (!this.isUnderEjs) break;
                this.panel.repaint();
                break;
            }
            case 12: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n7 = 0;
                    int n8 = nArray.length;
                    while (n7 < n8) {
                        this.panel.setPreferredColumnWidth(n7, nArray[n7]);
                        ++n7;
                    }
                } else {
                    this.panel.setPreferredColumnWidth(value.getInteger());
                }
                if (!this.isUnderEjs) break;
                this.panel.repaint();
                break;
            }
            default: {
                super.setValue(n - 13, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.panel.setArray(new double[][]{{0.0, 0.0}, {0.0, 0.0}});
                break;
            }
            case 1: {
                this.removeAction(1, this.getProperty("action"));
                break;
            }
            case 2: {
                this.panel.setNumericFormat("0.00;-0.00");
                break;
            }
            case 3: {
                this.panel.setRowNumberVisible(true);
                break;
            }
            case 4: {
                this.panel.setColumnNames((String[])null);
                break;
            }
            case 5: {
                this.panel.setFirstRowIndex(0);
                break;
            }
            case 6: {
                this.panel.setFirstColIndex(0);
                break;
            }
            case 7: {
                this.panel.setEditable(true);
                break;
            }
            case 8: {
                int n2 = 0;
                int n3 = this.panel.getNumColumns();
                while (n2 < n3) {
                    this.panel.setColumnLock(n2, true);
                    ++n2;
                }
                break;
            }
            case 9: {
                this.isStatic = false;
                break;
            }
            case 10: {
                this.panel.setTransposed(false);
                break;
            }
            case 11: {
                this.panel.setColumnAlignment(4);
                break;
            }
            case 12: {
                break;
            }
            default: {
                super.setDefaultValue(n - 13);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.dataValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
        }
        return super.getValue(n - 13);
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "{{0.0,0.0},{0.0,0.0}}";
            }
            case 1: {
                return "<no_action>";
            }
            case 2: {
                return "0.00;-0.00";
            }
            case 3: {
                return "true";
            }
            case 4: {
                return "<none>";
            }
            case 5: {
                return "0";
            }
            case 6: {
                return "0";
            }
            case 7: {
                return "true";
            }
            case 8: {
                return "true";
            }
            case 9: {
                return "false";
            }
            case 10: {
                return "false";
            }
            case 11: {
                return "RIGHT";
            }
            case 12: {
                return "<none>";
            }
        }
        return super.getDefaultValueString(n - 13);
    }
}

