/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.tools.Translator;

public class OSPRuntime {
    static String version = "2.0";
    static String releaseDate = "December 8, 2008";
    public static volatile boolean disableAllDrawing = false;
    public static boolean loadVideoTool = true;
    public static boolean loadExportTool = true;
    public static boolean loadDataTool = true;
    public static boolean loadFourierTool = true;
    public static boolean loadTranslatorTool = true;
    public static boolean loadOSPLog = true;
    private static Translator translator;
    public static Locale[] defaultLocales;
    protected static boolean launcherMode;
    public static Boolean antiAliasText;
    public static boolean appletMode;
    public static JApplet applet;
    public static boolean webStart;
    protected static boolean authorMode;
    private static String launchJarPath;
    private static String launchJarName;
    private static JarFile launchJar;
    private static String buildDate;
    public static String chooserDir;
    public static final String OSP_ICON_FILE = "/org/opensourcephysics/resources/controls/images/osp_icon.gif";
    public static boolean launchingInSingleVM;
    public static final String CROSS_PLATFORM_LF = "CROSS_PLATFORM";
    public static final String NIMBUS_LF = "NIMBUS";
    public static final String SYSTEM_LF = "SYSTEM";
    public static final String METAL_LF = "METAL";
    public static final String GTK_LF = "GTK";
    public static final String MOTIF_LF = "MOTIF";
    public static final String WINDOWS_LF = "WINDOWS";
    public static final String DEFAULT_LF = "DEFAULT";
    public static final LookAndFeel DEFAULT_LOOK_AND_FEEL;
    public static final boolean DEFAULT_LOOK_AND_FEEL_DECORATIONS;
    public static final HashMap<String, String> LOOK_AND_FEEL_TYPES;
    private static JFileChooser chooser;

    static {
        defaultLocales = new Locale[]{Locale.ENGLISH, new Locale("es"), new Locale("de"), new Locale("da"), new Locale("sk"), Locale.TAIWAN};
        launcherMode = false;
        antiAliasText = false;
        authorMode = true;
        launchJar = null;
        DEFAULT_LOOK_AND_FEEL = UIManager.getLookAndFeel();
        DEFAULT_LOOK_AND_FEEL_DECORATIONS = JFrame.isDefaultLookAndFeelDecorated();
        LOOK_AND_FEEL_TYPES = new HashMap();
        try {
            chooserDir = System.getProperty("user.dir", null);
        }
        catch (Exception exception) {
            chooserDir = null;
        }
        LOOK_AND_FEEL_TYPES.put(METAL_LF, "javax.swing.plaf.metal.MetalLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(NIMBUS_LF, "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(GTK_LF, "com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(MOTIF_LF, "com.sun.java.swing.plaf.motif.MotifLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(WINDOWS_LF, "com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
        LOOK_AND_FEEL_TYPES.put(CROSS_PLATFORM_LF, UIManager.getCrossPlatformLookAndFeelClassName());
        LOOK_AND_FEEL_TYPES.put(SYSTEM_LF, UIManager.getSystemLookAndFeelClassName());
        LOOK_AND_FEEL_TYPES.put(DEFAULT_LF, DEFAULT_LOOK_AND_FEEL.getClass().getName());
    }

    private OSPRuntime() {
    }

    public static void showAboutDialog(Component component) {
        String string = "OSP Library " + version + " released " + releaseDate + "\n" + "Open Source Physics Project \n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(component, string, "About Open Source Physics", 1);
    }

    public static boolean setLookAndFeel(boolean bl, String string) {
        boolean bl2 = true;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        try {
            if (string == null || string.equals(DEFAULT_LF)) {
                UIManager.setLookAndFeel(DEFAULT_LOOK_AND_FEEL);
                bl = DEFAULT_LOOK_AND_FEEL_DECORATIONS;
            } else if (string.equals(CROSS_PLATFORM_LF)) {
                string = UIManager.getCrossPlatformLookAndFeelClassName();
                UIManager.setLookAndFeel(string);
            } else if (string.equals(SYSTEM_LF)) {
                string = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(string);
            } else if (string.equals(NIMBUS_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
            } else if (string.equals(METAL_LF)) {
                UIManager.setLookAndFeel(new MetalLookAndFeel());
            } else if (string.equals(GTK_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
            } else if (string.equals(MOTIF_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
            } else if (string.equals(WINDOWS_LF)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            } else {
                UIManager.setLookAndFeel(string);
            }
            JFrame.setDefaultLookAndFeelDecorated(bl);
            JDialog.setDefaultLookAndFeelDecorated(bl);
        }
        catch (Exception exception) {
            bl2 = false;
        }
        if (!bl2) {
            try {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (Exception exception) {}
        }
        return bl2;
    }

    public static boolean isDefaultLookAndFeelDecorated() {
        return JFrame.isDefaultLookAndFeelDecorated();
    }

    public static boolean isWindows() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("windows");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isMac() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("mac");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isLinux() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("linux");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isVista() {
        return System.getProperty("os.name", "").toLowerCase().indexOf("vista") > -1;
    }

    public static boolean isPopupTrigger(InputEvent inputEvent) {
        if (inputEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)inputEvent;
            return mouseEvent.isPopupTrigger() || mouseEvent.getButton() == 3 || mouseEvent.isControlDown() && OSPRuntime.isMac();
        }
        return false;
    }

    public static boolean isWebStart() {
        if (!webStart) {
            try {
                webStart = System.getProperty("javawebstart.version") != null;
            }
            catch (Exception exception) {}
        }
        return webStart;
    }

    public static boolean isAppletMode() {
        return appletMode;
    }

    public static boolean isAuthorMode() {
        return authorMode;
    }

    public static void setAuthorMode(boolean bl) {
        authorMode = bl;
    }

    public static void setLauncherMode(boolean bl) {
        launcherMode = bl;
    }

    public static boolean isLauncherMode() {
        return launcherMode;
    }

    public static void setLaunchJarPath(String string) {
        if (string == null || launchJarPath != null) {
            return;
        }
        if (!string.endsWith(".jar") && !string.endsWith(".exe")) {
            int n = string.indexOf(".jar!");
            if (n == -1) {
                n = string.indexOf(".exe!");
            }
            if (n > -1) {
                string = string.substring(0, n + 4);
            } else {
                return;
            }
        }
        launchJarPath = string;
        launchJarName = string.substring(string.lastIndexOf("/") + 1);
    }

    public static String getLaunchJarName() {
        return launchJarName;
    }

    public static String getLaunchJarPath() {
        return launchJarPath;
    }

    public static String getLaunchJarDirectory() {
        if (applet != null) {
            return null;
        }
        return launchJarPath == null ? null : XML.getDirectoryPath(launchJarPath);
    }

    public static JarFile getLaunchJar() {
        if (launchJar != null) {
            return launchJar;
        }
        if (launchJarPath == null) {
            return null;
        }
        boolean bl = launchJarPath.startsWith("http:");
        try {
            if (applet == null && !bl) {
                launchJar = new JarFile(launchJarPath);
            } else {
                URL uRL = bl ? new URL("jar:" + launchJarPath + "!/") : new URL("jar:file:/" + launchJarPath + "!/");
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                launchJar = jarURLConnection.getJarFile();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return launchJar;
    }

    public static String getLaunchJarBuildDate() {
        if (buildDate == null) {
            try {
                JarFile jarFile = OSPRuntime.getLaunchJar();
                Attributes attributes = jarFile.getManifest().getMainAttributes();
                buildDate = attributes.getValue("Build-Date");
            }
            catch (Exception exception) {}
        }
        return buildDate;
    }

    public static Locale[] getDefaultLocales() {
        return defaultLocales;
    }

    public static Locale[] getInstalledLocales() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        TreeMap<String, Locale> treeMap = new TreeMap<String, Locale>();
        arrayList.add(Locale.ENGLISH);
        if (OSPRuntime.getLaunchJarPath() != null) {
            JarFile jarFile = OSPRuntime.getLaunchJar();
            if (jarFile != null) {
                Object object2 = jarFile.entries();
                while (object2.hasMoreElements()) {
                    Locale locale;
                    int n;
                    JarEntry jarEntry = object2.nextElement();
                    String string = jarEntry.toString();
                    int n2 = string.indexOf(".properties");
                    if (string.indexOf(".properties") <= -1 || (n = string.indexOf("display_res_")) <= -1) continue;
                    String string2 = string.substring(n + 12, n2);
                    if (string2.equals("zh_TW")) {
                        locale = Locale.TAIWAN;
                        treeMap.put(locale.getDisplayLanguage(locale).toLowerCase(), locale);
                        continue;
                    }
                    if (string2.equals("en_US") || (locale = new Locale(string2)).equals(Locale.ENGLISH)) continue;
                    treeMap.put(locale.getDisplayLanguage(locale).toLowerCase(), locale);
                }
                for (Object object2 : treeMap.keySet()) {
                    arrayList.add((Locale)treeMap.get(object2));
                }
            } else {
                defaultLocales = new Locale[]{Locale.ENGLISH};
                return defaultLocales;
            }
        }
        return arrayList.toArray(new Locale[0]);
    }

    public static Translator getTranslator() {
        if (translator == null && loadTranslatorTool) {
            try {
                Class<?> clazz = Class.forName("org.opensourcephysics.tools.TranslatorTool");
                Method method = clazz.getMethod("getTool", null);
                translator = (Translator)method.invoke(null, null);
            }
            catch (Exception exception) {
                loadTranslatorTool = false;
                OSPLog.finest("Cannot instantiate translator tool class:\n" + exception.toString());
            }
        }
        return translator;
    }

    public static JFileChooser getChooser() {
        if (chooser != null) {
            return chooser;
        }
        try {
            chooser = chooserDir == null ? new JFileChooser() : new JFileChooser(new File(chooserDir));
        }
        catch (Exception exception) {
            System.err.println("Exception in OSPFrame getChooser=" + exception);
            return null;
        }
        FileFilter fileFilter = chooser.getFileFilter();
        FileFilter fileFilter2 = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string != null && string.equals("xml");
            }

            public String getDescription() {
                return DisplayRes.getString("OSPRuntime.FileFilter.Description.XML");
            }
        };
        FileFilter fileFilter3 = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string != null && string.equals("txt");
            }

            public String getDescription() {
                return DisplayRes.getString("OSPRuntime.FileFilter.Description.TXT");
            }
        };
        chooser.addChoosableFileFilter(fileFilter2);
        chooser.addChoosableFileFilter(fileFilter3);
        chooser.setFileFilter(fileFilter);
        return chooser;
    }

    public static String chooseFilename(JFileChooser jFileChooser) {
        return OSPRuntime.chooseFilename(jFileChooser, null, true);
    }

    public static String chooseFilename(JFileChooser jFileChooser, Component component, boolean bl) {
        String string = null;
        int n = bl ? jFileChooser.showSaveDialog(component) : jFileChooser.showOpenDialog(component);
        if (n == 0) {
            chooserDir = jFileChooser.getCurrentDirectory().toString();
            File file = jFileChooser.getSelectedFile();
            if (bl) {
                int n2;
                if (file.exists() && (n2 = JOptionPane.showConfirmDialog(component, String.valueOf(DisplayRes.getString("DrawingFrame.ReplaceExisting_message")) + " " + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
                    return null;
                }
            } else if (!file.exists()) {
                JOptionPane.showMessageDialog(component, String.valueOf(DisplayRes.getString("GUIUtils.FileDoesntExist")) + " " + file.getName(), DisplayRes.getString("GUIUtils.FileChooserError"), 0);
                return null;
            }
            if ((string = file.getAbsolutePath()) == null || string.trim().equals("")) {
                return null;
            }
        }
        return string;
    }

    public static JFileChooser createChooser(String string, String string2, String[] stringArray) {
        JFileChooser jFileChooser = OSPRuntime.createChooser(string2, stringArray, null);
        jFileChooser.setDialogTitle(string);
        return jFileChooser;
    }

    public static JFileChooser createChooser(String string, String[] stringArray) {
        return OSPRuntime.createChooser(string, stringArray, null);
    }

    public static JFileChooser createChooser(String string, String[] stringArray, final File file) {
        JFileChooser jFileChooser = new JFileChooser(new File(chooserDir));
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter();
        int n = 0;
        while (n < stringArray.length) {
            extensionFileFilter.addExtension(stringArray[n]);
            ++n;
        }
        extensionFileFilter.setDescription(string);
        if (file != null) {
            jFileChooser.setFileSystemView(new FileSystemView(){

                public File createNewFolder(File file2) throws IOException {
                    return FileSystemView.getFileSystemView().createNewFolder(file2);
                }

                public File getHomeDirectory() {
                    return file;
                }
            });
        }
        jFileChooser.setFileFilter(extensionFileFilter);
        return jFileChooser;
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private String description = "";
        private ArrayList<String> extensions = new ArrayList();

        private ExtensionFileFilter() {
        }

        public void addExtension(String string) {
            if (!string.startsWith(".")) {
                string = "." + string;
            }
            this.extensions.add(string.toLowerCase());
        }

        public String toString() {
            return this.description;
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toLowerCase();
            int n = 0;
            while (n < this.extensions.size()) {
                if (string.endsWith(this.extensions.get(n))) {
                    return true;
                }
                ++n;
            }
            return false;
        }
    }
}

