/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.simple3d;

import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.drawing3d.DrawingPanel3D;
import org.opensourcephysics.drawing3d.ElementTrail;
import org.opensourcephysics.drawing3d.simple3d.Object3D;
import org.opensourcephysics.drawing3d.simple3d.SimpleElement;

public class SimpleElementTrail
extends SimpleElement {
    private static final int DEFAULT_SIZE = 100;
    private int[] connected;
    private int[] aCoord;
    private int[] bCoord;
    private double[][] points;
    private double[] pixel = new double[3];
    private List<ElementTrail.TrailPoint> trailPointsList = new ArrayList<ElementTrail.TrailPoint>();

    public SimpleElementTrail(ElementTrail elementTrail) {
        super(elementTrail);
        this.allocateArrays(100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChanges(int n, int n2) {
        if ((n2 & 8) != 0) {
            List<ElementTrail.TrailPoint> list;
            this.trailPointsList.clear();
            List<ElementTrail.TrailPoint> list2 = list = ((ElementTrail)this.element).getDisplayPoints();
            synchronized (list2) {
                this.trailPointsList.addAll(list);
            }
            int n3 = this.trailPointsList.size();
            if (n3 >= this.objects.length) {
                this.allocateArrays(this.objects.length + 100);
            } else if (n3 <= 0 && this.objects.length > 100) {
                this.allocateArrays(100);
            }
            this.computePositions();
            this.projectPoints();
        }
        if ((n2 & 0x136) != 0) {
            this.computePositions();
            this.projectPoints();
        } else if ((n2 & 0x40) != 0) {
            this.projectPoints();
        }
    }

    public void draw(Graphics2D graphics2D, int n) {
        graphics2D.setStroke(this.style.getLineStroke());
        graphics2D.setColor(this.element.getPanel().projectColor(this.style.getLineColor(), this.objects[n].getDistance()));
        if (n == 0 || this.connected[n] == 0) {
            graphics2D.drawLine(this.aCoord[n], this.bCoord[n], this.aCoord[n], this.bCoord[n]);
        } else {
            graphics2D.drawLine(this.aCoord[n], this.bCoord[n], this.aCoord[n - 1], this.bCoord[n - 1]);
        }
    }

    public void drawQuickly(Graphics2D graphics2D) {
        graphics2D.setStroke(this.style.getLineStroke());
        graphics2D.setColor(this.style.getLineColor());
        int n = this.trailPointsList.size();
        if (n == 0) {
            return;
        }
        int n2 = this.aCoord[0];
        int n3 = this.bCoord[0];
        graphics2D.drawLine(n2, n3, n2, n3);
        int n4 = 1;
        while (n4 < n) {
            int n5 = this.aCoord[n4];
            int n6 = this.bCoord[n4];
            switch (this.connected[n4]) {
                default: {
                    graphics2D.drawLine(n5, n6, n2, n3);
                    break;
                }
                case 0: {
                    graphics2D.drawLine(n5, n6, n5, n6);
                }
            }
            n2 = n5;
            n3 = n6;
            ++n4;
        }
    }

    private void allocateArrays(int n) {
        this.objects = new Object3D[n];
        this.points = new double[n][3];
        this.connected = new int[n];
        this.aCoord = new int[n];
        this.bCoord = new int[n];
        int n2 = 0;
        while (n2 < n) {
            this.objects[n2] = new Object3D(this, n2);
            ++n2;
        }
    }

    private void computePositions() {
        int n = this.trailPointsList.size();
        int n2 = 0;
        while (n2 < n) {
            ElementTrail.TrailPoint trailPoint = this.trailPointsList.get(n2);
            System.arraycopy(trailPoint.getPoint(), 0, this.points[n2], 0, 3);
            this.element.sizeAndToSpaceFrame(this.points[n2]);
            this.connected[n2] = trailPoint.getType();
            ++n2;
        }
    }

    private void projectPoints() {
        DrawingPanel3D drawingPanel3D = this.element.getPanel();
        int n = this.trailPointsList.size();
        int n2 = 0;
        while (n2 < n) {
            System.arraycopy(this.points[n2], 0, this.pixel, 0, 3);
            drawingPanel3D.projectPosition(this.pixel);
            this.aCoord[n2] = (int)this.pixel[0];
            this.bCoord[n2] = (int)this.pixel[1];
            this.objects[n2].setDistance(this.pixel[2] * this.style.getDepthFactor());
            ++n2;
        }
    }
}

