/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing3d.java3d;

import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.LineStripArray;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TriangleStripArray;
import javax.vecmath.Point3d;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.opensourcephysics.drawing3d.ElementPolygon;
import org.opensourcephysics.drawing3d.java3d.Java3dElement;

public class Java3dElementPolygon
extends Java3dElement {
    private GeometryArray tsa = null;
    private Shape3D shape = null;
    private TexCoord2f[] texCoord = null;
    private Point3d[] coords = null;
    private BranchGroup bg = null;

    public Java3dElementPolygon(ElementPolygon elementPolygon) {
        super(elementPolygon);
        this.getAppearance().getPolygonAttributes().setCullFace(0);
        this.getAppearance().getLineAttributes().setLineAntialiasingEnable(false);
        this.shape = new Shape3D();
        this.shape.setAppearance(this.getAppearance());
    }

    public void processChanges(int n, int n2) {
        super.processChanges(n, n2);
        if ((n & 8) != 0) {
            this.computePolygon();
        }
    }

    private void computePolygon() {
        int n = ((ElementPolygon)this.element).getData().length;
        if (n <= 1) {
            return;
        }
        this.coords = new Point3d[n * 2];
        this.texCoord = new TexCoord2f[n * 2];
        int n2 = 0;
        while (n2 < n) {
            this.coords[n2] = new Point3d(((ElementPolygon)this.element).getData()[n2][0], ((ElementPolygon)this.element).getData()[n2][1], ((ElementPolygon)this.element).getData()[n2][2]);
            this.coords[n * 2 - n2 - 1] = new Point3d(((ElementPolygon)this.element).getData()[n2][0], ((ElementPolygon)this.element).getData()[n2][1], ((ElementPolygon)this.element).getData()[n2][2]);
            if (n2 == 0 || n2 % 3 == 0) {
                this.texCoord[n2] = new TexCoord2f(0.0f, 0.0f);
                this.texCoord[n * 2 - n2 - 1] = new TexCoord2f(0.0f, 0.0f);
            } else if (n2 % 2 == 0) {
                this.texCoord[n2] = new TexCoord2f(1.0f, 0.0f);
                this.texCoord[n * 2 - n2 - 1] = new TexCoord2f(1.0f, 0.0f);
            } else {
                this.texCoord[n2] = new TexCoord2f(0.5f, 0.5f);
                this.texCoord[n * 2 - n2 - 1] = new TexCoord2f(0.5f, 0.5f);
            }
            ++n2;
        }
        this.addShape();
    }

    private void addShape() {
        if (this.coords == null) {
            return;
        }
        int n = ((ElementPolygon)this.element).getData().length;
        if (((ElementPolygon)this.element).isClosed()) {
            int n2 = 39;
            TriangleStripArray triangleStripArray = new TriangleStripArray(n * 2, n2, new int[]{Math.max(2, n * 2)});
            Vector3f[] vector3fArray = this.createNormals(((ElementPolygon)this.element).getData());
            int n3 = 0;
            while (n3 < n) {
                triangleStripArray.setCoordinate(n3, this.coords[n3]);
                triangleStripArray.setNormal(n3, vector3fArray[n3]);
                triangleStripArray.setTextureCoordinate(0, n3, this.texCoord[n3]);
                triangleStripArray.setCoordinate(n * 2 - n3 - 1, this.coords[n * 2 - n3 - 1]);
                triangleStripArray.setNormal(n * 2 - n3 - 1, Java3dElementPolygon.opposite(vector3fArray[n3]));
                triangleStripArray.setTextureCoordinate(0, n * 2 - n3 - 1, this.texCoord[n * 2 - n3 - 1]);
                ++n3;
            }
            this.tsa = triangleStripArray;
        } else {
            LineStripArray lineStripArray = new LineStripArray(((ElementPolygon)this.element).getDataArray().length, 37, new int[]{((ElementPolygon)this.element).getData().length});
            int n4 = 0;
            while (n4 < ((ElementPolygon)this.element).getData().length) {
                lineStripArray.setCoordinate(n4, this.coords[n4]);
                lineStripArray.setTextureCoordinate(0, n4, this.texCoord[n4]);
                ++n4;
            }
            this.tsa = lineStripArray;
        }
        this.shape = new Shape3D((Geometry)this.tsa, this.getAppearance());
        this.bg = new BranchGroup();
        this.bg.setCapability(17);
        this.bg.addChild((Node)this.shape);
        this.addNode((Node)this.bg);
    }

    private Vector3f[] createNormals(double[][] dArray) {
        int n = dArray.length;
        Vector3f[] vector3fArray = new Vector3f[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            if (n3 != 0 && n3 % 3 == 0) {
                n2 += 2;
            }
            Vector3f vector3f = new Vector3f();
            vector3f.sub((Tuple3f)new Vector3f((float)dArray[n2][0], (float)dArray[n2][1], (float)dArray[n2][2]), (Tuple3f)new Vector3f((float)dArray[n2 + 1][0], (float)dArray[n2 + 1][1], (float)dArray[n2 + 1][2]));
            Vector3f vector3f2 = new Vector3f();
            vector3f2.sub((Tuple3f)new Vector3f((float)dArray[n2 + 1][0], (float)dArray[n2 + 1][1], (float)dArray[n2 + 1][2]), (Tuple3f)new Vector3f((float)dArray[n2 + 2][0], (float)dArray[n2 + 2][1], (float)dArray[n2 + 2][2]));
            vector3fArray[n3] = new Vector3f();
            vector3fArray[n3].cross(vector3f2, vector3f);
            vector3fArray[n3].normalize();
            ++n3;
        }
        return vector3fArray;
    }

    private static Vector3f opposite(Vector3f vector3f) {
        Vector3f vector3f2 = new Vector3f();
        vector3f2.x = -vector3f.x;
        vector3f2.y = -vector3f.y;
        vector3f2.z = -vector3f.z;
        return vector3f2;
    }

    public boolean isPrimitive() {
        return true;
    }
}

