/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.drawing3d.ControlElement3D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing3d.utils.OptionalTransformation;
import org.opensourcephysics.numerics.Matrix3DTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlTransformation3D
extends ControlElement
implements OptionalTransformation {
    public static final int TR3D_NAME = 0;
    public static final int TR3D_PARENT = 1;
    public static final int TR3D_ENABLED = 2;
    public static final int TR3D_POSITION = 3;
    protected Matrix3DTransformation transformation = this.createTransformation();
    protected ControlElement3D myParent = null;
    protected boolean enabled = true;
    protected double[] origin = new double[]{0.0, 0.0, 0.0};
    private static List<String> infoList = null;

    protected Matrix3DTransformation createTransformation() {
        return Matrix3DTransformation.rotationX(0.0);
    }

    @Override
    public Object getObject() {
        return this.transformation;
    }

    @Override
    public String getObjectClassname() {
        return "org.opensourcephysics.numerics.Matrix3DTransformation";
    }

    public final void setParent(ControlElement3D controlElement3D) {
        if (this.myParent != null) {
            this.myParent.getElement().removeSecondaryTransformation(this);
        }
        if (controlElement3D != null) {
            this.myParent = controlElement3D;
            String string = this.getProperty("_ejs_indexInParent_");
            int n = -1;
            if (string != null) {
                n = Integer.parseInt(string);
            }
            this.setProperty("_ejs_indexInParent_", null);
            if (n >= 0) {
                this.myParent.getElement().addSecondaryTransformation(this, n);
            } else {
                this.myParent.getElement().addSecondaryTransformation(this);
            }
            this.myParent.updatePanel();
        }
    }

    public final ControlElement3D getParent() {
        return this.myParent;
    }

    @Override
    public final boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public final void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("name");
            infoList.add("parent");
            infoList.add("enabled");
            infoList.add("position");
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("name")) {
            return "String CONSTANT";
        }
        if (string.equals("parent")) {
            return "ControlElement CONSTANT";
        }
        if (string.equals("enabled")) {
            return "boolean";
        }
        if (string.equals("position")) {
            return "double[]";
        }
        return null;
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                super.setValue(0, value);
                break;
            }
            case 1: {
                ControlElement controlElement = this.myGroup.getElement(this.getProperty("parent"));
                if (controlElement != null) {
                    this.setParent(null);
                }
                if ((controlElement = this.myGroup.getElement(value.toString())) == null) {
                    System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> not found for " + this.toString());
                    break;
                }
                if (controlElement instanceof ControlElement3D) {
                    this.setParent((ControlElement3D)controlElement);
                    break;
                }
                System.err.println(String.valueOf(this.getClass().getName()) + " : Error! Parent <" + value + "> is not a ControlElements3DParent");
                break;
            }
            case 2: {
                this.enabled = value.getBoolean();
                if (this.myParent == null) break;
                this.myParent.getElement().addChange(256);
                break;
            }
            case 3: {
                double[] dArray = this.origin;
                if (value.getObject() instanceof double[]) {
                    dArray = (double[])value.getObject();
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    dArray = new double[]{nArray[0], nArray[1], nArray[2]};
                }
                if (dArray.equals(this.origin)) break;
                this.origin = dArray;
                this.transformation.setOrigin(dArray);
                if (this.myParent == null) break;
                this.myParent.getElement().addChange(256);
                if (!this.isUnderEjs) break;
                this.myParent.updatePanel();
                break;
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                super.setDefaultValue(0);
                break;
            }
            case 1: {
                if (this.myGroup.getElement(this.getProperty("parent")) == null) break;
                this.setParent(null);
                break;
            }
            case 2: {
                this.enabled = true;
                if (this.myParent == null) break;
                this.myParent.getElement().addChange(256);
                break;
            }
            case 3: {
                this.origin = new double[]{0.0, 0.0, 0.0};
                this.transformation.setOrigin(this.origin);
                if (this.myParent == null) break;
                this.myParent.getElement().addChange(256);
                if (!this.isUnderEjs) break;
                this.myParent.updatePanel();
                break;
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return "<none>";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "new double[]{0,0,0}";
            }
        }
        return "<none>";
    }

    @Override
    public Value getValue(int n) {
        return null;
    }

    @Override
    public Object clone() {
        ControlTransformation3D controlTransformation3D = new ControlTransformation3D();
        controlTransformation3D.enabled = this.enabled;
        controlTransformation3D.transformation = (Matrix3DTransformation)this.transformation.clone();
        controlTransformation3D.myParent = null;
        controlTransformation3D.origin = (double[])this.origin.clone();
        return controlTransformation3D;
    }

    @Override
    public double[] direct(double[] dArray) {
        if (this.enabled) {
            return this.transformation.direct(dArray);
        }
        return dArray;
    }

    @Override
    public double[] inverse(double[] dArray) throws UnsupportedOperationException {
        if (this.enabled) {
            return this.transformation.inverse(dArray);
        }
        return dArray;
    }
}

