/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import org.opensourcephysics.display3d.jogl.ElementCone;
import org.opensourcephysics.display3d.jogl.ElementSegment;
import org.opensourcephysics.numerics.Vec3D;

public class ElementArrow
extends ElementSegment
implements org.opensourcephysics.display3d.core.ElementArrow {
    public double headScale = 0.05;
    private ElementCone cone = new ElementCone();

    public ElementArrow() {
        this.setSizeXYZ(1.0, 1.0, 1.0);
        this.getStyle().setResolution(this.cone.style.getResolution());
        this.getStyle().setDrawingLines(false);
        this.cone.style = this.getStyle();
    }

    void draw(GLAutoDrawable gLAutoDrawable) {
        if (!this.isVisible()) {
            return;
        }
        double d = Math.sqrt(this.getSize().magnitude());
        this.cone.setSizeXYZ(d * this.headScale, d * this.headScale, d * this.headScale);
        Vec3D vec3D = new Vec3D(0.0, 0.0, 1.0);
        Vec3D vec3D2 = new Vec3D(this.getSize());
        vec3D2.normalize();
        this.cone.getRotation().angle = Math.toDegrees(Math.acos(vec3D.dot(vec3D2)));
        vec3D.cross(vec3D, this.getSize());
        this.cone.getRotation().setAxis(vec3D);
        vec3D2.multiply(vec3D2, this.cone.getSizeZ() / 2.0);
        vec3D2.subtract(this.getSize(), vec3D2);
        this.cone.setPosition(vec3D2);
        GL gL = gLAutoDrawable.getGL();
        gL.glPushMatrix();
        this.transform(gLAutoDrawable.getGL());
        this.cone.draw(gLAutoDrawable);
        gL.glPopMatrix();
        boolean bl = this.getStyle().isDrawingLines();
        this.getStyle().setDrawingLines(true);
        super.draw(gLAutoDrawable);
        this.getStyle().setDrawingLines(bl);
        this.setElementChanged(false);
    }
}

