/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.jogl;

import com.sun.opengl.util.BufferUtil;
import com.sun.opengl.util.GLUT;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCanvas;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLException;
import javax.media.opengl.glu.GLU;
import javax.swing.JFrame;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.display.Renderable;
import org.opensourcephysics.display3d.core.DrawingPanel3D;
import org.opensourcephysics.display3d.core.Resolution;
import org.opensourcephysics.display3d.core.interaction.InteractionEvent;
import org.opensourcephysics.display3d.core.interaction.InteractionListener;
import org.opensourcephysics.display3d.jogl.Camera;
import org.opensourcephysics.display3d.jogl.Element;
import org.opensourcephysics.display3d.jogl.ElementArrow;
import org.opensourcephysics.display3d.jogl.ElementBox;
import org.opensourcephysics.display3d.jogl.ElementSegment;
import org.opensourcephysics.display3d.jogl.ElementText;
import org.opensourcephysics.display3d.jogl.Group;
import org.opensourcephysics.display3d.jogl.InteractionTarget;
import org.opensourcephysics.display3d.jogl.TextPanel;
import org.opensourcephysics.display3d.jogl.VisualizationHints;
import org.opensourcephysics.display3d.jogl.utils.GLTools;
import org.opensourcephysics.numerics.Vec3D;
import org.opensourcephysics.tools.VideoTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DrawingPanel3D
implements org.opensourcephysics.display3d.core.DrawingPanel3D,
GLEventListener,
MouseListener,
MouseMotionListener,
KeyListener,
Renderable {
    private List<org.opensourcephysics.display3d.core.Element> elements;
    public GLCanvas canvas;
    private VisualizationHints visHints;
    private JFrame parent;
    private int width;
    private int height;
    private int keyPressed = -1;
    private Camera camera;
    private ElementArrow xAxis;
    private ElementArrow yAxis;
    private ElementArrow zAxis;
    private ElementText xText;
    private ElementText yText;
    private ElementText zText;
    private ElementBox box;
    public static GLUT GLUT;
    private float[] staticLightPosition;
    private boolean quickRedrawOn = false;
    private boolean sKeyDown = false;
    private boolean smoothLines = true;
    private boolean squareAspect = true;
    private double maxObjectDistance = 5000.0;
    private boolean requestingPickingUpdate = false;
    private MouseEvent lastMotionEvent;
    private InteractionTarget lastPickedTarget;
    private final InteractionTarget myTarget = new InteractionTarget(null, 0);
    private int trackersVisible;
    private InteractionTarget targetHit = null;
    private InteractionTarget targetEntered = null;
    private double[] trackerPoint = null;
    private List<InteractionListener> listeners = new ArrayList<InteractionListener>();
    private ElementSegment[] trackerLines = null;
    private double aconstant;
    private double bconstant;
    private boolean requestingImageRender = false;
    private BufferedImage renderTo;
    private double factorX = 1.0;
    private double factorY = 1.0;
    private double factorZ = 1.0;
    private static int axisMode;
    private String imageFile = null;
    protected TextPanel[] messageBoxes = new TextPanel[4];
    protected VideoTool vidCap;
    private boolean requestingModeChange = false;
    private final Comparator<org.opensourcephysics.display3d.core.Element> comparator = new Comparator<org.opensourcephysics.display3d.core.Element>(){

        @Override
        public int compare(org.opensourcephysics.display3d.core.Element element, org.opensourcephysics.display3d.core.Element element2) {
            return ((Element)element).getBlendPriority() - ((Element)element2).getBlendPriority();
        }
    };
    private boolean drawing = false;
    BufferedImage offscreenImage = new BufferedImage(300, 300, 5);
    private int strategy;
    private long lastRepaint = 0L;
    private int lastX;
    private int lastY;
    private static Element picked;

    static {
        axisMode = 0;
    }

    @Override
    public int getAxesMode() {
        return axisMode;
    }

    public DrawingPanel3D() {
        this.elements = new ArrayList<org.opensourcephysics.display3d.core.Element>();
        this.visHints = new VisualizationHints(this);
        this.canvas = new RenderCanvas(new GLCapabilities());
        this.canvas.addGLEventListener((GLEventListener)this);
        this.canvas.setBackground(new Color(0.9372549f, 0.9372549f, 1.0f, 1.0f));
        this.canvas.setAutoSwapBufferMode(false);
        this.canvas.setSize(new Dimension(300, 300));
        this.camera = new Camera(this);
        String[] stringArray = this.visHints.getAxesLabels();
        this.xAxis = new ElementArrow();
        this.xAxis.getStyle().setLineColor(Color.red);
        this.xAxis.getStyle().setFillColor(Color.red);
        this.xAxis.setVisible(false);
        this.yAxis = new ElementArrow();
        this.yAxis.getStyle().setLineColor(Color.green);
        this.yAxis.getStyle().setFillColor(Color.green);
        this.yAxis.setVisible(false);
        this.zAxis = new ElementArrow();
        this.zAxis.getStyle().setLineColor(Color.blue);
        this.zAxis.getStyle().setFillColor(Color.blue);
        this.zAxis.setVisible(false);
        this.xText = new ElementText(stringArray[0]);
        this.xText.setDrawingPanel3D(this);
        this.xText.setVisible(false);
        this.yText = new ElementText(stringArray[1]);
        this.yText.setDrawingPanel3D(this);
        this.yText.setVisible(false);
        this.zText = new ElementText(stringArray[2]);
        this.zText.setDrawingPanel3D(this);
        this.zText.setVisible(false);
        this.box = new ElementBox();
        this.box.getStyle().setLineColor(Color.black);
        this.box.getStyle().setDrawingFill(false);
        this.box.getStyle().setDrawingLines(true);
        this.box.getStyle().setResolution(new Resolution(1, 1, 1));
        this.trackerLines = new ElementSegment[9];
        int n = 0;
        int n2 = this.trackerLines.length;
        while (n < n2) {
            this.trackerLines[n] = new ElementSegment();
            this.trackerLines[n].setVisible(false);
            ++n;
        }
        this.setCursorMode();
        n = 0;
        while (n < this.messageBoxes.length) {
            this.messageBoxes[n] = new TextPanel();
            ++n;
        }
        GLUT = new GLUT();
        this.setPreferredMinMax(-1.0, 1.0, -1.0, 1.0, -1.0, 1.0);
    }

    @Override
    public void setLightEnabled(boolean bl, int n) {
    }

    public void cameraChanged(int n) {
        if (n == 1) {
            this.requestingModeChange = true;
            this.repaint();
        } else if (n == 5) {
            this.requestingModeChange = true;
            this.repaint();
        }
    }

    public void setParent(JFrame jFrame, DrawingPanel3D drawingPanel3D) {
        if (this.parent != null && drawingPanel3D != null) {
            this.parent.getContentPane().remove((Component)drawingPanel3D.canvas);
        }
        this.parent = jFrame;
        if (jFrame != null) {
            jFrame.getContentPane().add((Component)this.canvas, "Center");
        }
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        GL gL = gLAutoDrawable.getGL();
        gL.setSwapInterval(1);
        gL.glEnable(2929);
        gL.glEnable(2884);
        float f = 0.55f;
        float f2 = 0.0f;
        float f3 = 0.4f;
        float f4 = 0.7f;
        float f5 = 0.7f;
        float f6 = 30.0f;
        gL.glLightModelfv(2899, new float[]{f, f, f, 0.0f}, 0);
        this.staticLightPosition = new float[]{1.5f, 1.0f, 1.5f, 0.0f};
        gL.glLightfv(16384, 4608, new float[]{f2, f2, f2, 1.0f}, 0);
        gL.glLightfv(16384, 4609, new float[]{f3, f3, f3, 1.0f}, 0);
        gL.glLightfv(16384, 4610, new float[]{f4, f4, f4, 1.0f}, 0);
        gL.glLightfv(16385, 4608, new float[]{f2, f2, f2, 1.0f}, 0);
        gL.glLightfv(16385, 4609, new float[]{f3, f3, f3, 1.0f}, 0);
        gL.glLightfv(16385, 4610, new float[]{f4, f4, f4, 1.0f}, 0);
        gL.glLightfv(16384, 4611, this.staticLightPosition, 0);
        gL.glMaterialfv(1032, 4610, new float[]{f5, f5, f5, 1.0f}, 0);
        gL.glMaterialfv(1032, 5633, new float[]{f6}, 0);
        gL.glEnable(16384);
        gL.glEnable(2896);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.0f);
        gL.glBlendFunc(770, 771);
        gL.glEnable(2977);
        gLAutoDrawable.addMouseListener((MouseListener)this);
        gLAutoDrawable.addMouseMotionListener((MouseMotionListener)this);
        gLAutoDrawable.addKeyListener((KeyListener)this);
        this.additionalGLInit(gLAutoDrawable);
    }

    public void additionalGLInit(GLAutoDrawable gLAutoDrawable) {
    }

    /*
     * WARNING - void declaration
     */
    public void display(GLAutoDrawable gLAutoDrawable) {
        void var6_8;
        if (this.requestingPickingUpdate && this.lastMotionEvent != null) {
            this.lastPickedTarget = this.getTargetHit(gLAutoDrawable, this.lastMotionEvent.getX(), this.lastMotionEvent.getY());
            this.requestingPickingUpdate = false;
            return;
        }
        GLTools.GLU = new GLU();
        GL gL = gLAutoDrawable.getGL();
        Color color = this.getComponent().getBackground();
        gL.glClearColor((float)color.getRed() / 255.0f, (float)color.getGreen() / 255.0f, (float)color.getBlue() / 255.0f, 1.0f);
        gL.glClear(16640);
        if (this.requestingModeChange) {
            gL.glMatrixMode(5889);
            gL.glLoadIdentity();
            this.resetPerspective(gL);
            gL.glMatrixMode(5888);
            this.requestingModeChange = false;
        }
        gL.glLoadIdentity();
        if (this.smoothLines) {
            gL.glHint(3154, 4354);
            gL.glEnable(2848);
            gL.glBlendFunc(770, 771);
            gL.glEnable(3042);
        } else {
            gL.glDisable(2848);
            gL.glDisable(3042);
        }
        this.preCameraGL(gLAutoDrawable);
        this.camera.look(gLAutoDrawable);
        this.postCameraGL(gLAutoDrawable);
        List<org.opensourcephysics.display3d.core.Element> list = this.getElements();
        this.drawing = true;
        if (this.smoothLines) {
            Collections.sort(list, this.comparator);
        }
        for (Element element : list) {
            if (this.quickRedrawOn && this.visHints.isAllowQuickRedraw()) {
                element.drawQuickly(gLAutoDrawable);
                continue;
            }
            element.draw(gLAutoDrawable);
        }
        this.drawing = false;
        gL.glDisable(3552);
        this.box.draw(gLAutoDrawable);
        this.xText.draw(gLAutoDrawable);
        this.xAxis.draw(gLAutoDrawable);
        this.yAxis.draw(gLAutoDrawable);
        this.yText.draw(gLAutoDrawable);
        this.zAxis.draw(gLAutoDrawable);
        this.zText.draw(gLAutoDrawable);
        boolean n = false;
        while (var6_8 < this.trackerLines.length) {
            this.trackerLines[var6_8].draw(gLAutoDrawable);
            ++var6_8;
        }
        if (this.messageBoxes[0].canDraw() || this.messageBoxes[1].canDraw() || this.messageBoxes[2].canDraw() || this.messageBoxes[3].canDraw()) {
            void var6_10;
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            gL.glLoadIdentity();
            this.resetMessageBoxPositions();
            GLTools.GLU.gluOrtho2D(0.0, (double)this.width, 0.0, (double)this.height);
            gL.glMatrixMode(5888);
            gL.glLoadIdentity();
            boolean bl = false;
            while (var6_10 < this.messageBoxes.length) {
                if (this.messageBoxes[var6_10].canDraw()) {
                    this.messageBoxes[var6_10].draw(gLAutoDrawable);
                }
                ++var6_10;
            }
            gL.glMatrixMode(5889);
            gL.glPopMatrix();
            gL.glMatrixMode(5888);
        }
        this.canvas.swapBuffers();
        if (this.requestingImageRender) {
            int n2 = gLAutoDrawable.getWidth();
            int n3 = gLAutoDrawable.getHeight();
            ByteBuffer byteBuffer = BufferUtil.newByteBuffer((int)(n2 * n3 * 3));
            gL.glReadBuffer(1029);
            gL.glPixelStorei(3333, 1);
            gL.glReadPixels(0, 0, n2, n3, 6407, 5121, (Buffer)byteBuffer);
            int[] nArray = new int[n2 * n3];
            int n4 = n2 * n3 * 3;
            int n5 = 0;
            int n6 = n2 * 3;
            int n7 = 0;
            while (n7 < n3) {
                int n8 = n4 -= n6;
                int n9 = 0;
                while (n9 < n2) {
                    byte by = byteBuffer.get(n8++);
                    byte by2 = byteBuffer.get(n8++);
                    byte by3 = byteBuffer.get(n8++);
                    nArray[n5++] = 0xFF000000 | (by & 0xFF) << 16 | (by2 & 0xFF) << 8 | by3 & 0xFF;
                    ++n9;
                }
                ++n7;
            }
            if (this.renderTo == null || this.renderTo.getWidth() != n2 || this.renderTo.getHeight() != n3) {
                this.renderTo = new BufferedImage(n2, n3, 2);
            }
            this.renderTo.setRGB(0, 0, n2, n3, nArray, 0, n2);
        }
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        GL gL = gLAutoDrawable.getGL();
        this.width = n3;
        this.height = n4;
        gL.glLoadIdentity();
        this.requestingModeChange = true;
        double d = this.getMaximum3DSize();
        this.aconstant = 0.5 * (double)n3 / d;
        this.bconstant = 0.5 * (double)n4 / d;
        this.resetMessageBoxPositions();
        this.repaint();
    }

    private void resetMessageBoxPositions() {
        this.messageBoxes[3].setLocation(1, this.height - this.messageBoxes[3].getHeight() - 1);
        this.messageBoxes[2].setLocation(this.width - this.messageBoxes[2].getWidth(), this.height - this.messageBoxes[2].getHeight() - 1);
        this.messageBoxes[1].setLocation(this.width - this.messageBoxes[1].getWidth(), 0);
        this.messageBoxes[0].setLocation(1, 0);
    }

    @Override
    public synchronized BufferedImage render(BufferedImage bufferedImage) {
        if (bufferedImage != null) {
            this.requestingImageRender = true;
            this.renderTo = bufferedImage;
        }
        try {
            this.canvas.display();
        }
        catch (GLException gLException) {}
        return this.renderTo;
    }

    @Override
    public BufferedImage render() {
        this.render(null);
        if (this.vidCap != null && this.offscreenImage != null && this.vidCap.isRecording()) {
            this.vidCap.addFrame(this.render(this.offscreenImage));
        }
        return null;
    }

    public void displayChanged(GLAutoDrawable gLAutoDrawable, boolean bl, boolean bl2) {
    }

    @Override
    public void setBackgroundImage(String string) {
        this.imageFile = string;
    }

    @Override
    public String getBackgroundImage() {
        return this.imageFile;
    }

    @Override
    public void setScaleFactor(double d, double d2, double d3) {
        this.factorX = d;
        this.factorY = d2;
        this.factorZ = d3;
    }

    @Override
    public double getScaleFactorX() {
        return this.factorX;
    }

    @Override
    public double getScaleFactorY() {
        return this.factorY;
    }

    @Override
    public double getScaleFactorZ() {
        return this.factorZ;
    }

    @Override
    public void setAxesMode(int n) {
        axisMode = n;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void addElement(org.opensourcephysics.display3d.core.Element var1_1) {
        if (var1_1 instanceof Element) ** GOTO lbl4
        throw new UnsupportedOperationException("Can't add element to panel (incorrect implementation)");
lbl-1000:
        // 1 sources

        {
            System.out.println("drawing during element add");
lbl4:
            // 2 sources

            ** while (this.drawing)
        }
lbl5:
        // 1 sources

        if (!this.elements.contains(var1_1)) {
            if (var1_1 instanceof Group) {
                ((Group)var1_1).addChildrenTo(this.elements);
            } else {
                this.elements.add(var1_1);
            }
            ((Element)var1_1).setDrawingPanel3D(this);
            this.requestingModeChange = true;
        }
    }

    public void resizeBoundsFor(org.opensourcephysics.display3d.core.Element element) {
        Vec3D vec3D = new Vec3D(this.box.getSize());
        vec3D.multiply(vec3D, 0.5);
        this.box.getPosition().subtract(this.box.getPosition(), vec3D);
        if (element instanceof ElementSegment) {
            element.setX(element.getX() - element.getSizeX() / 2.0);
            element.setY(element.getY() - element.getSizeY() / 2.0);
            element.setZ(element.getZ() - element.getSizeZ() / 2.0);
        }
        Vec3D vec3D2 = new Vec3D(this.box.getPosition());
        Vec3D vec3D3 = new Vec3D(vec3D2);
        vec3D3.add(vec3D2, this.box.getSize());
        if (vec3D2.x > element.getX() - element.getSizeX() / 2.0) {
            vec3D2.x = element.getX() - element.getSizeX() / 2.0;
        }
        if (vec3D2.y > element.getY() - element.getSizeY() / 2.0) {
            vec3D2.y = element.getY() - element.getSizeY() / 2.0;
        }
        if (vec3D2.z > element.getZ() - element.getSizeZ() / 2.0) {
            vec3D2.z = element.getZ() - element.getSizeZ() / 2.0;
        }
        if (vec3D3.x < element.getX() + element.getSizeX() / 2.0) {
            vec3D3.x = element.getX() + element.getSizeX() / 2.0;
        }
        if (vec3D3.y < element.getY() + element.getSizeY() / 2.0) {
            vec3D3.y = element.getY() + element.getSizeY() / 2.0;
        }
        if (vec3D3.z < element.getZ() + element.getSizeZ() / 2.0) {
            vec3D3.z = element.getZ() + element.getSizeZ() / 2.0;
        }
        if (element instanceof ElementSegment) {
            element.setX(element.getX() + element.getSizeX() / 2.0);
            element.setY(element.getY() + element.getSizeY() / 2.0);
            element.setZ(element.getZ() + element.getSizeZ() / 2.0);
        }
        this.box.setXYZ(vec3D2.x, vec3D2.y, vec3D2.z);
        vec3D3.subtract(vec3D3, vec3D2);
        this.box.setSizeXYZ(vec3D3.x, vec3D3.y, vec3D3.z);
        vec3D = new Vec3D(this.box.getSize());
        vec3D.multiply(vec3D, 0.5);
        this.box.getPosition().add(this.box.getPosition(), vec3D);
        double d = this.getMaximum3DSize();
        this.aconstant = 0.5 * (double)this.width / d;
        this.bconstant = 0.5 * (double)this.height / d;
        if (element instanceof Group) {
            Iterator<org.opensourcephysics.display3d.core.Element> iterator = ((Group)element).getElements().iterator();
            while (iterator.hasNext()) {
                this.resizeBoundsFor(iterator.next());
            }
        }
    }

    @Override
    public Component getComponent() {
        return this.canvas;
    }

    @Override
    public void setPreferredMinMax(double d, double d2, double d3, double d4, double d5, double d6) {
        this.box.setXYZ((d2 + d) / 2.0, (d4 + d3) / 2.0, (d6 + d5) / 2.0);
        this.box.setSizeXYZ(d2 - d, d4 - d3, d6 - d5);
        this.resetAxes();
        this.camera.reset();
    }

    private void resetAxes() {
        this.xAxis.setXYZ(this.box.getX() - this.box.getSizeX() / 2.0, this.box.getY() - this.box.getSizeY() / 2.0, this.box.getZ() - this.box.getSizeZ() / 2.0);
        this.xAxis.setSizeXYZ(this.box.getSizeX(), 0.0, 0.0);
        this.xText.setSizeXYZ(3.0, 0.0, 0.0);
        this.xText.setXYZ(this.xAxis.getX() + this.xAxis.getSizeX() * 1.01, this.xAxis.getY() + this.xAxis.getSizeY() * 1.01, this.xAxis.getZ() + this.xAxis.getSizeZ() * 1.01);
        this.yAxis.setXYZ(this.box.getX() - this.box.getSizeX() / 2.0, this.box.getY() - this.box.getSizeY() / 2.0, this.box.getZ() - this.box.getSizeZ() / 2.0);
        this.yAxis.setSizeXYZ(0.0, this.box.getSizeY(), 0.0);
        this.yText.setSizeXYZ(3.0, 0.0, 0.0);
        this.yText.setXYZ(this.yAxis.getX() + this.yAxis.getSizeX() * 1.01, this.yAxis.getY() + this.yAxis.getSizeY() * 1.01, this.yAxis.getZ() + this.yAxis.getSizeZ() * 1.01);
        this.zAxis.setXYZ(this.box.getX() - this.box.getSizeX() / 2.0, this.box.getY() - this.box.getSizeY() / 2.0, this.box.getZ() - this.box.getSizeZ() / 2.0);
        this.zAxis.setSizeXYZ(0.0, 0.0, this.box.getSizeZ());
        this.zText.setSizeXYZ(3.0, 0.0, 0.0);
        this.zText.setXYZ(this.zAxis.getX() + this.zAxis.getSizeX() * 1.01, this.zAxis.getY() + this.zAxis.getSizeY() * 1.01, this.zAxis.getZ() + this.zAxis.getSizeZ() * 1.01);
    }

    @Override
    public double getPreferredMinX() {
        return this.box.getX();
    }

    @Override
    public double getPreferredMaxX() {
        return this.box.getX() + this.box.getSizeX();
    }

    @Override
    public double getPreferredMinY() {
        return this.box.getY();
    }

    @Override
    public double getPreferredMaxY() {
        return this.box.getY() + this.box.getSizeY();
    }

    @Override
    public double getPreferredMinZ() {
        return this.box.getZ();
    }

    @Override
    public double getPreferredMaxZ() {
        return this.box.getZ() + this.box.getSizeZ();
    }

    @Override
    public void zoomToFit() {
        double d = Double.POSITIVE_INFINITY;
        double d2 = Double.NEGATIVE_INFINITY;
        double d3 = Double.POSITIVE_INFINITY;
        double d4 = Double.NEGATIVE_INFINITY;
        double d5 = Double.POSITIVE_INFINITY;
        double d6 = Double.NEGATIVE_INFINITY;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        Iterator<org.opensourcephysics.display3d.core.Element> iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            ((Element)iterator.next()).getExtrema(dArray, dArray2);
            d = Math.min(Math.min(d, dArray[0]), dArray2[0]);
            d2 = Math.max(Math.max(d2, dArray[0]), dArray2[0]);
            d3 = Math.min(Math.min(d3, dArray[1]), dArray2[1]);
            d4 = Math.max(Math.max(d4, dArray[1]), dArray2[1]);
            d5 = Math.min(Math.min(d5, dArray[2]), dArray2[2]);
            d6 = Math.max(Math.max(d6, dArray[2]), dArray2[2]);
        }
        double d7 = Math.max(Math.max(d2 - d, d4 - d3), d6 - d5);
        if (d7 == 0.0) {
            d7 = 2.0;
        }
        if (d >= d2) {
            d = d2 - d7 / 2.0;
            d2 = d + d7;
        }
        if (d3 >= d4) {
            d3 = d4 - d7 / 2.0;
            d4 = d3 + d7;
        }
        if (d5 >= d6) {
            d5 = d6 - d7 / 2.0;
            d6 = d5 + d7;
        }
        this.setPreferredMinMax(d, d2, d3, d4, d5, d6);
    }

    @Override
    public void setSquareAspect(boolean bl) {
        this.squareAspect = bl;
    }

    @Override
    public boolean isSquareAspect() {
        return this.squareAspect;
    }

    @Override
    public org.opensourcephysics.display3d.core.VisualizationHints getVisualizationHints() {
        return this.visHints;
    }

    public void setUpdateStrategy(int n) {
        this.strategy = n;
    }

    public int getUpdateStrategy() {
        return this.strategy;
    }

    void hintChanged(int n) {
        switch (n) {
            case 0: {
                switch (this.visHints.getDecorationType()) {
                    case 0: {
                        this.box.setVisible(false);
                        this.xAxis.setVisible(false);
                        this.yAxis.setVisible(false);
                        this.zAxis.setVisible(false);
                        this.xText.setVisible(false);
                        this.yText.setVisible(false);
                        this.zText.setVisible(false);
                        break;
                    }
                    case 2: {
                        this.box.setVisible(true);
                        this.xAxis.setVisible(false);
                        this.yAxis.setVisible(false);
                        this.zAxis.setVisible(false);
                        this.xText.setVisible(false);
                        this.yText.setVisible(false);
                        this.zText.setVisible(false);
                        break;
                    }
                    case 1: {
                        this.box.setVisible(false);
                        this.xAxis.setVisible(true);
                        this.yAxis.setVisible(true);
                        this.zAxis.setVisible(true);
                        this.xText.setVisible(true);
                        this.yText.setVisible(true);
                        this.zText.setVisible(true);
                    }
                }
                break;
            }
            case 4: {
                this.setCursorMode();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                String[] stringArray = this.visHints.getAxesLabels();
                this.xText.setText(stringArray[0]);
                this.yText.setText(stringArray[1]);
                this.zText.setText(stringArray[2]);
            }
        }
    }

    private void setCursorMode() {
        switch (this.visHints.getCursorType()) {
            case 0: {
                this.trackersVisible = 0;
                break;
            }
            case 2: {
                this.trackersVisible = 9;
                break;
            }
            default: {
                this.trackersVisible = 3;
                break;
            }
            case 3: {
                this.trackersVisible = 3;
            }
        }
    }

    @Override
    public void removeElement(org.opensourcephysics.display3d.core.Element element) {
        this.elements.remove(element);
    }

    @Override
    public void removeAllElements() {
        this.elements.clear();
    }

    @Override
    public List<org.opensourcephysics.display3d.core.Element> getElements() {
        return this.elements;
    }

    @Override
    public org.opensourcephysics.display3d.core.interaction.InteractionTarget getInteractionTarget(int n) {
        return this.myTarget;
    }

    @Override
    public void addInteractionListener(InteractionListener interactionListener) {
        if (interactionListener == null || this.listeners.contains(interactionListener)) {
            return;
        }
        this.listeners.add(interactionListener);
    }

    @Override
    public void removeInteractionListener(InteractionListener interactionListener) {
        this.listeners.remove(interactionListener);
    }

    private void resetInteraction() {
        this.targetHit = null;
        this.showTrackers(false);
        this.repaint();
    }

    private void showTrackers(boolean bl) {
        int n = 0;
        int n2 = this.trackerLines.length;
        while (n < n2) {
            if (n < this.trackersVisible) {
                this.trackerLines[n].setVisible(bl);
            } else {
                this.trackerLines[n].setVisible(false);
            }
            ++n;
        }
    }

    private void positionTrackers() {
        double d = this.box.getX() - this.box.getSizeX() * 0.5;
        double d2 = this.box.getY() - this.box.getSizeY() * 0.5;
        double d3 = this.box.getZ() - this.box.getSizeZ() * 0.5;
        switch (this.visHints.getCursorType()) {
            case 0: {
                return;
            }
            default: {
                this.trackerLines[0].setXYZ(this.trackerPoint[0], d2, d3);
                this.trackerLines[0].setSizeXYZ(0.0, this.trackerPoint[1] - d2, 0.0);
                this.trackerLines[1].setXYZ(d, this.trackerPoint[1], d3);
                this.trackerLines[1].setSizeXYZ(this.trackerPoint[0] - d, 0.0, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], d3);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - d3);
                break;
            }
            case 2: {
                this.trackerLines[0].setXYZ(d, this.trackerPoint[1], this.trackerPoint[2]);
                this.trackerLines[0].setSizeXYZ(this.trackerPoint[0] - d, 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint[0], d2, this.trackerPoint[2]);
                this.trackerLines[1].setSizeXYZ(0.0, this.trackerPoint[1] - d2, 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], d3);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - d3);
                this.trackerLines[3].setXYZ(this.trackerPoint[0], d2, d3);
                this.trackerLines[3].setSizeXYZ(0.0, this.trackerPoint[1] - d2, 0.0);
                this.trackerLines[4].setXYZ(d, this.trackerPoint[1], d3);
                this.trackerLines[4].setSizeXYZ(this.trackerPoint[0] - d, 0.0, 0.0);
                this.trackerLines[5].setXYZ(this.trackerPoint[0], d2, d3);
                this.trackerLines[5].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - d3);
                this.trackerLines[6].setXYZ(d, d2, this.trackerPoint[2]);
                this.trackerLines[6].setSizeXYZ(this.trackerPoint[0] - d, 0.0, 0.0);
                this.trackerLines[7].setXYZ(d, this.trackerPoint[1], d3);
                this.trackerLines[7].setSizeXYZ(0.0, 0.0, this.trackerPoint[2] - d3);
                this.trackerLines[8].setXYZ(d, d2, this.trackerPoint[2]);
                this.trackerLines[8].setSizeXYZ(0.0, this.trackerPoint[1] - d2, 0.0);
                break;
            }
            case 3: {
                this.trackerLines[0].setXYZ(d, this.trackerPoint[1], this.trackerPoint[2]);
                this.trackerLines[0].setSizeXYZ(this.box.getSizeX(), 0.0, 0.0);
                this.trackerLines[1].setXYZ(this.trackerPoint[0], d2, this.trackerPoint[2]);
                this.trackerLines[1].setSizeXYZ(0.0, this.box.getSizeY(), 0.0);
                this.trackerLines[2].setXYZ(this.trackerPoint[0], this.trackerPoint[1], d3);
                this.trackerLines[2].setSizeXYZ(0.0, 0.0, this.box.getSizeZ());
            }
        }
    }

    @Override
    public void repaint() {
        if (this.parent != null && this.parent.isVisible() && !this.parent.getIgnoreRepaint() && this.lastRepaint + 40L < System.currentTimeMillis()) {
            this.canvas.repaint();
            this.lastRepaint = System.currentTimeMillis();
        }
    }

    public void repaintNow() {
        if (this.parent != null && this.parent.isVisible() && !this.parent.getIgnoreRepaint()) {
            this.canvas.repaint();
            this.lastRepaint = System.currentTimeMillis();
        }
    }

    @Override
    public org.opensourcephysics.display3d.core.Camera getCamera() {
        return this.camera;
    }

    @Override
    public VideoTool getVideoTool() {
        return this.vidCap;
    }

    @Override
    public void setVideoTool(VideoTool videoTool) {
        if (this.vidCap != null) {
            this.vidCap.setVisible(false);
        }
        this.vidCap = videoTool;
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 17 || keyEvent.getKeyCode() == 16) {
            return;
        }
        if (keyEvent.getKeyCode() == 83) {
            this.sKeyDown = true;
            return;
        }
        this.keyPressed = keyEvent.getKeyCode();
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 83) {
            this.sKeyDown = false;
            return;
        }
        this.keyPressed = -1;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.canvas.requestFocus();
        this.quickRedrawOn = this.visHints.isAllowQuickRedraw() && !this.sKeyDown;
        this.rePickTarget();
        this.targetHit = this.lastPickedTarget;
        if (this.targetHit != null) {
            Element element = this.targetHit.getElement();
            this.trackerPoint = element.getHotSpot(this.targetHit);
            element.invokeActions(new InteractionEvent((Object)element, 2000, this.targetHit.getActionCommand(), this.targetHit, mouseEvent));
            this.trackerPoint = element.getHotSpot(this.targetHit);
        } else {
            if (!this.myTarget.isEnabled()) {
                this.resetInteraction();
                return;
            }
            if (this.camera.is3dMode() && !mouseEvent.isAltDown()) {
                this.invokeActions(new InteractionEvent((Object)this, 2000, this.myTarget.getActionCommand(), null, mouseEvent));
                this.resetInteraction();
                return;
            }
            this.trackerPoint = this.worldPoint(mouseEvent.getX(), mouseEvent.getY());
            this.invokeActions(new InteractionEvent((Object)this, 2000, this.myTarget.getActionCommand(), this.trackerPoint, mouseEvent));
        }
        this.positionTrackers();
        this.showTrackers(true);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.targetHit != null) {
            Element element = this.targetHit.getElement();
            element.invokeActions(new InteractionEvent((Object)element, 2002, this.targetHit.getActionCommand(), this.targetHit, mouseEvent));
        } else if (this.myTarget.isEnabled()) {
            if (!this.camera.is3dMode() || mouseEvent.isAltDown()) {
                this.invokeActions(new InteractionEvent((Object)this, 2002, this.myTarget.getActionCommand(), this.trackerPoint, mouseEvent));
            } else {
                this.invokeActions(new InteractionEvent((Object)this, 2002, this.myTarget.getActionCommand(), null, mouseEvent));
            }
        }
        this.resetInteraction();
        this.quickRedrawOn = false;
        this.repaintNow();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        boolean bl = this.mouseDraggedComputations(mouseEvent);
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        if (!bl) {
            this.invokeActions(new InteractionEvent((Object)this, 2001, this.myTarget.getActionCommand(), null, mouseEvent));
            this.resetInteraction();
            return;
        }
        if (this.targetHit != null) {
            Element element = this.targetHit.getElement();
            element.updateHotSpot(this.targetHit, this.trackerPoint);
            element.invokeActions(new InteractionEvent((Object)element, 2001, this.targetHit.getActionCommand(), this.targetHit, mouseEvent));
            this.trackerPoint = element.getHotSpot(this.targetHit);
            this.displayPosition(this.trackerPoint);
            this.positionTrackers();
            this.showTrackers(true);
        } else if (this.myTarget.isEnabled()) {
            this.invokeActions(new InteractionEvent((Object)this, 2001, this.myTarget.getActionCommand(), this.trackerPoint, mouseEvent));
            this.displayPosition(this.trackerPoint);
            this.positionTrackers();
            this.showTrackers(true);
        }
        this.repaint();
    }

    private void displayPosition(double[] dArray) {
        this.visHints.displayPosition(this.camera.getProjectionMode(), dArray);
    }

    private void setMouseCursor(Cursor cursor) {
        this.canvas.setCursor(cursor);
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setMouseCursor(Cursor.getPredefinedCursor(1));
        if (this.myTarget.isEnabled()) {
            this.invokeActions(new InteractionEvent((Object)this, 2003, this.myTarget.getActionCommand(), null, mouseEvent));
        }
        this.targetEntered = null;
        this.targetHit = null;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setMouseCursor(Cursor.getPredefinedCursor(0));
        if (this.myTarget.isEnabled()) {
            this.invokeActions(new InteractionEvent((Object)this, 2004, this.myTarget.getActionCommand(), null, mouseEvent));
        }
        this.targetEntered = null;
        this.targetHit = null;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        this.lastX = mouseEvent.getX();
        this.lastY = mouseEvent.getY();
        this.lastMotionEvent = mouseEvent;
        this.rePickTarget();
        InteractionTarget interactionTarget = this.lastPickedTarget;
        if (interactionTarget != null) {
            if (this.targetEntered == null) {
                interactionTarget.getElement().invokeActions(new InteractionEvent((Object)interactionTarget.getElement(), 2003, interactionTarget.getActionCommand(), interactionTarget, mouseEvent));
            }
            this.setMouseCursor(Cursor.getPredefinedCursor(12));
        } else {
            if (this.targetEntered != null) {
                this.targetEntered.getElement().invokeActions(new InteractionEvent((Object)this.targetEntered.getElement(), 2004, this.targetEntered.getActionCommand(), this.targetEntered, mouseEvent));
            } else if (this.myTarget.isEnabled()) {
                this.invokeActions(new InteractionEvent((Object)this, 2005, this.myTarget.getActionCommand(), null, mouseEvent));
            }
            this.setMouseCursor(Cursor.getPredefinedCursor(1));
        }
        this.targetEntered = interactionTarget;
    }

    private void rePickTarget() {
        this.requestingPickingUpdate = true;
        this.canvas.display();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InteractionTarget getTargetHit(GLAutoDrawable gLAutoDrawable, int n, int n2) {
        int n3;
        List<org.opensourcephysics.display3d.core.Element> list;
        GL gL = gLAutoDrawable.getGL();
        int[] nArray = new int[4];
        gL.glGetIntegerv(2978, nArray, 0);
        IntBuffer intBuffer = BufferUtil.newIntBuffer((int)(this.elements.size() * 4));
        gL.glSelectBuffer(this.elements.size() * 4, intBuffer);
        gL.glRenderMode(7170);
        gL.glInitNames();
        gL.glPushName(0);
        gL.glMatrixMode(5889);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        GLTools.GLU.gluPickMatrix((double)n, (double)(nArray[3] - n2), 1.0, 1.0, nArray, 0);
        this.resetPerspective(gL);
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        this.camera.look(gLAutoDrawable);
        List<org.opensourcephysics.display3d.core.Element> list2 = list = this.getElements();
        synchronized (list2) {
            n3 = 0;
            int n4 = 0;
            while (n4 < list.size()) {
                Element element = (Element)list.get(n4);
                n3 = this.renderForPicking(gLAutoDrawable, element, n3);
                ++n4;
            }
        }
        gL.glPopMatrix();
        gL.glMatrixMode(5889);
        gL.glPopMatrix();
        gL.glMatrixMode(5888);
        int n5 = gL.glRenderMode(7168);
        if (n5 > 0) {
            n3 = intBuffer.get(3);
            long l = (long)intBuffer.get(1) & 0xFFFFFFFFL;
            int n6 = 1;
            while (n6 < n5) {
                long l2 = (long)intBuffer.get(n6 * 4 + 1) & 0xFFFFFFFFL;
                if (l2 < l) {
                    n3 = intBuffer.get(n6 * 4 + 3);
                    l = l2;
                }
                ++n6;
            }
            Object object = list;
            synchronized (object) {
                int n7 = 0;
                int n8 = 0;
                while (n8 < list.size()) {
                    Element element = (Element)list.get(n8);
                    n7 = this.findPicked(element, n7, n3);
                    ++n8;
                }
            }
            object = (InteractionTarget)picked.getInteractionTarget(0);
            if (object != null && ((InteractionTarget)object).isEnabled()) {
                return object;
            }
            return (InteractionTarget)picked.getInteractionTarget(1);
        }
        return null;
    }

    private int findPicked(Element element, int n, int n2) {
        if (element instanceof Group) {
            Group group = (Group)element;
            if (!element.isVisible()) {
                return n;
            }
            List<org.opensourcephysics.display3d.core.Element> list = group.getElements();
            int n3 = 0;
            while (n3 < list.size()) {
                Element element2 = (Element)list.get(n3);
                n = this.findPicked(element2, n, n2);
                ++n3;
            }
            return n;
        }
        if (element.getInteractionTarget(0) != null && element.getInteractionTarget(0).isEnabled() || element.getInteractionTarget(1) != null && element.getInteractionTarget(1).isEnabled()) {
            if (n == n2) {
                picked = element;
            }
            return n + 1;
        }
        return n;
    }

    private int renderForPicking(GLAutoDrawable gLAutoDrawable, Element element, int n) {
        if (element instanceof Group) {
            Group group = (Group)element;
            if (!element.isVisible()) {
                return n;
            }
            List<org.opensourcephysics.display3d.core.Element> list = group.getElements();
            int n2 = 0;
            while (n2 < list.size()) {
                Element element2 = (Element)list.get(n2);
                n = this.renderForPicking(gLAutoDrawable, element2, n);
                ++n2;
            }
            return n;
        }
        if (element.getInteractionTarget(0) != null && element.getInteractionTarget(0).isEnabled() || element.getInteractionTarget(1) != null && element.getInteractionTarget(1).isEnabled()) {
            gLAutoDrawable.getGL().glLoadName(n);
            element.draw(gLAutoDrawable);
            return n + 1;
        }
        return n;
    }

    private void resetPerspective(GL gL) {
        float f;
        float f2 = f = this.isSquareAspect() ? (float)this.width / (float)this.height : 1.0f;
        if (this.camera.getProjectionMode() == 11) {
            GLTools.GLU.gluPerspective(this.camera.getFoV(), (double)f, 0.1, this.maxObjectDistance);
        } else {
            float f3 = (float)(this.box.getSizeX() * 2.0 / 3.0);
            gL.glOrtho((double)(-f * f3), (double)(f * f3), (double)(-f3), (double)f3, 1.0, this.maxObjectDistance);
        }
    }

    public double getScreenSize() {
        return Math.sqrt(this.box.getSizeX() * this.box.getSizeX() + this.box.getSizeY() * this.box.getSizeY() + this.box.getSizeZ() * this.box.getSizeZ());
    }

    final double getMaximum3DSize() {
        double d = this.box.getSizeX();
        double d2 = this.box.getSizeY();
        double d3 = this.box.getSizeZ();
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return Math.max(d, d2);
            }
            case 1: {
                return Math.max(d, d3);
            }
            case 2: {
                return Math.max(d2, d3);
            }
        }
        return Math.max(Math.max(d, d2), d3);
    }

    private boolean mouseDraggedComputations(MouseEvent mouseEvent) {
        if (mouseEvent.isControlDown()) {
            if (this.camera.is3dMode()) {
                double d = this.camera.getFocusX();
                double d2 = this.camera.getFocusY();
                double d3 = this.camera.getFocusZ();
                double d4 = (double)(mouseEvent.getX() - this.lastX) * this.getMaximum3DSize() * 0.01;
                double d5 = (double)(mouseEvent.getY() - this.lastY) * this.getMaximum3DSize() * 0.01;
                switch (this.keyPressed) {
                    case 88: {
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d + d5, d2, d3);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(d + d4, d2, d3);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d - d5, d2, d3);
                            break;
                        }
                        this.camera.setFocusXYZ(d - d4, d2, d3);
                        break;
                    }
                    case 89: {
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 - d4, d3);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(d, d2 + d5, d3);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 + d4, d3);
                            break;
                        }
                        this.camera.setFocusXYZ(d, d2 - d5, d3);
                        break;
                    }
                    case 90: {
                        if (this.camera.cosBeta >= 0.0) {
                            this.camera.setFocusXYZ(d, d2, d3 + d5);
                            break;
                        }
                        this.camera.setFocusXYZ(d, d2, d3 - d5);
                        break;
                    }
                    default: {
                        if (this.camera.cosBeta < 0.0) {
                            d5 = -d5;
                        }
                        if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 - d4, d3 + d5);
                            break;
                        }
                        if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                            this.camera.setFocusXYZ(d + d4, d2, d3 + d5);
                            break;
                        }
                        if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                            this.camera.setFocusXYZ(d, d2 + d4, d3 - d5);
                            break;
                        }
                        this.camera.setFocusXYZ(d - d4, d2, d3 - d5);
                    }
                }
            }
            return false;
        }
        if (mouseEvent.isShiftDown()) {
            this.camera.setDistanceToScreen(this.camera.getDistanceToScreen() - (double)(mouseEvent.getY() - this.lastY) * this.getMaximum3DSize() * 0.01);
            return false;
        }
        if (this.camera.is3dMode() && this.targetHit == null && !mouseEvent.isAltDown()) {
            this.camera.setAzimuthAndAltitude(this.camera.getAzimuth() - (double)(mouseEvent.getX() - this.lastX) * 0.01, this.camera.getAltitude() + (double)(mouseEvent.getY() - this.lastY) * 0.005);
            return false;
        }
        if (this.trackerPoint == null) {
            return true;
        }
        double[] dArray = this.worldDistance(mouseEvent.getX() - this.lastX, mouseEvent.getY() - this.lastY);
        if (!this.camera.is3dMode()) {
            switch (this.keyPressed) {
                case 88: {
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                    break;
                }
                case 89: {
                    this.trackerPoint[1] = this.trackerPoint[1] + dArray[1];
                    break;
                }
                case 90: {
                    this.trackerPoint[2] = this.trackerPoint[2] + dArray[2];
                    break;
                }
                default: {
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                    this.trackerPoint[1] = this.trackerPoint[1] + dArray[1];
                    this.trackerPoint[2] = this.trackerPoint[2] + dArray[2];
                    break;
                }
            }
        } else {
            switch (this.keyPressed) {
                case 88: {
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] + dArray[1];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - dArray[0];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - dArray[1];
                        break;
                    }
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                    break;
                }
                case 89: {
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + dArray[0];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + dArray[1];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] - dArray[0];
                        break;
                    }
                    this.trackerPoint[1] = this.trackerPoint[1] - dArray[1];
                    break;
                }
                case 90: {
                    if (this.camera.cosBeta >= 0.0) {
                        this.trackerPoint[2] = this.trackerPoint[2] - dArray[1];
                        break;
                    }
                    this.trackerPoint[2] = this.trackerPoint[2] - dArray[2];
                    break;
                }
                default: {
                    this.trackerPoint[2] = this.camera.cosBeta >= 0.0 ? this.trackerPoint[2] - dArray[1] : this.trackerPoint[2] + dArray[1];
                    if (this.camera.cosAlpha >= 0.0 && Math.abs(this.camera.sinAlpha) < this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] + dArray[0];
                        break;
                    }
                    if (this.camera.sinAlpha >= 0.0 && Math.abs(this.camera.cosAlpha) < this.camera.sinAlpha) {
                        this.trackerPoint[0] = this.trackerPoint[0] - dArray[0];
                        break;
                    }
                    if (this.camera.cosAlpha < 0.0 && Math.abs(this.camera.sinAlpha) < -this.camera.cosAlpha) {
                        this.trackerPoint[1] = this.trackerPoint[1] - dArray[0];
                        break;
                    }
                    this.trackerPoint[0] = this.trackerPoint[0] + dArray[0];
                }
            }
        }
        return true;
    }

    private void invokeActions(InteractionEvent interactionEvent) {
        Iterator<InteractionListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().interactionPerformed(interactionEvent);
        }
    }

    private double[] worldDistance(double d, double d2) {
        double d3 = 1.5;
        switch (this.camera.getProjectionMode()) {
            case 0: {
                return new double[]{d / (d3 * this.aconstant), -d2 / (d3 * this.bconstant), 0.0};
            }
            case 1: {
                return new double[]{d / (d3 * this.aconstant), 0.0, -d2 / (d3 * this.bconstant)};
            }
            case 2: {
                return new double[]{0.0, d / (d3 * this.aconstant), -d2 / (d3 * this.bconstant)};
            }
        }
        d3 = 1.0;
        return new double[]{d / (d3 * this.aconstant), d2 / (d3 * this.bconstant), 0.0};
    }

    private double[] worldPoint(int n, int n2) {
        return this.getCenter();
    }

    public double[] getCenter() {
        return new double[]{this.box.getX(), this.box.getY(), this.box.getZ()};
    }

    public void preCameraGL(GLAutoDrawable gLAutoDrawable) {
    }

    public void postCameraGL(GLAutoDrawable gLAutoDrawable) {
    }

    public void setMessage(String string) {
        this.messageBoxes[1].setText(string);
    }

    public void setMessage(String string, int n) {
        if (n < 0 || n > 3) {
            return;
        }
        this.messageBoxes[n].setText(string);
    }

    public static XML.ObjectLoader getLoader() {
        return new DrawingPanel3DLoader();
    }

    private static class DrawingPanel3DLoader
    extends DrawingPanel3D.Loader {
        private DrawingPanel3DLoader() {
        }

        public Object createObject(XMLControl xMLControl) {
            return new DrawingPanel3D();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            super.loadObject(xMLControl, object);
            DrawingPanel3D drawingPanel3D = (DrawingPanel3D)object;
            VisualizationHints visualizationHints = (VisualizationHints)xMLControl.getObject("visualization hints");
            visualizationHints.setPanel(drawingPanel3D);
            drawingPanel3D.visHints = visualizationHints;
            drawingPanel3D.camera = (Camera)xMLControl.getObject("camera");
            return object;
        }
    }

    class RenderCanvas
    extends GLCanvas
    implements Renderable {
        private static final long serialVersionUID = 1L;

        RenderCanvas(GLCapabilities gLCapabilities) {
            super(gLCapabilities);
        }

        public BufferedImage render() {
            return DrawingPanel3D.this.render();
        }

        public BufferedImage render(BufferedImage bufferedImage) {
            return DrawingPanel3D.this.render(bufferedImage);
        }
    }
}

