/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display3d.java3d;

import com.sun.j3d.utils.geometry.Text2D;
import java.awt.Font;
import javax.media.j3d.Node;
import javax.media.j3d.OrientedShape3D;
import javax.vecmath.Color3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import org.opensourcephysics.display3d.java3d.Camera;
import org.opensourcephysics.display3d.java3d.Element;

public class ElementText
extends Element
implements org.opensourcephysics.display3d.core.ElementText {
    private String text;
    private Font font = new Font("Dialog", 0, 12);
    private int justification = 0;
    private double rotationAngle = 0.0;
    private Text2D textNode = null;
    private OrientedShape3D os = new OrientedShape3D();

    public ElementText() {
        super.setSizeXYZ(1.0, 1.0, 1.0);
        this.os.setCapability(13);
        this.os.setCapability(27);
        this.os.setRotationPoint(0.0f, 0.0f, 0.0f);
        this.os.setAlignmentMode(1);
        this.os.setAppearance(this.getAppearance());
        this.os.setConstantScaleEnable(true);
        this.os.setScale(22.0);
    }

    public ElementText(String string) {
        this();
        this.setText(string);
    }

    public void processChanges(int n) {
        super.processChanges(n);
        if ((n & 4) != 0) {
            this.updateNode();
        }
    }

    private void updateNode() {
        if (this.getStyle() == null || this.getStyle().getLineColor() == null || this.font == null) {
            return;
        }
        this.textNode = new Text2D(this.text, new Color3f(this.getStyle().getLineColor()), this.font.getFontName(), this.font.getSize() * 2, this.font.getStyle());
        this.getAppearance().setTexture(this.textNode.getAppearance().getTexture());
        this.getAppearance().getTransparencyAttributes().setTransparencyMode(1);
        this.os.removeAllGeometries();
        this.os.addGeometry(this.textNode.getGeometry());
        this.setNode((Node)this.os);
    }

    void update(Camera camera) {
        Vector3d vector3d = camera.getPosition();
        vector3d.sub((Tuple3d)vector3d, (Tuple3d)new Vector3d(this.getX(), this.getY(), this.getZ()));
    }

    public void setText(String string) {
        this.text = string;
        this.updateNode();
    }

    public String getText() {
        return this.text;
    }

    public void setFont(Font font) {
        this.font = font;
        this.updateNode();
    }

    public Font getFont() {
        return this.font;
    }

    public void setJustification(int n) {
        this.justification = n;
    }

    public int getJustification() {
        return this.justification;
    }

    public void setRotationAngle(double d) {
        this.rotationAngle = d;
    }

    public double getRotationAngle() {
        return this.rotationAngle;
    }

    public void setSizeX(double d) {
    }

    public void setSizeY(double d) {
    }

    public void setSizeZ(double d) {
    }

    public void setSizeXYZ(double d, double d2, double d3) {
    }

    public void setSizeXYZ(double[] dArray) {
    }
}

