/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.display3d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.display3d.ControlAnalyticCurve3D;
import org.colos.ejs.library.control.display3d.ControlSet3D;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.colos.ejs.library.control.value.ParserSuryono;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display3d.core.Element;
import org.opensourcephysics.display3d.core.ElementSurface;
import org.opensourcephysics.display3d.factory.OSP3DFactory;
import org.opensourcephysics.numerics.SuryonoParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlAnalyticSurface3D
extends ControlSet3D
implements NeedsPreUpdate {
    private static final int SURFACE_ROPERTIES_ADDED = 14;
    protected String variable1 = "u";
    protected String variable2 = "v";
    protected int numPoints1 = 20;
    protected int numPoints2 = 20;
    protected double min1 = -1.0;
    protected double max1 = 1.0;
    protected double min2 = -1.0;
    protected double max2 = 1.0;
    protected String functionX = null;
    protected String functionY = null;
    protected String functionZ = null;
    protected boolean useJavaSyntax = true;
    protected String parameterName = null;
    protected double[] parameterValues = null;
    private static List<String> infoList = null;
    protected ParserSuryono parserX;
    protected ParserSuryono parserY;
    protected ParserSuryono parserZ;
    protected SuryonoParser BparserX;
    protected SuryonoParser BparserY;
    protected SuryonoParser BparserZ;
    protected String[] varsX = new String[0];
    protected String[] varsY = new String[0];
    protected String[] varsZ = new String[0];
    protected int indexX1 = -1;
    protected int indexY1 = -1;
    protected int indexZ1 = -1;
    protected int indexX2 = -1;
    protected int indexY2 = -1;
    protected int indexZ2 = -1;
    protected int indexParameterX;
    protected int indexParameterY;
    protected int indexParameterZ;
    protected double[][][][] data = null;

    public ControlAnalyticSurface3D() {
        this.adjustNumberOfPoints();
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 14;
    }

    @Override
    protected Element createAnElement() {
        ElementSurface elementSurface = OSP3DFactory.ElementSurface();
        return elementSurface;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementSurface)element2).setData(((ElementSurface)element).getData());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable1");
            infoList.add("min1");
            infoList.add("max1");
            infoList.add("points1");
            infoList.add("variable2");
            infoList.add("min2");
            infoList.add("max2");
            infoList.add("points2");
            infoList.add("functionx");
            infoList.add("functiony");
            infoList.add("functionz");
            infoList.add("javaSyntax");
            infoList.add("parameterName");
            infoList.add("parameterValues");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable1")) {
            return "String";
        }
        if (string.equals("variable2")) {
            return "String";
        }
        if (string.equals("min1")) {
            return "int|double";
        }
        if (string.equals("max1")) {
            return "int|double";
        }
        if (string.equals("min2")) {
            return "int|double";
        }
        if (string.equals("max2")) {
            return "int|double";
        }
        if (string.equals("points1")) {
            return "int";
        }
        if (string.equals("points2")) {
            return "int";
        }
        if (string.equals("functionx")) {
            return "String";
        }
        if (string.equals("functiony")) {
            return "String";
        }
        if (string.equals("functionz")) {
            return "String";
        }
        if (string.equals("javaSyntax")) {
            return "boolean";
        }
        if (string.equals("parameterName")) {
            return "String";
        }
        if (string.equals("parameterValues")) {
            return "double[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.variable1 = value.getString();
                this.updateIndexes1();
                break;
            }
            case 1: {
                this.min1 = value.getDouble();
                break;
            }
            case 2: {
                this.max1 = value.getDouble();
                break;
            }
            case 3: {
                this.numPoints1 = value.getInteger();
                this.adjustNumberOfPoints();
                break;
            }
            case 4: {
                this.variable2 = value.getString();
                this.updateIndexes2();
                break;
            }
            case 5: {
                this.min2 = value.getDouble();
                break;
            }
            case 6: {
                this.max2 = value.getDouble();
                break;
            }
            case 7: {
                this.numPoints2 = value.getInteger();
                this.adjustNumberOfPoints();
                break;
            }
            case 8: {
                this.setfunctionX(value.getString());
                break;
            }
            case 9: {
                this.setfunctionY(value.getString());
                break;
            }
            case 10: {
                this.setfunctionZ(value.getString());
                break;
            }
            case 11: {
                this.useJavaSyntax = value.getBoolean();
                this.updateFunctions();
                break;
            }
            case 12: {
                this.parameterName = value.getString();
                this.adjustNumberOfPoints();
                this.updateIndexesParam();
                break;
            }
            case 13: {
                if (value.getObject() instanceof double[]) {
                    this.parameterValues = (double[])value.getObject();
                    this.adjustNumberOfPoints();
                    break;
                }
                this.parameterValues = null;
                break;
            }
            default: {
                super.setValue(n - 14, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.variable1 = "u";
                this.updateIndexes1();
                break;
            }
            case 1: {
                this.min1 = -1.0;
                break;
            }
            case 2: {
                this.max1 = 1.0;
                break;
            }
            case 3: {
                this.numPoints1 = 20;
                this.adjustNumberOfPoints();
                break;
            }
            case 4: {
                this.variable2 = "v";
                this.updateIndexes2();
                break;
            }
            case 5: {
                this.min2 = -1.0;
                break;
            }
            case 6: {
                this.max2 = 1.0;
                break;
            }
            case 7: {
                this.numPoints2 = 20;
                this.adjustNumberOfPoints();
                break;
            }
            case 8: {
                this.functionX = null;
                this.varsX = new String[0];
                break;
            }
            case 9: {
                this.functionY = null;
                this.varsY = new String[0];
                break;
            }
            case 10: {
                this.functionZ = null;
                this.varsZ = new String[0];
                break;
            }
            case 11: {
                this.useJavaSyntax = true;
                this.updateFunctions();
                break;
            }
            case 12: {
                this.parameterName = null;
                this.adjustNumberOfPoints();
                break;
            }
            case 13: {
                this.parameterValues = null;
                this.adjustNumberOfPoints();
                break;
            }
            default: {
                super.setDefaultValue(n - 14);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                return null;
            }
        }
        return super.getValue(n - 14);
    }

    /*
     * Unable to fully structure code
     */
    private void setfunctionX(String var1_1) {
        if (this.useJavaSyntax) {
            this.functionX = var1_1;
            this.varsX = ParserSuryono.getVariableList(this.functionX);
            this.parserX = new ParserSuryono(this.varsX.length);
            var2_2 = 0;
            var3_4 = this.varsX.length;
            while (var2_2 < var3_4) {
                this.parserX.defineVariable(var2_2, this.varsX[var2_2]);
                ++var2_2;
            }
            this.parserX.define(this.functionX);
            this.parserX.parse();
        } else {
            block7: {
                try {
                    this.BparserX = new SuryonoParser(0);
                    this.functionX = var1_1;
                    this.varsX = this.BparserX.parseUnknown(this.functionX);
                    break block7;
                }
                catch (Exception v0) {
                    this.functionX = var1_1;
                    this.varsX = ParserSuryono.getVariableList(this.functionX);
                    this.parserX = new ParserSuryono(this.varsX.length);
                    var2_3 = 0;
                    var3_5 = this.varsX.length;
                    ** while (var2_3 < var3_5)
                }
lbl-1000:
                // 1 sources

                {
                    this.BparserX.defineVariable(var2_3 + 1, this.varsX[var2_3]);
                    ++var2_3;
                    continue;
                }
            }
            this.BparserX.define(this.functionX);
            this.BparserX.parse();
        }
        this.indexX1 = ControlAnalyticCurve3D.indexOf(this.variable1, this.varsX);
        this.indexX2 = ControlAnalyticCurve3D.indexOf(this.variable2, this.varsX);
        if (this.parameterName != null) {
            this.indexParameterX = ControlAnalyticCurve3D.indexOf(this.parameterName, this.varsX);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setfunctionY(String var1_1) {
        if (this.useJavaSyntax) {
            this.functionY = var1_1;
            this.varsY = ParserSuryono.getVariableList(this.functionY);
            this.parserY = new ParserSuryono(this.varsY.length);
            var2_2 = 0;
            var3_4 = this.varsY.length;
            while (var2_2 < var3_4) {
                this.parserY.defineVariable(var2_2, this.varsY[var2_2]);
                ++var2_2;
            }
            this.parserY.define(this.functionY);
            this.parserY.parse();
        } else {
            block7: {
                try {
                    this.BparserY = new SuryonoParser(0);
                    this.functionY = var1_1;
                    this.varsY = this.BparserY.parseUnknown(this.functionY);
                    break block7;
                }
                catch (Exception v0) {
                    this.functionY = var1_1;
                    this.varsY = ParserSuryono.getVariableList(this.functionY);
                    this.parserY = new ParserSuryono(this.varsY.length);
                    var2_3 = 0;
                    var3_5 = this.varsY.length;
                    ** while (var2_3 < var3_5)
                }
lbl-1000:
                // 1 sources

                {
                    this.BparserY.defineVariable(var2_3 + 1, this.varsY[var2_3]);
                    ++var2_3;
                    continue;
                }
            }
            this.BparserY.define(this.functionY);
            this.BparserY.parse();
        }
        this.indexY1 = ControlAnalyticCurve3D.indexOf(this.variable1, this.varsY);
        this.indexY2 = ControlAnalyticCurve3D.indexOf(this.variable2, this.varsY);
        if (this.parameterName != null) {
            this.indexParameterY = ControlAnalyticCurve3D.indexOf(this.parameterName, this.varsY);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setfunctionZ(String var1_1) {
        if (this.useJavaSyntax) {
            this.functionZ = var1_1;
            this.varsZ = ParserSuryono.getVariableList(this.functionZ);
            this.parserZ = new ParserSuryono(this.varsZ.length);
            var2_2 = 0;
            var3_4 = this.varsZ.length;
            while (var2_2 < var3_4) {
                this.parserZ.defineVariable(var2_2, this.varsZ[var2_2]);
                ++var2_2;
            }
            this.parserZ.define(this.functionZ);
            this.parserZ.parse();
        } else {
            block7: {
                try {
                    this.BparserZ = new SuryonoParser(0);
                    this.functionZ = var1_1;
                    this.varsZ = this.BparserZ.parseUnknown(this.functionZ);
                    break block7;
                }
                catch (Exception v0) {
                    this.functionZ = var1_1;
                    this.varsZ = ParserSuryono.getVariableList(this.functionZ);
                    this.parserZ = new ParserSuryono(this.varsZ.length);
                    var2_3 = 0;
                    var3_5 = this.varsZ.length;
                    ** while (var2_3 < var3_5)
                }
lbl-1000:
                // 1 sources

                {
                    this.BparserZ.defineVariable(var2_3 + 1, this.varsZ[var2_3]);
                    ++var2_3;
                    continue;
                }
            }
            this.BparserZ.define(this.functionZ);
            this.BparserZ.parse();
        }
        this.indexZ1 = ControlAnalyticCurve3D.indexOf(this.variable1, this.varsZ);
        this.indexZ2 = ControlAnalyticCurve3D.indexOf(this.variable2, this.varsZ);
        if (this.parameterName != null) {
            this.indexParameterZ = ControlAnalyticCurve3D.indexOf(this.parameterName, this.varsZ);
        }
    }

    private void updateIndexes1() {
        this.indexX1 = ControlAnalyticCurve3D.indexOf(this.variable1, this.varsX);
        this.indexY1 = ControlAnalyticCurve3D.indexOf(this.variable1, this.varsY);
        this.indexZ1 = ControlAnalyticCurve3D.indexOf(this.variable1, this.varsZ);
    }

    private void updateIndexes2() {
        this.indexX2 = ControlAnalyticCurve3D.indexOf(this.variable2, this.varsX);
        this.indexY2 = ControlAnalyticCurve3D.indexOf(this.variable2, this.varsY);
        this.indexZ2 = ControlAnalyticCurve3D.indexOf(this.variable2, this.varsZ);
    }

    private void updateIndexesParam() {
        if (this.parameterName != null) {
            this.indexParameterX = ControlAnalyticCurve3D.indexOf(this.parameterName, this.varsX);
            this.indexParameterY = ControlAnalyticCurve3D.indexOf(this.parameterName, this.varsY);
            this.indexParameterZ = ControlAnalyticCurve3D.indexOf(this.parameterName, this.varsZ);
        }
    }

    private void updateFunctions() {
        if (this.functionX != null) {
            this.setfunctionX(this.functionX);
        }
        if (this.functionY != null) {
            this.setfunctionY(this.functionY);
        }
        if (this.functionZ != null) {
            this.setfunctionZ(this.functionZ);
        }
    }

    private void adjustNumberOfPoints() {
        if (this.parameterName != null && this.parameterValues != null) {
            this.data = new double[this.parameterValues.length][this.numPoints1][this.numPoints2][3];
            if (this.numElements != this.parameterValues.length) {
                super.setNumberOfElements(this.parameterValues.length);
            }
        } else {
            if (this.numElements != 1) {
                super.setNumberOfElements(1);
            }
            this.data = new double[1][this.numPoints1][this.numPoints2][3];
        }
    }

    @Override
    public void preupdate() {
        if (this.useJavaSyntax) {
            this.preupdateJavaSyntax();
        } else {
            this.preupdateFreeSyntax();
        }
    }

    public synchronized void preupdateJavaSyntax() {
        int n;
        int n2;
        if (this.myGroup != null) {
            n2 = 0;
            n = this.varsX.length;
            while (n2 < n) {
                if (n2 != this.indexX1 && n2 != this.indexX2) {
                    this.parserX.setVariable(n2, this.myGroup.getDouble(this.varsX[n2]));
                }
                ++n2;
            }
            n2 = 0;
            n = this.varsY.length;
            while (n2 < n) {
                if (n2 != this.indexY1 && n2 != this.indexY2) {
                    this.parserY.setVariable(n2, this.myGroup.getDouble(this.varsY[n2]));
                }
                ++n2;
            }
            n2 = 0;
            n = this.varsZ.length;
            while (n2 < n) {
                if (n2 != this.indexZ1 && n2 != this.indexZ2) {
                    this.parserZ.setVariable(n2, this.myGroup.getDouble(this.varsZ[n2]));
                }
                ++n2;
            }
        }
        n2 = 1;
        if (this.parameterName != null && this.parameterValues != null) {
            n2 = this.parameterValues.length;
        }
        n = 0;
        while (n < n2) {
            if (this.parameterName != null && this.parameterValues != null) {
                if (this.functionX != null && this.indexParameterX >= 0) {
                    this.parserX.setVariable(this.indexParameterX, this.parameterValues[n]);
                }
                if (this.functionY != null && this.indexParameterY >= 0) {
                    this.parserY.setVariable(this.indexParameterY, this.parameterValues[n]);
                }
                if (this.functionZ != null && this.indexParameterZ >= 0) {
                    this.parserZ.setVariable(this.indexParameterZ, this.parameterValues[n]);
                }
            }
            int n3 = 0;
            int n4 = this.numPoints1 - 1;
            while (n3 <= n4) {
                double d = ((double)(n4 - n3) * this.min1 + (double)n3 * this.max1) / (double)n4;
                if (this.indexX1 >= 0) {
                    this.parserX.setVariable(this.indexX1, d);
                }
                if (this.indexY1 >= 0) {
                    this.parserY.setVariable(this.indexY1, d);
                }
                if (this.indexZ1 >= 0) {
                    this.parserZ.setVariable(this.indexZ1, d);
                }
                int n5 = 0;
                int n6 = this.numPoints2 - 1;
                while (n5 <= n6) {
                    double d2 = ((double)(n6 - n5) * this.min2 + (double)n5 * this.max2) / (double)n6;
                    if (this.functionX == null) {
                        this.data[n][n3][n5][0] = 0.0;
                    } else {
                        if (this.indexX2 >= 0) {
                            this.parserX.setVariable(this.indexX2, d2);
                        }
                        this.data[n][n3][n5][0] = this.parserX.evaluate();
                    }
                    if (this.functionY == null) {
                        this.data[n][n3][n5][1] = 0.0;
                    } else {
                        if (this.indexY2 >= 0) {
                            this.parserY.setVariable(this.indexY2, d2);
                        }
                        this.data[n][n3][n5][1] = this.parserY.evaluate();
                    }
                    if (this.functionZ == null) {
                        this.data[n][n3][n5][2] = 0.0;
                    } else {
                        if (this.indexZ2 >= 0) {
                            this.parserZ.setVariable(this.indexZ2, d2);
                        }
                        this.data[n][n3][n5][2] = this.parserZ.evaluate();
                    }
                    ++n5;
                }
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < this.numElements) {
            ((ElementSurface)this.elements[n]).setData(this.data[n]);
            ++n;
        }
    }

    public synchronized void preupdateFreeSyntax() {
        int n;
        int n2;
        if (this.myGroup != null) {
            n2 = 0;
            n = this.varsX.length;
            while (n2 < n) {
                if (n2 != this.indexX1 && n2 != this.indexX2) {
                    this.BparserX.setVariable(n2 + 1, this.myGroup.getDouble(this.varsX[n2]));
                }
                ++n2;
            }
            n2 = 0;
            n = this.varsY.length;
            while (n2 < n) {
                if (n2 != this.indexY1 && n2 != this.indexY2) {
                    this.BparserY.setVariable(n2 + 1, this.myGroup.getDouble(this.varsY[n2]));
                }
                ++n2;
            }
            n2 = 0;
            n = this.varsZ.length;
            while (n2 < n) {
                if (n2 != this.indexZ1 && n2 != this.indexZ2) {
                    this.BparserZ.setVariable(n2 + 1, this.myGroup.getDouble(this.varsZ[n2]));
                }
                ++n2;
            }
        }
        n2 = 1;
        if (this.parameterName != null && this.parameterValues != null) {
            n2 = this.parameterValues.length;
        }
        n = 0;
        while (n < n2) {
            if (this.parameterName != null && this.parameterValues != null) {
                if (this.functionX != null && this.indexParameterX >= 0) {
                    this.parserX.setVariable(this.indexParameterX, this.parameterValues[n]);
                }
                if (this.functionY != null && this.indexParameterY >= 0) {
                    this.parserY.setVariable(this.indexParameterY, this.parameterValues[n]);
                }
                if (this.functionZ != null && this.indexParameterZ >= 0) {
                    this.parserZ.setVariable(this.indexParameterZ, this.parameterValues[n]);
                }
            }
            int n3 = 0;
            int n4 = this.numPoints1 - 1;
            while (n3 <= n4) {
                double d = ((double)(n4 - n3) * this.min1 + (double)n3 * this.max1) / (double)n4;
                if (this.indexX1 >= 0) {
                    this.BparserX.setVariable(this.indexX1 + 1, d);
                }
                if (this.indexY1 >= 0) {
                    this.BparserY.setVariable(this.indexY1 + 1, d);
                }
                if (this.indexZ1 >= 0) {
                    this.BparserZ.setVariable(this.indexZ1 + 1, d);
                }
                int n5 = 0;
                int n6 = this.numPoints2 - 1;
                while (n5 <= n6) {
                    double d2 = ((double)(n6 - n5) * this.min2 + (double)n5 * this.max2) / (double)n6;
                    if (this.functionX == null) {
                        this.data[n][n3][n5][0] = 0.0;
                    } else {
                        if (this.indexX2 >= 0) {
                            this.BparserX.setVariable(this.indexX2 + 1, d2);
                        }
                        this.data[n][n3][n5][0] = this.BparserX.evaluate();
                    }
                    if (this.functionY == null) {
                        this.data[n][n3][n5][1] = 0.0;
                    } else {
                        if (this.indexY2 >= 0) {
                            this.BparserY.setVariable(this.indexY2 + 1, d2);
                        }
                        this.data[n][n3][n5][1] = this.BparserY.evaluate();
                    }
                    if (this.functionZ == null) {
                        this.data[n][n3][n5][2] = 0.0;
                    } else {
                        if (this.indexZ2 >= 0) {
                            this.BparserZ.setVariable(this.indexZ2 + 1, d2);
                        }
                        this.data[n][n3][n5][2] = this.BparserZ.evaluate();
                    }
                    ++n5;
                }
                ++n3;
            }
            ++n;
        }
        n = 0;
        while (n < this.numElements) {
            ((ElementSurface)this.elements[n]).setData(this.data[n]);
            ++n;
        }
    }
}

