/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.table.AbstractTableModel;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.controls.XMLControl;
import org.opensourcephysics.controls.XMLLoader;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Dataset;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingFrame;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.Measurable;
import org.opensourcephysics.display.TeXParser;
import org.opensourcephysics.display.Trail;
import org.opensourcephysics.display.axes.XAxis;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexDataset
extends AbstractTableModel
implements Drawable,
Measurable,
Data {
    static final double PI2 = Math.PI * 2;
    public static final int AMP_CURVE = 0;
    public static final int RE_IM_CURVE = 1;
    public static final int PHASE_CURVE = 2;
    public static final int PHASE_BAR = 3;
    public static final int PHASE_POST = 4;
    protected boolean visible = true;
    protected boolean measurable = true;
    protected double[] xpoints;
    protected double[] re_points;
    protected double[] im_points;
    protected double[] amp_points;
    protected int index;
    private int markerShape = 2;
    private int markerSize = 5;
    private boolean centered = true;
    private boolean showPhase = true;
    private double xmin;
    private double xmax;
    private double ampmin;
    private double ampmax;
    private double remax;
    private double remin;
    private double immax;
    private double immin;
    private boolean sorted = false;
    private boolean connected = true;
    private int initialSize;
    private Color lineColor = Color.black;
    private GeneralPath ampPath;
    private Trail reTrail = new Trail();
    private Trail imTrail = new Trail();
    private String name = "Complex Data";
    private String xColumnName = "x";
    private String reColumnName = "re";
    private String imColumnName = "im";
    private int stride = 1;
    private AffineTransform flip;
    Dataset reDataset;
    Dataset imDataset;
    int datasetID = this.hashCode();

    public ComplexDataset() {
        this.reTrail.color = Color.RED;
        this.imTrail.color = Color.BLUE;
        this.initialSize = 10;
        this.xColumnName = "x";
        this.reColumnName = "re";
        this.imColumnName = "im";
        this.ampPath = new GeneralPath();
        this.index = 0;
        this.flip = new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f);
        this.clear();
    }

    public JFrame showLegend() {
        InteractivePanel interactivePanel = new InteractivePanel();
        interactivePanel.setPreferredGutters(5, 5, 5, 25);
        DrawingFrame drawingFrame = new DrawingFrame(DisplayRes.getString("GUIUtils.PhaseLegend"), interactivePanel);
        drawingFrame.setDefaultCloseOperation(2);
        drawingFrame.setJMenuBar(null);
        interactivePanel.addDrawable(new Phase());
        XAxis xAxis = new XAxis(DisplayRes.getString("ComplexDataset.Legend.XAxis"));
        xAxis.setLocationType(2);
        xAxis.setEnabled(true);
        interactivePanel.setClipAtGutter(false);
        interactivePanel.addDrawable(xAxis);
        interactivePanel.setSquareAspect(false);
        interactivePanel.setPreferredMinMax(-Math.PI, Math.PI, -1.0, 1.0);
        drawingFrame.setSize(300, 120);
        drawingFrame.setVisible(true);
        return drawingFrame;
    }

    @Override
    public boolean isMeasured() {
        if (this.index < 1) {
            return false;
        }
        return this.measurable;
    }

    @Override
    public double getXMin() {
        return this.xmin;
    }

    @Override
    public double getXMax() {
        return this.xmax;
    }

    @Override
    public double getYMin() {
        if (this.markerShape == 1) {
            return -this.ampmax;
        }
        if (this.centered && (this.markerShape == 3 || this.markerShape == 2)) {
            return -this.ampmax / 2.0;
        }
        return 0.0;
    }

    @Override
    public double getYMax() {
        if (this.markerShape == 1) {
            return this.ampmax;
        }
        if (this.centered && (this.markerShape == 3 || this.markerShape == 2)) {
            return this.ampmax / 2.0;
        }
        if (this.markerShape == 4) {
            return 1.1 * this.ampmax;
        }
        return this.ampmax;
    }

    public double[] getXPoints() {
        double[] dArray = new double[this.index];
        System.arraycopy(this.xpoints, 0, dArray, 0, this.index);
        return dArray;
    }

    public double[] getRePoints() {
        double[] dArray = new double[this.index];
        System.arraycopy(this.re_points, 0, dArray, 0, this.index);
        return dArray;
    }

    public double[] getImPoints() {
        double[] dArray = new double[this.index];
        System.arraycopy(this.im_points, 0, dArray, 0, this.index);
        return dArray;
    }

    public double[] getYPoints() {
        double[] dArray = new double[this.index];
        System.arraycopy(this.amp_points, 0, dArray, 0, this.index);
        return dArray;
    }

    public double[][] getPoints() {
        double[][] dArray = new double[this.index][3];
        int n = 0;
        while (n < this.index) {
            dArray[n] = new double[]{this.xpoints[n], this.re_points[n], this.im_points[n]};
            ++n;
        }
        return dArray;
    }

    public void setMarkerShape(int n) {
        this.markerShape = n;
    }

    public int getMarkerShape() {
        return this.markerShape;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(int n) {
        this.markerSize = n;
    }

    public void setSorted(boolean bl) {
        this.sorted = bl;
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public void setStride(int n) {
        this.stride = n;
        this.stride = Math.max(1, this.stride);
    }

    public boolean isSorted() {
        return this.sorted;
    }

    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public void setMeasurable(boolean bl) {
        this.measurable = bl;
    }

    public boolean getMeasurable() {
        return this.measurable;
    }

    public void setConnected(boolean bl) {
        this.connected = bl;
    }

    public void setCentered(boolean bl) {
        this.centered = bl;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setLineColor(Color color) {
        this.reTrail.color = this.lineColor = color;
        this.imTrail.color = this.lineColor;
    }

    public void setLineColor(Color color, Color color2) {
        this.lineColor = color;
        this.reTrail.color = color;
        this.imTrail.color = color2;
    }

    @Override
    public Color[] getLineColors() {
        return new Color[]{this.lineColor, this.lineColor};
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    @Override
    public Color[] getFillColors() {
        return new Color[]{this.lineColor, this.lineColor};
    }

    public Color getFillColor() {
        return this.lineColor;
    }

    public void setXYColumnNames(String string, String string2, String string3) {
        this.xColumnName = TeXParser.parseTeX(string);
        this.reColumnName = TeXParser.parseTeX(string2);
        this.imColumnName = TeXParser.parseTeX(string3);
    }

    public void setXYColumnNames(String string, String string2, String string3, String string4) {
        this.setXYColumnNames(string, string2, string3);
        this.name = TeXParser.parseTeX(string4);
    }

    public void append(double d, double d2, double d3) {
        if (Double.isNaN(d) || Double.isInfinite(d) || Double.isNaN(d2) || Double.isInfinite(d2) || Double.isNaN(d3) || Double.isInfinite(d3)) {
            return;
        }
        if (this.index >= this.xpoints.length) {
            this.setCapacity(this.xpoints.length * 2);
        }
        this.xpoints[this.index] = d;
        this.re_points[this.index] = d2;
        this.im_points[this.index] = d3;
        double d4 = Math.sqrt(d2 * d2 + d3 * d3);
        if (this.index == 0) {
            this.ampPath.moveTo((float)d, (float)d4);
        } else {
            this.ampPath.lineTo((float)d, (float)d4);
        }
        this.reTrail.addPoint(d, d2);
        this.imTrail.addPoint(d, d3);
        this.xmax = Math.max(d, this.xmax);
        this.xmin = Math.min(d, this.xmin);
        this.remin = Math.min(d2, this.remin);
        this.remax = Math.max(d2, this.remax);
        this.immin = Math.min(d3, this.immin);
        this.immax = Math.max(d3, this.immax);
        this.ampmin = Math.min(d4, this.ampmin);
        this.ampmax = Math.max(d4, this.ampmax);
        ++this.index;
        if (this.sorted && this.index > 1 && d < this.xpoints[this.index - 2]) {
            this.moveDatum(this.index - 1);
            this.recalculatePath();
        }
    }

    public void append(double[] dArray, double[] dArray2, double[] dArray3) {
        if (dArray == null) {
            return;
        }
        if (dArray2 == null || dArray3 == null || dArray.length != dArray2.length || dArray.length != dArray3.length) {
            throw new IllegalArgumentException("Array lenghts must be equal to append data.");
        }
        boolean bl = false;
        int n = 0;
        while (n < dArray.length) {
            if (Double.isNaN(dArray[n]) || Double.isInfinite(dArray[n]) || Double.isNaN(dArray2[n]) || Double.isInfinite(dArray2[n]) || Double.isNaN(dArray3[n]) || Double.isInfinite(dArray3[n])) {
                bl = true;
            } else {
                this.xmax = Math.max(dArray[n], this.xmax);
                this.xmin = Math.min(dArray[n], this.xmin);
                this.remin = Math.min(dArray2[n], this.remin);
                this.remax = Math.max(dArray2[n], this.remax);
                this.immin = Math.min(dArray3[n], this.immin);
                this.immax = Math.max(dArray3[n], this.immax);
                double d = Math.sqrt(dArray2[n] * dArray2[n] + dArray3[n] * dArray3[n]);
                this.ampmin = Math.min(d, this.ampmin);
                this.ampmax = Math.max(d, this.ampmax);
                if (this.index == 0 && n == 0) {
                    this.ampPath.moveTo((float)dArray[n], (float)d);
                } else {
                    this.ampPath.lineTo((float)dArray[n], (float)d);
                }
                this.reTrail.addPoint(dArray[n], dArray2[n]);
                this.imTrail.addPoint(dArray[n], dArray3[n]);
            }
            ++n;
        }
        n = dArray.length;
        int n2 = this.xpoints.length - this.index;
        if (n > n2) {
            this.setCapacity(2 * (this.xpoints.length + n));
        }
        System.arraycopy(dArray, 0, this.xpoints, this.index, n);
        System.arraycopy(dArray2, 0, this.re_points, this.index, n);
        System.arraycopy(dArray3, 0, this.im_points, this.index, n);
        this.index += n;
        if (bl) {
            this.cleanBadData();
        }
        if (this.sorted) {
            this.insertionSort();
        }
    }

    public void append(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            return;
        }
        if (dArray2 == null || 2 * dArray.length != dArray2.length) {
            throw new IllegalArgumentException("Length of z array must be twice the length of the x array.");
        }
        boolean bl = false;
        int n = dArray.length;
        int n2 = this.xpoints.length - this.index;
        if (n > n2) {
            this.setCapacity(2 * (this.xpoints.length + n));
        }
        int n3 = 0;
        while (n3 < dArray.length) {
            if (Double.isNaN(dArray[n3]) || Double.isInfinite(dArray[n3]) || Double.isNaN(dArray2[2 * n3]) || Double.isInfinite(dArray2[2 * n3]) || Double.isNaN(dArray2[2 * n3 + 1]) || Double.isInfinite(dArray2[2 * n3 + 1])) {
                bl = true;
            } else {
                this.xmax = Math.max(dArray[n3], this.xmax);
                this.xmin = Math.min(dArray[n3], this.xmin);
                this.remin = Math.min(dArray2[2 * n3], this.remin);
                this.remax = Math.max(dArray2[2 * n3], this.remax);
                this.immin = Math.min(dArray2[2 * n3 + 1], this.immin);
                this.immax = Math.max(dArray2[2 * n3 + 1], this.immax);
                double d = Math.sqrt(dArray2[2 * n3] * dArray2[2 * n3] + dArray2[2 * n3 + 1] * dArray2[2 * n3 + 1]);
                this.ampmin = Math.min(d, this.ampmin);
                this.ampmax = Math.max(d, this.ampmax);
                this.xpoints[this.index + n3] = dArray[n3];
                this.re_points[this.index + n3] = dArray2[2 * n3];
                this.im_points[this.index + n3] = dArray2[2 * n3 + 1];
                if (this.index == 0 && n3 == 0) {
                    this.ampPath.moveTo((float)dArray[n3], (float)d);
                } else {
                    this.ampPath.lineTo((float)dArray[n3], (float)d);
                }
                this.reTrail.addPoint(dArray[n3], dArray2[2 * n3]);
                this.imTrail.addPoint(dArray[n3], dArray2[2 * n3 + 1]);
            }
            ++n3;
        }
        this.index += n;
        if (bl) {
            this.cleanBadData();
        }
        if (this.sorted) {
            this.insertionSort();
        }
    }

    @Override
    public void setID(int n) {
        this.datasetID = n;
    }

    @Override
    public int getID() {
        return this.datasetID;
    }

    private void cleanBadData() {
        int n = 0;
        while (n < this.index) {
            if (Double.isNaN(this.xpoints[n]) || Double.isInfinite(this.xpoints[n]) || Double.isNaN(this.re_points[n]) || Double.isInfinite(this.re_points[n]) || Double.isNaN(this.im_points[n]) || Double.isInfinite(this.im_points[n])) {
                if (this.index == 1 || n == this.index - 1) {
                    --this.index;
                    break;
                }
                System.arraycopy(this.xpoints, n + 1, this.xpoints, n, this.index - n - 1);
                System.arraycopy(this.re_points, n + 1, this.re_points, n, this.index - n - 1);
                System.arraycopy(this.im_points, n + 1, this.im_points, n, this.index - n - 1);
                --this.index;
            }
            ++n;
        }
    }

    private void setCapacity(int n) {
        double[] dArray = this.xpoints;
        this.xpoints = new double[n];
        System.arraycopy(dArray, 0, this.xpoints, 0, dArray.length);
        double[] dArray2 = this.re_points;
        this.re_points = new double[n];
        System.arraycopy(dArray2, 0, this.re_points, 0, dArray2.length);
        double[] dArray3 = this.im_points;
        this.im_points = new double[n];
        System.arraycopy(dArray3, 0, this.im_points, 0, dArray3.length);
        double[] dArray4 = this.amp_points;
        this.amp_points = new double[n];
        System.arraycopy(dArray4, 0, this.amp_points, 0, dArray4.length);
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        switch (this.markerShape) {
            case 0: {
                this.drawLinePlot(drawingPanel, graphics2D);
                break;
            }
            case 1: {
                this.drawReImPlot(drawingPanel, graphics2D);
                break;
            }
            case 2: {
                this.drawPhaseCurve(drawingPanel, graphics2D);
                break;
            }
            case 3: {
                this.drawPhaseBars(drawingPanel, graphics2D);
                break;
            }
            case 4: {
                this.drawPhasePosts(drawingPanel, graphics2D);
            }
        }
    }

    public void clear() {
        this.index = 0;
        this.xpoints = new double[this.initialSize];
        this.re_points = new double[this.initialSize];
        this.im_points = new double[this.initialSize];
        this.amp_points = new double[this.initialSize];
        this.ampPath.reset();
        this.reTrail.clear();
        this.imTrail.clear();
        this.resetXYMinMax();
    }

    public String toString() {
        if (this.index == 0) {
            return "Dataset empty.";
        }
        String string = String.valueOf(this.xpoints[0]) + "\t" + this.re_points[0] + "\t" + this.im_points[0] + "\n";
        StringBuffer stringBuffer = new StringBuffer(this.index * string.length());
        int n = 0;
        while (n < this.index) {
            stringBuffer.append(this.xpoints[n]);
            stringBuffer.append('\t');
            stringBuffer.append(this.re_points[n]);
            stringBuffer.append('\t');
            stringBuffer.append(this.im_points[n]);
            stringBuffer.append('\n');
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public int getRowCount() {
        return (this.index + this.stride - 1) / this.stride;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return this.xColumnName;
            }
            case 1: {
                return this.reColumnName;
            }
            case 2: {
                return this.imColumnName;
            }
        }
        return "";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        n *= this.stride;
        switch (n2) {
            case 0: {
                return new Double(this.xpoints[n]);
            }
            case 1: {
                return new Double(this.re_points[n]);
            }
            case 2: {
                return new Double(this.im_points[n]);
            }
        }
        return new Double(0.0);
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return Double.class;
    }

    private void resetXYMinMax() {
        this.xmin = Double.MAX_VALUE;
        this.xmax = -1.7976931348623157E308;
        this.remax = -1.7976931348623157E308;
        this.remin = Double.MAX_VALUE;
        this.immax = -1.7976931348623157E308;
        this.immin = Double.MAX_VALUE;
        this.ampmax = -1.7976931348623157E308;
        this.ampmin = Double.MAX_VALUE;
        int n = 0;
        while (n < this.index) {
            this.xmin = Math.min(this.xpoints[n], this.xmin);
            this.xmax = Math.max(this.xpoints[n], this.xmax);
            this.remax = Math.max(this.re_points[n], this.remax);
            this.remin = Math.min(this.re_points[n], this.remin);
            this.immax = Math.max(this.im_points[n], this.immax);
            this.immin = Math.min(this.im_points[n], this.immin);
            this.ampmax = Math.max(this.amp_points[n], this.ampmax);
            this.ampmin = Math.min(this.amp_points[n], this.ampmin);
            ++n;
        }
    }

    protected void insertionSort() {
        boolean bl = false;
        if (this.index < 2) {
            return;
        }
        int n = 1;
        while (n < this.index) {
            if (this.xpoints[n] < this.xpoints[n - 1]) {
                bl = true;
                this.moveDatum(n);
            }
            ++n;
        }
        if (bl) {
            this.recalculatePath();
        }
    }

    protected void recalculatePath() {
        this.ampPath.reset();
        if (this.index < 1) {
            return;
        }
        float f = (float)Math.sqrt(this.re_points[0] * this.re_points[0] + this.im_points[0] * this.im_points[0]);
        this.ampPath.moveTo((float)this.xpoints[0], f);
        int n = 1;
        while (n < this.index) {
            f = (float)Math.sqrt(this.re_points[n] * this.re_points[n] + this.im_points[n] * this.im_points[n]);
            this.ampPath.lineTo((float)this.xpoints[n], f);
            ++n;
        }
    }

    protected void moveDatum(int n) {
        if (n < 1) {
            return;
        }
        double d = this.xpoints[n];
        double d2 = this.re_points[n];
        double d3 = this.im_points[n];
        int n2 = 0;
        while (n2 < this.index) {
            if (this.xpoints[n2] > d) {
                System.arraycopy(this.xpoints, n2, this.xpoints, n2 + 1, n - n2);
                this.xpoints[n2] = d;
                System.arraycopy(this.re_points, n2, this.re_points, n2 + 1, n - n2);
                this.re_points[n2] = d2;
                System.arraycopy(this.im_points, n2, this.im_points, n2 + 1, n - n2);
                this.im_points[n2] = d3;
                return;
            }
            ++n2;
        }
    }

    protected void drawLinePlot(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        AffineTransform affineTransform = (AffineTransform)drawingPanel.getPixelTransform().clone();
        Shape shape = this.ampPath.createTransformedShape(affineTransform);
        graphics2D.setColor(this.lineColor);
        graphics2D.draw(shape);
        if (this.showPhase) {
            affineTransform.concatenate(this.flip);
            shape = this.ampPath.createTransformedShape(affineTransform);
            graphics2D.draw(shape);
        }
    }

    protected void drawReImPlot(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        this.reTrail.draw(drawingPanel, graphics2D);
        this.imTrail.draw(drawingPanel, graphics2D);
    }

    protected void drawPhaseCurve(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        double[] dArray = this.xpoints;
        double[] dArray2 = this.re_points;
        double[] dArray3 = this.im_points;
        int n = this.index;
        if (n < 1) {
            return;
        }
        if (dArray.length < n || dArray.length != dArray2.length || dArray.length != dArray3.length) {
            return;
        }
        int n2 = drawingPanel.yToPix(0.0);
        int[] nArray = new int[4];
        int[] nArray2 = new int[4];
        nArray[2] = drawingPanel.xToPix(dArray[0]);
        double d = Math.sqrt(dArray2[0] * dArray2[0] + dArray3[0] * dArray3[0]);
        nArray2[3] = drawingPanel.yToPix(-d);
        nArray2[2] = drawingPanel.yToPix(d);
        double d2 = dArray2[0];
        double d3 = dArray3[0];
        int n3 = 0;
        while (n3 < n) {
            double d4 = dArray2[n3];
            double d5 = dArray3[n3];
            double d6 = Math.sqrt(d4 * d4 + d5 * d5);
            if (d6 > 0.0) {
                graphics2D.setColor(DisplayColors.phaseToColor(Math.atan2((d5 + d3) / 2.0, (d2 + d4) / 2.0)));
            }
            nArray[0] = drawingPanel.xToPix(dArray[n3]);
            if (this.centered) {
                nArray2[0] = drawingPanel.yToPix(-d6 / 2.0);
                nArray2[1] = drawingPanel.yToPix(d6 / 2.0);
            } else {
                nArray2[0] = n2;
                nArray2[1] = drawingPanel.yToPix(d6);
            }
            nArray[1] = nArray[0];
            nArray[3] = nArray[2];
            graphics2D.fillPolygon(nArray, nArray2, 4);
            nArray[2] = nArray[0];
            nArray2[3] = nArray2[0];
            nArray2[2] = nArray2[1];
            d3 = d5;
            d2 = d4;
            d = d6;
            ++n3;
        }
    }

    protected void drawPhaseBars(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        if (this.index < 1) {
            return;
        }
        double[] dArray = this.xpoints;
        double[] dArray2 = this.re_points;
        double[] dArray3 = this.im_points;
        if (dArray.length < this.index || dArray.length != dArray2.length || dArray.length != dArray3.length) {
            return;
        }
        int n = (int)(0.5 + (double)(drawingPanel.xToPix(this.xmax) - drawingPanel.xToPix(this.xmin)) / (2.0 * (double)(this.index - 1)));
        n = Math.min(this.markerSize, n);
        int n2 = drawingPanel.yToPix(0.0);
        int n3 = 0;
        while (n3 < this.index) {
            double d = dArray2[n3];
            double d2 = dArray3[n3];
            double d3 = Math.sqrt(d * d + d2 * d2);
            graphics2D.setColor(DisplayColors.phaseToColor(Math.atan2(d2, d)));
            int n4 = drawingPanel.xToPix(dArray[n3]);
            int n5 = Math.abs(n2 - drawingPanel.yToPix(d3));
            if (this.centered) {
                graphics2D.fillRect(n4 - n, n2 - n5 / 2, 2 * n + 1, n5);
            } else {
                graphics2D.fillRect(n4 - n, n2 - n5, 2 * n + 1, n5);
            }
            ++n3;
        }
    }

    protected void drawPhasePosts(DrawingPanel drawingPanel, Graphics2D graphics2D) {
        if (this.index < 1) {
            return;
        }
        double[] dArray = this.xpoints;
        double[] dArray2 = this.re_points;
        double[] dArray3 = this.im_points;
        if (dArray.length < this.index || dArray.length != dArray2.length || dArray.length != dArray3.length) {
            return;
        }
        int n = (int)(0.5 + (double)(drawingPanel.xToPix(this.xmax) - drawingPanel.xToPix(this.xmin)) / (2.0 * (double)(this.index - 1)));
        n = Math.min(this.markerSize, n);
        int n2 = 0;
        while (n2 < this.index) {
            double d = dArray2[n2];
            double d2 = dArray3[n2];
            double d3 = Math.sqrt(d * d + d2 * d2);
            this.drawPost(drawingPanel, graphics2D, dArray[n2], d3, n, DisplayColors.phaseToColor(Math.atan2(d2, d)));
            ++n2;
        }
    }

    private void drawPost(DrawingPanel drawingPanel, Graphics2D graphics2D, double d, double d2, int n, Color color) {
        Color color2 = Color.BLACK;
        int n2 = drawingPanel.xToPix(d);
        int n3 = drawingPanel.yToPix(d2);
        int n4 = n * 2 + 1;
        int n5 = Math.min(drawingPanel.yToPix(0.0), drawingPanel.yToPix(drawingPanel.getYMin()));
        Rectangle2D.Double double_ = new Rectangle2D.Double(n2 - n, n3 - n, n4, n4);
        graphics2D.setColor(color2);
        graphics2D.drawLine(n2, n3, n2, n5);
        graphics2D.setColor(color);
        graphics2D.fill(double_);
        graphics2D.setColor(color2);
        graphics2D.draw(double_);
    }

    public static XML.ObjectLoader getLoader() {
        return new Loader();
    }

    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getColumnNames() {
        return new String[]{"Re", "Im"};
    }

    @Override
    public double[][] getData2D() {
        double[][] dArray = new double[3][this.index];
        dArray[0] = this.getXPoints();
        dArray[1] = this.getRePoints();
        dArray[2] = this.getImPoints();
        return dArray;
    }

    @Override
    public double[][][] getData3D() {
        return null;
    }

    @Override
    public ArrayList<Dataset> getDatasets() {
        if (this.reDataset == null || this.imDataset == null) {
            this.reDataset = new Dataset(Color.RED, Color.RED, true);
            this.imDataset = new Dataset(Color.BLUE, Color.BLUE, true);
        }
        this.reDataset.clear();
        this.imDataset.clear();
        this.reDataset.setXYColumnNames(this.xColumnName, this.reColumnName, "Re(" + this.name + ")");
        this.imDataset.setXYColumnNames(this.xColumnName, this.imColumnName, "Im(" + this.name + ")");
        this.reDataset.append(this.getXPoints(), this.getRePoints());
        this.imDataset.append(this.getXPoints(), this.getImPoints());
        ArrayList<Dataset> arrayList = new ArrayList<Dataset>();
        arrayList.add(this.reDataset);
        arrayList.add(this.imDataset);
        return arrayList;
    }

    @Override
    public List<Data> getDataList() {
        if (this.reDataset == null || this.imDataset == null) {
            this.reDataset = new Dataset(Color.RED, Color.RED, true);
            this.imDataset = new Dataset(Color.BLUE, Color.BLUE, true);
        }
        this.reDataset.clear();
        this.imDataset.clear();
        this.reDataset.setXYColumnNames(this.xColumnName, this.reColumnName, "Re(" + this.name + ")");
        this.imDataset.setXYColumnNames(this.xColumnName, this.imColumnName, "Im(" + this.name + ")");
        this.reDataset.append(this.getXPoints(), this.getRePoints());
        this.imDataset.append(this.getXPoints(), this.getImPoints());
        ArrayList<Data> arrayList = new ArrayList<Data>();
        arrayList.add(this.reDataset);
        arrayList.add(this.imDataset);
        return arrayList;
    }

    private static class Loader
    extends XMLLoader {
        private Loader() {
        }

        public void saveObject(XMLControl xMLControl, Object object) {
            ComplexDataset complexDataset = (ComplexDataset)object;
            xMLControl.setValue("points", complexDataset.getPoints());
            xMLControl.setValue("marker_shape", complexDataset.getMarkerShape());
            xMLControl.setValue("marker_size", complexDataset.getMarkerSize());
            xMLControl.setValue("sorted", complexDataset.isSorted());
            xMLControl.setValue("connected", complexDataset.isConnected());
            xMLControl.setValue("name", complexDataset.name);
            xMLControl.setValue("x_name", complexDataset.xColumnName);
            xMLControl.setValue("re_name", complexDataset.reColumnName);
            xMLControl.setValue("im_name", complexDataset.imColumnName);
            xMLControl.setValue("line_color", complexDataset.lineColor);
            xMLControl.setValue("index", complexDataset.index);
        }

        public Object createObject(XMLControl xMLControl) {
            return new ComplexDataset();
        }

        public Object loadObject(XMLControl xMLControl, Object object) {
            ComplexDataset complexDataset = (ComplexDataset)object;
            double[][] dArray = (double[][])xMLControl.getObject("points");
            if (dArray != null && dArray[0] != null) {
                complexDataset.clear();
                int n = 0;
                while (n < dArray.length) {
                    complexDataset.append(dArray[n][0], dArray[n][1], dArray[n][2]);
                    ++n;
                }
            }
            double[] dArray2 = (double[])xMLControl.getObject("x_points");
            double[] dArray3 = (double[])xMLControl.getObject("y_points");
            if (dArray2 != null && dArray3 != null) {
                complexDataset.clear();
                complexDataset.append(dArray2, dArray3);
            }
            if (xMLControl.getPropertyNames().contains("marker_shape")) {
                complexDataset.setMarkerShape(xMLControl.getInt("marker_shape"));
            }
            if (xMLControl.getPropertyNames().contains("marker_size")) {
                complexDataset.setMarkerSize(xMLControl.getInt("marker_size"));
            }
            complexDataset.setSorted(xMLControl.getBoolean("sorted"));
            complexDataset.setConnected(xMLControl.getBoolean("connected"));
            complexDataset.name = xMLControl.getString("name");
            complexDataset.xColumnName = xMLControl.getString("x_name");
            complexDataset.reColumnName = xMLControl.getString("re_name");
            complexDataset.imColumnName = xMLControl.getString("im_name");
            Color color = (Color)xMLControl.getObject("line_color");
            if (color != null) {
                complexDataset.lineColor = color;
            }
            complexDataset.index = xMLControl.getInt("index");
            return object;
        }
    }

    class Phase
    implements Drawable {
        Phase() {
        }

        public void draw(DrawingPanel drawingPanel, Graphics graphics) {
            int n = drawingPanel.getWidth() - 5 + 1;
            int n2 = drawingPanel.getHeight() - 25;
            int n3 = 5;
            while (n3 < n) {
                double d = Math.PI * (double)(-1.0f + 2.0f * (float)n3 / (float)n);
                Color color = DisplayColors.phaseToColor(d);
                graphics.setColor(color);
                graphics.drawLine(n3, 5, n3, n2);
                ++n3;
            }
        }
    }
}

