/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.displayejs.ControlElementSet;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.DisplayColors;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveParticle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlParticleSet
extends ControlElementSet {
    private static final int PARTICLE_SET_ADDED = 1;
    private static final int MY_STYLE = 19;
    private static final int MY_PRIMARY_COLOR = 23;
    private static final int MY_SECONDARY_COLOR = 24;
    private static List<String> infoList = null;

    @Override
    protected Drawable createDrawable() {
        this.elementSet = new ElementSet(1, InteractiveParticle.class);
        this.elementSet.setEnabled(0, true);
        return this.elementSet;
    }

    @Override
    protected int getPropertiesDisplacement() {
        return 1;
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("pixelSize");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("pixelSize")) {
            return "boolean|boolean[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n2 = 0;
                    int n3 = this.elementSet.getNumberOfElements();
                    while (n2 < n3) {
                        ((InteractiveParticle)this.elementSet.elementAt(n2)).setPixelSize(blArray[n2]);
                        ++n2;
                    }
                } else {
                    int n4 = 0;
                    int n5 = this.elementSet.getNumberOfElements();
                    while (n4 < n5) {
                        ((InteractiveParticle)this.elementSet.elementAt(n4)).setPixelSize(value.getBoolean());
                        ++n4;
                    }
                }
                break;
            }
            case 19: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n6 = 0;
                    int n7 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    while (n6 < n7) {
                        ((InteractiveParticle)this.elementSet.elementAt(n6)).setShapeType(nArray[n6]);
                        ++n6;
                    }
                } else {
                    int n8 = value.getInteger();
                    int n9 = 0;
                    int n10 = this.elementSet.getNumberOfElements();
                    while (n9 < n10) {
                        ((InteractiveParticle)this.elementSet.elementAt(n9)).setShapeType(n8);
                        ++n9;
                    }
                }
                break;
            }
            case 23: {
                if (value instanceof IntegerValue) {
                    Color color = DisplayColors.getLineColor(value.getInteger());
                    int n11 = 0;
                    int n12 = this.elementSet.getNumberOfElements();
                    while (n11 < n12) {
                        this.elementSet.elementAt(n11).getStyle().setFillPattern(color);
                        ++n11;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n13 = 0;
                    int n14 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    while (n13 < n14) {
                        this.elementSet.elementAt(n13).getStyle().setFillPattern(DisplayColors.getLineColor(nArray[n13]));
                        ++n13;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n15 = 0;
                    int n16 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    while (n15 < n16) {
                        this.elementSet.elementAt(n15).getStyle().setFillPattern((Paint)objectArray[n15]);
                        ++n15;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Paint paint = (Paint)value.getObject();
                    if (paint == NULL_COLOR) {
                        paint = null;
                    }
                    int n17 = 0;
                    int n18 = this.elementSet.getNumberOfElements();
                    while (n17 < n18) {
                        this.elementSet.elementAt(n17).getStyle().setFillPattern(paint);
                        ++n17;
                    }
                }
                break;
            }
            case 24: {
                if (value instanceof IntegerValue) {
                    Color color = DisplayColors.getLineColor(value.getInteger());
                    int n19 = 0;
                    int n20 = this.elementSet.getNumberOfElements();
                    while (n19 < n20) {
                        this.elementSet.elementAt(n19).getStyle().setEdgeColor(color);
                        ++n19;
                    }
                } else if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n21 = 0;
                    int n22 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    while (n21 < n22) {
                        this.elementSet.elementAt(n21).getStyle().setEdgeColor(DisplayColors.getLineColor(nArray[n21]));
                        ++n21;
                    }
                } else if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n23 = 0;
                    int n24 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    while (n23 < n24) {
                        this.elementSet.elementAt(n23).getStyle().setEdgeColor((Color)objectArray[n23]);
                        ++n23;
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n25 = 0;
                    int n26 = this.elementSet.getNumberOfElements();
                    while (n25 < n26) {
                        this.elementSet.elementAt(n25).getStyle().setEdgeColor(color);
                        ++n25;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                int n3 = this.elementSet.getNumberOfElements();
                while (n2 < n3) {
                    ((InteractiveParticle)this.elementSet.elementAt(n2)).setPixelSize(false);
                    ++n2;
                }
                break;
            }
            case 19: {
                int n4 = 0;
                int n5 = this.elementSet.getNumberOfElements();
                while (n4 < n5) {
                    ((InteractiveParticle)this.elementSet.elementAt(n4)).setShapeType(1);
                    ++n4;
                }
                break;
            }
            case 23: {
                int n6 = 0;
                int n7 = this.elementSet.getNumberOfElements();
                while (n6 < n7) {
                    this.elementSet.elementAt(n6).getStyle().setFillPattern(Color.blue);
                    ++n6;
                }
                break;
            }
            case 24: {
                int n8 = 0;
                int n9 = this.elementSet.getNumberOfElements();
                while (n8 < n9) {
                    this.elementSet.elementAt(n8).getStyle().setEdgeColor(Color.black);
                    ++n8;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "false";
            }
            default: {
                return super.getDefaultValueString(n - 1);
            }
            case 19: {
                return "ELLIPSE";
            }
            case 23: {
                return "BLUE";
            }
            case 24: 
        }
        return "BLACK";
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }
}

