/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputAdapter;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.NeedsUpdate;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlParentOfDrawables;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.swing.NeedsPreUpdate;
import org.opensourcephysics.display.Data;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.dialogs.AutoScaleInspector;
import org.opensourcephysics.display.dialogs.ScaleInspector;
import org.opensourcephysics.tools.ToolForData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ControlDrawablesParent
extends ControlSwingElement
implements NeedsUpdate,
ControlParentOfDrawables {
    protected Vector<NeedsPreUpdate> preupdateList = new Vector();
    protected boolean isZoomed = false;
    protected double minX;
    protected double maxX;
    protected double minY;
    protected double maxY;
    protected boolean autoX;
    protected boolean autoY;
    protected boolean enableMenu = true;
    protected boolean xminSet = false;
    protected boolean xmaxSet = false;
    protected boolean yminSet = false;
    protected boolean ymaxSet = false;

    public ControlDrawablesParent() {
        this.getVisual().addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.isControlDown() && ControlDrawablesParent.this.getSimulation() != null) {
                    if (keyEvent.getKeyCode() == 77) {
                        ControlDrawablesParent.this.getPopupMenu(0, 0);
                    } else if (keyEvent.getKeyCode() == 80) {
                        ControlDrawablesParent.this.printScreen();
                    }
                }
            }
        });
        this.getVisual().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (!ControlDrawablesParent.this.enableMenu || ControlDrawablesParent.this.getSimulation() == null || !OSPRuntime.isPopupTrigger(mouseEvent)) {
                    return;
                }
                if (!ToolForData.getTool().isFullTool()) {
                    ControlDrawablesParent.this.getPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                    return;
                }
                Interactive interactive = ((InteractivePanel)ControlDrawablesParent.this.getVisual()).getInteractive();
                if (interactive instanceof Data) {
                    JPopupMenu jPopupMenu = new JPopupMenu();
                    for (Object e : ControlDrawablesParent.access$0(ControlDrawablesParent.this.getVisual(), (Data)((Object)interactive))) {
                        jPopupMenu.add((JMenuItem)e);
                    }
                    jPopupMenu.show(ControlDrawablesParent.this.getVisual(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    ControlDrawablesParent.this.getPopupMenu(mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    @Override
    public String getPropertyCommonName(String string) {
        if (string.equals("pressaction")) {
            return "pressAction";
        }
        if (string.equals("dragaction")) {
            return "dragAction";
        }
        if (string.equals("action")) {
            return "releaseAction";
        }
        return super.getPropertyCommonName(string);
    }

    @Override
    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null) {
            return;
        }
        JMenuItem jMenuItem = new JMenuItem("tools_res:MenuItem.Scale");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlDrawablesParent.this.isZoomed = true;
                ScaleInspector scaleInspector = new ScaleInspector((DrawingPanel)ControlDrawablesParent.this.getVisual());
                scaleInspector.setLocationRelativeTo(ControlDrawablesParent.this.getVisual());
                scaleInspector.updateDisplay();
                scaleInspector.setVisible(true);
            }
        });
        jMenuItem.setActionCommand("tools_res:MenuItem.Scale");
        JMenuItem jMenuItem2 = new JMenuItem("tools_res:MenuItem.ZoomIn");
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlDrawablesParent.this.checkAutoscaling();
                new ZoomController();
            }
        });
        jMenuItem2.setActionCommand("tools_res:MenuItem.ZoomIn");
        JMenuItem jMenuItem3 = new JMenuItem("tools_res:MenuItem.ZoomOut");
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlDrawablesParent.this.checkAutoscaling();
                double d = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getXMin();
                double d2 = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getXMax();
                double d3 = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getYMin();
                double d4 = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getYMax();
                double d5 = d2 - d;
                double d6 = d4 - d3;
                ControlDrawablesParent.this.isZoomed = true;
                if (!((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAutoscaleX()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setPreferredMinMaxX(d - d5 / 2.0, d2 + d5 / 2.0);
                }
                if (!((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAutoscaleY()) {
                    ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setPreferredMinMaxY(d3 - d6 / 2.0, d4 + d6 / 2.0);
                }
                ControlDrawablesParent.this.update();
            }
        });
        jMenuItem3.setActionCommand("tools_res:MenuItem.ZoomOut");
        JMenuItem jMenuItem4 = new JMenuItem("tools_res:MenuItem.ZoomCancel");
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlDrawablesParent.this.isZoomed = false;
                ControlDrawablesParent.this.updateAutoscale();
                ControlDrawablesParent.this.update();
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).render();
            }
        });
        jMenuItem4.setActionCommand("tools_res:MenuItem.ZoomCancel");
        JMenu jMenu = new JMenu("tools_res:MenuItem.Zoom");
        jMenu.setActionCommand("tools_res:MenuItem.Zoom");
        jMenu.add(jMenuItem);
        jMenu.add(jMenuItem2);
        jMenu.add(jMenuItem3);
        jMenu.add(jMenuItem4);
        final JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem("display_res:DrawingFrame.Text_checkbox_label", false);
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setAntialiasTextOn(jCheckBoxMenuItem.isSelected());
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).invalidateImage();
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).repaint();
            }
        });
        jCheckBoxMenuItem.setActionCommand("display_res:DrawingFrame.Text_checkbox_label");
        final JCheckBoxMenuItem jCheckBoxMenuItem2 = new JCheckBoxMenuItem("display_res:DrawingFrame.Drawing_textbox_label", false);
        jCheckBoxMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).setAntialiasShapeOn(jCheckBoxMenuItem2.isSelected());
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).invalidateImage();
                ((DrawingPanel)ControlDrawablesParent.this.getVisual()).repaint();
            }
        });
        jCheckBoxMenuItem2.setActionCommand("display_res:DrawingFrame.Drawing_textbox_label");
        JMenu jMenu2 = new JMenu("display_res:DrawingFrame.AntiAlias_menu_title");
        jMenu2.add(jCheckBoxMenuItem);
        jMenu2.add(jCheckBoxMenuItem2);
        jMenu2.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                jCheckBoxMenuItem.setSelected(((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAntialiasTextOn());
                jCheckBoxMenuItem2.setSelected(((DrawingPanel)ControlDrawablesParent.this.getVisual()).isAntialiasShapeOn());
            }
        });
        jMenu2.setActionCommand("display_res:DrawingFrame.AntiAlias_menu_title");
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(jMenu);
        arrayList.add(jMenu2);
        if (ToolForData.getTool().isFullTool()) {
            JMenuItem jMenuItem5 = new JMenuItem("tools_res:DataTool.Frame.Title");
            jMenuItem5.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToolForData.getTool().showDataTool(ControlDrawablesParent.this.getVisual(), ControlDrawablesParent.this.getAllData(ControlDrawablesParent.this.getDrawingPanel()));
                }
            });
            jMenuItem5.setActionCommand("tools_res:DataTool.Frame.Title");
            JMenuItem jMenuItem6 = new JMenuItem("tools_res:FourierTool.Frame.Title");
            jMenuItem6.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToolForData.getTool().showFourierTool(ControlDrawablesParent.this.getVisual(), ControlDrawablesParent.this.getAllData(ControlDrawablesParent.this.getDrawingPanel()));
                }
            });
            jMenuItem6.setActionCommand("tools_res:FourierTool.Frame.Title");
            arrayList.add(jMenuItem5);
            arrayList.add(jMenuItem6);
        }
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), arrayList);
    }

    @Override
    public DrawingPanel getDrawingPanel() {
        return (DrawingPanel)this.getVisual();
    }

    private List<Data> getAllData(DrawingPanel drawingPanel) {
        ArrayList<Data> arrayList = new ArrayList<Data>();
        for (Drawable drawable : drawingPanel.getDrawables()) {
            if (!(drawable instanceof Data)) continue;
            arrayList.add((Data)((Object)drawable));
        }
        return arrayList;
    }

    @Override
    public void reset() {
        this.isZoomed = false;
        this.updateAutoscale();
        if (this.isUnderEjs) {
            ((DrawingPanel)this.getVisual()).setBuffered(false);
        }
    }

    protected void updateAutoscale() {
        if (!this.isZoomed) {
            DrawingPanel drawingPanel = (DrawingPanel)this.getVisual();
            drawingPanel.setAutoscaleX(this.autoX);
            drawingPanel.setAutoscaleY(this.autoY);
            this.updateExtrema();
        }
    }

    protected void updateExtrema() {
        if (!this.isZoomed) {
            DrawingPanel drawingPanel = (DrawingPanel)this.getVisual();
            if (drawingPanel.isAutoscaleX()) {
                if (this.xminSet || this.xmaxSet) {
                    drawingPanel.limitAutoscaleX(this.minX, this.maxX);
                }
            } else {
                drawingPanel.setPreferredMinMaxX(this.minX, this.maxX);
            }
            if (drawingPanel.isAutoscaleY()) {
                if (this.yminSet || this.ymaxSet) {
                    drawingPanel.limitAutoscaleY(this.minY, this.maxY);
                }
            } else {
                drawingPanel.setPreferredMinMaxY(this.minY, this.maxY);
            }
            if (this.isUnderEjs) {
                drawingPanel.render();
            }
        }
    }

    protected void checkAutoscaling() {
        DrawingPanel drawingPanel = (DrawingPanel)this.getVisual();
        if (drawingPanel.isAutoscaleX() || drawingPanel.isAutoscaleY()) {
            this.isZoomed = true;
            AutoScaleInspector autoScaleInspector = new AutoScaleInspector(drawingPanel);
            autoScaleInspector.setLocationRelativeTo(drawingPanel);
            autoScaleInspector.updateDisplay();
            autoScaleInspector.setVisible(true);
        }
    }

    @Override
    public boolean acceptsChild(ControlElement controlElement) {
        return controlElement instanceof ControlDrawable;
    }

    @Override
    public void update() {
        Enumeration<NeedsPreUpdate> enumeration = this.preupdateList.elements();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().preupdate();
        }
        if (this.myGroup != null && this.myGroup.isCollectingData()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread() || Thread.currentThread().getName().equals("main")) {
            ((DrawingPanel)this.getVisual()).invalidateImage();
            ((DrawingPanel)this.getVisual()).repaint();
        } else {
            ((DrawingPanel)this.getVisual()).render();
        }
    }

    @Override
    public Component getComponent() {
        return this.getVisual();
    }

    @Override
    public void addToPreupdateList(NeedsPreUpdate needsPreUpdate) {
        this.preupdateList.add(needsPreUpdate);
    }

    @Override
    public void removeFromPreupdateList(NeedsPreUpdate needsPreUpdate) {
        this.preupdateList.remove(needsPreUpdate);
    }

    @Override
    public void addDrawable(Drawable drawable) {
        ((DrawingPanel)this.getVisual()).addDrawable(drawable);
    }

    @Override
    public void addDrawableAtIndex(int n, Drawable drawable) {
        ((DrawingPanel)this.getVisual()).addDrawableAtIndex(n, drawable);
    }

    @Override
    public void removeDrawable(Drawable drawable) {
        ((DrawingPanel)this.getVisual()).removeDrawable(drawable);
    }

    public ControlDrawable getSelectedDrawable() {
        return null;
    }

    static /* synthetic */ List access$0(Component component, Data data) {
        return ControlElement.getDataInformationMenuEntries(component, data);
    }

    class ZoomController
    extends MouseInputAdapter {
        ZoomController() {
            DrawingPanel drawingPanel = (DrawingPanel)ControlDrawablesParent.this.getVisual();
            drawingPanel.addMouseListener(this);
            drawingPanel.addMouseMotionListener(this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().startZoom(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().drag(mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            DrawingPanel drawingPanel = (DrawingPanel)ControlDrawablesParent.this.getVisual();
            Rectangle2D.Double double_ = ((DrawingPanel)ControlDrawablesParent.this.getVisual()).getZoomBox().reportZoom(mouseEvent.getX(), mouseEvent.getY());
            drawingPanel.removeMouseListener(this);
            drawingPanel.removeMouseMotionListener(this);
            if (double_ != null) {
                ControlDrawablesParent.this.isZoomed = true;
                if (!drawingPanel.isAutoscaleX()) {
                    drawingPanel.setPreferredMinMaxX(double_.x, double_.x + double_.width);
                }
                if (!drawingPanel.isAutoscaleY()) {
                    drawingPanel.setPreferredMinMaxY(double_.y, double_.y + double_.height);
                }
                ControlDrawablesParent.this.update();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

