/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.glassplate_taha_pkg;

import java.awt.Color;
import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.colos.ejs.library.external.ExternalAppsHandler;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.ToolForData;
import org.opensourcephysics.tools.ToolForDataFull;
import users.ntnu.fkh.glassplate_taha_pkg.glassplate_tahaSimulation;
import users.ntnu.fkh.glassplate_taha_pkg.glassplate_tahaView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class glassplate_taha
extends AbstractModel {
    public glassplate_tahaSimulation _simulation = null;
    public glassplate_tahaView _view = null;
    public glassplate_taha _model = this;
    private ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public double range = 1.0;
    public double h = this.range / 10.0;
    public double xmin = 0.0;
    public double xmax = this.range;
    public double ymin = -this.h;
    public double ymax = this.h;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 80.0;
    public Color[] colors;
    public Object lambda_color = new Color(255, 0, 0);
    public double wedge_n = 1.0;
    public int nx = 2000;
    public int ny = 10;
    public double[][] I;
    public double[][] I2;
    public double[] PX;
    public double[] PY;
    public double D = this.range / 100.0;
    public double cta = Math.atan(this.D / this.range);
    public double lambdai = 0.643936;
    public double lambda = this.lambdai * 0.001;

    @Override
    public int _getStepsPerDisplay() {
        return 1;
    }

    public static String _getEjsModel() {
        return "users/ntnu/fkh/glassplate_taha.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        glassplate_taha glassplate_taha2 = new glassplate_taha(stringArray);
    }

    public glassplate_taha() {
        this(null, null, null, null, null, false);
    }

    public glassplate_taha(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public glassplate_taha(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new glassplate_tahaSimulation(this, string, frame, uRL, bl);
        this._view = (glassplate_tahaView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        return null;
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        double d = this.range / (double)(this.nx - 1);
        for (int i = 0; i < this.nx; ++i) {
            this.PX[i] = this.xmin + (double)i * d;
        }
    }

    public void _constraints1() {
        this.lambda = this.lambdai * 0.001;
        this.lightPalette(this.lambda);
        this.lambda /= this.wedge_n;
        this.cta = Math.atan(this.D * 1.9 / this.range);
        for (int i = 0; i < this.nx; ++i) {
            double d = this.PX[i] * Math.tan(this.cta);
            double d2 = Math.PI * 4 * d / this.lambda + 1.5707963267948966;
            double d3 = Math.cos(d2 / 2.0);
            if (this.wedge_n > 1.495 && this.wedge_n < 1.505) {
                d3 = 0.0;
            }
            for (int j = 0; j < this.ny; ++j) {
                this.I[i][j] = d3 * d3;
                this.I2[i][j] = 1.0 - this.I[i][j];
            }
        }
    }

    public void lightPalette(double d) {
        d *= 1000.0;
        int n = this.colors.length;
        for (int i = 0; i < n; ++i) {
            int n2 = i;
            int n3 = i;
            int n4 = i;
            float f = (float)(-2.5 * d + 1.625);
            float f2 = 1.0f;
            if (d >= 0.65) {
                f = 0.0f;
                f2 = (float)(1.0 - d) / 0.35f;
            }
            if (d <= 0.35) {
                f = 0.75f;
                f2 = (float)(d / (double)0.35f);
            }
            this.colors[i] = Color.getHSBColor(f, f2, (float)((double)i / 255.0));
            this.lambda_color = Color.getHSBColor(f, f2, (float)((double)i / 255.0));
        }
    }

    public double _method_for_base_y() {
        return this.ymin + 0.05;
    }

    public double _method_for_top_y() {
        return this.ymin + this.size * 1.173 + 0.05;
    }

    public double _method_for_Particle_y() {
        return this.ymin + this.size + 0.05;
    }

    public double _method_for_Particle_sizex() {
        return this.D * 2.0;
    }

    public double _method_for_Particle_sizey() {
        return this.D * 2.0;
    }

    public Color _method_for_scalarField_ceilingcolor() {
        return this.colors[255];
    }

    public double _method_for_scalarField2_maximumY() {
        return -this.ymax;
    }

    public Color _method_for_scalarField2_ceilingcolor() {
        return this.colors[255];
    }

    public double _method_for_SliderD_minimum() {
        return this.range / 400.0;
    }

    public double _method_for_SliderD_maximum() {
        return this.range / 60.0;
    }

    @Override
    public synchronized void reset() {
        this.range = 1.0;
        this.h = this.range / 10.0;
        this.xmin = 0.0;
        this.xmax = this.range;
        this.ymin = -this.h;
        this.ymax = this.h;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 80.0;
        this.colors = new Color[256];
        for (int i = 0; i < 256; ++i) {
            this.colors[i] = Color.GRAY;
        }
        this.lambda_color = new Color(255, 0, 0);
        this.wedge_n = 1.0;
        this.nx = 2000;
        this.ny = 10;
        this.I = new double[this.nx][this.ny];
        this.I2 = new double[this.nx][this.ny];
        this.PX = new double[this.nx];
        this.PY = new double[this.nx];
        this.D = this.range / 100.0;
        this.cta = Math.atan(this.D / this.range);
        this.lambdai = 0.643936;
        this.lambda = this.lambdai * 0.001;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.colors = null;
        this.I = null;
        this.I2 = null;
        this.PX = null;
        this.PY = null;
        System.gc();
    }

    static {
        ToolForData.setTool(new ToolForDataFull());
    }
}

