/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.ThinFilm_v2_taha_pkg;

import java.awt.Component;
import java.awt.Frame;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.drawing2d.ControlAnalyticCurve2D;
import org.colos.ejs.library.control.drawing2d.ControlSegment2D;
import org.colos.ejs.library.control.drawing2d.ControlShape2D;
import org.colos.ejs.library.control.drawing2d.ControlText2D;
import org.colos.ejs.library.control.swing.ControlButton;
import org.colos.ejs.library.control.swing.ControlCheckBox;
import org.colos.ejs.library.control.swing.ControlDrawingPanel;
import org.colos.ejs.library.control.swing.ControlFrame;
import org.colos.ejs.library.control.swing.ControlPanel;
import org.colos.ejs.library.control.swing.ControlRadioButton;
import org.colos.ejs.library.control.swing.ControlSlider;
import org.colos.ejs.library.control.swing.ControlTextField;
import org.colos.ejs.library.control.swing.ControlTwoStateButton;
import org.colos.ejs.library.control.swing.JSliderDouble;
import org.opensourcephysics.drawing2d.DrawingPanel2D;
import org.opensourcephysics.drawing2d.ElementPolygon;
import org.opensourcephysics.drawing2d.ElementSegment;
import org.opensourcephysics.drawing2d.ElementShape;
import org.opensourcephysics.drawing2d.ElementText;
import users.ntnu.fkh.ThinFilm_v2_taha_pkg.ThinFilm_v2_taha;
import users.ntnu.fkh.ThinFilm_v2_taha_pkg.ThinFilm_v2_tahaSimulation;

class ThinFilm_v2_tahaView
extends EjsControl
implements View {
    private ThinFilm_v2_tahaSimulation _simulation = null;
    private ThinFilm_v2_taha _model = null;
    public Component MainWindow;
    public JPanel RightPanel;
    public JPanel ButtonsPanel;
    public JPanel panelLight;
    public JCheckBox redLight;
    public JCheckBox greenLight;
    public JCheckBox blueLight;
    public JPanel panelLight2;
    public JRadioButton redWaves;
    public JRadioButton greenWaves;
    public JRadioButton blueWaves;
    public JSliderDouble thickness;
    public JSliderDouble medium1;
    public JSliderDouble medium2;
    public JSliderDouble medium3;
    public JButton playpause;
    public JButton reset;
    public JButton instructions;
    public DrawingPanel2D drawingPanel;
    public ElementShape film;
    public ElementShape substrate;
    public ElementSegment lineA;
    public ElementSegment lineB;
    public ElementSegment lineC;
    public ElementPolygon wave1down;
    public ElementPolygon wave2down;
    public ElementPolygon wave3down;
    public ElementPolygon wave1up;
    public ElementPolygon wave2up;
    public ElementPolygon wave1up2;
    public ElementShape background;
    public ElementShape redIncident;
    public ElementShape redReflect;
    public ElementShape redTransmit;
    public ElementShape greenIncident;
    public ElementShape greenReflect;
    public ElementShape greenTransmit;
    public ElementShape blueIncident;
    public ElementShape blueReflect;
    public ElementShape blueTransmit;
    public ElementShape netIncident;
    public ElementShape netReflect;
    public ElementShape netTransmit;
    public ElementText incidentLabel;
    public ElementText ReflectLabel;
    public ElementText ReflectLabel2;
    public ElementText TransmitLabel;
    public ElementText TransmitLabel2;
    public ElementText RGBLabel;
    public ElementText RGBLabel2;
    public ElementText RGBLabel3;
    public DrawingPanel2D filmViews;
    public ElementShape netReflect2;
    public ElementShape netTransmit2;
    public ElementText ReflectedView;
    public ElementText transmittedView;
    public Component helpBox;
    public JTextField line1;
    public JTextField line2;
    public JTextField line3;
    public JTextField line4;
    public JTextField line5;
    public JTextField line6;
    public JTextField line7;
    public JTextField line8;
    public JTextField line9;
    public JTextField line10;
    public JTextField line12;

    public ThinFilm_v2_tahaView(ThinFilm_v2_tahaSimulation thinFilm_v2_tahaSimulation, String string, Frame frame) {
        super(thinFilm_v2_tahaSimulation, string, frame);
        this._simulation = thinFilm_v2_tahaSimulation;
        this._model = (ThinFilm_v2_taha)thinFilm_v2_tahaSimulation.getModel();
        this.addTarget("_simulation", this._simulation);
        this.addTarget("_model", this._model);
        this._model.reset();
        this.initialize();
        this.setUpdateSimulation(false);
        try {
            this.setUserCodebase(new URL(System.getProperty("jnlp.codebase")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.update();
        if (SwingUtilities.isEventDispatchThread()) {
            this.createControl();
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ThinFilm_v2_tahaView.this.createControl();
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
        this.addElementsMenuEntries();
        this.update();
        this.setUpdateSimulation(true);
        this.addListener("nColors", "apply(\"nColors\")");
        this.addListener("i", "apply(\"i\")");
        this.addListener("lambda", "apply(\"lambda\")");
        this.addListener("n1", "apply(\"n1\")");
        this.addListener("lambda1", "apply(\"lambda1\")");
        this.addListener("n2", "apply(\"n2\")");
        this.addListener("lambda2", "apply(\"lambda2\")");
        this.addListener("n3", "apply(\"n3\")");
        this.addListener("lambda3", "apply(\"lambda3\")");
        this.addListener("amp1", "apply(\"amp1\")");
        this.addListener("amp2", "apply(\"amp2\")");
        this.addListener("wavelength1", "apply(\"wavelength1\")");
        this.addListener("wavelength2", "apply(\"wavelength2\")");
        this.addListener("wavelength3", "apply(\"wavelength3\")");
        this.addListener("colorChoice", "apply(\"colorChoice\")");
        this.addListener("phase2", "apply(\"phase2\")");
        this.addListener("phase3", "apply(\"phase3\")");
        this.addListener("phase2up", "apply(\"phase2up\")");
        this.addListener("phase3up", "apply(\"phase3up\")");
        this.addListener("phase3bup", "apply(\"phase3bup\")");
        this.addListener("invert1phase", "apply(\"invert1phase\")");
        this.addListener("invert2phase", "apply(\"invert2phase\")");
        this.addListener("thickness", "apply(\"thickness\")");
        this.addListener("helpFlag", "apply(\"helpFlag\")");
        this.addListener("helpLabel", "apply(\"helpLabel\")");
        this.addListener("redFlag", "apply(\"redFlag\")");
        this.addListener("greenFlag", "apply(\"greenFlag\")");
        this.addListener("blueFlag", "apply(\"blueFlag\")");
        this.addListener("redReflectA", "apply(\"redReflectA\")");
        this.addListener("redTransmitA", "apply(\"redTransmitA\")");
        this.addListener("greenReflectA", "apply(\"greenReflectA\")");
        this.addListener("greenTransmitA", "apply(\"greenTransmitA\")");
        this.addListener("blueReflectA", "apply(\"blueReflectA\")");
        this.addListener("blueTransmitA", "apply(\"blueTransmitA\")");
        this.addListener("t", "apply(\"t\")");
        this.addListener("dt", "apply(\"dt\")");
        this.addListener("redColor", "apply(\"redColor\")");
        this.addListener("greenColor", "apply(\"greenColor\")");
        this.addListener("blueColor", "apply(\"blueColor\")");
        this.addListener("waveColor", "apply(\"waveColor\")");
        this.addListener("redReflectColor", "apply(\"redReflectColor\")");
        this.addListener("redTransmitColor", "apply(\"redTransmitColor\")");
        this.addListener("greenReflectColor", "apply(\"greenReflectColor\")");
        this.addListener("greenTransmitColor", "apply(\"greenTransmitColor\")");
        this.addListener("blueReflectColor", "apply(\"blueReflectColor\")");
        this.addListener("blueTransmitColor", "apply(\"blueTransmitColor\")");
        this.addListener("netColor", "apply(\"netColor\")");
        this.addListener("netReflectColor", "apply(\"netReflectColor\")");
        this.addListener("netTransmitColor", "apply(\"netTransmitColor\")");
        this.addListener("redness", "apply(\"redness\")");
        this.addListener("greenness", "apply(\"greenness\")");
        this.addListener("blueness", "apply(\"blueness\")");
        this.addListener("R1", "apply(\"R1\")");
        this.addListener("T1", "apply(\"T1\")");
        this.addListener("R2", "apply(\"R2\")");
        this.addListener("T2", "apply(\"T2\")");
    }

    public void read() {
    }

    public void read(String string) {
        int n;
        int n2;
        double[] dArray;
        if ("nColors".equals(string)) {
            this._model.nColors = this.getInt("nColors");
        }
        if ("i".equals(string)) {
            this._model.i = this.getInt("i");
        }
        if ("lambda".equals(string)) {
            dArray = (double[])this.getValue("lambda").getObject();
            n2 = dArray.length;
            if (n2 > this._model.lambda.length) {
                n2 = this._model.lambda.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.lambda[n] = dArray[n];
            }
        }
        if ("n1".equals(string)) {
            this._model.n1 = this.getDouble("n1");
        }
        if ("lambda1".equals(string)) {
            this._model.lambda1 = this.getDouble("lambda1");
        }
        if ("n2".equals(string)) {
            this._model.n2 = this.getDouble("n2");
        }
        if ("lambda2".equals(string)) {
            this._model.lambda2 = this.getDouble("lambda2");
        }
        if ("n3".equals(string)) {
            this._model.n3 = this.getDouble("n3");
        }
        if ("lambda3".equals(string)) {
            this._model.lambda3 = this.getDouble("lambda3");
        }
        if ("amp1".equals(string)) {
            this._model.amp1 = this.getDouble("amp1");
        }
        if ("amp2".equals(string)) {
            this._model.amp2 = this.getDouble("amp2");
        }
        if ("wavelength1".equals(string)) {
            dArray = (double[])this.getValue("wavelength1").getObject();
            n2 = dArray.length;
            if (n2 > this._model.wavelength1.length) {
                n2 = this._model.wavelength1.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.wavelength1[n] = dArray[n];
            }
        }
        if ("wavelength2".equals(string)) {
            dArray = (double[])this.getValue("wavelength2").getObject();
            n2 = dArray.length;
            if (n2 > this._model.wavelength2.length) {
                n2 = this._model.wavelength2.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.wavelength2[n] = dArray[n];
            }
        }
        if ("wavelength3".equals(string)) {
            dArray = (double[])this.getValue("wavelength3").getObject();
            n2 = dArray.length;
            if (n2 > this._model.wavelength3.length) {
                n2 = this._model.wavelength3.length;
            }
            for (n = 0; n < n2; ++n) {
                this._model.wavelength3[n] = dArray[n];
            }
        }
        if ("colorChoice".equals(string)) {
            this._model.colorChoice = this.getInt("colorChoice");
        }
        if ("phase2".equals(string)) {
            this._model.phase2 = this.getDouble("phase2");
        }
        if ("phase3".equals(string)) {
            this._model.phase3 = this.getDouble("phase3");
        }
        if ("phase2up".equals(string)) {
            this._model.phase2up = this.getDouble("phase2up");
        }
        if ("phase3up".equals(string)) {
            this._model.phase3up = this.getDouble("phase3up");
        }
        if ("phase3bup".equals(string)) {
            this._model.phase3bup = this.getDouble("phase3bup");
        }
        if ("invert1phase".equals(string)) {
            this._model.invert1phase = this.getDouble("invert1phase");
        }
        if ("invert2phase".equals(string)) {
            this._model.invert2phase = this.getDouble("invert2phase");
        }
        if ("thickness".equals(string)) {
            this._model.thickness = this.getDouble("thickness");
        }
        if ("helpFlag".equals(string)) {
            this._model.helpFlag = this.getBoolean("helpFlag");
        }
        if ("helpLabel".equals(string)) {
            this._model.helpLabel = this.getString("helpLabel");
        }
        if ("redFlag".equals(string)) {
            this._model.redFlag = this.getBoolean("redFlag");
        }
        if ("greenFlag".equals(string)) {
            this._model.greenFlag = this.getBoolean("greenFlag");
        }
        if ("blueFlag".equals(string)) {
            this._model.blueFlag = this.getBoolean("blueFlag");
        }
        if ("redReflectA".equals(string)) {
            this._model.redReflectA = this.getDouble("redReflectA");
        }
        if ("redTransmitA".equals(string)) {
            this._model.redTransmitA = this.getDouble("redTransmitA");
        }
        if ("greenReflectA".equals(string)) {
            this._model.greenReflectA = this.getDouble("greenReflectA");
        }
        if ("greenTransmitA".equals(string)) {
            this._model.greenTransmitA = this.getDouble("greenTransmitA");
        }
        if ("blueReflectA".equals(string)) {
            this._model.blueReflectA = this.getDouble("blueReflectA");
        }
        if ("blueTransmitA".equals(string)) {
            this._model.blueTransmitA = this.getDouble("blueTransmitA");
        }
        if ("t".equals(string)) {
            this._model.t = this.getDouble("t");
        }
        if ("dt".equals(string)) {
            this._model.dt = this.getDouble("dt");
        }
        if ("redColor".equals(string)) {
            this._model.redColor = this.getObject("redColor");
        }
        if ("greenColor".equals(string)) {
            this._model.greenColor = this.getObject("greenColor");
        }
        if ("blueColor".equals(string)) {
            this._model.blueColor = this.getObject("blueColor");
        }
        if ("waveColor".equals(string)) {
            this._model.waveColor = this.getObject("waveColor");
        }
        if ("redReflectColor".equals(string)) {
            this._model.redReflectColor = this.getObject("redReflectColor");
        }
        if ("redTransmitColor".equals(string)) {
            this._model.redTransmitColor = this.getObject("redTransmitColor");
        }
        if ("greenReflectColor".equals(string)) {
            this._model.greenReflectColor = this.getObject("greenReflectColor");
        }
        if ("greenTransmitColor".equals(string)) {
            this._model.greenTransmitColor = this.getObject("greenTransmitColor");
        }
        if ("blueReflectColor".equals(string)) {
            this._model.blueReflectColor = this.getObject("blueReflectColor");
        }
        if ("blueTransmitColor".equals(string)) {
            this._model.blueTransmitColor = this.getObject("blueTransmitColor");
        }
        if ("netColor".equals(string)) {
            this._model.netColor = this.getObject("netColor");
        }
        if ("netReflectColor".equals(string)) {
            this._model.netReflectColor = this.getObject("netReflectColor");
        }
        if ("netTransmitColor".equals(string)) {
            this._model.netTransmitColor = this.getObject("netTransmitColor");
        }
        if ("redness".equals(string)) {
            this._model.redness = this.getInt("redness");
        }
        if ("greenness".equals(string)) {
            this._model.greenness = this.getInt("greenness");
        }
        if ("blueness".equals(string)) {
            this._model.blueness = this.getInt("blueness");
        }
        if ("R1".equals(string)) {
            this._model.R1 = this.getDouble("R1");
        }
        if ("T1".equals(string)) {
            this._model.T1 = this.getDouble("T1");
        }
        if ("R2".equals(string)) {
            this._model.R2 = this.getDouble("R2");
        }
        if ("T2".equals(string)) {
            this._model.T2 = this.getDouble("T2");
        }
    }

    public void propagateValues() {
        this.setValue("_isPlaying", this._simulation.isPlaying());
        this.setValue("_isPaused", this._simulation.isPaused());
        this.setValue("nColors", this._model.nColors);
        this.setValue("i", this._model.i);
        this.setValue("lambda", this._model.lambda);
        this.setValue("n1", this._model.n1);
        this.setValue("lambda1", this._model.lambda1);
        this.setValue("n2", this._model.n2);
        this.setValue("lambda2", this._model.lambda2);
        this.setValue("n3", this._model.n3);
        this.setValue("lambda3", this._model.lambda3);
        this.setValue("amp1", this._model.amp1);
        this.setValue("amp2", this._model.amp2);
        this.setValue("wavelength1", this._model.wavelength1);
        this.setValue("wavelength2", this._model.wavelength2);
        this.setValue("wavelength3", this._model.wavelength3);
        this.setValue("colorChoice", this._model.colorChoice);
        this.setValue("phase2", this._model.phase2);
        this.setValue("phase3", this._model.phase3);
        this.setValue("phase2up", this._model.phase2up);
        this.setValue("phase3up", this._model.phase3up);
        this.setValue("phase3bup", this._model.phase3bup);
        this.setValue("invert1phase", this._model.invert1phase);
        this.setValue("invert2phase", this._model.invert2phase);
        this.setValue("thickness", this._model.thickness);
        this.setValue("helpFlag", this._model.helpFlag);
        this.setValue("helpLabel", this._model.helpLabel);
        this.setValue("redFlag", this._model.redFlag);
        this.setValue("greenFlag", this._model.greenFlag);
        this.setValue("blueFlag", this._model.blueFlag);
        this.setValue("redReflectA", this._model.redReflectA);
        this.setValue("redTransmitA", this._model.redTransmitA);
        this.setValue("greenReflectA", this._model.greenReflectA);
        this.setValue("greenTransmitA", this._model.greenTransmitA);
        this.setValue("blueReflectA", this._model.blueReflectA);
        this.setValue("blueTransmitA", this._model.blueTransmitA);
        this.setValue("t", this._model.t);
        this.setValue("dt", this._model.dt);
        this.setValue("redColor", this._model.redColor);
        this.setValue("greenColor", this._model.greenColor);
        this.setValue("blueColor", this._model.blueColor);
        this.setValue("waveColor", this._model.waveColor);
        this.setValue("redReflectColor", this._model.redReflectColor);
        this.setValue("redTransmitColor", this._model.redTransmitColor);
        this.setValue("greenReflectColor", this._model.greenReflectColor);
        this.setValue("greenTransmitColor", this._model.greenTransmitColor);
        this.setValue("blueReflectColor", this._model.blueReflectColor);
        this.setValue("blueTransmitColor", this._model.blueTransmitColor);
        this.setValue("netColor", this._model.netColor);
        this.setValue("netReflectColor", this._model.netReflectColor);
        this.setValue("netTransmitColor", this._model.netTransmitColor);
        this.setValue("redness", this._model.redness);
        this.setValue("greenness", this._model.greenness);
        this.setValue("blueness", this._model.blueness);
        this.setValue("R1", this._model.R1);
        this.setValue("T1", this._model.T1);
        this.setValue("R2", this._model.R2);
        this.setValue("T2", this._model.T2);
    }

    private void createControl() {
        this.addElement(new ControlFrame(), "_TOP_SECRET_").setProperty("waitForReset", "true").setProperty("visible", "false").setProperty("background", "green").setProperty("size", "100,100");
        this.MainWindow = (Component)this.addElement(new ControlFrame(), "MainWindow").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("exit", "true").setProperty("onExit", "_model._onExit()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.MainWindow.title", "\"Thin-film interference\"")).setProperty("layout", "border").setProperty("visible", "true").setProperty("location", "-1733,148").setProperty("size", this._simulation.translateString("View.MainWindow.size", "\"760,623\"")).getObject();
        this.RightPanel = (JPanel)this.addElement(new ControlPanel(), "RightPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "east").setProperty("parent", "MainWindow").setProperty("layout", "border").getObject();
        this.ButtonsPanel = (JPanel)this.addElement(new ControlPanel(), "ButtonsPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "RightPanel").setProperty("layout", "FLOW:left,0,0").setProperty("size", this._simulation.translateString("View.ButtonsPanel.size", "\"200,554\"")).getObject();
        this.panelLight = (JPanel)this.addElement(new ControlPanel(), "panelLight").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "ButtonsPanel").setProperty("layout", "border").setProperty("size", this._simulation.translateString("View.panelLight.size", "\"200,100\"")).setProperty("borderType", "ROUNDED_TITLED").setProperty("borderColor", "MAGENTA").setProperty("borderTitle", this._simulation.translateString("View.panelLight.borderTitle", "\"Light source\"")).setProperty("font", "Tahoma,BOLD,11").getObject();
        this.redLight = (JCheckBox)this.addElement(new ControlCheckBox(), "redLight").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "panelLight").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.redLight.text", "\"Red (660 nm)\"")).setProperty("actionon", "_model._method_for_redLight_actionon()").setProperty("actionoff", "_model._method_for_redLight_actionoff()").getObject();
        this.greenLight = (JCheckBox)this.addElement(new ControlCheckBox(), "greenLight").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "panelLight").setProperty("variable", "true").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.greenLight.text", "\"Green (540 nm)\"")).setProperty("actionon", "_model._method_for_greenLight_actionon()").setProperty("actionoff", "_model._method_for_greenLight_actionoff()").getObject();
        this.blueLight = (JCheckBox)this.addElement(new ControlCheckBox(), "blueLight").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "panelLight").setProperty("text", this._simulation.translateString("View.blueLight.text", "\"Blue (440 nm)\"")).setProperty("actionon", "_model._method_for_blueLight_actionon()").setProperty("actionoff", "_model._method_for_blueLight_actionoff()").getObject();
        this.panelLight2 = (JPanel)this.addElement(new ControlPanel(), "panelLight2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "ButtonsPanel").setProperty("layout", "border").setProperty("size", this._simulation.translateString("View.panelLight2.size", "\"200,100\"")).setProperty("borderType", "ROUNDED_TITLED").setProperty("borderColor", "BLUE").setProperty("borderTitle", this._simulation.translateString("View.panelLight2.borderTitle", "\"Show interference for ...\"")).setProperty("font", "Tahoma,BOLD,11").getObject();
        this.redWaves = (JRadioButton)this.addElement(new ControlRadioButton(), "redWaves").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "north").setProperty("parent", "panelLight2").setProperty("variable", "false").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.redWaves.text", "\"Red\"")).setProperty("actionon", "_model._method_for_redWaves_actionon()").getObject();
        this.greenWaves = (JRadioButton)this.addElement(new ControlRadioButton(), "greenWaves").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "panelLight2").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.greenWaves.text", "\"Green\"")).setProperty("actionon", "_model._method_for_greenWaves_actionon()").getObject();
        this.blueWaves = (JRadioButton)this.addElement(new ControlRadioButton(), "blueWaves").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "panelLight2").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.blueWaves.text", "\"Blue\"")).setProperty("actionon", "_model._method_for_blueWaves_actionon()").getObject();
        this.thickness = (JSliderDouble)this.addElement(new ControlSlider(), "thickness").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "ButtonsPanel").setProperty("variable", "thickness").setProperty("value", "399.973").setProperty("minimum", "0").setProperty("maximum", "700").setProperty("format", this._simulation.translateString("View.thickness.format", "\"film thickness (nm) = 0\"")).getObject();
        this.medium1 = (JSliderDouble)this.addElement(new ControlSlider(), "medium1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "ButtonsPanel").setProperty("variable", "n1").setProperty("minimum", "1.0").setProperty("maximum", "2.0").setProperty("format", this._simulation.translateString("View.medium1.format", "\"n1 = 0.##\"")).setProperty("dragaction", "_model._method_for_medium1_dragaction()").setProperty("action", "_model._method_for_medium1_action()").setProperty("background", "192,255,255").getObject();
        this.medium2 = (JSliderDouble)this.addElement(new ControlSlider(), "medium2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "ButtonsPanel").setProperty("variable", "n2").setProperty("minimum", "1.0").setProperty("maximum", "2.0").setProperty("format", this._simulation.translateString("View.medium2.format", "\"n2 = 0.00\"")).setProperty("dragaction", "_model._method_for_medium2_dragaction()").setProperty("action", "_model._method_for_medium2_action()").setProperty("background", "255,192,192").getObject();
        this.medium3 = (JSliderDouble)this.addElement(new ControlSlider(), "medium3").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "ButtonsPanel").setProperty("variable", "n3").setProperty("minimum", "1.0").setProperty("maximum", "2.0").setProperty("format", this._simulation.translateString("View.medium3.format", "\"n3 = 0.##\"")).setProperty("dragaction", "_model._method_for_medium3_dragaction()").setProperty("action", "_model._method_for_medium3_action()").setProperty("background", "200,200,255").getObject();
        this.playpause = (JButton)this.addElement(new ControlTwoStateButton(), "playpause").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "ButtonsPanel").setProperty("variable", "_isPaused").setProperty("size", this._simulation.translateString("View.playpause.size", "\"200,54\"")).setProperty("textOn", this._simulation.translateString("View.playpause.textOn", "\"Play\"")).setProperty("actionOn", "_model._method_for_playpause_actionOn()").setProperty("foreground", "BLUE").setProperty("background", "ORANGE").setProperty("textOff", this._simulation.translateString("View.playpause.textOff", "\"Pause\"")).setProperty("actionOff", "_model._method_for_playpause_actionOff()").setProperty("foregroundOff", "BLUE").setProperty("backgroundOff", "ORANGE").getObject();
        this.reset = (JButton)this.addElement(new ControlButton(), "reset").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "ButtonsPanel").setProperty("text", this._simulation.translateString("View.reset.text", "Reset Simulation")).setProperty("action", "_model._method_for_reset_action()").setProperty("size", this._simulation.translateString("View.reset.size", "\"200,54\"")).setProperty("background", "BLACK").setProperty("foreground", "RED").setProperty("font", "Dialog,BOLD,16").getObject();
        this.instructions = (JButton)this.addElement(new ControlButton(), "instructions").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "ButtonsPanel").setProperty("text", this._simulation.translateString("View.instructions.text", "%helpLabel%")).setProperty("action", "_model._method_for_instructions_action()").setProperty("size", this._simulation.translateString("View.instructions.size", "\"200,54\"")).setProperty("background", "BLUE").setProperty("foreground", "YELLOW").setProperty("font", "Dialog,BOLD,16").getObject();
        this.drawingPanel = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "drawingPanel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "center").setProperty("parent", "MainWindow").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-10").setProperty("maximumX", "5.0").setProperty("minimumY", "-1500").setProperty("maximumY", "0").setProperty("background", "192,255,255").getObject();
        this.film = (ElementShape)this.addElement(new ControlShape2D(), "film").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "0").setProperty("y", "-1000").setProperty("sizeX", "10").setProperty("sizeY", "thickness").setProperty("style", "RECTANGLE").setProperty("elementposition", "SOUTH").setProperty("fillColor", "255,192,192").getObject();
        this.substrate = (ElementShape)this.addElement(new ControlShape2D(), "substrate").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "0").setProperty("y", "-1500").setProperty("sizeX", "10").setProperty("sizeY", "500").setProperty("style", "RECTANGLE").setProperty("elementposition", "SOUTH").setProperty("fillColor", "200,200,255").getObject();
        this.lineA = (ElementSegment)this.addElement(new ControlSegment2D(), "lineA").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-3").setProperty("y", "-1500").setProperty("sizeX", "0").setProperty("sizeY", "1500").setProperty("lineColor", "BLACK").getObject();
        this.lineB = (ElementSegment)this.addElement(new ControlSegment2D(), "lineB").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "0").setProperty("y", "%_model._method_for_lineB_y()%").setProperty("sizeX", "0").setProperty("sizeY", "%_model._method_for_lineB_sizeY()%").setProperty("lineColor", "BLACK").getObject();
        this.lineC = (ElementSegment)this.addElement(new ControlSegment2D(), "lineC").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "3").setProperty("y", "-1000").setProperty("sizeX", "0").setProperty("sizeY", "1000").setProperty("lineColor", "BLACK").getObject();
        this.wave1down = (ElementPolygon)this.addElement(new ControlAnalyticCurve2D(), "wave1down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("points", "100").setProperty("min", "%_model._method_for_wave1down_min()%").setProperty("max", "0").setProperty("variable", "u").setProperty("functionx", "-3.0+Math.sin(t+2.0*Math.PI*u/lambda1)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineColor", "waveColor").setProperty("lineWidth", "2").getObject();
        this.wave2down = (ElementPolygon)this.addElement(new ControlAnalyticCurve2D(), "wave2down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("points", "100").setProperty("min", "-1000").setProperty("max", "%_model._method_for_wave2down_max()%").setProperty("variable", "u").setProperty("functionx", "-3.0+T1*Math.sin(phase2+t+2.0*Math.PI*u/lambda2)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineColor", "waveColor").setProperty("lineWidth", "2").getObject();
        this.wave3down = (ElementPolygon)this.addElement(new ControlAnalyticCurve2D(), "wave3down").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("points", "100").setProperty("min", "-1500").setProperty("max", "-1000").setProperty("variable", "u").setProperty("functionx", "-3.0+T2*Math.sin(phase3+t+2.0*Math.PI*u/lambda3)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineColor", "waveColor").setProperty("lineWidth", "2").getObject();
        this.wave1up = (ElementPolygon)this.addElement(new ControlAnalyticCurve2D(), "wave1up").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("points", "100").setProperty("min", "%_model._method_for_wave1up_min()%").setProperty("max", "0").setProperty("variable", "u").setProperty("functionx", "R1*10.*Math.sin(invert1phase+phase2up+t-2.0*Math.PI*(u+1000-thickness)/lambda1)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineColor", "waveColor").setProperty("lineWidth", "2").getObject();
        this.wave2up = (ElementPolygon)this.addElement(new ControlAnalyticCurve2D(), "wave2up").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("points", "100").setProperty("min", "-1000").setProperty("max", "%_model._method_for_wave2up_max()%").setProperty("variable", "u").setProperty("functionx", "3.0+R2*10.*Math.sin(invert2phase+phase3up+t-2.0*Math.PI*(u+1000)/lambda2)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineColor", "waveColor").setProperty("lineWidth", "2").getObject();
        this.wave1up2 = (ElementPolygon)this.addElement(new ControlAnalyticCurve2D(), "wave1up2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("points", "100").setProperty("min", "%_model._method_for_wave1up2_min()%").setProperty("max", "0").setProperty("variable", "u").setProperty("functionx", "3.0+R2*10.*Math.sin(invert2phase+phase3bup+t-2.0*Math.PI*(u+1000-thickness)/lambda1)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineColor", "waveColor").setProperty("lineWidth", "2").getObject();
        this.background = (ElementShape)this.addElement(new ControlShape2D(), "background").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-10").setProperty("y", "-1500").setProperty("sizeX", "5").setProperty("sizeY", "1500").setProperty("style", "RECTANGLE").setProperty("elementposition", "SOUTH_WEST").setProperty("fillColor", "black").getObject();
        this.redIncident = (ElementShape)this.addElement(new ControlShape2D(), "redIncident").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-9").setProperty("y", "-180").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("visible", "redFlag").setProperty("style", "RECTANGLE").setProperty("fillColor", "RED").getObject();
        this.redReflect = (ElementShape)this.addElement(new ControlShape2D(), "redReflect").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-9").setProperty("y", "-650").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("visible", "redFlag").setProperty("style", "RECTANGLE").setProperty("fillColor", "redReflectColor").getObject();
        this.redTransmit = (ElementShape)this.addElement(new ControlShape2D(), "redTransmit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-9").setProperty("y", "-1230").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("visible", "redFlag").setProperty("style", "RECTANGLE").setProperty("fillColor", "redTransmitColor").getObject();
        this.greenIncident = (ElementShape)this.addElement(new ControlShape2D(), "greenIncident").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-8").setProperty("y", "-180").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("visible", "greenFlag").setProperty("style", "RECTANGLE").setProperty("fillColor", "GREEN").getObject();
        this.greenReflect = (ElementShape)this.addElement(new ControlShape2D(), "greenReflect").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-8").setProperty("y", "-650").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("visible", "greenFlag").setProperty("style", "RECTANGLE").setProperty("fillColor", "greenReflectColor").getObject();
        this.greenTransmit = (ElementShape)this.addElement(new ControlShape2D(), "greenTransmit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-8").setProperty("y", "-1230").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("visible", "greenFlag").setProperty("style", "RECTANGLE").setProperty("fillColor", "greenTransmitColor").getObject();
        this.blueIncident = (ElementShape)this.addElement(new ControlShape2D(), "blueIncident").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7").setProperty("y", "-180").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("visible", "blueFlag").setProperty("style", "RECTANGLE").setProperty("fillColor", "BLUE").getObject();
        this.blueReflect = (ElementShape)this.addElement(new ControlShape2D(), "blueReflect").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7").setProperty("y", "-650").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("visible", "blueFlag").setProperty("style", "RECTANGLE").setProperty("fillColor", "blueReflectColor").getObject();
        this.blueTransmit = (ElementShape)this.addElement(new ControlShape2D(), "blueTransmit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7").setProperty("y", "-1230").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("visible", "blueFlag").setProperty("style", "RECTANGLE").setProperty("fillColor", "blueTransmitColor").getObject();
        this.netIncident = (ElementShape)this.addElement(new ControlShape2D(), "netIncident").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-6").setProperty("y", "-180").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE").setProperty("fillColor", "netColor").getObject();
        this.netReflect = (ElementShape)this.addElement(new ControlShape2D(), "netReflect").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-6").setProperty("y", "-650").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE").setProperty("fillColor", "netReflectColor").getObject();
        this.netTransmit = (ElementShape)this.addElement(new ControlShape2D(), "netTransmit").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-6").setProperty("y", "-1230").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE").setProperty("fillColor", "netTransmitColor").getObject();
        this.incidentLabel = (ElementText)this.addElement(new ControlText2D(), "incidentLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7.5").setProperty("y", "-80").setProperty("sizeX", "3").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.incidentLabel.text", "\"Incident\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE").getObject();
        this.ReflectLabel = (ElementText)this.addElement(new ControlText2D(), "ReflectLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7.5").setProperty("y", "-480").setProperty("sizeX", "3.6").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.ReflectLabel.text", "\"Reflected\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE").getObject();
        this.ReflectLabel2 = (ElementText)this.addElement(new ControlText2D(), "ReflectLabel2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7.5").setProperty("y", "-560").setProperty("sizeX", "4.0").setProperty("sizeY", "50").setProperty("text", this._simulation.translateString("View.ReflectLabel2.text", "\"(top view of film)\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE").getObject();
        this.TransmitLabel = (ElementText)this.addElement(new ControlText2D(), "TransmitLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7.5").setProperty("y", "-1050").setProperty("sizeX", "4.4").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.TransmitLabel.text", "\"Transmitted\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE").getObject();
        this.TransmitLabel2 = (ElementText)this.addElement(new ControlText2D(), "TransmitLabel2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7.5").setProperty("y", "-1130").setProperty("sizeX", "4.8").setProperty("sizeY", "50").setProperty("text", this._simulation.translateString("View.TransmitLabel2.text", "\"(bottom view of film)\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE").getObject();
        this.createControl50();
    }

    private void createControl50() {
        this.RGBLabel = (ElementText)this.addElement(new ControlText2D(), "RGBLabel").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7.3").setProperty("y", "-280").setProperty("sizeX", "3.8").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.RGBLabel.text", "\"R   G   B  net\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE").getObject();
        this.RGBLabel2 = (ElementText)this.addElement(new ControlText2D(), "RGBLabel2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7.3").setProperty("y", "-750").setProperty("sizeX", "3.8").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.RGBLabel2.text", "\"R   G   B  net\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE").getObject();
        this.RGBLabel3 = (ElementText)this.addElement(new ControlText2D(), "RGBLabel3").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "drawingPanel").setProperty("x", "-7.3").setProperty("y", "-1330").setProperty("sizeX", "3.8").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.RGBLabel3.text", "\"R   G   B  net\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE").getObject();
        this.filmViews = (DrawingPanel2D)this.addElement(new ControlDrawingPanel(), "filmViews").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("position", "south").setProperty("parent", "MainWindow").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1.0").setProperty("maximumX", "1.0").setProperty("minimumY", "-1.0").setProperty("maximumY", "1.0").setProperty("size", this._simulation.translateString("View.filmViews.size", "\"715,50\"")).getObject();
        this.netReflect2 = (ElementShape)this.addElement(new ControlShape2D(), "netReflect2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "filmViews").setProperty("x", "-0.5").setProperty("y", "-0.5").setProperty("sizeX", "1").setProperty("sizeY", "1").setProperty("style", "RECTANGLE").setProperty("fillColor", "netReflectColor").getObject();
        this.netTransmit2 = (ElementShape)this.addElement(new ControlShape2D(), "netTransmit2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "filmViews").setProperty("x", "0.5").setProperty("y", "-0.5").setProperty("sizeX", "1").setProperty("sizeY", "1").setProperty("style", "RECTANGLE").setProperty("fillColor", "netTransmitColor").getObject();
        this.ReflectedView = (ElementText)this.addElement(new ControlText2D(), "ReflectedView").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "filmViews").setProperty("x", "-0.5").setProperty("y", "0.5").setProperty("text", this._simulation.translateString("View.ReflectedView.text", "\"Reflected View\"")).getObject();
        this.transmittedView = (ElementText)this.addElement(new ControlText2D(), "transmittedView").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "filmViews").setProperty("x", "0.5").setProperty("y", "0.5").setProperty("text", this._simulation.translateString("View.transmittedView.text", "\"Transmitted View\"")).getObject();
        this.helpBox = (Component)this.addElement(new ControlFrame(), "helpBox").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("waitForReset", "true").setProperty("title", this._simulation.translateString("View.helpBox.title", "Help")).setProperty("layout", "grid:0,1,0,0").setProperty("visible", "helpFlag").setProperty("onClosing", "_model._method_for_helpBox_onClosing()").setProperty("location", "6,32").setProperty("size", this._simulation.translateString("View.helpBox.size", "\"852,308\"")).getObject();
        this.line1 = (JTextField)this.addElement(new ControlTextField(), "line1").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line1.value", "\"The screen shows a sandwich of three media. Waves of light are incident on the top layer (medium 1).\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
        this.line2 = (JTextField)this.addElement(new ControlTextField(), "line2").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line2.value", "\"Medium 2, in the middle, is a thin film - you can vary its thickness with the film thickness slider.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
        this.line3 = (JTextField)this.addElement(new ControlTextField(), "line3").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line3.value", "\"Some of the light is transmitted into medium 3, at the bottom. Some reflects back into medium 1.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
        this.line4 = (JTextField)this.addElement(new ControlTextField(), "line4").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line4.value", "\"The waves that reflect from the top and bottom of the film interfere with one another.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
        this.line5 = (JTextField)this.addElement(new ControlTextField(), "line5").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line5.value", "\"Under the right conditions, the waves interfere completely constructively, or completely destructively.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
        this.line6 = (JTextField)this.addElement(new ControlTextField(), "line6").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line6.value", "\"Note that waves reflecting from a medium with a higher index of refraction than the one they're in are inverted.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
        this.line7 = (JTextField)this.addElement(new ControlTextField(), "line7").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line7.value", "\"On the left of the screen, the colored boxes show the incident light, the reflected light, and the transmitted light.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
        this.line8 = (JTextField)this.addElement(new ControlTextField(), "line8").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line8.value", "\"Turn the red, green, and blue light sources on and off using the check boxes at top right.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
        this.line9 = (JTextField)this.addElement(new ControlTextField(), "line9").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line9.value", "\"With the radio buttons underneath, select the color of light to show the interference for.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
        this.line10 = (JTextField)this.addElement(new ControlTextField(), "line10").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line10.value", "\"You can also adjust the indices of refraction for the three layers, using the sliders on the right.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
        this.line12 = (JTextField)this.addElement(new ControlTextField(), "line12").setProperty("_ejs_SecondAction_", "updateAfterModelAction()").setProperty("parent", "helpBox").setProperty("value", this._simulation.translateString("View.line12.value", "\"You can completely reset the simulation, if necessary, with the \"Reset Simulation\" button.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16").getObject();
    }

    public void reset() {
        this.getElement("MainWindow").setProperty("title", this._simulation.translateString("View.MainWindow.title", "\"Thin-film interference\"")).setProperty("visible", "true");
        this.getElement("RightPanel");
        this.getElement("ButtonsPanel").setProperty("size", this._simulation.translateString("View.ButtonsPanel.size", "\"200,554\""));
        this.getElement("panelLight").setProperty("size", this._simulation.translateString("View.panelLight.size", "\"200,100\"")).setProperty("borderType", "ROUNDED_TITLED").setProperty("borderColor", "MAGENTA").setProperty("borderTitle", this._simulation.translateString("View.panelLight.borderTitle", "\"Light source\"")).setProperty("font", "Tahoma,BOLD,11");
        this.getElement("redLight").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.redLight.text", "\"Red (660 nm)\""));
        this.getElement("greenLight").setProperty("variable", "true").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.greenLight.text", "\"Green (540 nm)\""));
        this.getElement("blueLight").setProperty("text", this._simulation.translateString("View.blueLight.text", "\"Blue (440 nm)\""));
        this.getElement("panelLight2").setProperty("size", this._simulation.translateString("View.panelLight2.size", "\"200,100\"")).setProperty("borderType", "ROUNDED_TITLED").setProperty("borderColor", "BLUE").setProperty("borderTitle", this._simulation.translateString("View.panelLight2.borderTitle", "\"Show interference for ...\"")).setProperty("font", "Tahoma,BOLD,11");
        this.getElement("redWaves").setProperty("variable", "false").setProperty("selected", "true").setProperty("text", this._simulation.translateString("View.redWaves.text", "\"Red\""));
        this.getElement("greenWaves").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.greenWaves.text", "\"Green\""));
        this.getElement("blueWaves").setProperty("selected", "false").setProperty("text", this._simulation.translateString("View.blueWaves.text", "\"Blue\""));
        this.getElement("thickness").setProperty("value", "399.973").setProperty("minimum", "0").setProperty("maximum", "700").setProperty("format", this._simulation.translateString("View.thickness.format", "\"film thickness (nm) = 0\""));
        this.getElement("medium1").setProperty("minimum", "1.0").setProperty("maximum", "2.0").setProperty("format", this._simulation.translateString("View.medium1.format", "\"n1 = 0.##\"")).setProperty("background", "192,255,255");
        this.getElement("medium2").setProperty("minimum", "1.0").setProperty("maximum", "2.0").setProperty("format", this._simulation.translateString("View.medium2.format", "\"n2 = 0.00\"")).setProperty("background", "255,192,192");
        this.getElement("medium3").setProperty("minimum", "1.0").setProperty("maximum", "2.0").setProperty("format", this._simulation.translateString("View.medium3.format", "\"n3 = 0.##\"")).setProperty("background", "200,200,255");
        this.getElement("playpause").setProperty("size", this._simulation.translateString("View.playpause.size", "\"200,54\"")).setProperty("textOn", this._simulation.translateString("View.playpause.textOn", "\"Play\"")).setProperty("foreground", "BLUE").setProperty("background", "ORANGE").setProperty("textOff", this._simulation.translateString("View.playpause.textOff", "\"Pause\"")).setProperty("foregroundOff", "BLUE").setProperty("backgroundOff", "ORANGE");
        this.getElement("reset").setProperty("text", this._simulation.translateString("View.reset.text", "Reset Simulation")).setProperty("size", this._simulation.translateString("View.reset.size", "\"200,54\"")).setProperty("background", "BLACK").setProperty("foreground", "RED").setProperty("font", "Dialog,BOLD,16");
        this.getElement("instructions").setProperty("size", this._simulation.translateString("View.instructions.size", "\"200,54\"")).setProperty("background", "BLUE").setProperty("foreground", "YELLOW").setProperty("font", "Dialog,BOLD,16");
        this.getElement("drawingPanel").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-10").setProperty("maximumX", "5.0").setProperty("minimumY", "-1500").setProperty("maximumY", "0").setProperty("background", "192,255,255");
        this.getElement("film").setProperty("x", "0").setProperty("y", "-1000").setProperty("sizeX", "10").setProperty("style", "RECTANGLE").setProperty("elementposition", "SOUTH").setProperty("fillColor", "255,192,192");
        this.getElement("substrate").setProperty("x", "0").setProperty("y", "-1500").setProperty("sizeX", "10").setProperty("sizeY", "500").setProperty("style", "RECTANGLE").setProperty("elementposition", "SOUTH").setProperty("fillColor", "200,200,255");
        this.getElement("lineA").setProperty("x", "-3").setProperty("y", "-1500").setProperty("sizeX", "0").setProperty("sizeY", "1500").setProperty("lineColor", "BLACK");
        this.getElement("lineB").setProperty("x", "0").setProperty("sizeX", "0").setProperty("lineColor", "BLACK");
        this.getElement("lineC").setProperty("x", "3").setProperty("y", "-1000").setProperty("sizeX", "0").setProperty("sizeY", "1000").setProperty("lineColor", "BLACK");
        this.getElement("wave1down").setProperty("points", "100").setProperty("max", "0").setProperty("variable", "u").setProperty("functionx", "-3.0+Math.sin(t+2.0*Math.PI*u/lambda1)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineWidth", "2");
        this.getElement("wave2down").setProperty("points", "100").setProperty("min", "-1000").setProperty("variable", "u").setProperty("functionx", "-3.0+T1*Math.sin(phase2+t+2.0*Math.PI*u/lambda2)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineWidth", "2");
        this.getElement("wave3down").setProperty("points", "100").setProperty("min", "-1500").setProperty("max", "-1000").setProperty("variable", "u").setProperty("functionx", "-3.0+T2*Math.sin(phase3+t+2.0*Math.PI*u/lambda3)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineWidth", "2");
        this.getElement("wave1up").setProperty("points", "100").setProperty("max", "0").setProperty("variable", "u").setProperty("functionx", "R1*10.*Math.sin(invert1phase+phase2up+t-2.0*Math.PI*(u+1000-thickness)/lambda1)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineWidth", "2");
        this.getElement("wave2up").setProperty("points", "100").setProperty("min", "-1000").setProperty("variable", "u").setProperty("functionx", "3.0+R2*10.*Math.sin(invert2phase+phase3up+t-2.0*Math.PI*(u+1000)/lambda2)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineWidth", "2");
        this.getElement("wave1up2").setProperty("points", "100").setProperty("max", "0").setProperty("variable", "u").setProperty("functionx", "3.0+R2*10.*Math.sin(invert2phase+phase3bup+t-2.0*Math.PI*(u+1000-thickness)/lambda1)").setProperty("functiony", "u").setProperty("javaSyntax", "true").setProperty("lineWidth", "2");
        this.getElement("background").setProperty("x", "-10").setProperty("y", "-1500").setProperty("sizeX", "5").setProperty("sizeY", "1500").setProperty("style", "RECTANGLE").setProperty("elementposition", "SOUTH_WEST").setProperty("fillColor", "black");
        this.getElement("redIncident").setProperty("x", "-9").setProperty("y", "-180").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE").setProperty("fillColor", "RED");
        this.getElement("redReflect").setProperty("x", "-9").setProperty("y", "-650").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE");
        this.getElement("redTransmit").setProperty("x", "-9").setProperty("y", "-1230").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE");
        this.getElement("greenIncident").setProperty("x", "-8").setProperty("y", "-180").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE").setProperty("fillColor", "GREEN");
        this.getElement("greenReflect").setProperty("x", "-8").setProperty("y", "-650").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE");
        this.getElement("greenTransmit").setProperty("x", "-8").setProperty("y", "-1230").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE");
        this.getElement("blueIncident").setProperty("x", "-7").setProperty("y", "-180").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE").setProperty("fillColor", "BLUE");
        this.getElement("blueReflect").setProperty("x", "-7").setProperty("y", "-650").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE");
        this.getElement("blueTransmit").setProperty("x", "-7").setProperty("y", "-1230").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE");
        this.getElement("netIncident").setProperty("x", "-6").setProperty("y", "-180").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE");
        this.getElement("netReflect").setProperty("x", "-6").setProperty("y", "-650").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE");
        this.getElement("netTransmit").setProperty("x", "-6").setProperty("y", "-1230").setProperty("sizeX", "1").setProperty("sizeY", "100").setProperty("style", "RECTANGLE");
        this.getElement("incidentLabel").setProperty("x", "-7.5").setProperty("y", "-80").setProperty("sizeX", "3").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.incidentLabel.text", "\"Incident\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE");
        this.getElement("ReflectLabel").setProperty("x", "-7.5").setProperty("y", "-480").setProperty("sizeX", "3.6").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.ReflectLabel.text", "\"Reflected\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE");
        this.getElement("ReflectLabel2").setProperty("x", "-7.5").setProperty("y", "-560").setProperty("sizeX", "4.0").setProperty("sizeY", "50").setProperty("text", this._simulation.translateString("View.ReflectLabel2.text", "\"(top view of film)\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE");
        this.getElement("TransmitLabel").setProperty("x", "-7.5").setProperty("y", "-1050").setProperty("sizeX", "4.4").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.TransmitLabel.text", "\"Transmitted\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE");
        this.getElement("TransmitLabel2").setProperty("x", "-7.5").setProperty("y", "-1130").setProperty("sizeX", "4.8").setProperty("sizeY", "50").setProperty("text", this._simulation.translateString("View.TransmitLabel2.text", "\"(bottom view of film)\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE");
        this.getElement("RGBLabel").setProperty("x", "-7.3").setProperty("y", "-280").setProperty("sizeX", "3.8").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.RGBLabel.text", "\"R   G   B  net\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE");
        this.getElement("RGBLabel2").setProperty("x", "-7.3").setProperty("y", "-750").setProperty("sizeX", "3.8").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.RGBLabel2.text", "\"R   G   B  net\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE");
        this.getElement("RGBLabel3").setProperty("x", "-7.3").setProperty("y", "-1330").setProperty("sizeX", "3.8").setProperty("sizeY", "60").setProperty("text", this._simulation.translateString("View.RGBLabel3.text", "\"R   G   B  net\"")).setProperty("lineColor", "WHITE").setProperty("fillColor", "WHITE");
        this.getElement("filmViews").setProperty("autoscaleX", "false").setProperty("autoscaleY", "false").setProperty("minimumX", "-1.0").setProperty("maximumX", "1.0").setProperty("minimumY", "-1.0").setProperty("maximumY", "1.0").setProperty("size", this._simulation.translateString("View.filmViews.size", "\"715,50\""));
        this.getElement("netReflect2").setProperty("x", "-0.5").setProperty("y", "-0.5").setProperty("sizeX", "1").setProperty("sizeY", "1").setProperty("style", "RECTANGLE");
        this.getElement("netTransmit2").setProperty("x", "0.5").setProperty("y", "-0.5").setProperty("sizeX", "1").setProperty("sizeY", "1").setProperty("style", "RECTANGLE");
        this.getElement("ReflectedView").setProperty("x", "-0.5").setProperty("y", "0.5").setProperty("text", this._simulation.translateString("View.ReflectedView.text", "\"Reflected View\""));
        this.getElement("transmittedView").setProperty("x", "0.5").setProperty("y", "0.5").setProperty("text", this._simulation.translateString("View.transmittedView.text", "\"Transmitted View\""));
        this.getElement("helpBox").setProperty("title", this._simulation.translateString("View.helpBox.title", "Help"));
        this.getElement("line1").setProperty("value", this._simulation.translateString("View.line1.value", "\"The screen shows a sandwich of three media. Waves of light are incident on the top layer (medium 1).\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        this.getElement("line2").setProperty("value", this._simulation.translateString("View.line2.value", "\"Medium 2, in the middle, is a thin film - you can vary its thickness with the film thickness slider.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        this.getElement("line3").setProperty("value", this._simulation.translateString("View.line3.value", "\"Some of the light is transmitted into medium 3, at the bottom. Some reflects back into medium 1.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        this.getElement("line4").setProperty("value", this._simulation.translateString("View.line4.value", "\"The waves that reflect from the top and bottom of the film interfere with one another.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        this.getElement("line5").setProperty("value", this._simulation.translateString("View.line5.value", "\"Under the right conditions, the waves interfere completely constructively, or completely destructively.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        this.getElement("line6").setProperty("value", this._simulation.translateString("View.line6.value", "\"Note that waves reflecting from a medium with a higher index of refraction than the one they're in are inverted.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        this.getElement("line7").setProperty("value", this._simulation.translateString("View.line7.value", "\"On the left of the screen, the colored boxes show the incident light, the reflected light, and the transmitted light.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        this.getElement("line8").setProperty("value", this._simulation.translateString("View.line8.value", "\"Turn the red, green, and blue light sources on and off using the check boxes at top right.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        this.getElement("line9").setProperty("value", this._simulation.translateString("View.line9.value", "\"With the radio buttons underneath, select the color of light to show the interference for.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        this.getElement("line10").setProperty("value", this._simulation.translateString("View.line10.value", "\"You can also adjust the indices of refraction for the three layers, using the sliders on the right.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        this.getElement("line12").setProperty("value", this._simulation.translateString("View.line12.value", "\"You can completely reset the simulation, if necessary, with the \"Reset Simulation\" button.\"")).setProperty("editable", "false").setProperty("font", "Dialog,BOLD,16");
        super.reset();
    }
}

