/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.glassplate_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ntnu.fkh.glassplate_pkg.glassplateSimulation;
import users.ntnu.fkh.glassplate_pkg.glassplateView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class glassplate
extends AbstractModel {
    public glassplateSimulation _simulation = null;
    public glassplateView _view = null;
    public glassplate _model = this;
    public double range = 1.0;
    public double h = this.range / 10.0;
    public double xmin = 0.0;
    public double xmax = this.range;
    public double ymin = -this.h;
    public double ymax = this.h;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 80.0;
    public int nx = 2000;
    public int ny = 10;
    public double[][] I;
    public double[] PX;
    public double[] PY;
    public double D = this.range / 100.0;
    public double cta = Math.atan(this.D / this.range);
    public double lambda = 7.0E-4;

    public static String _getEjsModel() {
        return "users/ntnu/fkh/glassplate.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        glassplate glassplate2 = new glassplate(stringArray);
    }

    public glassplate() {
        this(null, null, null, null, null, false);
    }

    public glassplate(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public glassplate(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new glassplateSimulation(this, string, frame, uRL, bl);
        this._view = (glassplateView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        double d = this.range / (double)(this.nx - 1);
        for (int i = 0; i < this.nx; ++i) {
            this.PX[i] = this.xmin + (double)i * d;
        }
    }

    public void _constraints1() {
        this.cta = Math.atan(this.D / this.range);
        for (int i = 0; i < this.nx; ++i) {
            double d = this.PX[i] * Math.tan(this.cta);
            double d2 = Math.PI * 4 * d / this.lambda + 1.5707963267948966;
            double d3 = Math.cos(d2 / 2.0);
            for (int j = 0; j < this.ny; ++j) {
                this.I[i][j] = d3 * d3;
            }
        }
    }

    public double _method_for_top_y() {
        return this.ymin + this.size * 1.173;
    }

    public double _method_for_Particle_y() {
        return this.ymin + this.size;
    }

    public double _method_for_SliderD_minimum() {
        return this.range / 200.0;
    }

    public double _method_for_SliderD_maximum() {
        return this.range / 20.0;
    }

    @Override
    public synchronized void reset() {
        this.range = 1.0;
        this.h = this.range / 10.0;
        this.xmin = 0.0;
        this.xmax = this.range;
        this.ymin = -this.h;
        this.ymax = this.h;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 80.0;
        this.nx = 2000;
        this.ny = 10;
        this.I = new double[this.nx][this.ny];
        this.PX = new double[this.nx];
        this.PY = new double[this.nx];
        this.D = this.range / 100.0;
        this.cta = Math.atan(this.D / this.range);
        this.lambda = 7.0E-4;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.I = null;
        this.PX = null;
        this.PY = null;
        System.gc();
    }
}

