/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.List;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.Style;
import org.opensourcephysics.tools.ToolForDataInfo;
import org.opensourcephysics.tools.ToolForDataUser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementTrail
extends Element
implements ToolForDataUser {
    public static final int NO_CONNECTION = 0;
    public static final int LINE_CONNECTION = 1;
    private static TrailPoint nullPoint = new TrailPoint(Double.NaN, Double.NaN, 1);
    private int maximum = 0;
    private int connectionType = 1;
    private boolean active = true;
    private boolean noRepeat = false;
    private boolean clearAtInput = false;
    private int skip = 0;
    private List<TrailPoint> list = new ArrayList<TrailPoint>();
    private GeneralPath currentPath = new GeneralPath();
    private List<PathAndStyle> pastPathsList = new ArrayList<PathAndStyle>();
    private TrailPoint flushPoint = nullPoint;
    private boolean isEmpty = true;
    private int counter = 0;
    private int firstPoint = 0;
    private double lastX = Double.NaN;
    private double lastY = Double.NaN;

    public void setActive(boolean bl) {
        this.active = bl;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setNoRepeat(boolean bl) {
        this.noRepeat = bl;
    }

    public boolean isNoRepeat() {
        return this.noRepeat;
    }

    public void setClearAtInput(boolean bl) {
        this.clearAtInput = bl;
    }

    public boolean isClearAtInput() {
        return this.clearAtInput;
    }

    public void setSkipPoints(int n) {
        if (this.skip != n) {
            this.skip = n;
            this.counter = 0;
        }
    }

    public int getSkipPoints() {
        return this.skip;
    }

    public void addPoint(double d, double d2) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(d, d2, this.connectionType);
    }

    public void addPoint(double[] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(dArray[0], dArray[1], this.connectionType);
    }

    public void moveToPoint(double d, double d2) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(d, d2, 0);
    }

    public void moveToPoint(double[] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        this.addPoint(dArray[0], dArray[1], 0);
    }

    public void addPoints(double[][] dArray) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = 0;
        int n2 = dArray.length;
        while (n < n2) {
            this.addPoint(dArray[n][0], dArray[n][1], this.connectionType);
            ++n;
        }
    }

    public void addPoints(double[] dArray, double[] dArray2) {
        if (this.clearAtInput) {
            this.initialize();
        }
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = 0;
        while (n2 < n) {
            this.addPoint(dArray[n2], dArray2[n2], this.connectionType);
            ++n2;
        }
    }

    public void setMaximumPoints(int n) {
        int n2 = Math.max(n, 2);
        if (n2 != this.maximum) {
            this.clear();
            this.maximum = n2;
        }
    }

    public int getMaximumPoints() {
        return this.maximum;
    }

    public void setConnectionType(int n) {
        this.connectionType = n;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<TrailPoint> list = this.list;
        synchronized (list) {
            this.list.clear();
            this.currentPath.reset();
            List<PathAndStyle> list2 = this.pastPathsList;
            synchronized (list2) {
                this.pastPathsList.clear();
            }
            this.flushPoint = nullPoint;
            this.isEmpty = true;
            this.counter = 0;
            this.firstPoint = 0;
            this.lastX = Double.NaN;
            this.lastY = Double.NaN;
            this.setNeedToProject(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        List<TrailPoint> list = this.list;
        synchronized (list) {
            if (this.firstPoint == 0) {
                this.list.clear();
            } else {
                int n = this.list.size() - 1;
                while (n >= this.firstPoint) {
                    this.list.remove(n);
                    --n;
                }
            }
            this.currentPath.reset();
            this.flushPoint = nullPoint;
            this.isEmpty = true;
            this.counter = 0;
            this.lastX = Double.NaN;
            this.lastY = Double.NaN;
            this.setNeedToProject(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newSegment() {
        TrailPoint trailPoint = null;
        TrailPoint trailPoint2 = this.flushPoint;
        synchronized (trailPoint2) {
            if (this.flushPoint != nullPoint) {
                trailPoint = new TrailPoint(this.flushPoint.x, this.flushPoint.y, this.flushPoint.type);
            }
        }
        if (trailPoint != null) {
            this.list.add(trailPoint);
            int n = this.isEmpty ? 0 : trailPoint.type;
            switch (n) {
                default: {
                    this.currentPath.lineTo((float)trailPoint.x, (float)trailPoint.y);
                    break;
                }
                case 0: {
                    this.currentPath.moveTo((float)trailPoint.x, (float)trailPoint.y);
                    this.currentPath.lineTo((float)trailPoint.x, (float)trailPoint.y);
                }
            }
        }
        this.pastPathsList.add(new PathAndStyle(this.currentPath, this.getStyle()));
        List<TrailPoint> list = this.list;
        synchronized (list) {
            this.currentPath = new GeneralPath();
            this.flushPoint = nullPoint;
            this.isEmpty = true;
            this.firstPoint = this.list.size();
            this.counter = 0;
            this.lastX = Double.NaN;
            this.lastY = Double.NaN;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ToolForDataInfo getToolForDataInfo() {
        TrailPoint[] trailPointArray;
        Object object = this.list;
        synchronized (object) {
            trailPointArray = this.list.toArray(new TrailPoint[this.list.size()]);
        }
        object = null;
        TrailPoint trailPoint = this.flushPoint;
        synchronized (trailPoint) {
            if (this.flushPoint != nullPoint) {
                object = new TrailPoint(this.flushPoint.x, this.flushPoint.y, this.flushPoint.type);
            }
        }
        int n = trailPointArray.length;
        double[][] dArrayArray = object == null ? new double[n][] : new double[n + 1][];
        int n2 = 0;
        while (n2 < n) {
            dArrayArray[n2] = new double[]{trailPointArray[n2].x, trailPointArray[n2].y};
            ++n2;
        }
        if (object != null) {
            dArrayArray[n] = new double[]{((TrailPoint)object).x, ((TrailPoint)object).y};
        }
        return new ToolForDataInfo(this.getName(), this.getStyle().getLineColor(), this.getStyle().getFillColor(), dArrayArray);
    }

    @Override
    public List<ToolForDataUser> getToolForDataUsers() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        Object object;
        if (!this.isReallyVisible()) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        for (PathAndStyle object22 : this.pastPathsList) {
            object = object22.style.getLineColor();
            if (object == null) continue;
            graphics2D.setStroke(object22.style.getLineStroke());
            graphics2D.setColor((Color)object);
            Shape n = this.getPixelTransform(drawingPanel).createTransformedShape(object22.path);
            graphics2D.draw(n);
        }
        Color color = this.getStyle().getLineColor();
        if (color == null) {
            return;
        }
        graphics2D.setStroke(this.getStyle().getLineStroke());
        graphics2D.setColor(color);
        Object object3 = null;
        object = this.flushPoint;
        synchronized (object) {
            if (this.flushPoint != nullPoint) {
                object3 = new TrailPoint(this.flushPoint.x, this.flushPoint.y, this.flushPoint.type);
            }
        }
        if (object3 == null) {
            object = this.currentPath;
        } else {
            object = new GeneralPath(this.currentPath);
            int shape = this.isEmpty ? 0 : ((TrailPoint)object3).type;
            switch (shape) {
                default: {
                    ((Path2D.Float)object).lineTo((float)((TrailPoint)object3).x, (float)((TrailPoint)object3).y);
                    break;
                }
                case 0: {
                    ((Path2D.Float)object).moveTo((float)((TrailPoint)object3).x, (float)((TrailPoint)object3).y);
                    ((Path2D.Float)object).lineTo((float)((TrailPoint)object3).x, (float)((TrailPoint)object3).y);
                }
            }
        }
        Shape shape = this.getPixelTransform(drawingPanel).createTransformedShape((Shape)object);
        graphics2D.draw(shape);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.targetPosition.isEnabled()) {
            return null;
        }
        if (!this.isReallyVisible()) {
            return null;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints(drawingPanel);
        }
        int n3 = this.getStyle().getSensitivity();
        if (this.targetPosition.isEnabled()) {
            TrailPoint[] trailPointArray;
            List<TrailPoint> list = this.list;
            synchronized (list) {
                trailPointArray = this.list.toArray(new TrailPoint[this.list.size()]);
            }
            int n4 = 0;
            int n5 = trailPointArray.length;
            while (n4 < n5) {
                TrailPoint trailPoint = trailPointArray[n4];
                if (Math.abs(trailPoint.pixel[0] - (double)n) < (double)n3 && Math.abs(trailPoint.pixel[1] - (double)n2) < (double)n3) {
                    return this.targetPosition;
                }
                ++n4;
            }
            TrailPoint trailPoint = this.flushPoint;
            synchronized (trailPoint) {
                if (this.flushPoint != nullPoint && Math.abs(this.flushPoint.pixel[0] - (double)n) < (double)n3 && Math.abs(this.flushPoint.pixel[1] - (double)n2) < (double)n3) {
                    return this.targetPosition;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isMeasured() {
        return !this.list.isEmpty() && super.isMeasured();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void updateExtrema() {
        TrailPoint[] trailPointArray;
        if (!this.hasChanged()) {
            return;
        }
        this.initExtrema();
        double[] dArray = new double[2];
        List<TrailPoint> list = this.list;
        synchronized (list) {
            trailPointArray = this.list.toArray(new TrailPoint[this.list.size()]);
        }
        int n = 0;
        int n2 = trailPointArray.length;
        while (n < n2) {
            TrailPoint trailPoint = trailPointArray[n];
            dArray[0] = trailPoint.x;
            dArray[1] = trailPoint.y;
            this.getTotalTransform().transform(dArray, 0, dArray, 0, 1);
            if (!Double.isNaN(dArray[0]) && !Double.isNaN(dArray[1])) {
                this.compareToAllExtrema(dArray[0], dArray[1]);
            }
            ++n;
        }
        n = 0;
        TrailPoint trailPoint = this.flushPoint;
        synchronized (trailPoint) {
            if (this.flushPoint != nullPoint) {
                dArray[0] = this.flushPoint.x;
                dArray[1] = this.flushPoint.y;
                n = 1;
            }
        }
        if (n != 0) {
            this.getTotalTransform().transform(dArray, 0, dArray, 0, 1);
            if (!Double.isNaN(dArray[0]) && !Double.isNaN(dArray[1])) {
                this.compareToAllExtrema(dArray[0], dArray[1]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void projectPoints(DrawingPanel drawingPanel) {
        TrailPoint[] trailPointArray;
        AffineTransform affineTransform = this.getPixelTransform(drawingPanel);
        List<TrailPoint> list = this.list;
        synchronized (list) {
            trailPointArray = this.list.toArray(new TrailPoint[this.list.size()]);
        }
        int n = 0;
        int n2 = trailPointArray.length;
        while (n < n2) {
            trailPointArray[n].project(affineTransform);
            ++n;
        }
        TrailPoint trailPoint = this.flushPoint;
        synchronized (trailPoint) {
            if (this.flushPoint != nullPoint) {
                this.flushPoint.project(affineTransform);
            }
        }
        this.setNeedToProject(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPoint(double d, double d2, int n) {
        if (this.noRepeat && this.lastX == d && this.lastY == d2) {
            return;
        }
        if (this.skip > 0) {
            if (this.counter > 0) {
                ++this.counter;
                if (this.counter >= this.skip) {
                    this.counter = 0;
                }
                this.flushPoint = new TrailPoint(d, d2, n);
                this.lastX = d;
                this.lastY = d2;
                return;
            }
            ++this.counter;
        }
        this.flushPoint = nullPoint;
        List<TrailPoint> list = this.list;
        synchronized (list) {
            GeneralPath generalPath;
            TrailPoint[] trailPointArray;
            this.lastX = d;
            this.lastY = d2;
            int n2 = this.list.size();
            if (this.maximum > 2 && n2 >= this.maximum) {
                this.list.remove(this.firstPoint);
                trailPointArray = this.list.toArray(new TrailPoint[n2 - 1]);
                generalPath = this.currentPath;
                synchronized (generalPath) {
                    this.currentPath.reset();
                    TrailPoint trailPoint = trailPointArray[this.firstPoint];
                    this.currentPath.moveTo((float)trailPoint.x, (float)trailPoint.y);
                    int n3 = this.firstPoint + 1;
                    int n4 = trailPointArray.length;
                    while (n3 < n4) {
                        trailPoint = trailPointArray[n3];
                        switch (trailPoint.type) {
                            default: {
                                this.currentPath.lineTo((float)trailPoint.x, (float)trailPoint.y);
                                break;
                            }
                            case 0: {
                                this.currentPath.moveTo((float)trailPoint.x, (float)trailPoint.y);
                                this.currentPath.lineTo((float)trailPoint.x, (float)trailPoint.y);
                            }
                        }
                        ++n3;
                    }
                }
            }
            trailPointArray = new TrailPoint(d, d2, n);
            this.list.add((TrailPoint)trailPointArray);
            generalPath = this.currentPath;
            synchronized (generalPath) {
                if (this.isEmpty) {
                    this.currentPath.moveTo((float)d, (float)d2);
                } else {
                    switch (((TrailPoint)trailPointArray).type) {
                        default: {
                            this.currentPath.lineTo((float)d, (float)d2);
                            break;
                        }
                        case 0: {
                            this.currentPath.moveTo((float)d, (float)d2);
                            this.currentPath.lineTo((float)d, (float)d2);
                        }
                    }
                }
            }
            this.isEmpty = false;
            this.setElementChanged();
        }
    }

    private static class PathAndStyle {
        GeneralPath path;
        Style style;

        PathAndStyle(GeneralPath generalPath, Style style) {
            this.path = generalPath;
            this.style = style.clone();
        }
    }

    private static class TrailPoint {
        private int type;
        private double x;
        private double y;
        private double[] pixel = new double[2];

        TrailPoint(double d, double d2, int n) {
            this.x = d;
            this.y = d2;
            this.type = n;
        }

        void project(AffineTransform affineTransform) {
            this.pixel[0] = this.x;
            this.pixel[1] = this.y;
            affineTransform.transform(this.pixel, 0, this.pixel, 0, 1);
        }
    }
}

