/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Timer;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;

public abstract class Animation
implements Runnable {
    public static int MAXIMUM_FPS = 25;
    public static final int MINIMUM_FPS = 1;
    public static final int MINIMUM_DELAY = 10;
    private volatile Thread animationThread = null;
    private volatile boolean loopEnabled = true;
    private boolean autoplay = false;
    protected boolean isPlaying = false;
    protected boolean updateView = true;
    private int stepsPerDisplay = 1;
    private long delay = 10L;
    protected String resetFile = null;
    protected Model model = null;
    protected View view = null;
    protected Animation master = null;
    protected ArrayList<Model> slaveList = new ArrayList();

    public final Model getModel() {
        return this.model;
    }

    public final void setModel(Model model) {
        this.model = model;
        LauncherApplet launcherApplet = this.model._getApplet();
        if (launcherApplet != null && launcherApplet.getParameter("_initialState") != null) {
            this.resetFile = launcherApplet.getParameter("_initialState");
        }
    }

    public final View getView() {
        return this.view;
    }

    public final void setView(View view) {
        this.view = view;
    }

    public final void setFPS(int n) {
        this.delay = n <= 1 ? 1000L : (n >= MAXIMUM_FPS ? 10L : Math.max((long)(1000.0 / (double)n), 10L));
    }

    public final void setDelay(int n) {
        this.delay = Math.max((long)n, 0L);
    }

    public final int getDelay() {
        return (int)this.delay;
    }

    public final void setStepsPerDisplay(int n) {
        if (n >= 1) {
            this.stepsPerDisplay = n;
        }
    }

    public final void setUpdateView(boolean bl) {
        this.updateView = bl;
    }

    public final void setAutoplay(boolean bl) {
        this.autoplay = bl;
    }

    public final boolean isPlaying() {
        return this.isPlaying && this.animationThread != null;
    }

    public final boolean isPaused() {
        return !this.isPlaying();
    }

    public void disableLoop() {
        this.loopEnabled = false;
        if (Thread.currentThread() == this.animationThread) {
            return;
        }
        try {
            this.animationThread.interrupt();
            this.animationThread.join(100L);
        }
        catch (Exception exception) {}
    }

    public void enableLoop() {
        this.loopEnabled = true;
    }

    public synchronized void play() {
        if (this.master != null) {
            this.getTopMaster().play();
            return;
        }
        if (this.animationThread != null) {
            return;
        }
        this.animationThread = new Thread(this);
        this.animationThread.setPriority(1);
        this.animationThread.setDaemon(true);
        this.animationThread.start();
        this.isPlaying = true;
        for (Model model : this.slaveList) {
            model.getSimulation().isPlaying = true;
        }
    }

    public synchronized void pause() {
        if (this.master != null) {
            this.getTopMaster().pause();
            return;
        }
        if (this.animationThread == null) {
            return;
        }
        Thread thread = this.animationThread;
        this.animationThread = null;
        this.isPlaying = false;
        for (Model model : this.slaveList) {
            model.getSimulation().isPlaying = false;
        }
        if (Thread.currentThread() == thread) {
            return;
        }
        try {
            thread.interrupt();
            thread.join(100L);
        }
        catch (Exception exception) {}
    }

    public void run() {
        long l = this.delay;
        while (this.animationThread == Thread.currentThread()) {
            long l2 = System.currentTimeMillis();
            if (this.loopEnabled) {
                this.step();
                for (Model model : this.slaveList) {
                    model.getSimulation().step();
                }
            }
            if ((l = this.delay - (System.currentTimeMillis() - l2)) < 10L) {
                Thread.yield();
                continue;
            }
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void onExit() {
        this.animationThread = null;
        this.isPlaying = false;
        Timer timer = new Timer(500, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Animation.this.view.onExit();
                Animation.this.model._freeMemory();
                System.gc();
            }
        });
        timer.setRepeats(false);
        timer.setCoalesce(true);
        timer.start();
    }

    protected abstract void userDefinedReset();

    protected abstract void userDefinedViewUpdate();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void reset() {
        this.pause();
        if (this.model != null) {
            this.model.reset();
        }
        if (this.view != null) {
            this.view.setUpdateSimulation(false);
            this.view.reset();
            this.view.initialize();
        }
        if (this.model != null) {
            this.model.initialize();
            this.model.update();
            this.userDefinedReset();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
                this.userDefinedViewUpdate();
            } else {
                this.view.collectData();
            }
            this.view.setUpdateSimulation(true);
        }
        System.gc();
        ArrayList<Model> arrayList = this.slaveList;
        synchronized (arrayList) {
            this.killAllSimulations();
        }
        if (this.autoplay) {
            this.play();
        }
    }

    public final void initialize() {
        if (this.view != null) {
            this.view.read();
        }
        if (this.model != null) {
            this.model.initialize();
            this.model.update();
        }
        if (this.view != null) {
            this.view.initialize();
            if (this.updateView) {
                this.view.update();
                this.userDefinedViewUpdate();
            } else {
                this.view.collectData();
            }
        }
    }

    public final void apply() {
        if (this.view != null) {
            this.view.read();
        }
        this.update();
    }

    public final void applyAll() {
        this.view.read();
        this.update();
    }

    public final void apply(String string) {
        if (this.view != null) {
            this.view.read(string);
        }
    }

    public final void update() {
        if (this.model != null) {
            this.model.update();
        }
        if (this.view != null) {
            if (this.updateView) {
                this.view.update();
            } else {
                this.view.collectData();
            }
        }
    }

    public final void step() {
        if (this.stepsPerDisplay > 1) {
            int n = 1;
            while (n < this.stepsPerDisplay) {
                this.model.step();
                this.model.update();
                this.view.collectData();
                ++n;
            }
        }
        this.model.step();
        this.update();
        if (this.updateView) {
            this.userDefinedViewUpdate();
        }
    }

    public final void updateAfterModelAction() {
        if (this.master != null) {
            this.getTopMaster().updateAfterModelAction();
            return;
        }
        this.update();
        for (Model model : this.slaveList) {
            model.getSimulation().update();
        }
        this.loopEnabled = true;
    }

    public final Model runSimulation() {
        return this.runSimulation(null);
    }

    public final Model runSimulation(String string) {
        try {
            Animation animation;
            Class<?> clazz = string == null ? this.getModel().getClass() : Class.forName(string);
            Model model = (Model)clazz.newInstance();
            model.getSimulation().master = animation = this.getTopMaster();
            model.getSimulation().isPlaying = this.isPlaying;
            model.getSimulation().update();
            animation.slaveList.add(model);
            return model;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public final void freeSimulation(Model model) {
        if (model == null) {
            return;
        }
        try {
            Animation animation = this.getTopMaster();
            animation.slaveList.remove(model);
            model.getSimulation().master = null;
            if (model.getView() instanceof EjsControl) {
                ((EjsControl)((Object)model.getView())).undoReparenting();
            }
            if (animation.isPlaying) {
                model.getSimulation().play();
            } else {
                model.getSimulation().isPlaying = false;
            }
            model.getSimulation().update();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final void killSimulation(Model model) {
        if (model == null) {
            return;
        }
        this.freeSimulation(model);
        model.getSimulation().pause();
        if (model.getView() instanceof EjsControl) {
            ((EjsControl)((Object)model.getView())).dispose();
        }
    }

    public final synchronized void killAllSimulations() {
        ArrayList<Model> arrayList = this.slaveList;
        this.slaveList = new ArrayList();
        for (Model model : arrayList) {
            model.getSimulation().pause();
            model.getSimulation().master = null;
            if (!(model.getView() instanceof EjsControl)) continue;
            ((EjsControl)((Object)model.getView())).undoReparenting();
            ((EjsControl)((Object)model.getView())).dispose();
        }
    }

    public final Model getTopSimulation() {
        return this.getTopMaster().getModel();
    }

    private final Animation getTopMaster() {
        if (this.master == null) {
            return this;
        }
        Animation animation = this.master;
        while (animation.master != null) {
            animation = animation.master;
        }
        return animation;
    }
}

