/*
 * Decompiled with CFR 0.152.
 */
package users.ntnu.fkh.aperature_pkg;

import java.awt.Frame;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashSet;
import java.util.Set;
import org.colos.ejs.library.AbstractModel;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.external.ExternalApp;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.tools.ResourceLoader;
import users.ntnu.fkh.aperature_pkg.aperatureSimulation;
import users.ntnu.fkh.aperature_pkg.aperatureView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class aperature
extends AbstractModel {
    public aperatureSimulation _simulation = null;
    public aperatureView _view = null;
    public aperature _model = this;
    public double range = 0.2;
    public double xmin = -this.range / 2.0;
    public double xmax = this.range / 2.0;
    public double ymin = -this.range / 2.0;
    public double ymax = this.range / 2.0;
    public double t = 0.0;
    public double dt = 0.05;
    public double size = this.range / 40.0;
    public String label = "";
    public String l_play = "play";
    public String l_pause = "pause";
    public String l_reset = "reset";
    public String l_init = "initialize";
    public String l_xd = "Distances between light sources";
    public String l_D = "Diameter of the optics aperature";
    public String l_L = "Distance from Light Source to the aperature";
    public String l_show = "show curves";
    public int nx = 300;
    public int ny = 300;
    public double[][] I;
    public double lambda = 1.0E-7;
    public double Dr = 200.0;
    public double L = 9.843637;
    public double D = this.Dr * this.lambda;
    public double[] XP;
    public double[] YP;
    public double[] YP1;
    public double[] YP2;
    public double xd = this.size * 4.0;
    public double cta = 0.01;
    public double n = 50.0;
    public double yscale = 1.5;

    public static String _getEjsModel() {
        return "users/ntnu/fkh/aperature.xml";
    }

    public static String _getModelDirectory() {
        return "users/ntnu/fkh/";
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        return hashSet;
    }

    public static void main(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath("users/ntnu/fkh/");
        n = 0;
        try {
            if (System.getProperty("osp_ejs") != null) {
                Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("D:/EJS_4.1/bin/config/");
        }
        aperature aperature2 = new aperature(stringArray);
    }

    public aperature() {
        this(null, null, null, null, null, false);
    }

    public aperature(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public aperature(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new aperatureSimulation(this, string, frame, uRL, bl);
        this._view = (aperatureView)this._simulation.getView();
        this._simulation.processArguments(stringArray);
    }

    @Override
    public View getView() {
        return this._view;
    }

    @Override
    public Simulation getSimulation() {
        return this._simulation;
    }

    @Override
    public void _resetSolvers() {
        this._external.resetIC();
    }

    @Override
    public String _externalInitCommand(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        return stringBuffer.toString();
    }

    @Override
    public synchronized void _externalSetValues(boolean bl, ExternalApp externalApp) {
    }

    @Override
    public synchronized void _externalGetValues(boolean bl, ExternalApp externalApp) {
    }

    public void _initialization1() {
        double d = (this.xmax - this.xmin) / (double)(this.nx - 1);
        for (int i = 0; i < this.nx; ++i) {
            this.XP[i] = this.xmin + (double)i * d;
        }
    }

    public void _constraints1() {
        double d = (this.xmax - this.xmin) / (double)(this.nx - 1);
        double d2 = (this.ymax - this.ymin) / (double)(this.ny - 1);
        double d3 = Math.PI * this.D / this.lambda;
        this.D = this.Dr * this.lambda;
        for (int i = 0; i < this.nx; ++i) {
            double d4 = this.XP[i];
            for (int j = 0; j < this.ny; ++j) {
                double d5 = this.ymin + (double)j * d2;
                double d6 = Math.sqrt((d4 - this.xd) * (d4 - this.xd) + d5 * d5);
                double d7 = Math.sqrt((d4 + this.xd) * (d4 + this.xd) + d5 * d5);
                double d8 = d3 * d6 / this.L;
                double d9 = Math.sin(d8) / d8;
                double d10 = d3 * d7 / this.L;
                double d11 = Math.sin(d10) / d10;
                this.I[i][j] = (d9 * d9 + d11 * d11) * this.yscale;
                if (j != this.ny / 2) continue;
                this.YP[i] = this.ymin + this.I[i][j] * this.xmax;
                this.YP1[i] = this.ymin + d9 * d9 * this.yscale * this.xmax;
                this.YP2[i] = this.ymin + d11 * d11 * this.yscale * this.xmax;
            }
        }
    }

    public void zh_tw() {
        this.l_play = "\u64ad\u653e";
        this.l_reset = "\u91cd\u8a2d";
        this.l_pause = "\u66ab\u505c";
        this.l_init = "\u521d\u59cb\u5316";
        this.l_xd = "\u5149\u6e90\u4e4b\u9593\u7684\u8ddd\u96e2";
        this.l_L = "\u5149\u6e90\u8207\u5149\u5b78\u5143\u4ef6(\u5982\u900f\u93e1)\u8ddd\u96e2";
        this.l_D = "\u5149\u5b78\u5143\u4ef6(\u900f\u93e1)\u76f4\u5f91";
        this.l_show = "\u986f\u793a\u66f2\u7dda";
        this.label = this.l_play;
    }

    public void locale(String string) {
        if (string.equals("zh_tw")) {
            this.zh_tw();
        }
        this._initialize();
    }

    public void _method_for_reset_action() {
        this._simulation.disableLoop();
        this._reset();
        this._simulation.enableLoop();
    }

    @Override
    public synchronized void reset() {
        int n;
        this.range = 0.2;
        this.xmin = -this.range / 2.0;
        this.xmax = this.range / 2.0;
        this.ymin = -this.range / 2.0;
        this.ymax = this.range / 2.0;
        this.t = 0.0;
        this.dt = 0.05;
        this.size = this.range / 40.0;
        this.label = "";
        this.l_play = "play";
        this.l_pause = "pause";
        this.l_reset = "reset";
        this.l_init = "initialize";
        this.l_xd = "Distances between light sources";
        this.l_D = "Diameter of the optics aperature";
        this.l_L = "Distance from Light Source to the aperature";
        this.l_show = "show curves";
        this.nx = 300;
        this.ny = 300;
        this.I = new double[this.nx][this.ny];
        this.lambda = 1.0E-7;
        this.Dr = 200.0;
        this.L = 9.843637;
        this.D = this.Dr * this.lambda;
        this.XP = new double[this.nx];
        this.YP = new double[this.nx];
        this.YP1 = new double[this.nx];
        for (n = 0; n < this.nx; ++n) {
            this.YP1[n] = 0.0;
        }
        this.YP2 = new double[this.nx];
        for (n = 0; n < this.nx; ++n) {
            this.YP2[n] = 0.0;
        }
        this.xd = this.size * 4.0;
        this.cta = 0.01;
        this.n = 50.0;
        this.yscale = 1.5;
    }

    @Override
    public synchronized void initialize() {
        this._initialization1();
        this._resetSolvers();
    }

    @Override
    public synchronized void step() {
    }

    @Override
    public synchronized void update() {
        this._constraints1();
    }

    @Override
    public void _freeMemory() {
        this.I = null;
        this.XP = null;
        this.YP = null;
        this.YP1 = null;
        this.YP2 = null;
        System.gc();
    }
}

